/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.reports;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQuerySQL;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.services.ContractorBillService;
import org.egov.works.web.actions.reports.RetentionMoneyRecoveryRegisterBean;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"exportPdf"}, type="stream", location="pdfInputStream", params={"inputName", "pdfInputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=RetentionMoneyRecoveryRegister.pdf"}), @Result(name={"exportExcel"}, type="stream", location="excelInputStream", params={"inputName", "excelInputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=RetentionMoneyRecoveryRegister.xls"})})
public class RetentionMoneyRecoveryRegisterAction
extends SearchFormAction {
    private static final long serialVersionUID = 3137793754124318372L;
    private static final Logger logger = Logger.getLogger(RetentionMoneyRecoveryRegisterAction.class);
    private String estimateNumber;
    private String projectCode;
    private String contractorCodeName;
    private Date billDateFrom;
    private Date billDateTo;
    private List<Object> paramList;
    private List<Object> paramListCountQuery;
    private String reportSubTitle;
    private Long billDepartment;
    public static final String EXPORTPDF = "exportPdf";
    public static final String EXPORTEXCEL = "exportExcel";
    private ReportService reportService;
    private InputStream pdfInputStream;
    private InputStream excelInputStream;
    @Autowired
    private DepartmentService departmentService;
    private List<Long> depositCOA;
    private List<Long> budgetHeads;
    private final DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    private String subHeaderBudgetHeads;
    private String subHeaderDepositCOA;
    private BigDecimal retentionMoneyAmountFrom = null;
    private BigDecimal retentionMoneyAmountTo = null;
    private ContractorBillService contractorBillService;
    private String billType;
    public Integer retentionMoneyRefPeriod;

    public Object getModel() {
        return null;
    }

    public String execute() {
        return "index";
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("billDepartmentList", this.departmentService.getAllDepartments());
        this.addDropdownData("billTypeList", this.contractorBillService.getBillType());
        this.addDropdownData("budgetHeadList", this.getPersistenceService().findAllBy("select distinct(bg) from FinancialDetail fd , BudgetGroup bg where fd.abstractEstimate.egwStatus.code = ? and fd.abstractEstimate.projectCode.id in (select bpd.accountDetailKeyId from EgBillPayeedetails bpd where bpd.accountDetailTypeId = ( select id from Accountdetailtype where name='PROJECTCODE') and bpd.egBilldetailsId.egBillregister.status.code=?  and expendituretype='Works' ) and bg=fd.budgetGroup order by bg.name ", new Object[]{AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString(), ContractorBillRegister.BillStatus.APPROVED.toString()}));
        this.addDropdownData("depositCOAList", this.getPersistenceService().findAllBy("select distinct(fd.coa) from FinancialDetail fd where fd.abstractEstimate.egwStatus.code = ? and fd.abstractEstimate.projectCode.id in (select bpd.accountDetailKeyId from EgBillPayeedetails bpd where bpd.accountDetailTypeId = ( select id from Accountdetailtype where name='PROJECTCODE') and bpd.egBilldetailsId.egBillregister.status.code=?  and expendituretype='Works') order by glcode ", new Object[]{AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString(), ContractorBillRegister.BillStatus.APPROVED.toString()}));
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String query = this.getSelectQuery() + this.getSearchQuery();
        String countQry = " select count(*) from (" + query + ")";
        String orderByClause = " ORDER BY \"Bill Date\"";
        this.setPageSize(30);
        return new SearchQuerySQL(query + " ORDER BY \"Bill Date\"", countQry, this.paramList);
    }

    public String search() {
        return "search";
    }

    public String searchList() {
        boolean isError = false;
        if (this.billDateFrom != null && this.billDateTo == null) {
            this.addFieldError("billDateTo", this.getText("search.billDateTo.null"));
            isError = true;
        }
        if (this.billDateTo != null && this.billDateFrom == null) {
            this.addFieldError("billDateFrom", this.getText("search.billDateFrom.null"));
            isError = true;
        }
        if (this.billDateFrom != null && this.billDateTo != null && !DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
            this.addFieldError("billDateFrom", this.getText("greaterthan.billDateTo.billDateFrom"));
            isError = true;
        }
        if (this.billDateTo != null && !DateUtils.compareDates((Date)new Date(), (Date)this.getToDate())) {
            this.addFieldError("billDateTo", this.getText("greaterthan.billDateTo.currentdate"));
            isError = true;
        }
        if (isError) {
            return "edit";
        }
        super.search();
        if (this.searchResult != null && this.searchResult.getList() != null && !this.searchResult.getList().isEmpty()) {
            List resultList = this.setBeanValues(this.searchResult.getList());
            this.searchResult.getList().clear();
            this.searchResult.getList().addAll(resultList);
        }
        return "search";
    }

    private List<RetentionMoneyRecoveryRegisterBean> setBeanValues(List searchList) {
        ArrayList<RetentionMoneyRecoveryRegisterBean> resultList = new ArrayList<RetentionMoneyRecoveryRegisterBean>();
        for (Object[] object : searchList) {
            RetentionMoneyRecoveryRegisterBean retentionMoneyRecoveryRegisterBean = new RetentionMoneyRecoveryRegisterBean();
            if (object[0] != null) {
                retentionMoneyRecoveryRegisterBean.setBillDepartment(object[0].toString());
            }
            if (object[1] != null) {
                retentionMoneyRecoveryRegisterBean.setContractorCode(object[1].toString());
            }
            if (object[2] != null) {
                retentionMoneyRecoveryRegisterBean.setContractorName(object[2].toString());
            }
            if (object[3] != null) {
                retentionMoneyRecoveryRegisterBean.setProjectCode(object[3].toString());
            }
            if (object[11] != null && Integer.valueOf(object[11].toString()) > 1) {
                retentionMoneyRecoveryRegisterBean.setProjectName(this.getText("retentionMoneyRecoveryRegister.multiple.label"));
            } else if (object[4] != null) {
                retentionMoneyRecoveryRegisterBean.setProjectName(object[4].toString());
            }
            if (object[5] != null) {
                retentionMoneyRecoveryRegisterBean.setBillNumber(object[5].toString());
            }
            if (object[6] != null) {
                retentionMoneyRecoveryRegisterBean.setBillType(object[6].toString());
            }
            if (object[7] != null) {
                retentionMoneyRecoveryRegisterBean.setBillDate(this.formatter.format(object[7]));
            }
            if (object[8] != null) {
                retentionMoneyRecoveryRegisterBean.setVoucherNumber(object[8].toString());
            } else {
                retentionMoneyRecoveryRegisterBean.setVoucherNumber("NA");
            }
            if (object[9] != null) {
                retentionMoneyRecoveryRegisterBean.setBillAmount(new BigDecimal(object[9].toString()));
            }
            if (object[10] != null) {
                retentionMoneyRecoveryRegisterBean.setRetentionMoneyRecoveredAmount(new BigDecimal(object[10].toString()));
            }
            if (object[13] != null && object[13].toString().equalsIgnoreCase("1")) {
                retentionMoneyRecoveryRegisterBean.setBillType("Final Bill");
            }
            if (object[12] != null) {
                if (object[13].toString().equalsIgnoreCase("0")) {
                    if (object[6].toString().equalsIgnoreCase("Part Bill")) {
                        retentionMoneyRecoveryRegisterBean.setRefundDate("NA");
                    } else {
                        retentionMoneyRecoveryRegisterBean.setRefundDate(this.formatter.format(object[12]));
                    }
                } else {
                    retentionMoneyRecoveryRegisterBean.setRefundDate(this.formatter.format(object[12]));
                }
            } else {
                retentionMoneyRecoveryRegisterBean.setRefundDate("NA");
            }
            resultList.add(retentionMoneyRecoveryRegisterBean);
        }
        return resultList;
    }

    private String getSelectQuery() {
        return "select \"Bill Department\", \"Contractor Code\",\"Contractor Name\", RTrim(xmlagg(xmlelement(a,\"Project Code\" || ', ').extract('//text()')),', ') as \"Project Code\", RTrim(xmlagg(xmlelement(a,\"Project Name\" || ',').extract('//text()')),',') as \"Project Name\", \"Bill Number\", \"Bill Type\", \"Bill Date\", \"Voucher Number\", \"Bill Amount\",  \"Retention money recovered\", count(\"Project Code\"),\"Refund Date\",\"PC Flag\" ";
    }

    private String getSearchQuery() {
        this.paramList = new ArrayList();
        StringBuffer titleBuffer = new StringBuffer();
        titleBuffer.append(this.getText("retentionMoneyRecoveryRegister.title.report"));
        Map whereClauseMap = this.formSearchConditionsQuery();
        List params = (List)whereClauseMap.get("params");
        this.paramList.addAll(params);
        String whereClauseBfr = whereClauseMap.get("whereClause").toString();
        String estimateStartQueryCondition = whereClauseMap.get("estimateQryCondition").toString();
        String query1 = " (SELECT dp.name AS \"Bill Department\", cont.code AS \"Contractor Code\", cont.name AS \"Contractor Name\", pc.code AS \"Project Code\", pc.name as \"Project Name\",br.billnumber AS \"Bill Number\", br.billtype AS \"Bill Type\",  br.billdate AS \"Bill Date\", vh.vouchernumber AS \"Voucher Number\", br.billamount AS \"Bill Amount\", bd.creditamount AS \"Retention money recovered\",(pcmis.work_completion_date+(365*pcmis.defect_liability_period)) AS \"Refund Date\", pc.is_final_bill AS \"PC Flag\"  FROM EG_DEPARTMENT dp, eg_billregister br, eg_billregistermis bmis LEFT OUTER JOIN VOUCHERHEADER vh ON vh.id=bmis.voucherheaderid and vh.status=0, eg_billdetails bd, eg_billpayeedetails bpd, egw_contractor cont, egw_projectcode pc left outer join egw_projectcodemis pcmis on pcmis.projectcode_id = pc.id  WHERE dp.id_dept = bmis.departmentid AND br.id = bd.billid AND bmis.billid = br.id AND bd.id = bpd.billdetailid  AND cont.id = bpd.ACCOUNTDETAILKEYID AND bpd.ACCOUNTDETAILTYPEID=(select id from accountdetailtype where name='contractor')  AND bd.creditamount > 0 AND br.EXPENDITURETYPE = 'Works' AND br.STATUSID IN (select id from egw_status where code='APPROVED' and moduletype='CONTRACTORBILL')  and bd.glcodeid in(select coa1.id from chartofaccounts coa1  where coa1.purposeid = (select id from egf_accountcode_purpose where name = 'RETENTION_MONEY')) and pc.id in(select bpd1.accountdetailkeyid from eg_billpayeedetails bpd1,eg_billdetails bd1 where  bpd1.ACCOUNTDETAILTYPEID=(select id from accountdetailtype where name='PROJECTCODE') AND bd1.id = bpd1.billdetailid  and bd1.debitamount>0 and bd1.billid=br.id) and not exists (select cbr.id from egw_contractorbill cbr where cbr.id = br.id ) " + whereClauseBfr + estimateStartQueryCondition;
        if (this.retentionMoneyRefPeriod != null && this.retentionMoneyRefPeriod != -1) {
            Date currentDate = new Date();
            Long period = new Long(this.retentionMoneyRefPeriod.intValue()) * new Long(24L) * new Long(3600L) * new Long(1000L);
            Date toDate = new Date(currentDate.getTime() + period);
            query1 = query1.concat(" and (br.billtype = ? OR pc.is_final_bill = 1) ");
            this.paramList.add("Final Bill");
            query1 = query1.concat(" and (pcmis.work_completion_date+(365*pcmis.defect_liability_period)) between ? and ? ");
            this.paramList.add(DateUtils.getFormattedDate((Date)currentDate, (String)"dd-MMM-yyyy"));
            this.paramList.add(DateUtils.getFormattedDate((Date)toDate, (String)"dd-MMM-yyyy"));
        }
        query1 = query1.concat(")");
        this.paramList.addAll(params);
        String query2 = "(SELECT dp.dept_name AS \"Bill Department\", cont.code AS \"Contractor Code\", cont.name AS \"Contractor Name\", pc.code AS \"Project Code\", pc.name as \"Project Name\",br.billnumber AS \"Bill Number\", br.billtype AS \"Bill Type\",  br.billdate AS \"Bill Date\", vh.vouchernumber AS \"Voucher Number\", br.billamount AS \"Bill Amount\", bd.creditamount AS \"Retention money recovered\",(woe.work_completion_date+ (365*wo.defect_liability_period)) as \"Refund Date\", pc.is_final_bill AS \"PC Flag\" FROM EG_DEPARTMENT dp, eg_billregister br, eg_billregistermis bmis LEFT OUTER JOIN VOUCHERHEADER vh ON vh.id=bmis.voucherheaderid and vh.status=0, eg_billdetails bd, eg_billpayeedetails bpd, egw_contractor cont, egw_projectcode pc,egw_work_order wo left outer join egw_workorder_estimate woe on woe.workorder_id = wo.id, egw_mb_header mbh  WHERE dp.id = bmis.departmentid AND br.id = bd.billid AND bmis.billid = br.id AND bd.id = bpd.billdetailid  AND cont.id = bpd.ACCOUNTDETAILKEYID AND mbh.WORKORDER_ESTIMATE_ID = woe.id AND mbh.billregister_id = br.id AND bpd.ACCOUNTDETAILTYPEID=(select id from accountdetailtype where name='contractor')  AND bd.creditamount > 0 AND br.EXPENDITURETYPE = 'Works' AND br.STATUSID IN (select id from egw_status where code='APPROVED' and moduletype='CONTRACTORBILL')  and bd.glcodeid in(select coa1.id from chartofaccounts coa1  where coa1.purposeid = (select id from egf_accountcode_purpose where name = 'RETENTION_MONEY')) and pc.id in(select bpd1.accountdetailkeyid from eg_billpayeedetails bpd1,eg_billdetails bd1 where  bpd1.ACCOUNTDETAILTYPEID=(select id from accountdetailtype where name='PROJECTCODE') AND bd1.id = bpd1.billdetailid  and bd1.debitamount>0 and bd1.billid=br.id)" + whereClauseBfr + estimateStartQueryCondition;
        if (this.retentionMoneyRefPeriod != null && this.retentionMoneyRefPeriod != -1) {
            Date currentDate = new Date();
            Long period = new Long(this.retentionMoneyRefPeriod.intValue()) * new Long(24L) * new Long(3600L) * new Long(1000L);
            Date toDate = new Date(currentDate.getTime() + period);
            query2 = query2.concat(" and br.billtype = ? ");
            this.paramList.add("Final Bill");
            query2 = query2.concat(" and (woe.work_completion_date+ (365*wo.defect_liability_period)) between ? and ? ");
            this.paramList.add(DateUtils.getFormattedDate((Date)currentDate, (String)"dd-MMM-yyyy"));
            this.paramList.add(DateUtils.getFormattedDate((Date)toDate, (String)"dd-MMM-yyyy"));
        }
        query2 = query2.concat(")");
        String unionQuery = "FROM (" + query1 + " UNION " + query2;
        String groupByQuery = " ) GROUP BY \"Bill Department\", \"Contractor Code\",\"Contractor Name\",\"Bill Number\", \"Bill Type\", \"Bill Date\", \"Voucher Number\", \"Bill Amount\", \"Retention money recovered\", \"Refund Date\",\"PC Flag\" ";
        this.reportSubTitle = titleBuffer.append(whereClauseMap.get("title").toString()).toString();
        return unionQuery + " ) GROUP BY \"Bill Department\", \"Contractor Code\",\"Contractor Name\",\"Bill Number\", \"Bill Type\", \"Bill Date\", \"Voucher Number\", \"Bill Amount\", \"Retention money recovered\", \"Refund Date\",\"PC Flag\" ";
    }

    private Map<String, Object> formSearchConditionsQuery() {
        StringBuilder dynQuery = new StringBuilder(800);
        StringBuffer titleBuffer = new StringBuffer();
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        ArrayList<Object> params = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)this.projectCode)) {
            dynQuery.append(" and pc.code like '%'||?||'%' ");
            params.add(this.projectCode);
            titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.projectcode") + this.projectCode);
        }
        if (StringUtils.isNotBlank((String)this.contractorCodeName)) {
            titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.contractorcodeorname") + this.contractorCodeName);
            String[] contractorDetails = this.contractorCodeName.split("~");
            if (contractorDetails.length > 1) {
                dynQuery.append(" and (upper(cont.code) like '%'||?||'%' or upper(cont.name) like '%'||?||'%') ");
                params.add(contractorDetails[0].toUpperCase());
                params.add(contractorDetails[1].toUpperCase());
            } else {
                dynQuery.append(" and (upper(cont.code) like '%'||?||'%' or upper(cont.name) like '%'||?||'%') ");
                params.add(contractorDetails[0].toUpperCase());
                params.add(contractorDetails[0].toUpperCase());
            }
        }
        if (this.billDepartment != null && this.billDepartment != 0L && this.billDepartment != -1L) {
            dynQuery.append(" and bmis.departmentid = ?");
            params.add(this.billDepartment);
            Department department = this.departmentService.getDepartmentById(this.billDepartment);
            titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.billdepartment") + department.getName());
        }
        if (this.billDateFrom != null) {
            dynQuery.append(" and br.billdate >= '" + DateUtils.getFormattedDate((Date)this.billDateFrom, (String)"dd-MMM-yyyy") + "' ");
        }
        if (this.billDateTo != null) {
            dynQuery.append(" and br.billdate <= '" + DateUtils.getFormattedDate((Date)this.billDateTo, (String)"dd-MMM-yyyy") + "' ");
        }
        if (this.billDateFrom != null && this.billDateTo != null) {
            titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.date") + DateUtils.getFormattedDate((Date)this.billDateFrom, (String)"dd/MM/yyyy") + " to " + DateUtils.getFormattedDate((Date)this.billDateTo, (String)"dd/MM/yyyy"));
        }
        if (StringUtils.isNotBlank((String)this.billType)) {
            dynQuery.append(" and br.billtype = ? ");
            params.add(this.billType);
            titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.billType") + this.billType);
        }
        if (this.retentionMoneyAmountFrom != null && this.retentionMoneyAmountTo != null && !this.retentionMoneyAmountFrom.equals(BigDecimal.ZERO) && !this.retentionMoneyAmountTo.equals(BigDecimal.ZERO)) {
            dynQuery.append(" and bd.creditamount between ? and ? ");
            params.add(this.retentionMoneyAmountFrom);
            params.add(this.retentionMoneyAmountTo);
            titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.report.retentionmoney.amount.range.lebel") + String.format("%.2f", this.retentionMoneyAmountFrom) + " - " + String.format("%.2f", this.retentionMoneyAmountTo));
        }
        if (this.retentionMoneyRefPeriod != null && this.retentionMoneyRefPeriod != -1) {
            titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.refundDueForPayable"));
            if (this.retentionMoneyRefPeriod == 30) {
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.refundDueForPayable.1month"));
            }
            if (this.retentionMoneyRefPeriod == 60) {
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.refundDueForPayable.2month"));
            }
            if (this.retentionMoneyRefPeriod == 90) {
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.refundDueForPayable.3month"));
            }
            if (this.retentionMoneyRefPeriod == 180) {
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.refundDueForPayable.6month"));
            }
            if (this.retentionMoneyRefPeriod == 365) {
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.refundDueForPayable.1year"));
            }
        }
        String estimateStartQueryCondition = "";
        if (StringUtils.isNotBlank((String)this.estimateNumber) || this.budgetHeads != null && !this.budgetHeads.isEmpty() || this.depositCOA != null && !this.depositCOA.isEmpty()) {
            estimateStartQueryCondition = " and pc.id in (select est.projectcode_id from egw_abstractestimate est where est.parentid is null and est.status_id = (select id from egw_status where code='ADMIN_SANCTIONED' and moduletype='AbstractEstimate') ";
            if (StringUtils.isNotBlank((String)this.estimateNumber)) {
                estimateStartQueryCondition = estimateStartQueryCondition + " and est.estimate_number like '%'||?||'%'";
                params.add(this.estimateNumber);
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.estimatenumber") + this.estimateNumber);
            }
            if (this.budgetHeads != null && !this.budgetHeads.isEmpty() && this.budgetHeads.get(0) != null && (Long)this.budgetHeads.get(0) != -1L && this.depositCOA != null && !this.depositCOA.isEmpty() && this.depositCOA.get(0) != null && (Long)this.depositCOA.get(0) != -1L) {
                estimateStartQueryCondition = estimateStartQueryCondition + " and est.id in (select abstractestimate_id from egw_financialdetail" + " where " + this.getInSubQuery(new ArrayList(this.budgetHeads), " BUDGETGROUP_ID ");
                estimateStartQueryCondition = estimateStartQueryCondition + " or " + this.getInSubQuery(new ArrayList(this.depositCOA), " COA_ID ") + ")";
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.budgethead") + this.subHeaderBudgetHeads);
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.depositcoa") + this.subHeaderDepositCOA);
            } else if (this.budgetHeads != null && !this.budgetHeads.isEmpty() && this.budgetHeads.get(0) != null && (Long)this.budgetHeads.get(0) != -1L) {
                estimateStartQueryCondition = estimateStartQueryCondition + " and est.id in (select abstractestimate_id from egw_financialdetail" + " where " + this.getInSubQuery(new ArrayList(this.budgetHeads), " BUDGETGROUP_ID ") + ")";
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.budgethead") + this.subHeaderBudgetHeads);
            } else if (this.depositCOA != null && !this.depositCOA.isEmpty() && this.depositCOA.get(0) != null && (Long)this.depositCOA.get(0) != -1L) {
                estimateStartQueryCondition = estimateStartQueryCondition + " and est.id in (select abstractestimate_id from egw_financialdetail" + " where " + this.getInSubQuery(new ArrayList(this.depositCOA), " COA_ID ") + ")";
                titleBuffer.append(" " + this.getText("retentionMoneyRecoveryRegister.title.depositcoa") + this.subHeaderDepositCOA);
            }
            estimateStartQueryCondition = estimateStartQueryCondition + ")";
        }
        searchCriteria.put("whereClause", dynQuery.toString());
        searchCriteria.put("params", params);
        searchCriteria.put("title", titleBuffer.toString());
        searchCriteria.put("estimateQryCondition", estimateStartQueryCondition);
        return searchCriteria;
    }

    public String getInSubQuery(List<Object> idList, String param) {
        StringBuffer inClause = new StringBuffer("");
        if (idList != null && idList.size() > 0 && param != null) {
            int size = idList.size();
            inClause.append(" (" + param + " in ( ");
            for (int i = 0; i < size; ++i) {
                if (i % 1000 == 0 && i != 0) {
                    inClause.append(") or " + param + " in (").append(idList.get(i).toString());
                } else {
                    inClause.append(idList.get(i).toString());
                }
                if (i == size - 1) {
                    inClause.append(")) ");
                    continue;
                }
                if (i % 1000 == 999) continue;
                inClause.append(",");
            }
        }
        return inClause.toString();
    }

    private List getReportData() {
        String orderByClause = " ORDER BY \"Bill Date\"";
        String reportQuery = this.getSelectQuery() + this.getSearchQuery() + " ORDER BY \"Bill Date\"";
        SQLQuery sqlQuery = this.getPersistenceService().getSession().createSQLQuery(String.valueOf(reportQuery));
        int count = 0;
        for (Object param : this.paramList) {
            sqlQuery.setParameter(count, param);
            ++count;
        }
        List resultList = sqlQuery.list();
        List reportList = this.setBeanValues(resultList);
        return reportList;
    }

    public String exportToPdf() {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        List reportData = this.getReportData();
        reportParams.put("reportSubTitle", this.reportSubTitle);
        ReportRequest reportRequest = new ReportRequest("RetentionMoneyRecoveryRegister", (Collection)reportData, reportParams);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.pdfInputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return EXPORTPDF;
    }

    public String exportToExcel() {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        List reportData = this.getReportData();
        reportParams.put("reportSubTitle", this.reportSubTitle);
        ReportRequest reportRequest = new ReportRequest("RetentionMoneyRecoveryRegister", (Collection)reportData, reportParams);
        reportRequest.setReportFormat(ReportConstants.FileFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.excelInputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return EXPORTEXCEL;
    }

    public InputStream getPdfInputStream() {
        return this.pdfInputStream;
    }

    public InputStream getExcelInputStream() {
        return this.excelInputStream;
    }

    public Date getFromDate() {
        return this.billDateFrom;
    }

    public void setFromDate(Date fromDate) {
        this.billDateFrom = fromDate;
    }

    public Date getToDate() {
        return this.billDateTo;
    }

    public void setToDate(Date toDate) {
        this.billDateTo = toDate;
    }

    public String getReportSubTitle() {
        return this.reportSubTitle;
    }

    public void setReportSubTitle(String reportSubTitle) {
        this.reportSubTitle = reportSubTitle;
    }

    public List<Object> getParamList() {
        return this.paramList;
    }

    public void setParamList(List<Object> paramList) {
        this.paramList = paramList;
    }

    public Long getUserDept() {
        return this.billDepartment;
    }

    public void setUserDept(Long userDept) {
        this.billDepartment = userDept;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public List<Long> getDepositCOA() {
        return this.depositCOA;
    }

    public void setDepositCOA(List<Long> depositCOA) {
        this.depositCOA = depositCOA;
    }

    public List<Long> getBudgetHeads() {
        return this.budgetHeads;
    }

    public void setBudgetHeads(List<Long> budgetHeads) {
        this.budgetHeads = budgetHeads;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getContractorCodeName() {
        return this.contractorCodeName;
    }

    public void setContractorCodeName(String contractorCodeName) {
        this.contractorCodeName = contractorCodeName;
    }

    public Date getBillDateFrom() {
        return this.billDateFrom;
    }

    public void setBillDateFrom(Date billDateFrom) {
        this.billDateFrom = billDateFrom;
    }

    public Date getBillDateTo() {
        return this.billDateTo;
    }

    public void setBillDateTo(Date billDateTo) {
        this.billDateTo = billDateTo;
    }

    public Long getBillDepartment() {
        return this.billDepartment;
    }

    public void setBillDepartment(Long billDepartment) {
        this.billDepartment = billDepartment;
    }

    public List<Object> getParamListCountQuery() {
        return this.paramListCountQuery;
    }

    public void setParamListCountQuery(List<Object> paramListCountQuery) {
        this.paramListCountQuery = paramListCountQuery;
    }

    public String getSubHeaderBudgetHeads() {
        return this.subHeaderBudgetHeads;
    }

    public void setSubHeaderBudgetHeads(String subHeaderBudgetHeads) {
        this.subHeaderBudgetHeads = subHeaderBudgetHeads;
    }

    public String getSubHeaderDepositCOA() {
        return this.subHeaderDepositCOA;
    }

    public void setSubHeaderDepositCOA(String subHeaderDepositCOA) {
        this.subHeaderDepositCOA = subHeaderDepositCOA;
    }

    public BigDecimal getRetentionMoneyAmountFrom() {
        return this.retentionMoneyAmountFrom;
    }

    public void setRetentionMoneyAmountFrom(BigDecimal retentionMoneyAmountFrom) {
        this.retentionMoneyAmountFrom = retentionMoneyAmountFrom;
    }

    public BigDecimal getRetentionMoneyAmountTo() {
        return this.retentionMoneyAmountTo;
    }

    public void setRetentionMoneyAmountTo(BigDecimal retentionMoneyAmountTo) {
        this.retentionMoneyAmountTo = retentionMoneyAmountTo;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
        this.contractorBillService = contractorBillService;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public Integer getRetentionMoneyRefPeriod() {
        return this.retentionMoneyRefPeriod;
    }

    public void setRetentionMoneyRefPeriod(Integer retentionMoneyRefPeriod) {
        this.retentionMoneyRefPeriod = retentionMoneyRefPeriod;
    }
}

