/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ActionService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.web.actions.workorder.AjaxWorkOrderAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"success"}, location="searchEstimate.jsp")})
public class SearchEstimateAction
extends SearchFormAction {
    private static final long serialVersionUID = -6825168798764375539L;
    private final Logger logger = Logger.getLogger(this.getClass());
    private String status;
    private Integer expenditureType = -1;
    private String estimateNumber = "";
    private String projCode = "";
    private String workOrderNo = "";
    private Integer engineerIncharge;
    private Integer engineerIncharge2;
    private Long assignedTo1;
    private Long assignedTo2;
    private String source;
    private Long execDept;
    @Autowired
    private AbstractEstimateService abstractEstimateService;
    private final List<AbstractEstimate> results = new LinkedList();
    private AbstractEstimate estimates = new AbstractEstimate();
    private Long estimateCreatedBy;
    private String wpdate;
    @Autowired
    private WorksService worksService;
    private String negoCreatedBy;
    private String statusReq;
    private Date fromDate;
    private Date toDate;
    private String estimateOrWpSearchReq;
    public static final String dateFormat = "dd-MMM-yyyy";
    private String option = "";
    private boolean selectedorder;
    public static final String RESULTS = "results";
    public static final String SEARCH_ESTIMATE_FOR_WO = "SearchEstimateforWO";
    public static final String UNCHECKED = "unchecked";
    @Autowired
    private DepartmentService departmentService;
    private boolean checkWO;
    private String cancellationReason;
    private String cancelRemarks;
    private static final String ASSIGNED_TO_LIST = "assignedToList";
    private static final String ASSIGNED_USER_LIST1 = "assignedUserList1";
    private static final String ASSIGNED_USER_LIST2 = "assignedUserList2";
    public static final String SEARCH_ESTIMATE_FOR_MILESTONE = "searchEstimateForMilestone";
    public static final String VIEW_MILESTONE = "viewMilestone";
    public static final String CANCEL_MILESTONE = "cancelMilestone";
    public static final String MILESTONE_STATUS_APPRD = "Approved";
    public static final String MS_OBJECT_TYPE = "Milestone";
    public static final String TMS_OBJECT_TYPE = "TrackMilestone";
    private String workOrdEstIds;
    @Autowired
    private UserService userService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private AssignmentService assignmentService;
    private String messageKey;
    private String ward = "";
    private String loginUserDeptName = "";
    @Autowired
    private ActionService actionService;
    private List<Role> roles = new ArrayList();
    private String milestoneStatus;
    private String status2;

    public SearchEstimateAction() {
        this.addRelatedEntity("category", EgwTypeOfWork.class);
        this.addRelatedEntity("parentCategory", EgwTypeOfWork.class);
        this.addRelatedEntity("ward", Boundary.class);
    }

    public Object getModel() {
        return this.estimates;
    }

    public String execute() {
        return "index";
    }

    private void populatePositionAndUserName() {
        LinkedList<AbstractEstimate> abEstimateList = new LinkedList<AbstractEstimate>();
        for (Object row : this.searchResult.getList()) {
            AbstractEstimate estimate = (AbstractEstimate)row;
            if (!estimate.getEgwStatus().getCode().equalsIgnoreCase("ADMIN_SANCTIONED") && !estimate.getEgwStatus().getCode().equalsIgnoreCase("CANCELLED") && estimate.getState() != null) {
                String posName = estimate.getState().getOwnerPosition().getName();
                Assignment assignment = this.assignmentService.getPrimaryAssignmentForPositon(estimate.getState().getOwnerPosition().getId());
                if (assignment != null) {
                    estimate.setPositionAndUserName(posName + " / " + assignment.getEmployee().getName());
                } else {
                    estimate.setPositionAndUserName(posName);
                }
            }
            abEstimateList.add(estimate);
        }
        this.searchResult.getList().clear();
        HashSet uniqueAbsEstimateList = new HashSet(abEstimateList);
        this.searchResult.getList().addAll(uniqueAbsEstimateList);
    }

    private void showOwnerName() {
        LinkedList<WorkOrderEstimate> woeList = new LinkedList<WorkOrderEstimate>();
        for (Object row : this.searchResult.getList()) {
            Assignment assignment;
            WorkOrderEstimate woe = (WorkOrderEstimate)row;
            Milestone lastestMilestoneObj = woe.getLatestMilestone();
            if (lastestMilestoneObj != null && !lastestMilestoneObj.getStatus().getCode().equalsIgnoreCase("APPROVED") && !lastestMilestoneObj.getStatus().getCode().equalsIgnoreCase("CANCELLED") && (assignment = this.assignmentService.getPrimaryAssignmentForPositon(lastestMilestoneObj.getState().getOwnerPosition().getId())) != null && assignment.getEmployee() != null) {
                lastestMilestoneObj.setOwnerName(assignment.getEmployee().getName());
            }
            woeList.add(woe);
        }
        this.searchResult.getList().clear();
        HashSet uniqueWOEstimateList = new HashSet(woeList);
        this.searchResult.getList().addAll(uniqueWOEstimateList);
    }

    public void showOwnerNameForViewMilestone() {
        LinkedList<Object[]> tempList = new LinkedList<Object[]>();
        for (Object[] obj : this.searchResult.getList()) {
            Assignment assignment;
            Milestone msObj = (Milestone)obj[1];
            TrackMilestone tmObj = (TrackMilestone)obj[2];
            if (msObj != null && !msObj.getStatus().getCode().equalsIgnoreCase("APPROVED") && !msObj.getStatus().getCode().equalsIgnoreCase("CANCELLED") && (assignment = this.assignmentService.getPrimaryAssignmentForPositon(msObj.getState().getOwnerPosition().getId())) != null && assignment.getEmployee() != null) {
                msObj.setOwnerName(assignment.getEmployee().getName());
            }
            if (tmObj != null && !tmObj.getStatus().getCode().equalsIgnoreCase("APPROVED") && !tmObj.getStatus().getCode().equalsIgnoreCase("CANCELLED") && (assignment = this.assignmentService.getPrimaryAssignmentForPositon(tmObj.getState().getOwnerPosition().getId())) != null && assignment.getEmployee() != null) {
                tmObj.setOwnerName(assignment.getEmployee().getName());
            }
            tempList.add(obj);
        }
        this.searchResult.getList();
    }

    public String printpage() {
        this.search();
        return "print";
    }

    private void populateWorkOrderAssignedToList(AjaxWorkOrderAction ajaxWorkOrderAction, boolean executingDeptPopulated) {
        if (executingDeptPopulated && this.execDept != null && this.execDept > 0L) {
            ajaxWorkOrderAction.setDepartmentName(this.departmentService.getDepartmentById(Long.valueOf(this.execDept)).getName());
            ajaxWorkOrderAction.getDesignationByDeptId();
            this.addDropdownData(ASSIGNED_TO_LIST, ajaxWorkOrderAction.getWorkOrderDesigList());
        } else {
            this.addDropdownData(ASSIGNED_TO_LIST, Collections.EMPTY_LIST);
        }
    }

    private void populateWorkOrderUsersList1(AjaxWorkOrderAction ajaxWorkOrderAction, boolean desgId, boolean executingDeptPopulated) {
        if (desgId && executingDeptPopulated && this.execDept != null && this.execDept > 0L) {
            ajaxWorkOrderAction.setDesgId(Long.valueOf(this.getassignedTo1()));
            ajaxWorkOrderAction.setExecutingDepartment(this.execDept);
            ajaxWorkOrderAction.getUsersForDesg();
            this.addDropdownData(ASSIGNED_USER_LIST1, ajaxWorkOrderAction.getUserList());
        } else {
            this.addDropdownData(ASSIGNED_USER_LIST1, Collections.EMPTY_LIST);
        }
    }

    private void populateWorkOrderUsersList2(AjaxWorkOrderAction ajaxWorkOrderAction, boolean desgId, boolean executingDeptPopulated) {
        if (desgId && executingDeptPopulated && this.execDept > 0L) {
            ajaxWorkOrderAction.setDesgId(Long.valueOf(this.assignedTo2));
            ajaxWorkOrderAction.setExecutingDepartment(this.execDept);
            ajaxWorkOrderAction.getUsersForDesg();
            this.addDropdownData(ASSIGNED_USER_LIST2, ajaxWorkOrderAction.getUserList());
        } else {
            this.addDropdownData(ASSIGNED_USER_LIST2, Collections.EMPTY_LIST);
        }
    }

    public List getEstimateStatuses() {
        return this.persistenceService.findAllBy("from EgwStatus s where moduletype=? and code not in ('NEW','APPROVED','BUDGETARY_APPR_VALIDATED') order by orderId", new Object[]{AbstractEstimate.class.getSimpleName()});
    }

    public void prepare() {
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        AjaxWorkOrderAction ajaxWorkOrderAction = new AjaxWorkOrderAction();
        ajaxWorkOrderAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"ward"});
        List values = this.getPersistenceService().findAllBy("from Department dt", new Object[0]);
        this.addDropdownData("executingDepartmentList", values);
        List worktypeList = this.getPersistenceService().findAllBy("from NatureOfWork dt", new Object[0]);
        this.addDropdownData("typeList", worktypeList);
        ArrayList<String> milestoneStatusList = new ArrayList<String>();
        milestoneStatusList.add("Milestone Created");
        milestoneStatusList.add("Milestone Tracked");
        milestoneStatusList.add("Project/Work Completed");
        this.addDropdownData("msStatusList", milestoneStatusList);
        List statList = this.persistenceService.findAllBy("select s.code from EgwStatus s where s.moduletype=? and s.code in ('NEW','CREATED','APPROVED','CANCELLED')order by s.orderId", new Object[]{Milestone.class.getSimpleName()});
        this.addDropdownData("statusList", statList);
        this.addDropdownData("parentCategoryList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw1 where etw1.parentid is null", new Object[0]));
        this.populateCategoryList(ajaxEstimateAction, this.estimates.getParentCategory() != null);
        this.addDropdownData("estimateCreatedByList", this.abstractEstimateService.findAllBy("select distinct createdBy from AbstractEstimate", new Object[0]));
        if ("wp".equals(this.source)) {
            this.setStatus(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
        }
        if (SEARCH_ESTIMATE_FOR_WO.equals(this.source)) {
            String status = this.worksService.getWorksConfigValue("NEGOTIATIONSTMT_WO_STATUS");
            if (StringUtils.isNotBlank((String)status)) {
                this.setStatus(status);
            }
            this.setToDate(new Date());
            this.perform();
        }
        if (SEARCH_ESTIMATE_FOR_MILESTONE.equalsIgnoreCase(this.source) || VIEW_MILESTONE.equalsIgnoreCase(this.source) || CANCEL_MILESTONE.equalsIgnoreCase(this.source)) {
            this.populateWorkOrderAssignedToList(ajaxWorkOrderAction, this.execDept != null);
            this.populateWorkOrderUsersList1(ajaxWorkOrderAction, this.assignedTo1 != null, this.execDept != null);
            this.populateWorkOrderUsersList2(ajaxWorkOrderAction, this.assignedTo2 != null, this.execDept != null);
        }
        if ("createNegotiationNew".equalsIgnoreCase(this.source)) {
            this.perform();
        }
        if (CANCEL_MILESTONE.equalsIgnoreCase(this.source)) {
            this.setStatus(MILESTONE_STATUS_APPRD);
        }
        if ("cancelEstimate".equals(this.source)) {
            this.status = AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString();
        }
        this.getLoginUserDept();
        this.getLoginUserRoles();
    }

    public void perform() {
        if (this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser() != null) {
            this.execDept = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser().getDepartment().getId();
        }
        this.negoCreatedBy = this.worksService.getWorksConfigValue("TENDER_NEGOTIATION_CREATED_BY_SELECTION");
        if (SEARCH_ESTIMATE_FOR_WO.equals(this.source)) {
            List deptValues = this.getPersistenceService().findAllBy("select distinct ae.executingDepartment from AbstractEstimate ae where ae.id in ( ( select tr.tenderEstimate.abstractEstimate.id  from TenderResponse tr where tr.egwStatus.code=? ) ) or  ae.id in (  select wd.estimate.id from WorksPackageDetails wd where wd.worksPackage.id in  (select tr.tenderEstimate.worksPackage.id from TenderResponse tr  where tr.tenderEstimate.abstractEstimate.id=null and  tr.tenderEstimate.worksPackage.id!=null  and tr.egwStatus.code=?)) and ae.id not in (select wo.abstractEstimate.id from WorkOrder wo)", new Object[]{this.status, this.status});
            this.addDropdownData("executingDepartmentList", deptValues);
        } else {
            this.estimateOrWpSearchReq = this.worksService.getWorksConfigValue("ESTIMATE_OR_WP_SEARCH_REQ");
            this.statusReq = this.worksService.getWorksConfigValue("ESTIMATE_STATUS");
            if (StringUtils.isNotBlank((String)this.statusReq)) {
                this.setStatus(this.statusReq);
            }
        }
    }

    private Map getEstimateForMilestoneQuery() {
        StringBuffer query = new StringBuffer(700);
        ArrayList<Object> paramList = new ArrayList<Object>();
        HashMap<String, Object> queryAndParams = new HashMap<String, Object>();
        if (SEARCH_ESTIMATE_FOR_MILESTONE.equalsIgnoreCase(this.source)) {
            query.append("from WorkOrderEstimate  as woe where woe.workOrder.parent is null and woe.workOrder.egwStatus.code=? ");
            paramList.add("APPROVED");
            query.append(" and woe.id not in (select m.workOrderEstimate.id from Milestone as m where m.egwStatus.code not in (?,?))");
            paramList.add("APPROVED");
            paramList.add("CANCELLED");
            query.append(" and woe.id not in (select tm.milestone.workOrderEstimate.id from TrackMilestone as tm where tm.egwStatus.code not in (?,?) or (tm.isProjectCompleted=? and tm.egwStatus.code<>?))");
            paramList.add("APPROVED");
            paramList.add("CANCELLED");
            paramList.add(Boolean.TRUE);
            paramList.add("CANCELLED");
            query.append("and woe.estimate.projectCode.egwStatus.code!=?");
            paramList.add("CLOSED");
        } else if (CANCEL_MILESTONE.equalsIgnoreCase(this.source)) {
            query.append("from WorkOrderEstimate  as woe left outer join woe.milestone milestone left outer join milestone.trackMilestone trackMilestone");
            query.append(" where woe.id in (select workOrderEstimate.id from Milestone m where m.egwStatus.code=?) ");
            paramList.add(this.getStatus().toUpperCase());
        } else {
            query.append("from WorkOrderEstimate  as woe left outer join woe.milestone milestone left outer join milestone.trackMilestone trackMilestone where woe.workOrder.egwStatus.code=? ");
            paramList.add("APPROVED");
            query.append(" and woe.id in (select workOrderEstimate.id from Milestone m1) ");
        }
        if (this.getExecDept() != null && this.getExecDept() != -1L) {
            query.append(" and woe.estimate.executingDepartment.id=? ");
            paramList.add(this.getExecDept());
        }
        if (this.getExpenditureType() != -1) {
            query.append(" and woe.estimate.natureOfWork.id=? ");
            paramList.add(Long.valueOf(this.getExpenditureType().intValue()));
        }
        if (StringUtils.isNotBlank((String)this.getEstimatenumber())) {
            query.append(" and UPPER(woe.estimate.estimateNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.getEstimatenumber()).toUpperCase());
        }
        if (VIEW_MILESTONE.equalsIgnoreCase(this.source) && StringUtils.isNotBlank((String)this.milestoneStatus) && !this.milestoneStatus.equalsIgnoreCase("-1")) {
            if (this.milestoneStatus.equalsIgnoreCase("Milestone Created") || this.milestoneStatus.equalsIgnoreCase("Milestone Tracked")) {
                if (StringUtils.isNotBlank((String)this.status2) && !this.status2.equalsIgnoreCase("-1")) {
                    if (this.milestoneStatus.equalsIgnoreCase("Milestone Created") && !this.status2.equalsIgnoreCase("CREATED")) {
                        query.append(" and milestone.egwStatus.code = ? and milestone.id not in (select tm.milestone.id from TrackMilestone tm ) ");
                        paramList.add(this.status2);
                    } else if (this.milestoneStatus.equalsIgnoreCase("Milestone Created") && this.status2.equalsIgnoreCase("CREATED")) {
                        query.append(" and milestone.egwStatus.code in ('CREATED','REJECTED','RESUBMITTED') and milestone.id not in (select tm.milestone.id from TrackMilestone tm ) ");
                    } else if (this.milestoneStatus.equalsIgnoreCase("Milestone Tracked") && !this.status2.equalsIgnoreCase("CREATED")) {
                        query.append(" and trackMilestone.egwStatus.code = ? ");
                        paramList.add(this.getStatus2());
                    } else if (this.milestoneStatus.equalsIgnoreCase("Milestone Tracked") && this.status2.equalsIgnoreCase("CREATED")) {
                        query.append(" and trackMilestone.egwStatus.code in  ('CREATED','REJECTED','RESUBMITTED') ");
                    }
                }
                if (this.milestoneStatus.equalsIgnoreCase("Milestone Created") && this.status2.equalsIgnoreCase("-1")) {
                    query.append(" and milestone.egwStatus.code in (?,?,?,?,?,?) and milestone.id not in (select tm.milestone.id from TrackMilestone tm )");
                    paramList.add("NEW");
                    paramList.add("CREATED");
                    paramList.add("APPROVED");
                    paramList.add("REJECTED");
                    paramList.add("RESUBMITTED");
                    paramList.add("CANCELLED");
                }
                if (this.milestoneStatus.equalsIgnoreCase("Milestone Tracked") && this.status2.equalsIgnoreCase("-1")) {
                    query.append(" and trackMilestone.egwStatus.code in (?,?,?,?,?,?) and trackMilestone.isProjectCompleted!=1  ");
                    paramList.add("NEW");
                    paramList.add("CREATED");
                    paramList.add("APPROVED");
                    paramList.add("REJECTED");
                    paramList.add("RESUBMITTED");
                    paramList.add("CANCELLED");
                }
            } else {
                query.append(" and trackMilestone.isProjectCompleted = 1 and trackMilestone.egwStatus.code = ?");
                paramList.add("APPROVED");
            }
        }
        if ((SEARCH_ESTIMATE_FOR_MILESTONE.equalsIgnoreCase(this.source) || VIEW_MILESTONE.equalsIgnoreCase(this.source)) && this.estimateCreatedBy != null && this.estimateCreatedBy != -1L) {
            query.append(" and woe.estimate.createdBy.id = ?");
            paramList.add(this.estimateCreatedBy);
        }
        if (StringUtils.isNotBlank((String)this.getProjCode())) {
            query.append(" and UPPER(woe.estimate.projectCode.code) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.getProjCode()).toUpperCase());
        }
        if (StringUtils.isNotBlank((String)this.getWorkOrderNo())) {
            query.append(" and UPPER(woe.workOrder.workOrderNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.getWorkOrderNo()).toUpperCase());
        }
        if (this.engineerIncharge != null && this.engineerIncharge != -1) {
            query.append(" and woe.workOrder.engineerIncharge.idPersonalInformation=?");
            paramList.add(this.engineerIncharge);
        }
        if (this.engineerIncharge2 != null && this.engineerIncharge2 != -1) {
            query.append(" and woe.workOrder.engineerIncharge2.idPersonalInformation=?");
            paramList.add(this.engineerIncharge2);
        }
        if (this.estimates.getCategory() != null) {
            query.append(" and woe.estimate.category.id=?");
            paramList.add(this.estimates.getCategory().getId());
        }
        if (this.estimates.getParentCategory() != null) {
            query.append(" and woe.estimate.parentCategory.id=?");
            paramList.add(this.estimates.getParentCategory().getId());
        }
        if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            query.append(" and woe.estimate.estimateDate between ? and ? ");
            paramList.add(this.fromDate);
            paramList.add(this.toDate);
        }
        if (VIEW_MILESTONE.equalsIgnoreCase(this.source) && this.estimates.getWard() != null) {
            query.append(" and woe.estimate.ward.id = ?  ");
            paramList.add(this.estimates.getWard().getId());
        }
        queryAndParams.put("query", query.toString());
        queryAndParams.put("params", paramList);
        return queryAndParams;
    }

    public List<String> getEstimateActions() {
        ArrayList copyEstActionRoles = new ArrayList();
        boolean allowCopyEst = false;
        ArrayList<String> actionList = new ArrayList<String>();
        actionList.add(0, "View");
        actionList.add(1, "View PDF");
        actionList.add(2, "WorkFlow History");
        actionList.add(3, "View Document");
        actionList.add(4, "Copy Estimate");
        if (actionList != null && !actionList.isEmpty()) {
            String copyEstActionName = (String)actionList.get(actionList.size() - 1);
            org.egov.infra.admin.master.entity.Action copyEstimateAction = this.actionService.getActionByName(copyEstActionName);
            if (copyEstimateAction != null) {
                copyEstActionRoles.addAll(copyEstimateAction.getRoles());
            }
            for (Role copyEstrole : copyEstActionRoles) {
                if (!this.roles.contains(copyEstrole)) continue;
                allowCopyEst = true;
                break;
            }
            if (!allowCopyEst) {
                ArrayList<String> tempActionList = new ArrayList<String>();
                for (String action : actionList) {
                    if (action.equals(copyEstActionName)) continue;
                    tempActionList.add(action);
                }
                actionList.retainAll(tempActionList);
            }
        }
        return actionList;
    }

    protected void populateCategoryList(AjaxEstimateAction ajaxEstimateAction, boolean categoryPopulated) {
        if (categoryPopulated) {
            ajaxEstimateAction.setCategory(this.estimates.getParentCategory().getId());
            ajaxEstimateAction.subcategories();
            this.addDropdownData("categoryList", ajaxEstimateAction.getSubCategories());
        } else {
            this.addDropdownData("categoryList", Collections.emptyList());
        }
    }

    public String displayEstimaeOrWpSearch() {
        if (StringUtils.isNotBlank((String)this.estimateOrWpSearchReq) && ("both".equalsIgnoreCase(this.estimateOrWpSearchReq) || "estimate".equalsIgnoreCase(this.estimateOrWpSearchReq))) {
            return RESULTS;
        }
        return "wpSearch";
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        List<String> paramList = new ArrayList();
        String query = null;
        String countQuery = null;
        String baseQuery = null;
        StringBuilder sb = new StringBuilder(500);
        Map queryAndParms = null;
        if (SEARCH_ESTIMATE_FOR_MILESTONE.equalsIgnoreCase(this.source) || VIEW_MILESTONE.equalsIgnoreCase(this.source) || CANCEL_MILESTONE.equalsIgnoreCase(this.source)) {
            queryAndParms = this.getEstimateForMilestoneQuery();
            paramList = (List)queryAndParms.get("params");
            query = (String)queryAndParms.get("query");
            if (CANCEL_MILESTONE.equalsIgnoreCase(this.source) || SEARCH_ESTIMATE_FOR_MILESTONE.equalsIgnoreCase(this.source)) {
                countQuery = "select count(distinct woe.id) " + query;
            }
            if (CANCEL_MILESTONE.equalsIgnoreCase(this.source)) {
                query = "select distinct woe " + query;
            }
            if (VIEW_MILESTONE.equalsIgnoreCase(this.source)) {
                countQuery = "select count(woe.id) " + query;
                query = "select woe , milestone , trackMilestone " + query;
            }
        } else {
            baseQuery = "from AbstractEstimate as ae where ae.parent is null  ";
            boolean isError = false;
            if (SEARCH_ESTIMATE_FOR_WO.equals(this.source)) {
                if (StringUtils.isNotBlank((String)this.status)) {
                    sb.append(baseQuery);
                    sb.append(" and ( ae.id in (  ( select tr.tenderEstimate.abstractEstimate.id  from TenderResponse tr where tr.egwStatus.code=? ) ) or  ae.id in (  select wd.estimate.id from WorksPackageDetails wd where wd.worksPackage.id in  (select tr.tenderEstimate.worksPackage.id from TenderResponse tr  where tr.tenderEstimate.abstractEstimate.id=null and  tr.tenderEstimate.worksPackage.id!=null  and tr.egwStatus.code=? ))) and ae.id not in (select wo.abstractEstimate.id from WorkOrder wo where wo.parent is null)");
                    paramList.add(this.status);
                    paramList.add(this.status);
                }
            } else if (StringUtils.isNotBlank((String)this.getStatus()) && (this.getStatus().equals(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString()) || this.getStatus().equals(AbstractEstimate.EstimateStatus.CANCELLED.toString()))) {
                sb.append(baseQuery);
                sb.append("and ae.egwStatus.code = ?");
                paramList.add(this.getStatus());
            } else if (StringUtils.isNotBlank((String)this.getStatus()) && !this.getStatus().equals("-1")) {
                sb.append(baseQuery);
                sb.append("and ae.egwStatus.code=? ");
                paramList.add(this.getStatus());
            } else if (StringUtils.isNotBlank((String)this.getStatus()) && this.getStatus().equals("-1")) {
                sb.append(baseQuery);
                sb.append("and ae.egwStatus.code not in ('NEW')");
            }
            if (this.getExecDept() != null && this.getExecDept() != -1L) {
                sb.append(" and ae.executingDepartment.id= ? ");
                paramList.add((String)((Object)this.getExecDept()));
            }
            if (this.getExpenditureType() != -1) {
                sb.append(" and ae.natureOfWork.id= ? ");
                paramList.add((String)((Object)Long.valueOf(this.getExpenditureType().intValue())));
            }
            if (StringUtils.isNotBlank((String)this.getEstimatenumber())) {
                sb.append(" and ae.estimateNumber like ? ");
                paramList.add("%" + this.getEstimatenumber() + "%");
            }
            if (StringUtils.isNotBlank((String)this.projCode)) {
                sb.append(" and ae.projectCode.code like ? ");
                paramList.add("%" + this.projCode + "%");
            }
            if (this.estimateCreatedBy != null && this.estimateCreatedBy != -1L) {
                sb.append(" and ae.createdBy.id=? ");
                paramList.add((String)((Object)this.estimateCreatedBy));
            }
            if (this.estimates.getCategory() != null) {
                sb.append(" and ae.category.id= ? ");
                paramList.add((String)((Object)this.estimates.getCategory().getId()));
            }
            if (this.estimates.getParentCategory() != null) {
                sb.append(" and ae.parentCategory.id= ? ");
                paramList.add((String)((Object)this.estimates.getParentCategory().getId()));
            }
            if (this.estimates.getDescription() != null && StringUtils.isNotBlank((String)this.estimates.getDescription())) {
                sb.append(" and UPPER(ae.description) like ? ");
                paramList.add("%" + this.estimates.getDescription().toUpperCase() + "%");
            }
            if (StringUtils.isNotBlank((String)this.wpdate)) {
                Date workspacDate = null;
                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", new Locale("en", "IN"));
                try {
                    workspacDate = formatter.parse(this.wpdate);
                }
                catch (ParseException e) {
                    isError = true;
                    this.logger.error((Object)("Date Conversion Error :" + e.getMessage()));
                    this.addFieldError("parse exception", "Date Conversion Error");
                }
                sb.append(" and ae.approvedDate <= ? ");
                paramList.add((String)((Object)workspacDate));
            }
            if ("wp".equals(this.source) && !isError) {
                sb.append(" and ae.id not in(select tr.tenderEstimate.abstractEstimate.id from TenderResponse tr where tr.egwStatus.code !='CANCELLED' and tr.tenderEstimate.abstractEstimate is not null and ae.id=tr.tenderEstimate.abstractEstimate.id) and ae.id not in(select wpd.estimate.id from WorksPackageDetails wpd where wpd.estimate.id=ae.id  and wpd.worksPackage.egwStatus.code !='CANCELLED')");
            }
            if ("createNegotiationNew".equals(this.source) && !isError) {
                sb.append(" and ae.id not in(select tr.tenderEstimate.abstractEstimate.id from TenderResponse tr where tr.egwStatus.code !='CANCELLED' and tr.tenderEstimate.abstractEstimate is not null and ae.id=tr.tenderEstimate.abstractEstimate.id) and ae.id not in(select tr.tenderEstimate.abstractEstimate.id from TenderResponse tr where tr.egwStatus.code ='NEW' and tr.tenderEstimate.abstractEstimate.id is not null) and ae.id not in(select wpd.estimate.id from WorksPackageDetails wpd where wpd.estimate.id=ae.id)");
            }
            if (SEARCH_ESTIMATE_FOR_WO.equals(this.source)) {
                if (this.fromDate != null && this.toDate == null) {
                    this.setToDate(new Date());
                }
                if (this.toDate != null && this.fromDate == null) {
                    sb.append(" and ae.estimateDate <= ? ");
                    paramList.add((String)((Object)this.toDate));
                }
            } else {
                if (this.fromDate != null && this.toDate == null) {
                    this.addFieldError("enddate", this.getText("search.endDate.null"));
                }
                if (this.toDate != null && this.fromDate == null) {
                    this.addFieldError("startdate", this.getText("search.startDate.null"));
                }
            }
            if (!DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
                this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
            }
            if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
                sb.append(" and ae.estimateDate between ? and ? ");
                paramList.add((String)((Object)this.fromDate));
                paramList.add((String)((Object)this.toDate));
            }
            query = sb.toString();
            countQuery = "select count(distinct ae.id) " + query;
        }
        return new SearchQueryHQL(query, countQuery, paramList);
    }

    public String viewMilestone() {
        return "index";
    }

    @Action(value="/estimate/searchEstimate-search")
    public String search() {
        boolean isError = false;
        if ((SEARCH_ESTIMATE_FOR_MILESTONE.equalsIgnoreCase(this.source) || CANCEL_MILESTONE.equalsIgnoreCase(this.source)) && this.execDept == -1L) {
            this.addFieldError("execDept", this.getText("search.execDept.null"));
            isError = true;
        }
        if (this.fromDate != null && this.toDate == null) {
            this.addFieldError("enddate", this.getText("search.endDate.null"));
            isError = true;
        }
        if (this.toDate != null && this.fromDate == null) {
            this.addFieldError("startdate", this.getText("search.startDate.null"));
            isError = true;
        }
        if (!DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
            isError = true;
        }
        if (isError) {
            return "success";
        }
        this.setPageSize(30);
        String retVal = super.search();
        if (!(SEARCH_ESTIMATE_FOR_MILESTONE.equalsIgnoreCase(this.source) || VIEW_MILESTONE.equalsIgnoreCase(this.source) || CANCEL_MILESTONE.equalsIgnoreCase(this.source))) {
            this.populatePositionAndUserName();
        }
        if (SEARCH_ESTIMATE_FOR_MILESTONE.equalsIgnoreCase(this.source)) {
            this.showOwnerName();
        }
        if (VIEW_MILESTONE.equalsIgnoreCase(this.source)) {
            this.showOwnerNameForViewMilestone();
        }
        if ((VIEW_MILESTONE.equalsIgnoreCase(this.source) || CANCEL_MILESTONE.equalsIgnoreCase(this.source)) && this.searchResult.getFullListSize() != 0) {
            ArrayList woeList = new ArrayList();
            woeList.addAll(this.searchResult.getList());
            this.searchResult.getList().clear();
            this.searchResult.getList().addAll(woeList);
        }
        if (this.searchResult.getFullListSize() == 0) {
            WorksPackage wp = null;
            if ("wp".equals(this.source) && StringUtils.isNotBlank((String)this.getEstimatenumber())) {
                wp = (WorksPackage)this.persistenceService.find("from WorksPackage wp where wp.id in (select wpd.worksPackage.id from WorksPackageDetails wpd where wpd.estimate.estimateNumber = ? ) and wp.egwStatus.code<>'CANCELLED'", new Object[]{this.getEstimatenumber()});
            }
            if (wp != null) {
                if ("NEW".equalsIgnoreCase(wp.getEgwStatus().getCode())) {
                    Assignment assignment = this.assignmentService.getPrimaryAssignmentForPositon(wp.getState().getOwnerPosition().getId());
                    this.addFieldError("result not found", "Work package is already created for the Estimate with Work Package No " + wp.getWpNumber() + " dated on " + DateUtils.getFormattedDate((Date)wp.getWpDate(), (String)"dd/MM/yyyy") + " and " + "it is drafts of " + assignment.getEmployee().getName());
                } else {
                    this.addFieldError("result not found", "Work package is already created for the Estimate with Work Package No: " + wp.getWpNumber() + " dated on " + DateUtils.getFormattedDate((Date)wp.getWpDate(), (String)"dd/MM/yyyy") + " and it is in " + wp.getEgwStatus().getDescription() + " status");
                }
            } else {
                this.addFieldError("result not found", "No results found for search parameters");
            }
        }
        return retVal;
    }

    @ValidationErrorPage(value="index")
    public String cancelApprdMilestones() {
        WorkOrderEstimate woe;
        StringBuilder estimateNum = new StringBuilder(200);
        String[] workOrderEstIdsStr = this.workOrdEstIds.split(",");
        Employee employee = this.employeeService.getEmployeeById(this.worksService.getCurrentLoggedInUserId());
        StringBuilder cancelComments = new StringBuilder(200);
        if (this.cancelRemarks != null && StringUtils.isNotBlank((String)this.cancelRemarks)) {
            cancelComments.append(this.cancellationReason).append(" : ").append(this.cancelRemarks).append(". ").append(this.getText("milestone.cancel.cancelledby")).append(": ").append(employee.getName());
        } else {
            cancelComments.append(this.cancellationReason).append(". ").append(this.getText("milestone.cancel.cancelledby")).append(": ").append(employee.getName());
        }
        for (String workOrderIdStr : workOrderEstIdsStr) {
            woe = (WorkOrderEstimate)this.getPersistenceService().find("from WorkOrderEstimate woe where woe.id=?", new Object[]{Long.valueOf(workOrderIdStr)});
            List mbHeaderList = this.getPersistenceService().findAllBy("from MBHeader where egBillregister is not null and egBillregister.status.code!=? and workOrderEstimate.id = ? ", new Object[]{ContractorBillRegister.BillStatus.CANCELLED.toString(), woe.getId()});
            if (mbHeaderList == null || mbHeaderList.isEmpty()) continue;
            String billList = "";
            for (MBHeader mbh : mbHeaderList) {
                if (billList.equalsIgnoreCase("")) {
                    billList = mbh.getEgBillregister().getBillnumber();
                    continue;
                }
                billList = billList + "," + mbh.getEgBillregister().getBillnumber();
            }
            this.source = CANCEL_MILESTONE;
            this.prepare();
            throw new ValidationException(Arrays.asList(new ValidationError("error", this.getText("milestone.cancel.bill.validation", new String[]{woe.getEstimate().getEstimateNumber(), billList}))));
        }
        for (String workOrderIdStr : workOrderEstIdsStr) {
            woe = (WorkOrderEstimate)this.getPersistenceService().find("from WorkOrderEstimate woe where woe.id=?", new Object[]{Long.valueOf(workOrderIdStr)});
            for (Milestone milestone : woe.getMilestone()) {
                if (!"APPROVED".equalsIgnoreCase(milestone.getStatus().getCode())) continue;
                milestone.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(MS_OBJECT_TYPE, "CANCELLED"));
                for (TrackMilestone tms : milestone.getTrackMilestone()) {
                    if ("CANCELLED".equalsIgnoreCase(tms.getStatus().getCode())) continue;
                    tms.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(TMS_OBJECT_TYPE, "CANCELLED"));
                    tms.getCurrentState();
                }
            }
            if (estimateNum.toString().contains(woe.getEstimate().getEstimateNumber())) continue;
            estimateNum.append(woe.getEstimate().getEstimateNumber()).append(",");
        }
        this.messageKey = this.getText("milestone.cancel.success.msg", new String[]{estimateNum.toString()});
        return "successMSCancel";
    }

    public List<String> getMilestoneActions() {
        String actions = this.worksService.getWorksConfigValue("MILESTONE_SEARCH_ACTIONS");
        if (actions != null) {
            return Arrays.asList(actions.split(","));
        }
        return new ArrayList<String>();
    }

    private void getLoginUserDept() {
        Assignment assignment = this.assignmentService.getPrimaryAssignmentForEmployeeByToDate(this.worksService.getCurrentLoggedInUserId(), new Date());
        if (assignment != null) {
            this.setLoginUserDeptName(assignment.getDepartment().getName());
        }
    }

    private void getLoginUserRoles() {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        if (user != null && !user.getRoles().isEmpty()) {
            this.roles.addAll(user.getRoles());
        }
    }

    public Long getEstimateCreatedBy() {
        return this.estimateCreatedBy;
    }

    public void setEstimateCreatedBy(Long estimateCreatedBy) {
        this.estimateCreatedBy = estimateCreatedBy;
    }

    public String getWpdate() {
        return this.wpdate;
    }

    public void setWpdate(String wpdate) {
        this.wpdate = wpdate;
    }

    public String getNegoCreatedBy() {
        return this.negoCreatedBy;
    }

    public void setNegoCreatedBy(String negoCreatedBy) {
        this.negoCreatedBy = negoCreatedBy;
    }

    public String getStatusReq() {
        return this.statusReq;
    }

    public void setStatusReq(String statusReq) {
        this.statusReq = statusReq;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public String getEstimateOrWpSearchReq() {
        return this.estimateOrWpSearchReq;
    }

    public void setEstimateOrWpSearchReq(String estimateOrWpSearchReq) {
        this.estimateOrWpSearchReq = estimateOrWpSearchReq;
    }

    public boolean getSelectedorder() {
        return this.selectedorder;
    }

    public void setSelectedorder(boolean selectedorder) {
        this.selectedorder = selectedorder;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getProjCode() {
        return this.projCode;
    }

    public void setProjCode(String projCode) {
        this.projCode = projCode;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public String getWorkOrderNo() {
        return this.workOrderNo;
    }

    public void setWorkOrderNo(String workOrderNo) {
        this.workOrderNo = workOrderNo;
    }

    public void setEngineerIncharge(Integer engineerIncharge) {
        this.engineerIncharge = engineerIncharge;
    }

    public Integer getEngineerIncharge2() {
        return this.engineerIncharge2;
    }

    public Integer getEngineerIncharge() {
        return this.engineerIncharge;
    }

    public void setEngineerIncharge2(Integer engineerIncharge2) {
        this.engineerIncharge2 = engineerIncharge2;
    }

    public Long getassignedTo1() {
        return this.assignedTo1;
    }

    public void setassignedTo1(Long assignedTo1) {
        this.assignedTo1 = assignedTo1;
    }

    public Long getAssignedTo2() {
        return this.assignedTo2;
    }

    public void setAssignedTo2(Long assignedTo2) {
        this.assignedTo2 = assignedTo2;
    }

    public Long getAssignedTo1() {
        return this.assignedTo1;
    }

    public void setAssignedTo1(Long assignedTo1) {
        this.assignedTo1 = assignedTo1;
    }

    public boolean isCheckWO() {
        return this.checkWO;
    }

    public void setCheckWO(boolean checkWO) {
        this.checkWO = checkWO;
    }

    public String getWorkOrdEstIds() {
        return this.workOrdEstIds;
    }

    public void setWorkOrdEstIds(String workOrdEstIds) {
        this.workOrdEstIds = workOrdEstIds;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancelRemarks() {
        return this.cancelRemarks;
    }

    public void setCancelRemarks(String cancelRemarks) {
        this.cancelRemarks = cancelRemarks;
    }

    public String getWard() {
        return this.ward;
    }

    public void setWard(String ward) {
        this.ward = ward;
    }

    public String getLoginUserDeptName() {
        return this.loginUserDeptName;
    }

    public void setLoginUserDeptName(String loginUserDeptName) {
        this.loginUserDeptName = loginUserDeptName;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public String getStatus2() {
        return this.status2;
    }

    public void setStatus2(String status2) {
        this.status2 = status2;
    }

    public String getMilestoneStatus() {
        return this.milestoneStatus;
    }

    public void setMilestoneStatus(String milestoneStatus) {
        this.milestoneStatus = milestoneStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<AbstractEstimate> getResults() {
        return this.results;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getExpenditureType() {
        return this.expenditureType;
    }

    public void setExpenditureType(Integer expenditureType) {
        this.expenditureType = expenditureType;
    }

    public String getEstimatenumber() {
        return this.estimateNumber;
    }

    public void setEstimatenumber(String estimatenumber) {
        this.estimateNumber = estimatenumber;
    }

    public AbstractEstimate getEstimates() {
        return this.estimates;
    }

    public void setEstimates(AbstractEstimate estimates) {
        this.estimates = estimates;
    }

    public Long getExecDept() {
        return this.execDept;
    }

    public void setExecDept(Long execDept) {
        this.execDept = execDept;
    }
}

