/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.EgwTypeOfWork;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.models.BaseModel;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.models.estimate.EstimateTemplate;
import org.egov.works.models.estimate.EstimateTemplateActivity;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.web.actions.estimate.AjaxEstimateTemplateAction;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"new"}, location="estimateTemplate-new.jsp"), @Result(name={"search"}, location="estimateTemplate-search.jsp"), @Result(name={"success"}, location="estimateTemplate-success.jsp"), @Result(name={"edit"}, location="estimateTemplate-edit.jsp")})
public class EstimateTemplateAction
extends SearchFormAction {
    private static final long serialVersionUID = 3610026596221473556L;
    private static final String VIEW = "view";
    private EstimateTemplate estimateTemplate = new EstimateTemplate();
    private List<EstimateTemplateActivity> sorActivities = new LinkedList();
    private List<EstimateTemplateActivity> nonSorActivities = new LinkedList();
    @Autowired
    private AssignmentService assignmentService;
    private WorksService worksService;
    private PersistenceService<EstimateTemplate, Long> estimateTemplateService;
    private String mode = null;
    private Long id;
    private String sourcePage = null;
    private Long typeOfWork;
    private String estimateTemplateCode;
    private Long subTypeOfWork;
    public static final String SEARCH = "search";
    public static final String EDIT = "edit";
    public static final String SUCCESS = "success";
    private AbstractEstimateService abstractEstimateService;

    public EstimateTemplateAction() {
        this.addRelatedEntity("workType", EgwTypeOfWork.class);
        this.addRelatedEntity("subType", EgwTypeOfWork.class);
    }

    public Object getModel() {
        return this.estimateTemplate;
    }

    protected void setModel(EstimateTemplate estimateTemplate) {
        this.estimateTemplate = estimateTemplate;
    }

    @Action(value="/estimate/estimateTemplate-edit")
    public String edit() {
        return EDIT;
    }

    public void prepare() {
        if (this.id != null) {
            this.estimateTemplate = (EstimateTemplate)this.estimateTemplateService.findById((Serializable)this.id, false);
        }
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setAssignmentService(this.assignmentService);
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"workType", "subType"});
        this.addDropdownData("parentCategoryList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw1 where etw1.parentid is null", new Object[0]));
        List uomList = this.getPersistenceService().findAllBy("from UOM  order by upper(uom)", new Object[0]);
        if (!VIEW.equals(this.mode)) {
            uomList = this.abstractEstimateService.prepareUomListByExcludingSpecialUoms(uomList);
        }
        this.addDropdownData("uomList", uomList);
        this.addDropdownData("scheduleCategoryList", this.getPersistenceService().findAllBy("from ScheduleCategory order by upper(code)", new Object[0]));
        this.populateCategoryList(ajaxEstimateAction, this.estimateTemplate.getWorkType() != null);
    }

    @Action(value="/estimate/estimateTemplate-newform")
    public String newform() {
        return "new";
    }

    @SkipValidation
    @Action(value="/estimate/estimateTemplate-search")
    public String search() {
        return SEARCH;
    }

    @Action(value="/estimate/estimateTemplate-save")
    public String save() {
        this.estimateTemplate.getEstimateTemplateActivities().clear();
        this.populateSorActivities();
        this.populateNonSorActivities();
        this.populateActivities();
        if (this.estimateTemplate.getId() == null) {
            this.estimateTemplate.setStatus(1);
        } else {
            this.setMode(EDIT);
        }
        this.estimateTemplate = (EstimateTemplate)this.estimateTemplateService.persist((Object)this.estimateTemplate);
        return SUCCESS;
    }

    protected void populateSorActivities() {
        for (EstimateTemplateActivity activity : this.sorActivities) {
            if (!this.validSorActivity(activity)) continue;
            activity.setSchedule((ScheduleOfRate)this.getPersistenceService().find("from ScheduleOfRate where id = ?", new Object[]{activity.getSchedule().getId()}));
            activity.setUom(activity.getSchedule().getUom());
            this.estimateTemplate.addActivity(activity);
        }
    }

    protected boolean validSorActivity(EstimateTemplateActivity activity) {
        return activity != null && activity.getSchedule() != null && activity.getSchedule().getId() != null;
    }

    protected void populateNonSorActivities() {
        for (EstimateTemplateActivity activity : this.nonSorActivities) {
            if (activity == null) continue;
            activity.setUom(activity.getNonSor().getUom());
            activity.getNonSor().setCreatedBy(this.worksService.getCurrentLoggedInUser());
            activity.getNonSor().setCreatedDate(new Date());
            activity.getNonSor().setLastModifiedBy(this.worksService.getCurrentLoggedInUser());
            activity.getNonSor().setLastModifiedDate(new Date());
            this.estimateTemplate.addActivity(activity);
        }
    }

    private void populateActivities() {
        for (EstimateTemplateActivity activity : this.estimateTemplate.getEstimateTemplateActivities()) {
            activity.setEstimateTemplate(this.estimateTemplate);
            activity.setCreatedBy(this.worksService.getCurrentLoggedInUser());
            activity.setCreatedDate(new Date());
            activity.setModifiedBy(this.worksService.getCurrentLoggedInUser());
            activity.setModifiedDate(new Date());
        }
        this.persistenceService.applyAuditing((BaseModel)this.estimateTemplate);
    }

    protected void populateCategoryList(AjaxEstimateAction ajaxEstimateAction, boolean categoryPopulated) {
        if (categoryPopulated) {
            ajaxEstimateAction.setCategory(this.estimateTemplate.getWorkType().getId());
            ajaxEstimateAction.subcategories();
            this.addDropdownData("categoryList", ajaxEstimateAction.getSubCategories());
        } else {
            this.addDropdownData("categoryList", Collections.emptyList());
        }
    }

    public boolean validCode() {
        boolean status = false;
        if (this.estimateTemplate != null && this.estimateTemplate.getCode() != null) {
            AjaxEstimateTemplateAction ajaxEstimateTemplateAction = new AjaxEstimateTemplateAction();
            ajaxEstimateTemplateAction.setCode(this.estimateTemplate.getCode());
            ajaxEstimateTemplateAction.setPersistenceService(this.persistenceService);
            if (ajaxEstimateTemplateAction.getCodeCheck()) {
                status = true;
            }
        }
        return status;
    }

    @Action(value="/estimate/estimateTemplate-searchDetails")
    public String searchDetails() {
        if (this.estimateTemplate.getWorkType() == null || this.estimateTemplate.getWorkType().getId() == -1L) {
            String messageKey = "estimate.template.search.workType.error";
            this.addActionError(this.getText("estimate.template.search.workType.error"));
            return SEARCH;
        }
        this.setPageSize(30);
        super.search();
        return SEARCH;
    }

    public List<EstimateTemplateActivity> getSorActivities() {
        return this.sorActivities;
    }

    public void setSorActivities(List<EstimateTemplateActivity> sorActivities) {
        this.sorActivities = sorActivities;
    }

    public List<EstimateTemplateActivity> getNonSorActivities() {
        return this.nonSorActivities;
    }

    public void setNonSorActivities(List<EstimateTemplateActivity> nonSorActivities) {
        this.nonSorActivities = nonSorActivities;
    }

    public PersistenceService<EstimateTemplate, Long> getEstimateTemplateService() {
        return this.estimateTemplateService;
    }

    public void setEstimateTemplateService(PersistenceService<EstimateTemplate, Long> estimateTemplateService) {
        this.estimateTemplateService = estimateTemplateService;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String dynQuery = " from EstimateTemplate et where et.id is not null ";
        ArrayList<Number> paramList = new ArrayList<Number>();
        dynQuery = dynQuery + " and et.status = ?";
        paramList.add(this.estimateTemplate.getStatus());
        if (this.estimateTemplate.getWorkType() != null && this.estimateTemplate.getWorkType().getId() != -1L) {
            dynQuery = dynQuery + " and et.workType.id = ? ";
            paramList.add(this.estimateTemplate.getWorkType().getId());
        }
        if (this.estimateTemplate.getSubType() != null && this.estimateTemplate.getSubType().getId() != -1L) {
            dynQuery = dynQuery + " and et.subType.id = ? ";
            paramList.add(this.estimateTemplate.getSubType().getId());
        }
        if (StringUtils.isNotBlank((String)this.estimateTemplate.getCode().trim())) {
            dynQuery = dynQuery + " and UPPER(et.code) like '%" + this.estimateTemplate.getCode().trim().toUpperCase() + "%'";
        }
        if (StringUtils.isNotBlank((String)this.estimateTemplate.getName().trim())) {
            dynQuery = dynQuery + " and UPPER(et.name) like '%" + this.estimateTemplate.getName().trim().toUpperCase() + "%'";
        }
        if (StringUtils.isNotBlank((String)this.estimateTemplate.getDescription().trim())) {
            dynQuery = dynQuery + " and UPPER(et.description) like '%" + this.estimateTemplate.getDescription().trim().toUpperCase() + "%'";
        }
        String countQuery = "select distinct count(et) " + dynQuery;
        return new SearchQueryHQL(dynQuery, countQuery, paramList);
    }

    public String getSourcePage() {
        return this.sourcePage;
    }

    public void setSourcePage(String sourcePage) {
        this.sourcePage = sourcePage;
    }

    public Long getTypeOfWork() {
        return this.typeOfWork;
    }

    public void setTypeOfWork(Long typeOfWork) {
        this.typeOfWork = typeOfWork;
    }

    public String getEstimateTemplateCode() {
        return this.estimateTemplateCode;
    }

    public void setEstimateTemplateCode(String estimateTemplateCode) {
        this.estimateTemplateCode = estimateTemplateCode;
    }

    public Long getSubTypeOfWork() {
        return this.subTypeOfWork;
    }

    public void setSubTypeOfWork(Long subTypeOfWork) {
        this.subTypeOfWork = subTypeOfWork;
    }

    public AbstractEstimateService getAbstractEstimateService() {
        return this.abstractEstimateService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }
}

