/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.assets.model.Asset;
import org.egov.common.entity.UOM;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.Fundsource;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FundSourceHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infra.workflow.service.StateService;
import org.egov.model.budget.BudgetUsage;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EisUtilService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.AssetsForEstimate;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.entity.MultiYearEstimate;
import org.egov.works.abstractestimate.entity.OverheadValue;
import org.egov.works.models.masters.DepositCode;
import org.egov.works.models.masters.NatureOfWork;
import org.egov.works.models.masters.Overhead;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"print"}, type="stream", location="XlsInputStream", params={"inputName", "XlsInputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=AbstractEstimate-BillOfQuantites.xls"}), @Result(name={"new"}, location="abstractEstimate-new.jsp"), @Result(name={"maps"}, location="abstractEstimate-maps.jsp"), @Result(name={"edit"}, location="abstractEstimate-edit.jsp"), @Result(name={"success"}, location="abstractEstimate-success.jsp"), @Result(name={"history"}, location="abstractEstimate-history.jsp")})
public class AbstractEstimateAction
extends GenericWorkFlowAction {
    private static final long serialVersionUID = -4801105778751138267L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private static final String CANCEL_ACTION = "Cancel";
    private static final String SAVE_ACTION = "Save";
    private static final Object REJECT_ACTION = "Reject";
    private static final Object FORWARD_ACTION = "Forward";
    private static final String SOURCE_SEARCH = "search";
    private static final String KEY_NAME = "SKIP_BUDGET_CHECK";
    public static final String MAPS = "maps";
    public static final String HISTORY = "history";
    public static final String ABSTRACTESTIMATE = "AbstractEstimate";
    private AbstractEstimate abstractEstimate = new AbstractEstimate();
    private List<Activity> sorActivities = new LinkedList();
    private List<Activity> nonSorActivities = new LinkedList();
    private List<OverheadValue> actionOverheadValues = new LinkedList();
    private List<AssetsForEstimate> actionAssetValues = new LinkedList();
    private List<MultiYearEstimate> actionMultiYearEstimateValues = new LinkedList();
    private AbstractEstimateService abstractEstimateService;
    @Autowired
    private EmployeeService employeeService;
    private String messageKey;
    private String sourcepage = "";
    private String assetStatus;
    private Integer approverUserId;
    private Long departmentId;
    private Integer designationId;
    private String approverComments;
    private Long stateValue;
    private String estimateValue;
    private ReportService reportService;
    public static final String BOQ = "Bill Of Qunatities";
    private InputStream xlsInputStream;
    public static final String PRINT = "print";
    private String mode = "";
    private boolean isAllowEstDateModify = false;
    private String employeeName;
    private String designation;
    private WorksService worksService;
    private Long estimateId;
    private String cancellationReason;
    private String cancelRemarks;
    private String errorCode;
    private String mapMode;
    private String latitude;
    private String longitude;
    @Autowired
    private EisUtilService eisService;
    private List<Object> woDetails;
    private List<Object> wpDetails;
    private BigDecimal paymentReleased = BigDecimal.ZERO;
    private ContractorBillService contractorBillService;
    @Autowired
    private FundSourceHibernateDAO fundSourceHibernateDAO;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<AbstractEstimate> abstractEstimateWorkflowService;
    private Long stateId;
    private final List<StateHistory> workflowHistory = new LinkedList();
    @Autowired
    private StateService stateService;
    private String currentFinancialYearId;
    private Long id;

    public String getMessageKey() {
        return this.messageKey;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AbstractEstimateAction() {
        this.addRelatedEntity("fundSource", Fundsource.class);
        this.addRelatedEntity("userDepartment", Department.class);
        this.addRelatedEntity("executingDepartment", Department.class);
        this.addRelatedEntity("ward", Boundary.class);
        this.addRelatedEntity("natureOfWork", NatureOfWork.class);
        this.addRelatedEntity("category", EgwTypeOfWork.class);
        this.addRelatedEntity("parentCategory", EgwTypeOfWork.class);
        this.addRelatedEntity("depositCode", DepositCode.class);
    }

    @Action(value="/estimate/abstractEstimate-edit")
    public String edit() {
        if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = SOURCE_SEARCH;
        }
        this.getWorkOrderDetails();
        return "edit";
    }

    private void getWorkOrderDetails() {
        ArrayList<Integer> projectCodeIdList = new ArrayList<Integer>();
        if ("ADMIN_SANCTIONED".equalsIgnoreCase(this.abstractEstimate.getEgwStatus().getCode())) {
            this.woDetails = this.abstractEstimateService.getWODetailsForEstimateId(this.id);
            this.wpDetails = this.abstractEstimateService.getWPDetailsForEstimateId(this.id);
            if (this.abstractEstimate.getProjectCode() != null) {
                projectCodeIdList.add(this.abstractEstimate.getProjectCode().getId().intValue());
                this.paymentReleased = this.contractorBillService.getTotalExpenditure(projectCodeIdList, "PROJECTCODE");
            }
        }
    }

    @SkipValidation
    @Action(value="/estimate/abstractEstimate-viewBillOfQuantitiesXls")
    public String viewBillOfQuantitiesXls() throws JRException, Exception {
        AbstractEstimate estimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.id, false);
        ReportRequest reportRequest = new ReportRequest("BillOfQuantities", estimate.getSORActivities(), this.createHeaderParams(estimate, BOQ));
        reportRequest.setReportFormat(ReportConstants.FileFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.xlsInputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return PRINT;
    }

    private Map createHeaderParams(AbstractEstimate estimate, String type) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (type.equalsIgnoreCase(BOQ)) {
            reportParams.put("workName", estimate.getName());
            reportParams.put("deptName", estimate.getExecutingDepartment().getName());
            reportParams.put("estimateNo", estimate.getEstimateNumber());
            reportParams.put("activitySize", estimate.getSORActivities() == null ? 0 : estimate.getSORActivities().size());
            reportParams.put("NonSOR_Activities", estimate.getNonSORActivities());
            reportParams.put("grandTotalAmt", this.getGrandTotalForEstimate(estimate));
        }
        return reportParams;
    }

    private Double getGrandTotalForEstimate(AbstractEstimate estimate) {
        Double total = 0.0;
        for (Activity act : estimate.getActivities()) {
            total = total + act.getAmount().getValue();
        }
        return total;
    }

    @Action(value="/estimate/abstractEstimate-workflowHistory")
    public String workflowHistory() {
        if (this.stateId != null) {
            State state = this.stateService.getStateById(this.stateId);
            this.workflowHistory.addAll(state.getHistory());
            this.workflowHistory.add(new StateHistory(state));
        }
        return HISTORY;
    }

    public StateAware getModel() {
        return this.abstractEstimate;
    }

    protected void setModel(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public void prepare() {
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setEisService(this.eisService);
        if (this.id != null && "edit".equals("edit")) {
            this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.id, false);
            this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.merge((Object)this.abstractEstimate);
        }
        super.prepare();
        CFinancialYear financialYear = this.getCurrentFinancialYear();
        if (financialYear != null) {
            this.currentFinancialYearId = financialYear.getId().toString();
        }
        this.setupDropdownDataExcluding(new String[]{"ward", "category", "parentCategory", "fundSource", "depositCode"});
        this.addDropdownData("parentCategoryList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw1 where etw1.parentid is null", new Object[0]));
        List uomList = this.getPersistenceService().findAllBy("from UOM  order by upper(uom)", new Object[0]);
        if (this.id == null && this.abstractEstimate.getEgwStatus() == null || !SOURCE_SEARCH.equals(this.sourcepage) && this.abstractEstimate.getEgwStatus() != null && this.abstractEstimate.getEgwStatus().getCode().equals("REJECTED") || this.id != null && this.abstractEstimate.getEgwStatus() != null && this.abstractEstimate.getEgwStatus().getCode().equals("NEW")) {
            uomList = this.abstractEstimateService.prepareUomListByExcludingSpecialUoms(uomList);
        }
        this.addDropdownData("uomList", uomList);
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true", new Object[0]));
        this.addDropdownData("scheduleCategoryList", this.getPersistenceService().findAllBy("from ScheduleCategory order by upper(code)", new Object[0]));
        this.populateCategoryList(ajaxEstimateAction, this.abstractEstimate.getParentCategory() != null);
        this.populateOverheadsList(ajaxEstimateAction, this.abstractEstimate.getEstimateDate() != null);
        this.addDropdownData("fundSourceList", this.fundSourceHibernateDAO.findAllActiveIsLeafFundSources());
        Assignment latestAssignment = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser();
        if (latestAssignment != null) {
            this.approverDepartment = latestAssignment.getDepartment().getId().toString();
            if (this.abstractEstimate != null && this.abstractEstimate.getId() == null && this.abstractEstimate.getExecutingDepartment() == null) {
                this.abstractEstimate.setExecutingDepartment(latestAssignment.getDepartment());
            }
        }
    }

    @Action(value="/estimate/abstractEstimate-save")
    public String save() {
        if (!(this.workFlowAction == null || this.workFlowAction.equals(REJECT_ACTION) || this.workFlowAction.equals(SAVE_ACTION) || this.workFlowAction.equals(FORWARD_ACTION))) {
            this.validateNonSorActivities();
        }
        if (!this.workFlowAction.equals(REJECT_ACTION)) {
            this.validateDeptForDepositWorks();
        }
        if ((!CANCEL_ACTION.equals(this.workFlowAction) || this.abstractEstimate.getId() != null) && (this.abstractEstimate.getEgwStatus() == null || this.abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.REJECTED.toString()) && (this.workFlowAction.equals(FORWARD_ACTION) || this.workFlowAction.equals(SAVE_ACTION)) || this.abstractEstimate.getEgwStatus().getCode().equals("NEW"))) {
            this.populateEstimateDetails(this.workFlowAction);
        }
        if (this.workFlowAction.equals(FORWARD_ACTION) && (this.abstractEstimate.getEgwStatus() == null || this.abstractEstimate.getEgwStatus() != null && (this.abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.REJECTED.toString()) || this.abstractEstimate.getEgwStatus().getCode().equals("NEW")))) {
            this.validateForAssetSelection();
            this.validateForLatLongSelection();
        }
        try {
            this.transitionWorkFlow(this.abstractEstimate);
            this.abstractEstimateService.applyAuditing((AbstractAuditable)this.abstractEstimate.getState());
            this.abstractEstimateService.setEstimateNumber(this.abstractEstimate);
            if (this.abstractEstimate.getEgwStatus() != null && this.abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString())) {
                this.abstractEstimateService.setProjectCode(this.abstractEstimate);
                this.abstractEstimate.setApprovedDate(new Date());
            }
            this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.persist((Object)this.abstractEstimate);
        }
        catch (ValidationException valException) {
            throw new ValidationException(valException.getErrors());
        }
        this.messageKey = "estimate." + this.workFlowAction;
        this.addActionMessage(this.getText(this.messageKey, "The estimate was saved successfully"));
        if (SAVE_ACTION.equals(this.workFlowAction)) {
            this.sourcepage = "inbox";
        }
        return SAVE_ACTION.equals(this.workFlowAction) ? "edit" : "success";
    }

    public void transitionWorkFlow(AbstractEstimate abstractEstimate) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position position = null;
        Assignment wfInitiator = null;
        wfInitiator = this.getWorkflowInitiator(abstractEstimate);
        if (CANCEL_ACTION.equals(this.workFlowAction)) {
            if (wfInitiator.equals(userAssignment)) {
                abstractEstimate.transition().end().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(AbstractEstimate.EstimateStatus.CANCELLED.toString()).withDateInfo(currentDate.toDate()).withNextAction("END");
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(ABSTRACTESTIMATE, AbstractEstimate.EstimateStatus.CANCELLED.toString()));
            }
        } else if (REJECT_ACTION.equals(this.workFlowAction)) {
            abstractEstimate.transition().progressWithStateCopy().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(AbstractEstimate.EstimateStatus.REJECTED.toString()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("");
            abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(ABSTRACTESTIMATE, AbstractEstimate.EstimateStatus.REJECTED.toString()));
        } else if (SAVE_ACTION.equals(this.workFlowAction)) {
            if (abstractEstimate.getState() == null) {
                WorkFlowMatrix wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, null, this.getAdditionalRule(), this.currentState, null);
                abstractEstimate.transition().start().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getCurrentState()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition());
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(ABSTRACTESTIMATE, "NEW"));
            }
        } else {
            if (null != this.approverPositionId && this.approverPositionId != -1L) {
                position = (Position)this.persistenceService.find("from Position where id=?", new Object[]{this.approverPositionId});
            }
            if (abstractEstimate.getState() == null) {
                WorkFlowMatrix wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, null, this.getAdditionalRule(), this.currentState, null);
                abstractEstimate.transition().start().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(position).withNextAction(wfmatrix.getNextAction());
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(ABSTRACTESTIMATE, wfmatrix.getNextStatus()));
            } else {
                WorkFlowMatrix wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, null, this.getAdditionalRule(), abstractEstimate.getCurrentState().getValue(), null);
                if (wfmatrix.getNextAction() != null && wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    abstractEstimate.transition().end().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withNextAction(wfmatrix.getNextAction());
                } else {
                    abstractEstimate.transition().progressWithStateCopy().withSenderName(user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(position).withNextAction(wfmatrix.getNextAction());
                }
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(ABSTRACTESTIMATE, wfmatrix.getNextStatus()));
            }
        }
        if (!CANCEL_ACTION.equals(this.workFlowAction) && !SAVE_ACTION.equals(this.workFlowAction)) {
            this.setApproverAndDesignation(abstractEstimate);
        }
    }

    public void setApproverAndDesignation(AbstractEstimate abstractEstimate) {
        if (abstractEstimate.getEgwStatus() != null && !"NEW".equalsIgnoreCase(abstractEstimate.getEgwStatus().getCode())) {
            String result;
            Date date = new Date();
            if (abstractEstimate.getState().getCreatedDate() != null) {
                date = abstractEstimate.getState().getCreatedDate();
            }
            if ((result = this.worksService.getEmpNameDesignation(abstractEstimate.getState().getOwnerPosition(), date)) != null && !"@".equalsIgnoreCase(result)) {
                String empName = result.substring(0, result.lastIndexOf(64));
                String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
                this.setEmployeeName(empName);
                this.setDesignation(designation);
            }
        }
    }

    private Assignment getWorkflowInitiator(AbstractEstimate abstractEstimate) {
        Assignment wfInitiator = abstractEstimate.getCreatedBy() == null ? this.assignmentService.getPrimaryAssignmentForUser(this.worksService.getCurrentLoggedInUserId()) : this.assignmentService.getPrimaryAssignmentForUser(abstractEstimate.getCreatedBy().getId());
        return wfInitiator;
    }

    private void validateForAssetSelection() {
        String isAssetRequired;
        if (this.abstractEstimate.getNatureOfWork() != null && !this.abstractEstimate.getNatureOfWork().getName().equals("Deposit Works - Third Party Asset") && !this.abstractEstimate.getNatureOfWork().getName().equals("Deposit Works - No Asset Created") && (isAssetRequired = this.worksService.getWorksConfigValue("ASSET_MANDATORY")).equals("yes") && this.actionAssetValues != null) {
            boolean isAssetPresent = false;
            for (AssetsForEstimate assetValue : this.actionAssetValues) {
                if (assetValue == null || assetValue.getAsset() == null || assetValue.getAsset().getId() == null) continue;
                isAssetPresent = true;
                break;
            }
            if (!isAssetPresent) {
                throw new ValidationException(Arrays.asList(new ValidationError("estimate.asset.required", "estimate.asset.required")));
            }
        }
    }

    private void validateForLatLongSelection() {
        if (this.abstractEstimate.getLatitude() == null || this.abstractEstimate.getLongitude() == null || StringUtils.isBlank((String)this.abstractEstimate.getLocation())) {
            throw new ValidationException(Arrays.asList(new ValidationError("estimate.latlon.required", "estimate.latlon.required")));
        }
    }

    @Action(value="/estimate/abstractEstimate-maps")
    public String maps() {
        return MAPS;
    }

    private void validateNonSorActivities() {
        Set exceptionSor = this.worksService.getExceptionSOR().keySet();
        for (Activity activity : this.nonSorActivities) {
            UOM nonSorUom;
            if (activity == null || activity.getNonSor().getUom() == null || (nonSorUom = (UOM)this.getPersistenceService().find("from UOM where id = ?", new Object[]{activity.getNonSor().getUom().getId()})) == null || !exceptionSor.contains(nonSorUom.getUom())) continue;
            this.setSourcepage("inbox");
            throw new ValidationException(Arrays.asList(new ValidationError("validate.nonSor.uom", "validate.nonSor.uom")));
        }
    }

    public String downloadTemplate() {
        return "template";
    }

    protected void populateCategoryList(AjaxEstimateAction ajaxEstimateAction, boolean categoryPopulated) {
        if (categoryPopulated) {
            ajaxEstimateAction.setCategory(this.abstractEstimate.getParentCategory().getId());
            ajaxEstimateAction.subcategories();
            this.addDropdownData("categoryList", ajaxEstimateAction.getSubCategories());
        } else {
            this.addDropdownData("categoryList", Collections.emptyList());
        }
    }

    protected void populateOverheadsList(AjaxEstimateAction ajaxEstimateAction, boolean estimateDatePresent) {
        if (estimateDatePresent) {
            ajaxEstimateAction.setEstDate(this.abstractEstimate.getEstimateDate());
            ajaxEstimateAction.overheads();
            this.addDropdownData("overheadsList", ajaxEstimateAction.getOverheads());
        } else {
            ajaxEstimateAction.setEstDate(new Date());
            ajaxEstimateAction.overheads();
            this.addDropdownData("overheadsList", ajaxEstimateAction.getOverheads());
        }
    }

    public String execute() {
        return "success";
    }

    @Action(value="/estimate/abstractEstimate-newform")
    public String newform() {
        return "new";
    }

    private void populateEstimateDetails(String actionName) {
        this.abstractEstimate.getActivities().clear();
        this.abstractEstimate.getOverheadValues().clear();
        this.abstractEstimate.getAssetValues().clear();
        this.abstractEstimate.getMultiYearEstimates().clear();
        this.populateSorActivities();
        this.populateNonSorActivities();
        this.populateActivities();
        this.populateOverheads();
        this.populateAssets();
        this.populateMultiYearEstimates();
        this.abstractEstimate.setWorkValue(this.abstractEstimate.getWorkValue());
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        this.populateOverheadsList(ajaxEstimateAction, this.abstractEstimate.getEstimateDate() != null);
        if (!SAVE_ACTION.equals(actionName) && !CANCEL_ACTION.equals(actionName) && !REJECT_ACTION.equals(actionName) && this.abstractEstimate.getWorkValue() <= 0.0) {
            this.errorCode = "estimate.workvalue.null";
            throw new ValidationException(Arrays.asList(new ValidationError("estimate.workvalue.null", "estimate.workvalue.null")));
        }
    }

    protected void populateSorActivities() {
        for (Activity activity : this.sorActivities) {
            if (!this.validSorActivity(activity)) continue;
            activity.setSchedule((ScheduleOfRate)this.getPersistenceService().find("from ScheduleOfRate where id = ?", new Object[]{activity.getSchedule().getId()}));
            activity.setUom(activity.getSchedule().getUom());
            this.abstractEstimate.addActivity(activity);
        }
    }

    protected boolean validSorActivity(Activity activity) {
        return activity != null && activity.getSchedule() != null && activity.getSchedule().getId() != null;
    }

    protected void populateNonSorActivities() {
        for (Activity activity : this.nonSorActivities) {
            if (activity == null) continue;
            activity.setUom(activity.getNonSor().getUom());
            activity.getNonSor().setCreatedBy(this.worksService.getCurrentLoggedInUser());
            activity.getNonSor().setCreatedDate(new Date());
            activity.getNonSor().setLastModifiedBy(this.worksService.getCurrentLoggedInUser());
            activity.getNonSor().setLastModifiedDate(new Date());
            this.abstractEstimate.addActivity(activity);
        }
    }

    private void populateActivities() {
        for (Activity activity : this.abstractEstimate.getActivities()) {
            activity.setCreatedBy(this.worksService.getCurrentLoggedInUser());
            activity.setCreatedDate(new Date());
            activity.setLastModifiedBy(this.worksService.getCurrentLoggedInUser());
            activity.setLastModifiedDate(new Date());
            activity.setAbstractEstimate(this.abstractEstimate);
        }
    }

    protected void populateOverheads() {
        for (OverheadValue overheadValue : this.actionOverheadValues) {
            if (!this.validOverhead(overheadValue)) continue;
            overheadValue.setOverhead((Overhead)this.getPersistenceService().find("from Overhead where id = ?", new Object[]{overheadValue.getOverhead().getId()}));
            overheadValue.setAbstractEstimate(this.abstractEstimate);
            overheadValue.setCreatedBy(this.worksService.getCurrentLoggedInUser());
            overheadValue.setCreatedDate(new Date());
            overheadValue.setLastModifiedBy(this.worksService.getCurrentLoggedInUser());
            overheadValue.setLastModifiedDate(new Date());
            this.abstractEstimate.addOverheadValue(overheadValue);
        }
    }

    protected boolean validOverhead(OverheadValue overheadValue) {
        return overheadValue != null && overheadValue.getOverhead() != null && overheadValue.getOverhead().getId() != null && overheadValue.getOverhead().getId() != -1L && overheadValue.getOverhead().getId() != 0L;
    }

    protected void populateAssets() {
        LinkedList<ValidationError> valErrList = new LinkedList<ValidationError>();
        List strStatus = this.getStatusList();
        HashSet<String> validAssetCodes = new HashSet<String>();
        for (AssetsForEstimate assetValue : this.actionAssetValues) {
            String message;
            if (!this.validAsset(assetValue)) continue;
            Asset lAsset = (Asset)this.getPersistenceService().find("from Asset where code = ?", new Object[]{assetValue.getAsset().getCode()});
            if (lAsset == null) {
                message = "Asset code '" + assetValue.getAsset().getCode() + "' does not exist. Please create the asset before link.";
                valErrList.add(new ValidationError(message, message));
                continue;
            }
            if (!this.checkValidStatus(lAsset, strStatus)) {
                message = "Asset code '" + assetValue.getAsset().getCode() + "' can't be link for selected nature of work.";
                valErrList.add(new ValidationError(message, message));
            }
            if (validAssetCodes.contains(lAsset.getCode())) {
                message = "Please remove the duplicate entry for Asset code '" + lAsset.getCode() + "'";
                valErrList.add(new ValidationError(message, message));
            } else {
                validAssetCodes.add(lAsset.getCode());
            }
            assetValue.setAsset(lAsset);
            assetValue.setAbstractEstimate(this.abstractEstimate);
            assetValue.setCreatedBy(this.worksService.getCurrentLoggedInUser());
            assetValue.setCreatedDate(new Date());
            assetValue.setLastModifiedBy(this.worksService.getCurrentLoggedInUser());
            assetValue.setLastModifiedDate(new Date());
            this.abstractEstimate.addAssetValue(assetValue);
        }
        if (!valErrList.isEmpty()) {
            throw new ValidationException(valErrList);
        }
    }

    private List<String> getStatusList() {
        List<String> strStatus = null;
        strStatus = this.assetStatus == null ? new ArrayList<String>() : Arrays.asList(this.assetStatus.split(","));
        return strStatus;
    }

    private boolean checkValidStatus(Asset ass, List<String> strStatus) {
        for (String desc : strStatus) {
            if (!desc.trim().equalsIgnoreCase(ass.getStatus().getDescription())) continue;
            return true;
        }
        return false;
    }

    protected boolean validAsset(AssetsForEstimate assetValue) {
        return assetValue != null && assetValue.getAsset() != null && assetValue.getAsset().getCode() != null && !assetValue.getAsset().getCode().isEmpty();
    }

    protected void populateMultiYearEstimates() {
        int count = 1;
        double totalPerc = 0.0;
        for (MultiYearEstimate multiYearEstimate : this.actionMultiYearEstimateValues) {
            if (this.validMultiYearEstimate(multiYearEstimate)) {
                multiYearEstimate.setFinancialYear((CFinancialYear)this.getPersistenceService().find("from CFinancialYear where id = ?", new Object[]{multiYearEstimate.getFinancialYear().getId()}));
                multiYearEstimate.setAbstractEstimate(this.abstractEstimate);
                totalPerc += multiYearEstimate.getPercentage();
                multiYearEstimate.setCreatedBy(this.worksService.getCurrentLoggedInUser());
                multiYearEstimate.setCreatedDate(new Date());
                multiYearEstimate.setLastModifiedBy(this.worksService.getCurrentLoggedInUser());
                multiYearEstimate.setLastModifiedDate(new Date());
                this.abstractEstimate.addMultiYearEstimate(multiYearEstimate);
            }
            if (multiYearEstimate != null && this.actionMultiYearEstimateValues.size() == count && totalPerc != 0.0 && totalPerc < 100.0) {
                throw new ValidationException(Arrays.asList(new ValidationError("percentage", "multiYearEstimate.percentage.percentage_equals_100")));
            }
            if (multiYearEstimate != null && multiYearEstimate.getFinancialYear() == null || multiYearEstimate != null && multiYearEstimate.getFinancialYear() != null && multiYearEstimate.getFinancialYear().getId() != null && multiYearEstimate.getFinancialYear().getId() == 0L) {
                throw new ValidationException(Arrays.asList(new ValidationError("financialYear", "multiYeareEstimate.financialYear.null")));
            }
            ++count;
        }
    }

    protected boolean validMultiYearEstimate(MultiYearEstimate multiYearEstimate) {
        return multiYearEstimate != null && multiYearEstimate.getFinancialYear() != null && multiYearEstimate.getFinancialYear().getId() != null && multiYearEstimate.getFinancialYear().getId() != 0L && multiYearEstimate.getPercentage() >= 0.0;
    }

    public String cancelApprovedEstimate() {
        this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.estimateId, false);
        String oldEstimateNo = this.abstractEstimate.getEstimateNumber();
        Employee employee = this.employeeService.getEmployeeById(this.worksService.getCurrentLoggedInUserId());
        String empName = "";
        if (employee != null) {
            empName = employee.getName();
        }
        if (this.cancelRemarks != null && StringUtils.isNotBlank((String)this.cancelRemarks)) {
            this.cancellationReason.concat(" : ").concat(this.cancelRemarks).concat(". ").concat(this.getText("estimate.cancel.cancelledby")).concat(": ").concat(empName);
        } else {
            this.cancellationReason.concat(". ").concat(this.getText("estimate.cancel.cancelledby")).concat(": ").concat(empName);
        }
        String newEstNo = this.abstractEstimate.getEstimateNumber() + "/C";
        this.abstractEstimate.setEstimateNumber(newEstNo);
        if (this.isSkipBudgetCheck().booleanValue()) {
            this.abstractEstimateService.releaseDepositWorksAmountOnReject((FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0));
        } else {
            this.abstractEstimateService.releaseBudgetOnReject((FinancialDetail)this.abstractEstimate.getFinancialDetails().get(0));
        }
        this.abstractEstimate.getProjectCode().setActive(false);
        this.abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(ABSTRACTESTIMATE, AbstractEstimate.EstimateStatus.CANCELLED.toString()));
        this.getBudgetUsageListForEstimateNumber(oldEstimateNo);
        this.messageKey = "estimate.cancel";
        return "success";
    }

    private void getBudgetUsageListForEstimateNumber(String estimateNo) {
        List budgetUsageList = this.abstractEstimateService.getBudgetUsageListForEstNo(estimateNo);
        if (budgetUsageList != null && !budgetUsageList.isEmpty()) {
            for (BudgetUsage bu : budgetUsageList) {
                bu.setReferenceNumber(this.abstractEstimate.getEstimateNumber());
            }
        }
    }

    private void validateDeptForDepositWorks() {
        if (this.isDepositWorksType().booleanValue() && this.abstractEstimate.getUserDepartment() != null && this.abstractEstimate.getUserDepartment().getId() != null && this.abstractEstimate.getExecutingDepartment() != null && this.abstractEstimate.getExecutingDepartment().getId() != null && this.abstractEstimate.getExecutingDepartment().getId() != this.abstractEstimate.getUserDepartment().getId()) {
            this.abstractEstimate.getActivities().clear();
            this.abstractEstimate.getAssetValues().clear();
            this.abstractEstimate.getOverheadValues().clear();
            this.abstractEstimate.getMultiYearEstimates().clear();
            this.populateSorActivities();
            this.populateNonSorActivities();
            this.populateActivities();
            this.populateOverheads();
            this.populateAssets();
            this.populateMultiYearEstimates();
            this.errorCode = "estimate.depositworks.dept.check";
            throw new ValidationException(Arrays.asList(new ValidationError("estimate.depositworks.dept.check", "estimate.depositworks.dept.check")));
        }
    }

    private Boolean isDepositWorksType() {
        boolean isDepositWorks = false;
        List depositTypeList = this.getAppConfigValuesToSkipBudget();
        for (String type : depositTypeList) {
            if (!type.equals(this.abstractEstimate.getNatureOfWork().getName())) continue;
            isDepositWorks = true;
        }
        return isDepositWorks;
    }

    private Boolean isSkipBudgetCheck() {
        boolean skipBudget = false;
        if (this.abstractEstimate != null && this.abstractEstimate.getId() != null) {
            skipBudget = this.isDepositWorksType();
        }
        return skipBudget;
    }

    public AbstractEstimateService getAbstractEstimateService() {
        return this.abstractEstimateService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public List<Activity> getSorActivities() {
        return this.sorActivities;
    }

    public void setSorActivities(List<Activity> sorActivities) {
        this.sorActivities = sorActivities;
    }

    public List<Activity> getNonSorActivities() {
        return this.nonSorActivities;
    }

    public void setNonSorActivities(List<Activity> nonSorActivities) {
        this.nonSorActivities = nonSorActivities;
    }

    public List<OverheadValue> getActionOverheadValues() {
        return this.actionOverheadValues;
    }

    public void setActionOverheadValues(List<OverheadValue> actionOverheadValues) {
        this.actionOverheadValues = actionOverheadValues;
    }

    public List<AssetsForEstimate> getActionAssetValues() {
        return this.actionAssetValues;
    }

    public void setActionAssetValues(List<AssetsForEstimate> actionAssetValues) {
        this.actionAssetValues = actionAssetValues;
    }

    public String getCurrentFinancialYearId() {
        return this.currentFinancialYearId;
    }

    public void setCurrentFinancialYearId(String currentFinancialYearId) {
        this.currentFinancialYearId = currentFinancialYearId;
    }

    protected CFinancialYear getCurrentFinancialYear() {
        if (this.abstractEstimate.getEstimateDate() != null) {
            return this.financialYearHibernateDAO.getFinYearByDate(this.abstractEstimate.getEstimateDate());
        }
        return this.financialYearHibernateDAO.getFinYearByDate(new Date());
    }

    public List<MultiYearEstimate> getActionMultiYearEstimateValues() {
        return this.actionMultiYearEstimateValues;
    }

    public void setActionMultiYearEstimateValues(List<MultiYearEstimate> actionMultiYearEstimateValues) {
        this.actionMultiYearEstimateValues = actionMultiYearEstimateValues;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getAssetStatus() {
        return this.assetStatus;
    }

    public void setAssetStatus(String assetStatus) {
        this.assetStatus = assetStatus;
    }

    public Integer getApproverUserId() {
        return this.approverUserId;
    }

    public void setApproverUserId(Integer approverUserId) {
        this.approverUserId = approverUserId;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public String getApproverComments() {
        return this.approverComments;
    }

    public void setApproverComments(String approverComments) {
        this.approverComments = approverComments;
    }

    public Long getStateValue() {
        return this.stateValue;
    }

    public void setStateValue(Long stateValue) {
        this.stateValue = stateValue;
    }

    public List<String> getAppConfigValuesToSkipBudget() {
        return this.worksService.getNatureOfWorkAppConfigValues("Works Management", KEY_NAME);
    }

    public String getEstimateValue() {
        return this.estimateValue;
    }

    public void setEstimateValue(String estimateValue) {
        this.estimateValue = estimateValue;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public InputStream getXlsInputStream() {
        return this.xlsInputStream;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancelRemarks() {
        return this.cancelRemarks;
    }

    public void setCancelRemarks(String cancelRemarks) {
        this.cancelRemarks = cancelRemarks;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public boolean getIsAllowEstDateModify() {
        return this.isAllowEstDateModify;
    }

    public void setIsAllowEstDateModify(boolean isAllowEstDateModify) {
        this.isAllowEstDateModify = isAllowEstDateModify;
    }

    public String getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(String mapMode) {
        this.mapMode = mapMode;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getPaymentReleased() {
        return this.paymentReleased;
    }

    public void setPaymentReleased(BigDecimal paymentReleased) {
        this.paymentReleased = paymentReleased;
    }

    public ContractorBillService getContractorBillService() {
        return this.contractorBillService;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
        this.contractorBillService = contractorBillService;
    }

    public List<Object> getWoDetails() {
        return this.woDetails;
    }

    public void setWoDetails(List<Object> woDetails) {
        this.woDetails = woDetails;
    }

    public List<Object> getWpDetails() {
        return this.wpDetails;
    }

    public void setWpDetails(List<Object> wpDetails) {
        this.wpDetails = wpDetails;
    }

    public void setStateId(Long stateId) {
        this.stateId = stateId;
    }

    public List<StateHistory> getWorkflowHistory() {
        return this.workflowHistory;
    }
}

