/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractorBill;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPageExt;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.measurementbook.MBForCancelledBill;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksService;
import org.egov.works.services.impl.MeasurementBookServiceImpl;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@Result(name={"search"}, location="searchBill-search.jsp")
public class SearchBillAction
extends BaseFormAction {
    private static final long serialVersionUID = 1691106236053172675L;
    private String status;
    private String contractor;
    private Date fromDate;
    private Date toDate;
    private String workordercode;
    private String billno;
    private WorkOrderService workOrderService;
    private String workorderid;
    private Long contractorId;
    @Autowired
    private EmployeeServiceOld employeeService;
    private ContractorBillService contractorBillService;
    private WorksService worksService;
    public static final String SEARCH = "search";
    private static final String BILL_MODULE_KEY = "CONTRACTORBILL";
    private static final String NEW_STATUS = "NEW";
    private static final String DATE_FORMAT_DD_MMM_YYYY = "dd-MMM-yyyy";
    private ContractorBillRegister contractorBillRegister = new ContractorBillRegister();
    private MeasurementBookServiceImpl measurementBookService;
    private PersistenceService<MBForCancelledBill, Long> cancelBillService;
    private Long contractorBillId;
    private String messageKey;
    private String sourcePage;
    private String billNumber;
    private String cancellationReason;
    private String cancelRemarks;
    private Integer execDeptid;
    private Integer billDeptId;
    private Integer page = 1;
    private Integer pageSize = 30;
    private EgovPaginatedList pagedResults;
    List<ContractorBillRegister> contractorBillList = null;
    private String estimateNo;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;

    public Object getModel() {
        return null;
    }

    public List<EgwStatus> getBillStatuses() {
        List statusList = this.egwStatusHibernateDAO.getStatusByModule(BILL_MODULE_KEY);
        ArrayList<EgwStatus> latestStatusList = new ArrayList<EgwStatus>();
        if (!statusList.isEmpty()) {
            for (EgwStatus egwStatus : statusList) {
                if (egwStatus.getCode().equals(NEW_STATUS)) continue;
                latestStatusList.add(egwStatus);
            }
        }
        return latestStatusList;
    }

    @Action(value="/contractorBill/searchBill-search")
    public String search() {
        return SEARCH;
    }

    public String edit() {
        return this.searchBill();
    }

    public String execute() {
        return this.searchBill();
    }

    public String searchBill() {
        Page resPage;
        Long count;
        HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
        ArrayList paramList = new ArrayList();
        List qryObj = new ArrayList();
        if (StringUtils.isNotBlank((String)this.getWorkordercode())) {
            criteriaMap.put("WORKORDER_NO", this.getWorkordercode());
        }
        if (this.getContractorId() != -1L) {
            criteriaMap.put("CONTRACTOR_ID", this.getContractorId());
        }
        if (StringUtils.isNotBlank((String)this.getBillno())) {
            criteriaMap.put("BILLNO", this.getBillno());
        }
        if (this.fromDate != null && this.toDate != null && !DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
            this.addFieldError("fromDate", this.getText("greaterthan.endDate.fromDate"));
        }
        if (this.toDate != null && !DateUtils.compareDates((Date)new Date(), (Date)this.getToDate())) {
            this.addFieldError("toDate", this.getText("greaterthan.endDate.currentdate"));
        }
        if (this.fromDate != null && this.toDate == null) {
            criteriaMap.put("FROM_DATE", new Date(DateUtils.getFormattedDate((Date)this.getFromDate(), (String)DATE_FORMAT_DD_MMM_YYYY)));
        } else if (this.toDate != null && this.fromDate == null) {
            criteriaMap.put("TO_DATE", new Date(DateUtils.getFormattedDate((Date)this.getToDate(), (String)DATE_FORMAT_DD_MMM_YYYY)));
        } else if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            criteriaMap.put("FROM_DATE", new Date(DateUtils.getFormattedDate((Date)this.getFromDate(), (String)DATE_FORMAT_DD_MMM_YYYY)));
            criteriaMap.put("TO_DATE", new Date(DateUtils.getFormattedDate((Date)this.getToDate(), (String)DATE_FORMAT_DD_MMM_YYYY)));
        }
        if (this.execDeptid != null && this.execDeptid != -1) {
            criteriaMap.put("EXEC_DEPT_ID", this.execDeptid);
        }
        if (this.billDeptId != null && this.billDeptId != -1) {
            criteriaMap.put("BILL_DEPT_ID", this.billDeptId);
        }
        if (this.estimateNo != null && !"".equalsIgnoreCase(this.estimateNo)) {
            criteriaMap.put("EST_NO", this.estimateNo);
        }
        if (!this.getStatus().equals("-1")) {
            criteriaMap.put("BILLSTATUS", this.getStatus());
        }
        qryObj = this.contractorBillService.searchContractorBill(criteriaMap, paramList);
        String qry = (String)qryObj.get(0);
        if (paramList.isEmpty()) {
            Object params = null;
            count = (Long)this.persistenceService.find((String)qryObj.get(0));
            Query qry1 = this.persistenceService.getSession().createQuery(qry);
            resPage = new Page(qry1, this.page, this.pageSize);
        } else {
            Object[] params = new Object[paramList.size()];
            params = paramList.toArray(params);
            count = (Long)this.persistenceService.find((String)qryObj.get(1), params);
            resPage = this.persistenceService.findPageBy(qry, this.page, this.pageSize, params);
        }
        this.pagedResults = new EgovPaginatedList(resPage, count.intValue());
        List list = this.contractorBillList = this.pagedResults != null ? this.pagedResults.getList() : null;
        if (!this.contractorBillList.isEmpty()) {
            this.contractorBillList = this.getPositionAndUser(this.contractorBillList);
        }
        this.pagedResults.setList(this.contractorBillList);
        return SEARCH;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("ContractorList", this.workOrderService.getAllContractorForWorkOrder());
        List departmentList = this.getPersistenceService().findAllBy("from DepartmentImpl", new Object[0]);
        this.addDropdownData("billDepartmentList", departmentList);
        this.addDropdownData("executingDepartmentList", departmentList);
        if ("cancelBill".equals(this.sourcePage)) {
            this.setStatus(ContractorBillRegister.BillStatus.APPROVED.toString());
        }
    }

    @ValidationErrorPageExt(action="search", makeCall=true, toMethod="searchBill")
    public String cancelApprovedBill() throws Exception {
        this.contractorBillRegister = (ContractorBillRegister)this.contractorBillService.findById((Serializable)this.contractorBillId, false);
        List mbHeaderListForBillId = this.measurementBookService.findAllByNamedQuery("getAllMBsForBillId", new Object[]{MBHeader.MeasurementBookStatus.APPROVED.toString(), this.contractorBillRegister.getId()});
        for (MBHeader mbObj : mbHeaderListForBillId) {
            MBForCancelledBill mbCB = new MBForCancelledBill();
            mbCB.setEgBillregister(mbObj.getEgBillregister());
            mbCB.setMbHeader(mbObj);
            this.cancelBillService.persist((Object)mbCB);
        }
        this.contractorBillRegister.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(BILL_MODULE_KEY, ContractorBillRegister.BillStatus.CANCELLED.toString()));
        this.contractorBillRegister.setBillstatus(ContractorBillRegister.BillStatus.CANCELLED.toString());
        PersonalInformation prsnlInfo = this.employeeService.getEmpForUserId(this.worksService.getCurrentLoggedInUserId());
        String empName = "";
        if (prsnlInfo.getEmployeeFirstName() != null) {
            empName = prsnlInfo.getEmployeeFirstName();
        }
        if (prsnlInfo.getEmployeeLastName() != null) {
            empName = empName.concat(" ").concat(prsnlInfo.getEmployeeLastName());
        }
        if (this.cancelRemarks == null || StringUtils.isNotBlank((String)this.cancelRemarks)) {
            // empty if block
        }
        this.billNumber = this.contractorBillRegister.getBillnumber();
        this.messageKey = "contractorBill." + this.contractorBillRegister.getBillstatus();
        return "success";
    }

    public String getContractor() {
        return this.contractor;
    }

    public String getWorkordercode() {
        return this.workordercode;
    }

    public String getBillno() {
        return this.billno;
    }

    public void setContractor(String contractor) {
        this.contractor = contractor;
    }

    public void setWorkordercode(String workordercode) {
        this.workordercode = workordercode;
    }

    public void setBillno(String billno) {
        this.billno = billno;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public String getWorkorderid() {
        return this.workorderid;
    }

    public void setWorkorderid(String workorderid) {
        this.workorderid = workorderid;
    }

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    protected List<ContractorBillRegister> getPositionAndUser(List<ContractorBillRegister> results) {
        ArrayList<ContractorBillRegister> billList = new ArrayList<ContractorBillRegister>();
        for (ContractorBillRegister br : results) {
            PersonalInformation emp = null;
            if (!br.getStatus().getCode().equalsIgnoreCase("APPROVED") && !br.getStatus().getCode().equalsIgnoreCase("CANCELLED")) {
                if (br.getCurrentState() != null) {
                    emp = this.employeeService.getEmployeeforPosition(br.getCurrentState().getOwnerPosition());
                }
                if (emp != null && StringUtils.isNotBlank((String)emp.getEmployeeName())) {
                    br.setOwner(emp.getEmployeeName());
                }
            }
            billList.add(br);
            String actions = this.worksService.getWorksConfigValue("BILL_SHOW_ACTIONS");
            if (StringUtils.isNotBlank((String)actions)) {
                List<String> showBillActionsList = Arrays.asList(actions.split(","));
                for (String action : showBillActionsList) {
                    if (action.equalsIgnoreCase("View Completion Certificate") && br.getBilltype().equals(this.worksService.getWorksConfigValue("FinalBillType"))) {
                        br.getBillActions().add(action);
                        continue;
                    }
                    if (action.equalsIgnoreCase("View Completion Certificate")) continue;
                    br.getBillActions().add(action);
                }
            }
            WorkOrder workOrderObj = (WorkOrder)this.getPersistenceService().find("from WorkOrder where workOrderNumber = ?", new Object[]{br.getWorkordernumber()});
            br.setWorkOrder(workOrderObj);
        }
        return billList;
    }

    public Map<String, Object> getContractorForApprovedWorkOrder() {
        HashMap<String, Object> contractorsWithWOList = new HashMap<String, Object>();
        if (this.workOrderService.getContractorsWithWO() != null) {
            for (Contractor contractor : this.workOrderService.getContractorsWithWO()) {
                contractorsWithWOList.put(contractor.getId() + "", contractor.getCode() + " - " + contractor.getName());
            }
        }
        return contractorsWithWOList;
    }

    public String getFinalBillTypeConfigValue() {
        return this.worksService.getWorksConfigValue("FinalBillType");
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
        this.contractorBillService = contractorBillService;
    }

    public void setMeasurementBookService(MeasurementBookServiceImpl measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public void setCancelBillService(PersistenceService<MBForCancelledBill, Long> cancelBillService) {
        this.cancelBillService = cancelBillService;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancelRemarks() {
        return this.cancelRemarks;
    }

    public void setCancelRemarks(String cancelRemarks) {
        this.cancelRemarks = cancelRemarks;
    }

    public ContractorBillRegister getContractorBillRegister() {
        return this.contractorBillRegister;
    }

    public void setContractorBillRegister(ContractorBillRegister contractorBillRegister) {
        this.contractorBillRegister = contractorBillRegister;
    }

    public Long getContractorBillId() {
        return this.contractorBillId;
    }

    public void setContractorBillId(Long contractorBillId) {
        this.contractorBillId = contractorBillId;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getSourcePage() {
        return this.sourcePage;
    }

    public void setSourcePage(String sourcePage) {
        this.sourcePage = sourcePage;
    }

    public Integer getExecDeptid() {
        return this.execDeptid;
    }

    public void setExecDeptid(Integer execDeptid) {
        this.execDeptid = execDeptid;
    }

    public List<ContractorBillRegister> getContractorBillList() {
        return this.contractorBillList;
    }

    public EgovPaginatedList getPagedResults() {
        return this.pagedResults;
    }

    public void setPagedResults(EgovPaginatedList pagedResults) {
        this.pagedResults = pagedResults;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getBillDeptId() {
        return this.billDeptId;
    }

    public void setBillDeptId(Integer billDeptId) {
        this.billDeptId = billDeptId;
    }

    public String getEstimateNo() {
        return this.estimateNo;
    }

    public void setEstimateNo(String estimateNo) {
        this.estimateNo = estimateNo;
    }
}

