/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.EgBilldetails;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.autonumber.ContractorBillNumberGenerator;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorderestimate.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/contractorbill"})
public class CreateContractorBillController
extends GenericWorkFlowController {
    private static final String BILLDATE = "billdate";
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, Model model, HttpServletRequest request) {
        String loaNumber = request.getParameter("loaNumber");
        WorkOrder workOrder = this.letterOfAcceptanceService.getApprovedWorkOrder(loaNumber);
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        this.setDropDownValues(model);
        model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
        this.prepareWorkflow(model, (StateAware)contractorBillRegister, new WorkflowContainer());
        model.addAttribute("mode", (Object)"edit");
        if (!lineEstimateDetails.getLineEstimate().isSpillOverFlag()) {
            contractorBillRegister.setBilldate(new Date());
        }
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByWorkOrderId(workOrder.getId());
        model.addAttribute("workOrderEstimate", (Object)workOrderEstimate);
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("contractorBillRegister", (Object)contractorBillRegister);
        model.addAttribute("defaultCutOffDate", (Object)this.worksApplicationProperties.getContractorBillCutOffDate());
        contractorBillRegister.setApprovalDepartment(this.worksUtils.getDefaultDepartmentId());
        return "contractorBill-form";
    }

    private void setDropDownValues(Model model) {
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        List contractorRefundAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByListOfPurposeName(WorksConstants.CONTRACTOR_REFUND_PURPOSE);
        model.addAttribute("netPayableAccounCodes", (Object)contractorPayableAccountList);
        model.addAttribute("refundAccounCodes", (Object)contractorRefundAccountList);
        model.addAttribute("billTypes", (Object)BillTypes.values());
    }

    @RequestMapping(value={"/contractorbill-save"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam String workFlowAction, @RequestParam(value="file") MultipartFile[] files) throws IOException {
        Integer partBillCount;
        String loaNumber = request.getParameter("loaNumber");
        WorkOrder workOrder = this.letterOfAcceptanceService.getApprovedWorkOrder(loaNumber);
        Date workCompletionDate = contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate();
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumberAndStatus(lineEstimateDetails.getEstimateNumber());
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getEstimateByWorkOrderAndEstimateAndStatus(workOrder.getId(), abstractEstimate.getId());
        contractorBillRegister.setWorkOrder(workOrder);
        contractorBillRegister.setWorkOrderEstimate(workOrderEstimate);
        contractorBillRegister.getWorkOrderEstimate().setWorkCompletionDate(workCompletionDate);
        this.validateInput(contractorBillRegister, lineEstimateDetails, resultBinder, request);
        contractorBillRegister = this.addBillDetails(contractorBillRegister, lineEstimateDetails, resultBinder, request);
        this.contractorBillRegisterService.validateRefundAmount(contractorBillRegister, resultBinder);
        this.contractorBillRegisterService.validateMileStonePercentage(contractorBillRegister, resultBinder);
        if (!this.contractorBillRegisterService.checkForDuplicateAccountCodes(contractorBillRegister)) {
            resultBinder.reject("error.contractorbill.duplicate.accountcodes", "error.contractorbill.duplicate.accountcodes");
        }
        if (!this.contractorBillRegisterService.validateDuplicateRefundAccountCodes(contractorBillRegister)) {
            resultBinder.reject("error.contractorbill.duplicate.refund.accountcodes", "error.contractorbill.duplicate.refund.accountcodes");
        }
        this.contractorBillRegisterService.validateTotalDebitAndCreditAmount(contractorBillRegister, resultBinder);
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
            model.addAttribute("workOrder", (Object)workOrder);
            model.addAttribute("workOrderEstimate", (Object)workOrderEstimate);
            model.addAttribute("netPayableAmount", (Object)request.getParameter("netPayableAmount"));
            model.addAttribute("netPayableAccountCode", (Object)request.getParameter("netPayableAccountCode"));
            model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            this.prepareWorkflow(model, (StateAware)contractorBillRegister, new WorkflowContainer());
            model.addAttribute("mode", (Object)"edit");
            model.addAttribute("billDetailsMap", (Object)this.contractorBillRegisterService.getBillDetailsMap(contractorBillRegister, model));
            model.addAttribute("cutOffDate", (Object)this.worksApplicationProperties.getContractorBillCutOffDate());
            return "contractorBill-form";
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ((partBillCount = this.contractorBillRegisterService.getMaxSequenceNumberByWorkOrder(workOrderEstimate)) == null || partBillCount == 0) {
            partBillCount = 1;
        } else {
            Integer n = partBillCount;
            Integer n2 = partBillCount = Integer.valueOf(partBillCount + 1);
        }
        contractorBillRegister.setBillSequenceNumber(partBillCount);
        ContractorBillNumberGenerator c = (ContractorBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ContractorBillNumberGenerator.class);
        String contractorBillNumber = c.getNextNumber(contractorBillRegister);
        contractorBillRegister.setBillnumber(contractorBillNumber);
        contractorBillRegister.setPassedamount(contractorBillRegister.getBillamount());
        ContractorBillRegister savedContractorBillRegister = null;
        try {
            savedContractorBillRegister = this.contractorBillRegisterService.create(contractorBillRegister, lineEstimateDetails, files, approvalPosition, approvalComment, null, workFlowAction);
        }
        catch (ValidationException e) {
            throw new ApplicationRuntimeException("error.contractorbill.budgetcheck.insufficient.amount");
        }
        String pathVars = this.worksUtils.getPathVars(savedContractorBillRegister.getStatus(), savedContractorBillRegister.getState(), savedContractorBillRegister.getId(), approvalPosition);
        return "redirect:/contractorbill/contractorbill-success?pathVars=" + pathVars + "&billNumber=" + savedContractorBillRegister.getBillnumber();
    }

    @RequestMapping(value={"/contractorbill-success"}, method={RequestMethod.GET})
    public String showContractorBillSuccessPage(@RequestParam(value="billNumber") String billNumber, Model model, HttpServletRequest request) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            model.addAttribute("approverName", (Object)approverName);
        }
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillByBillNumber(billNumber);
        String message = this.getMessageByStatus(contractorBillRegister, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        model.addAttribute("contractorBillRegister", (Object)contractorBillRegister);
        return "contractorBill-success";
    }

    private void validateInput(ContractorBillRegister contractorBillRegister, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        boolean validateBillInWorkflow = this.letterOfAcceptanceService.validateContractorBillInWorkflowForWorkorder(contractorBillRegister.getWorkOrder().getId());
        if (!validateBillInWorkflow) {
            resultBinder.reject("error.contractorbill.in.workflow.for.workorder", (Object[])new String[]{contractorBillRegister.getWorkOrder().getWorkOrderNumber()}, null);
        }
        BigDecimal totalBillAmountIncludingCurrentBill = contractorBillRegister.getBillamount();
        BigDecimal totalBillAmount = this.contractorBillRegisterService.getTotalBillAmountByWorkOrder(contractorBillRegister.getWorkOrder());
        if (totalBillAmount != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(totalBillAmount);
        }
        if (lineEstimateDetails.getLineEstimate().isBillsCreated() && lineEstimateDetails.getGrossAmountBilled() != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(lineEstimateDetails.getGrossAmountBilled());
        }
        if (totalBillAmountIncludingCurrentBill.doubleValue() > contractorBillRegister.getWorkOrder().getWorkOrderAmount()) {
            resultBinder.reject("error.contractorbill.totalbillamount.exceeds.workorderamount", (Object[])new String[]{String.valueOf(totalBillAmountIncludingCurrentBill), String.valueOf(contractorBillRegister.getWorkOrder().getWorkOrderAmount())}, null);
        }
        if (StringUtils.isBlank((String)contractorBillRegister.getBilltype())) {
            resultBinder.rejectValue("billtype", "error.billtype.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.validate.partybilldate.lessthan.loadate");
        }
        if (contractorBillRegister.getMbHeader() != null) {
            if (StringUtils.isBlank((String)contractorBillRegister.getMbHeader().getMbRefNo())) {
                resultBinder.rejectValue("mbHeader.mbRefNo", "error.mbrefno.required");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() == null) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.mbdate.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == null) {
                resultBinder.rejectValue("mbHeader.fromPageNo", "error.frompageno.required");
            }
            if (contractorBillRegister.getMbHeader().getToPageNo() == null) {
                resultBinder.rejectValue("mbHeader.toPageNo", "error.topageno.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == 0 || contractorBillRegister.getMbHeader().getToPageNo() == 0) {
                resultBinder.reject("error.validate.mb.pagenumbers.zero", "error.validate.mb.pagenumbers.zero");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() != null && contractorBillRegister.getMbHeader().getToPageNo() != null && contractorBillRegister.getMbHeader().getFromPageNo() > contractorBillRegister.getMbHeader().getToPageNo()) {
                resultBinder.reject("error.validate.mb.frompagenumber.greaterthan.topagenumber", "error.validate.mb.frompagenumber.greaterthan.topagenumber");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() != null && contractorBillRegister.getMbHeader().getMbDate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.validate.mbdate.lessthan.loadate");
            }
        }
        if (StringUtils.isBlank((String)request.getParameter("netPayableAccountCode"))) {
            resultBinder.reject("error.netpayable.accountcode.required", "error.netpayable.accountcode.required");
        }
        if (StringUtils.isBlank((String)request.getParameter("netPayableAmount")) || Double.valueOf(request.getParameter("netPayableAmount").toString()) <= 0.0) {
            resultBinder.reject("error.netpayable.amount.required", "error.netpayable.amount.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().after(contractorBillRegister.getBilldate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.partybilldate.billdate");
        }
        Date workCompletionDate = contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate();
        if (contractorBillRegister.getBilltype().equals(BillTypes.Final_Bill.toString()) && workCompletionDate == null) {
            resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.required");
        }
        Date currentDate = new Date();
        if (workCompletionDate != null) {
            if (workCompletionDate.after(currentDate)) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.futuredate");
            }
            if (workCompletionDate.before(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.workorderdate");
            }
            if (workCompletionDate.after(contractorBillRegister.getBilldate())) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.billdate");
            }
        }
        if (lineEstimateDetails.getLineEstimate().isSpillOverFlag()) {
            String cutoffDateString = this.worksApplicationProperties.getContractorBillCutOffDate();
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
            try {
                if (org.egov.infra.utils.StringUtils.isNotBlank((String)cutoffDateString)) {
                    Date cutOffdate = df.parse(cutoffDateString);
                    if (contractorBillRegister.getBilldate().before(cutOffdate)) {
                        resultBinder.rejectValue(BILLDATE, "error.billdate.cutoff");
                    }
                } else {
                    Date currentFinYear = this.lineEstimateService.getCurrentFinancialYear(currentDate).getStartingDate();
                    if (contractorBillRegister.getBilldate().before(currentFinYear)) {
                        resultBinder.rejectValue(BILLDATE, "error.billdate.finyear");
                    }
                }
                if (contractorBillRegister.getBilldate().after(currentDate)) {
                    resultBinder.rejectValue(BILLDATE, "error.billdate.futuredate");
                }
                if (contractorBillRegister.getBilldate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
                    resultBinder.rejectValue(BILLDATE, "error.billdate.workorderdate");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private String getMessageByStatus(ContractorBillRegister contractorBillRegister, String approverName, String nextDesign) {
        String message = "";
        if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.CREATED.toString())) {
            message = StringUtils.isNotBlank((String)contractorBillRegister.getEgBillregistermis().getBudgetaryAppnumber()) && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) ? this.messageSource.getMessage("msg.contractorbill.create.success.with.budgetappropriation", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign, contractorBillRegister.getEgBillregistermis().getBudgetaryAppnumber()}, null) : this.messageSource.getMessage("msg.contractorbill.create.success", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        } else if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.APPROVED.toString())) {
            message = this.messageSource.getMessage("msg.contractorbill.approved.success", (Object[])new String[]{contractorBillRegister.getBillnumber()}, null);
        } else if (contractorBillRegister.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.contractorbill.reject", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        } else if (contractorBillRegister.getState().getValue().equals("Cancelled")) {
            message = this.messageSource.getMessage("msg.contractorbill.cancel", (Object[])new String[]{contractorBillRegister.getBillnumber()}, null);
        }
        return message;
    }

    private ContractorBillRegister addBillDetails(ContractorBillRegister contractorBillRegister, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        if (contractorBillRegister.getBillDetailes() == null || contractorBillRegister.getBillDetailes().isEmpty()) {
            resultBinder.reject("error.contractorbill.accountdetails.required", "error.contractorbill.accountdetails.required");
        }
        for (EgBilldetails egBilldetails : contractorBillRegister.getBillDetailes()) {
            if (!contractorBillRegister.getEgBilldetailes().isEmpty() && contractorBillRegister.getEgBilldetailes().size() == 1) {
                for (EgBilldetails refundBill : contractorBillRegister.getRefundBillDetails()) {
                    if (refundBill.getGlcodeid() == null) continue;
                    contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, refundBill, lineEstimateDetails, resultBinder, request));
                }
                if (egBilldetails.getGlcodeid() == null) continue;
                contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, egBilldetails, lineEstimateDetails, resultBinder, request));
                continue;
            }
            if (egBilldetails.getGlcodeid() == null) continue;
            contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, egBilldetails, lineEstimateDetails, resultBinder, request));
        }
        this.contractorBillRegisterService.validateZeroCreditAndDebitAmount(contractorBillRegister, resultBinder);
        String netPayableAccountCodeId = request.getParameter("netPayableAccountCode");
        String netPayableAmount = request.getParameter("netPayableAmount");
        if (StringUtils.isNotBlank((String)netPayableAccountCodeId) && StringUtils.isNotBlank((String)netPayableAmount)) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setGlcodeid(new BigDecimal(netPayableAccountCodeId));
            billdetails.setCreditamount(new BigDecimal(netPayableAmount));
            contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, billdetails, lineEstimateDetails, resultBinder, request));
        }
        return contractorBillRegister;
    }
}

