/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.tender;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.Retender;
import org.egov.works.models.tender.RetenderHistory;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.services.WorksService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"edit"}, location="offlineStatus-edit.jsp"), @Result(name={"retender"}, location="offlineStatus-retender.jsp"), @Result(name={"success"}, location="offlineStatus-success.jsp")})
public class OfflineStatusAction
extends BaseFormAction {
    private static final long serialVersionUID = -6533573442117204510L;
    private OfflineStatus worksStatus = new OfflineStatus();
    private PersistenceService<OfflineStatus, Long> worksStatusService;
    private WorksService worksService;
    private String[] statusName;
    private Date[] statusDate;
    private Long objId;
    private String objectType;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private List<OfflineStatus> setStatusList;
    private static final String STATUS_OBJECTID = "getStatusByObjectId";
    private static final String STATUS_VALUES = ".setstatus";
    private static final String LAST_STATUS = ".laststatus";
    private Date appDate;
    private String appDateProperFormat;
    private String ObjNo;
    private static final String TENDERRESPONSE_CONTRACTORS = "TenderResponseContractors";
    private static final String TENDERRESPONSE = "TenderResponse";
    private static final String WORKSPACKAGE = "WorksPackage";
    public static final String RETENDER = "retender";
    private WorksPackage worksPackage;
    private String[][] statusInfo;
    private Integer statusTableXValue;
    private Integer statusTableYValue;
    private List<RetenderHistory> retenderHistoryList = new LinkedList();
    private List<Retender> retenderInfoList = new LinkedList();
    private Boolean retenderingIsAllowed;
    private Boolean retenderingIsSelected;
    private Boolean viewMode = false;
    private Integer iterationCount;
    private String setStatus;

    public Object getModel() {
        return this.worksStatus;
    }

    public void prepare() {
        if (this.objId != null) {
            this.setStatusList = this.worksStatusService.findAllByNamedQuery(STATUS_OBJECTID, new Object[]{this.objId, this.objectType});
        }
        this.addDropdownData("statusList", this.getAllStatus());
    }

    private void loadWorksPackageStatuses() {
        List retenderDetails = this.worksPackage.getRetenderDetails();
        List retenderHistoryDetails = this.worksPackage.getRetenderHistoryDetails();
        Integer maxIterations = 0;
        if (this.worksPackage.getOfflineStatuses() != null && this.getWorksPackageSetStatusesLength() == this.getAllStatus().size() || StringUtils.isNotBlank((String)this.setStatus) && this.setStatus.equalsIgnoreCase("view") || this.worksPackage.getEgwStatus().getCode().equalsIgnoreCase(WorksPackage.WorkPacakgeStatus.CANCELLED.toString())) {
            this.viewMode = true;
        }
        if (retenderDetails != null && retenderDetails.size() > 0) {
            for (int i = 0; i < retenderDetails.size(); ++i) {
                if (((Retender)retenderDetails.get(i)).getIterationNumber() == null || ((Retender)retenderDetails.get(i)).getIterationNumber() <= maxIterations) continue;
                maxIterations = ((Retender)retenderDetails.get(i)).getIterationNumber();
            }
        }
        if (retenderHistoryDetails != null && retenderHistoryDetails.size() > 0) {
            LinkedHashMap<Integer, Integer> statusesInDb = new LinkedHashMap<Integer, Integer>();
            Integer count = 0;
            for (RetenderHistory rh : retenderHistoryDetails) {
                count = (Integer)statusesInDb.get(rh.getEgwStatus().getId());
                if (count == null || count == 0) {
                    statusesInDb.put(rh.getEgwStatus().getId(), 1);
                    continue;
                }
                count = count + 1;
                statusesInDb.put(rh.getEgwStatus().getId(), count);
            }
            Integer numberOfStatusesSet = statusesInDb.size();
            this.statusInfo = new String[numberOfStatusesSet.intValue()][maxIterations + 2];
            this.statusTableXValue = numberOfStatusesSet - 1;
            this.statusTableYValue = maxIterations + 1;
            int i = 0;
            int iterationCount = 0;
            for (Integer key : statusesInDb.keySet()) {
                this.statusInfo[i][0] = key.toString();
                ++i;
            }
            i = 0;
            for (RetenderHistory rh : retenderHistoryDetails) {
                if (iterationCount != (rh.getRetender() == null ? 0 : rh.getRetender().getIterationNumber())) {
                    iterationCount = rh.getRetender().getIterationNumber();
                    i = 0;
                }
                if (rh.getRetender() == null) {
                    this.statusInfo[i][1] = DateUtils.getDefaultFormattedDate((Date)rh.getStatusDate());
                } else {
                    this.statusInfo[i][rh.getRetender().getIterationNumber().intValue() + 1] = DateUtils.getDefaultFormattedDate((Date)rh.getStatusDate());
                }
                ++i;
            }
        }
    }

    @SkipValidation
    @Action(value="/tender/offlineStatus-edit")
    public String edit() {
        if (this.setStatusList != null && !this.setStatusList.isEmpty()) {
            this.populateStatusNameAndDateDetails(this.setStatusList);
        }
        return "edit";
    }

    @SkipValidation
    @Action(value="/tender/offlineStatus-retenderEdit")
    public String retenderEdit() {
        this.worksPackage = (WorksPackage)this.persistenceService.find(" from WorksPackage where id =? ", new Object[]{this.objId});
        this.iterationCount = this.worksPackage.getRetenderDetails() == null || this.worksPackage.getRetenderDetails().size() == 0 ? Integer.valueOf(0) : ((Retender)this.worksPackage.getRetenderDetails().get(this.worksPackage.getRetenderDetails().size() - 1)).getIterationNumber();
        if (this.appDate != null) {
            this.appDateProperFormat = DateUtils.getDefaultFormattedDate((Date)this.appDate);
        }
        this.loadWorksPackageStatuses();
        this.checkIfRetenderingIsAllowed();
        return RETENDER;
    }

    private void checkIfRetenderingIsAllowed() {
        String lastStatus = this.worksService.getWorksConfigValue("WorksPackage.laststatus");
        this.retenderingIsAllowed = false;
        if (this.worksPackage.getLatestOfflineStatus() != null && this.worksPackage.getLatestOfflineStatus().getEgwStatus() != null && !this.worksPackage.getLatestOfflineStatus().getEgwStatus().getCode().equalsIgnoreCase(lastStatus) && this.worksPackage.getOfflineStatuses() != null && this.getWorksPackageSetStatusesLength() >= 2) {
            this.retenderingIsAllowed = true;
        }
    }

    private void validateRetendering() {
        if (this.retenderHistoryList != null && this.retenderHistoryList.size() > 0) {
            int i = 0;
            int j = 0;
            Date maxRetenderHistoryDate = null;
            boolean wrongOrderOfStatus = false;
            for (RetenderHistory rh : this.retenderHistoryList) {
                if (rh == null) continue;
                if (rh.getStatusDate() != null && (rh.getEgwStatus() == null || rh.getEgwStatus().getId() == null)) {
                    this.addFieldError(this.getText("wp.retender.both.status.date.set"), this.getText("wp.retender.both.status.date.set"));
                }
                if (rh.getEgwStatus() != null && rh.getEgwStatus().getId() != null && rh.getStatusDate() == null) {
                    this.addFieldError(this.getText("wp.retender.both.status.date.set"), this.getText("wp.retender.both.status.date.set"));
                }
                j = 0;
                for (RetenderHistory rh1 : this.retenderHistoryList) {
                    if (rh1 == null) continue;
                    if (i != j && rh.getEgwStatus() != null && rh.getEgwStatus().getId() != null && rh1.getEgwStatus() != null && rh1.getEgwStatus().getId() != null && rh.getEgwStatus().getId().longValue() == rh1.getEgwStatus().getId().longValue()) {
                        this.addFieldError(this.getText("wp.retender.both.status.duplicate"), this.getText("wp.retender.both.status.duplicate"));
                    }
                    if (i < j && rh1.getStatusDate().before(rh.getStatusDate())) {
                        this.addFieldError(this.getText("wp.retender.incorrect.date.order"), this.getText("wp.retender.incorrect.date.order"));
                    }
                    if (i > j && rh.getStatusDate().before(rh1.getStatusDate())) {
                        this.addFieldError(this.getText("wp.retender.incorrect.date.order"), this.getText("wp.retender.incorrect.date.order"));
                    }
                    ++j;
                }
                if (this.worksPackage.getOfflineStatuses() != null && this.getWorksPackageSetStatusesLength() > 0 && !this.retenderingIsSelected.booleanValue()) {
                    int index = 0;
                    List statusList = this.getAllStatus();
                    List alreadyPersistedStatusForWP = this.persistenceService.findAllBy(" from OfflineStatus    where objectId=? and objectType='WorksPackage' order by id ", new Object[]{this.worksPackage.getId()});
                    for (OfflineStatus st : alreadyPersistedStatusForWP) {
                        if (rh.getEgwStatus().getId().intValue() == st.getEgwStatus().getId().intValue()) {
                            this.addFieldError(this.getText("wp.retender.both.status.duplicate"), this.getText("wp.retender.both.status.duplicate"));
                        }
                        if (!st.getEgwStatus().getCode().equalsIgnoreCase(((EgwStatus)statusList.get(index)).getCode())) {
                            wrongOrderOfStatus = true;
                        }
                        ++index;
                    }
                    for (RetenderHistory rh1 : this.retenderHistoryList) {
                        if (rh1 == null) continue;
                        if (rh1.getEgwStatus().getId().intValue() != ((EgwStatus)statusList.get(index)).getId().intValue()) {
                            wrongOrderOfStatus = true;
                        }
                        ++index;
                    }
                }
                if (rh.getStatusDate().after(new Date())) {
                    this.addFieldError(this.getText("wp.retender.no.futuredate"), this.getText("wp.retender.no.futuredate"));
                }
                if (this.appDate != null && this.appDate.after(rh.getStatusDate())) {
                    this.addFieldError(this.getText("wp.retender.greater.than.approved.date"), this.getText("wp.retender.greater.than.approved.date"));
                }
                if (this.worksPackage.getLatestOfflineStatus() != null && this.worksPackage.getLatestOfflineStatus().getStatusDate().after(rh.getStatusDate())) {
                    this.addFieldError(this.getText("wp.retender.incorrect.date.order"), this.getText("wp.retender.incorrect.date.order"));
                }
                if (maxRetenderHistoryDate == null) {
                    maxRetenderHistoryDate = rh.getStatusDate();
                } else if (rh.getStatusDate().after(maxRetenderHistoryDate)) {
                    maxRetenderHistoryDate = rh.getStatusDate();
                }
                ++i;
            }
            if (wrongOrderOfStatus) {
                this.addFieldError(this.getText("wp.retender.wrong.order"), this.getText("wp.retender.wrong.order"));
            }
            if (this.retenderingIsSelected.booleanValue()) {
                if (this.retenderInfoList == null || this.retenderInfoList.size() == 0) {
                    this.addFieldError(this.getText("wp.retender.no.info"), this.getText("wp.retender.no.info"));
                } else {
                    for (Retender ret : this.retenderInfoList) {
                        if (StringUtils.isBlank((String)ret.getReason())) {
                            this.addFieldError(this.getText("wp.retender.enter.reason"), this.getText("wp.retender.enter.reason"));
                        }
                        if (ret.getRetenderDate() == null) {
                            this.addFieldError(this.getText("wp.retender.enter.date"), this.getText("wp.retender.enter.date"));
                        }
                        if (ret.getRetenderDate() != null && maxRetenderHistoryDate.after(ret.getRetenderDate())) {
                            this.addFieldError(this.getText("wp.retender.date.less.than.statusdate"), this.getText("wp.retender.date.less.than.statusdate"));
                        }
                        for (Retender re : this.worksPackage.getRetenderDetails()) {
                            if (re == null || !(re.getRetenderDate() != null & re.getRetenderDate().after(ret.getRetenderDate()))) continue;
                            this.addFieldError(this.getText("wp.retender.increasing.date"), this.getText("wp.retender.increasing.date"));
                        }
                    }
                }
            }
        } else {
            this.addFieldError(this.getText("wp.retender.set.status.no.info"), this.getText("wp.retender.set.status.no.info"));
        }
    }

    private int getWorksPackageSetStatusesLength() {
        int returnVal = 0;
        if (this.worksPackage.getOfflineStatuses() != null && this.worksPackage.getOfflineStatuses().size() > 0) {
            for (OfflineStatus ss : this.worksPackage.getOfflineStatuses()) {
                if (ss == null || !ss.getObjectType().equalsIgnoreCase(WORKSPACKAGE)) continue;
                ++returnVal;
            }
        }
        return returnVal;
    }

    @ValidationErrorPage(value="retender")
    @SkipValidation
    @Action(value="/tender/offlineStatus-retenderSave")
    public String retenderSave() {
        this.worksPackage = (WorksPackage)this.persistenceService.find(" from WorksPackage where id =? ", new Object[]{this.objId});
        this.validateRetendering();
        if (!this.getFieldErrors().isEmpty()) {
            return this.retenderEdit();
        }
        if (this.worksPackage.getRetenderDetails() == null || this.worksPackage.getRetenderDetails().size() == 0 && !this.retenderingIsSelected.booleanValue()) {
            this.saveWhenRetenderingWasNotPreviouslyDone();
        } else if (this.worksPackage.getRetenderDetails() == null || this.worksPackage.getRetenderDetails().size() == 0 && this.retenderingIsSelected.booleanValue()) {
            this.saveWhenRetenderingIsSelected();
        } else if (this.worksPackage.getRetenderDetails() != null && this.worksPackage.getRetenderDetails().size() > 0 && !this.retenderingIsSelected.booleanValue()) {
            this.saveWhenRetenderingPreviouslyDoneAndRetenderingIsNotSelected();
        } else if (this.worksPackage.getRetenderDetails() != null && this.worksPackage.getRetenderDetails().size() > 0 && this.retenderingIsSelected.booleanValue()) {
            this.saveWhenRetenderingIsSelected();
        }
        this.getPersistenceService().getSession().flush();
        return "success";
    }

    private void saveWhenRetenderingWasNotPreviouslyDone() {
        LinkedList<RetenderHistory> retHistList = new LinkedList<RetenderHistory>();
        for (RetenderHistory rh : this.retenderHistoryList) {
            if (rh == null) continue;
            rh.setWorksPackage(this.worksPackage);
            retHistList.add(rh);
        }
        this.worksPackage.getRetenderHistoryDetails().addAll(retHistList);
        OfflineStatus ss = null;
        for (RetenderHistory rh : retHistList) {
            ss = new OfflineStatus();
            ss.setEgwStatus(rh.getEgwStatus());
            ss.setObjectId(rh.getWorksPackage().getId());
            ss.setObjectType(WORKSPACKAGE);
            ss.setStatusDate(rh.getStatusDate());
            this.worksStatusService.persist((Object)ss);
        }
        this.worksPackage.setLatestOfflineStatus(ss);
    }

    private void saveWhenRetenderingPreviouslyDoneAndRetenderingIsNotSelected() {
        LinkedList<RetenderHistory> retHistList = new LinkedList<RetenderHistory>();
        for (RetenderHistory rh : this.retenderHistoryList) {
            if (rh == null) continue;
            rh.setWorksPackage(this.worksPackage);
            rh.setRetender((Retender)this.worksPackage.getRetenderDetails().get(this.worksPackage.getRetenderDetails().size() - 1));
            retHistList.add(rh);
        }
        ((Retender)this.worksPackage.getRetenderDetails().get(this.worksPackage.getRetenderDetails().size() - 1)).getRetenderHistoryDetails().addAll(retHistList);
        this.worksPackage.getRetenderHistoryDetails().addAll(retHistList);
        OfflineStatus ss = null;
        for (RetenderHistory rh : retHistList) {
            ss = new OfflineStatus();
            ss.setEgwStatus(rh.getEgwStatus());
            ss.setObjectId(rh.getWorksPackage().getId());
            ss.setObjectType(WORKSPACKAGE);
            ss.setStatusDate(rh.getStatusDate());
            this.worksStatusService.persist((Object)ss);
        }
        this.worksPackage.setLatestOfflineStatus(ss);
    }

    private void saveWhenRetenderingIsSelected() {
        LinkedList<RetenderHistory> retHistList = new LinkedList<RetenderHistory>();
        LinkedList<Retender> retList = new LinkedList<Retender>();
        for (Retender ret : this.retenderInfoList) {
            ret.setWorksPackage(this.worksPackage);
            if (this.worksPackage.getRetenderDetails() == null || this.worksPackage.getRetenderDetails().size() == 0) {
                ret.setIterationNumber(Integer.valueOf(1));
            } else {
                ret.setIterationNumber(Integer.valueOf(this.worksPackage.getRetenderDetails().size() + 1));
            }
            retList.add(ret);
        }
        for (RetenderHistory rh : this.retenderHistoryList) {
            if (rh == null) continue;
            rh.setWorksPackage(this.worksPackage);
            rh.setRetender((Retender)retList.get(0));
            retHistList.add(rh);
        }
        this.worksPackage.getRetenderDetails().addAll(retList);
        ((Retender)retList.get(0)).setRetenderHistoryDetails(retHistList);
        this.worksPackage.getRetenderHistoryDetails().addAll(retHistList);
        Query qry1 = this.getPersistenceService().getSession().createQuery("delete from OfflineStatus where objectId=:object_id and objectType='WorksPackage' ");
        qry1.setLong("object_id", this.worksPackage.getId().longValue());
        qry1.executeUpdate();
        OfflineStatus ss = null;
        for (RetenderHistory rh : retHistList) {
            ss = new OfflineStatus();
            ss.setEgwStatus(rh.getEgwStatus());
            ss.setObjectId(rh.getWorksPackage().getId());
            ss.setObjectType(WORKSPACKAGE);
            ss.setStatusDate(rh.getStatusDate());
            this.worksStatusService.persist((Object)ss);
        }
        this.worksPackage.setLatestOfflineStatus(ss);
    }

    public String save() {
        int i = 0;
        for (String statName : this.worksService.getStatusNameDetails(this.statusName)) {
            if (i > this.getSetStatusList().size() - 1) {
                OfflineStatus stat = new OfflineStatus();
                stat.setObjectId(this.objId);
                stat.setObjectType(this.objectType);
                stat.setEgwStatus(this.getDescriptionByCode(statName));
                stat.setStatusDate((Date)this.getDateList().get(i));
                this.worksStatusService.persist((Object)stat);
            }
            ++i;
        }
        return "success";
    }

    public List<EgwStatus> getAllStatus() {
        String lastStatus;
        String status;
        if (this.objectType != null && this.objectType.equals(TENDERRESPONSE_CONTRACTORS)) {
            status = this.worksService.getWorksConfigValue("TenderResponse.setstatus");
            lastStatus = this.worksService.getWorksConfigValue("TenderResponse.laststatus");
        } else {
            status = this.worksService.getWorksConfigValue(this.objectType + STATUS_VALUES);
            lastStatus = this.worksService.getWorksConfigValue(this.objectType + LAST_STATUS);
        }
        ArrayList<String> statList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)status) && StringUtils.isNotBlank((String)lastStatus)) {
            List<String> statusList = Arrays.asList(status.split(","));
            for (String stat : statusList) {
                if (stat.equals(lastStatus)) {
                    statList.add(stat);
                    break;
                }
                statList.add(stat);
            }
        }
        if (!statList.isEmpty()) {
            if (this.objectType != null && this.objectType.equals(TENDERRESPONSE_CONTRACTORS)) {
                return this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList(TENDERRESPONSE, statList);
            }
            return this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList(this.objectType, statList);
        }
        return Collections.EMPTY_LIST;
    }

    private EgwStatus getDescriptionByCode(String statName) {
        if (this.objectType != null && this.objectType.equals(TENDERRESPONSE_CONTRACTORS)) {
            return this.egwStatusHibernateDAO.getStatusByModuleAndCode(TENDERRESPONSE, statName);
        }
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode(this.objectType, statName);
    }

    private void populateStatusNameAndDateDetails(List<OfflineStatus> setStatusList) {
        int i = 0;
        this.statusName = new String[setStatusList.size()];
        this.statusDate = new Date[setStatusList.size()];
        for (OfflineStatus stat : setStatusList) {
            this.getStatusName()[i] = stat.getEgwStatus().getCode();
            this.getStatusDate()[i] = stat.getStatusDate();
            ++i;
        }
    }

    private void validateStatusName() {
        int i = 0;
        List statList = this.getAllStatus();
        for (String statName : this.worksService.getStatusNameDetails(this.statusName)) {
            if (!statList.isEmpty() && !statName.equals(((EgwStatus)statList.get(i)).getCode())) {
                this.addFieldError("status.order.incorrect", this.getText("status.order.incorrect", new String[]{this.getDescriptionByCode(statName).getDescription(), ((EgwStatus)statList.get(i)).getDescription()}));
                break;
            }
            ++i;
        }
    }

    private void validateStatusDate() {
        if (!(this.appDate == null || this.getDateList().isEmpty() || this.getStatusCodeList().isEmpty() || DateUtils.compareDates((Date)((Date)this.getDateList().get(0)), (Date)this.appDate))) {
            this.addFieldError("status.date.incorrect", this.getText("status.date.greaterThan.appDate", new String[]{this.getDescriptionByCode((String)this.getStatusCodeList().get(0)).getDescription(), this.objectType}));
        }
        int j = 1;
        for (Date dateObj : this.getDateList()) {
            if (this.getDateList().size() > j && !DateUtils.compareDates((Date)((Date)this.getDateList().get(j)), (Date)dateObj)) {
                this.addFieldError("status.date.incorrect", this.getText("status.date.incorrect", new String[]{this.getDescriptionByCode((String)this.getStatusCodeList().get(j)).getDescription(), this.getDescriptionByCode((String)this.getStatusCodeList().get(j - 1)).getDescription()}));
            }
            ++j;
        }
    }

    public void validate() {
        this.validateStatusName();
        this.validateStatusDate();
    }

    private List<Date> getDateList() {
        return (List)this.worksService.getStatusDateDetails(this.statusDate);
    }

    private List<String> getStatusCodeList() {
        return (List)this.worksService.getStatusNameDetails(this.statusName);
    }

    public void setWorksStatusService(PersistenceService<OfflineStatus, Long> worksStatusService) {
        this.worksStatusService = worksStatusService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String[] getStatusName() {
        return this.statusName == null ? new String[]{} : this.statusName;
    }

    public void setStatusName(String[] statusName) {
        this.statusName = statusName;
    }

    public Date[] getStatusDate() {
        return this.statusDate == null ? new Date[]{} : this.statusDate;
    }

    public void setStatusDate(Date[] statusDate) {
        this.statusDate = statusDate;
    }

    public Long getObjId() {
        return this.objId;
    }

    public void setObjId(Long objId) {
        this.objId = objId;
    }

    public List<OfflineStatus> getSetStatusList() {
        return this.setStatusList;
    }

    public void setSetStatusList(List<OfflineStatus> setStatusList) {
        this.setStatusList = setStatusList;
    }

    public void setWorksStatus(OfflineStatus worksStatus) {
        this.worksStatus = worksStatus;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public Date getAppDate() {
        return this.appDate;
    }

    public void setAppDate(Date appDate) {
        this.appDate = appDate;
    }

    public String getObjNo() {
        return this.ObjNo;
    }

    public void setObjNo(String objNo) {
        this.ObjNo = objNo;
    }

    public String[][] getStatusInfo() {
        return this.statusInfo;
    }

    public void setStatusInfo(String[][] statusInfo) {
        this.statusInfo = statusInfo;
    }

    public List<Integer> getRowloop() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (this.statusTableXValue != null && this.statusTableXValue >= 0) {
            Integer i = 0;
            while (i <= this.statusTableXValue) {
                list.add(i);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return list;
    }

    public List<Integer> getColumnloop() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (this.statusTableYValue != null && this.statusTableYValue >= 0) {
            Integer i = 0;
            while (i <= this.statusTableYValue) {
                list.add(i);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return list;
    }

    public Boolean getRetenderingIsAllowed() {
        return this.retenderingIsAllowed;
    }

    public Boolean getRetenderingIsSelected() {
        return this.retenderingIsSelected;
    }

    public void setRetenderingIsSelected(Boolean retenderingIsSelected) {
        this.retenderingIsSelected = retenderingIsSelected;
    }

    public List<RetenderHistory> getRetenderHistoryList() {
        return this.retenderHistoryList;
    }

    public void setRetenderHistoryList(List<RetenderHistory> retenderHistoryList) {
        this.retenderHistoryList = retenderHistoryList;
    }

    public List<Retender> getRetenderInfoList() {
        return this.retenderInfoList;
    }

    public void setRetenderInfoList(List<Retender> retenderInfoList) {
        this.retenderInfoList = retenderInfoList;
    }

    public Integer getIterationCount() {
        return this.iterationCount;
    }

    public WorksPackage getWorksPackage() {
        return this.worksPackage;
    }

    public Boolean getViewMode() {
        return this.viewMode;
    }

    public Integer getStatusTableYValue() {
        return this.statusTableYValue;
    }

    public String getAppDateProperFormat() {
        return this.appDateProperFormat;
    }

    public void setAppDateProperFormat(String appDateProperFormat) {
        this.appDateProperFormat = appDateProperFormat;
    }

    public String getSetStatus() {
        return this.setStatus;
    }

    public void setSetStatus(String setStatus) {
        this.setStatus = setStatus;
    }
}

