/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.masters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.models.masters.ExpenditureType;
import org.egov.works.models.masters.Overhead;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name={"new"}, location="overhead-new.jsp")
public class OverheadAction
extends BaseFormAction {
    private static final long serialVersionUID = 5694568397341403350L;
    private static final Logger logger = Logger.getLogger(OverheadAction.class);
    private PersistenceService<Overhead, Long> overheadService;
    private Overhead overhead = new Overhead();
    private Long id;
    private WorksService worksService;
    private List<Overhead> overheadList = null;
    private List<ExpenditureType> expenditureTypeList = new ArrayList();
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;

    public OverheadAction() {
        this.addRelatedEntity("account", CChartOfAccounts.class);
    }

    public String execute() {
        return this.list();
    }

    @Action(value="/masters/overhead-newform")
    public String newform() {
        return "new";
    }

    public String list() {
        this.overheadList = this.overheadService.findAllBy(" from Overhead o order by name asc", new Object[0]);
        return "index";
    }

    public String edit() {
        return "edit";
    }

    public String save() {
        this.overheadService.persist((Object)this.overhead);
        return "success";
    }

    public String create() {
        this.overheadService.persist((Object)this.overhead);
        this.addActionMessage(this.getText("overhead.save.success", "The overhead was saved successfully"));
        return this.list();
    }

    public Object getModel() {
        return this.overhead;
    }

    public void prepare() {
        if (this.id != null) {
            this.overhead = (Overhead)this.overheadService.findById((Serializable)this.id, false);
        }
        this.expenditureTypeList = this.overheadService.findAllBy("select distinct expenditureType from Overhead", new Object[0]);
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"account"});
        try {
            List accounts = new ArrayList();
            if (this.worksService.getWorksConfigValue("OVERHEAD_PURPOSE") != null) {
                accounts = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue("OVERHEAD_PURPOSE")));
            }
            this.addDropdownData("accountList", accounts);
        }
        catch (ApplicationRuntimeException e) {
            logger.error((Object)("Unable to load accountcode :" + e.getMessage()));
            this.addFieldError("accountcode", "Unable to load accountcode");
        }
        Object[] expenditure = (String[])this.parameters.get("expenditure");
        if (!ArrayUtils.isEmpty((Object[])expenditure) && !((String)expenditure[0]).equals("-1")) {
            this.overhead.setExpenditureType(new ExpenditureType((String)expenditure[0]));
        }
    }

    public List<Overhead> getOverheadList() {
        return this.overheadList;
    }

    public void setOverheadList(List<Overhead> overheadList) {
        this.overheadList = overheadList;
    }

    public PersistenceService<Overhead, Long> getOverheadService() {
        return this.overheadService;
    }

    public void setOverheadService(PersistenceService<Overhead, Long> service) {
        this.overheadService = service;
    }

    public Overhead getOverhead() {
        return this.overhead;
    }

    public void setOverhead(Overhead overhead) {
        this.overhead = overhead;
    }

    public List<ExpenditureType> getExpenditureTypeList() {
        return this.expenditureTypeList;
    }

    public void setExpenditureTypeList(List<ExpenditureType> expenditureTypeList) {
        this.expenditureTypeList = expenditureTypeList;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }
}

