/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.masters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.EgwTypeOfWork;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.works.master.service.MilestoneTemplateService;
import org.egov.works.models.masters.MilestoneTemplate;
import org.egov.works.models.masters.MilestoneTemplateActivity;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="milestoneTemplate-new.jsp"), @Result(name={"search"}, location="milestoneTemplate-search.jsp"), @Result(name={"success"}, location="milestoneTemplate-success.jsp"), @Result(name={"edit"}, location="milestoneTemplate-edit.jsp"), @Result(name={"view"}, location="milestoneTemplate-view.jsp")})
public class MilestoneTemplateAction
extends SearchFormAction {
    private static final long serialVersionUID = 5517312981738363805L;
    private MilestoneTemplate template = new MilestoneTemplate();
    @Autowired
    private MilestoneTemplateService milestoneTemplateService;
    @Autowired
    private WorksService worksService;
    Long id;
    private String mode;
    private String messageKey;
    private String sourcepage;
    private List<MilestoneTemplateActivity> templateActivities = new LinkedList();
    public static final String SEARCH = "search";
    public static final String SUCCESS = "success";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";

    public MilestoneTemplateAction() {
        this.addRelatedEntity("typeOfWork", EgwTypeOfWork.class);
        this.addRelatedEntity("subTypeOfWork", EgwTypeOfWork.class);
    }

    public void prepare() {
        if (this.id != null) {
            this.template = this.milestoneTemplateService.getMilestoneTemplateById(this.id);
        }
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"typeOfWork", "subTypeOfWork"});
        this.addDropdownData("parentCategoryList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw where etw.parentid is null", new Object[0]));
        this.populateCategoryList(ajaxEstimateAction, this.template.getTypeOfWork() != null);
    }

    public Object getModel() {
        return this.template;
    }

    @Action(value="/masters/milestoneTemplate-newform")
    @SkipValidation
    public String newform() {
        return "new";
    }

    @Action(value="/masters/milestoneTemplate-view")
    @SkipValidation
    public String view() {
        return VIEW;
    }

    @SkipValidation
    @Action(value="/masters/milestoneTemplate-search")
    public String search() {
        return SEARCH;
    }

    @Action(value="/masters/milestoneTemplate-save")
    public String save() {
        this.populateActivities();
        this.template = this.milestoneTemplateService.save(this.template);
        if (StringUtils.isBlank((String)this.mode)) {
            this.addActionMessage(this.getText("milestonetemplate.save.success", new String[]{this.template.getCode()}));
        } else {
            this.addActionMessage(this.getText("milestonetemplate.modified.success", new String[]{this.template.getCode()}));
        }
        return SUCCESS;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    @Action(value="/masters/milestoneTemplate-edit")
    @SkipValidation
    public String edit() {
        this.template = this.milestoneTemplateService.getMilestoneTemplateById(this.id);
        if (this.mode.equals(EDIT)) {
            return EDIT;
        }
        return VIEW;
    }

    @SkipValidation
    public String searchTemplate() {
        if ("searchForMilestone".equalsIgnoreCase(this.sourcepage)) {
            this.template.setStatus(Integer.valueOf(1));
        }
        return SEARCH;
    }

    @Action(value="/masters/milestoneTemplate-searchDetails")
    @SkipValidation
    public String searchDetails() {
        if (this.template.getTypeOfWork() == null || this.template.getTypeOfWork().getId() == -1L) {
            String messageKey = "milestone.template.search.typeOfWork.error";
            this.addActionError(this.getText("milestone.template.search.typeOfWork.error"));
            return SEARCH;
        }
        this.setPageSize(30);
        super.search();
        return SEARCH;
    }

    public void validate() {
        this.populateActivities();
        if (this.milestoneTemplateService.getCode(this.template.getCode()) && this.id == null) {
            this.addFieldError("Unique.MilestoneTemplate.code", this.getText("milestonetemplate.code.isunique"));
        }
        if (null == this.template.getMilestoneTemplateActivities() || this.template.getMilestoneTemplateActivities().size() == 0) {
            this.addFieldError("milestone.activity.missing", this.getText("milestone.activity.missing"));
        }
        Double percentage = 0.0;
        for (MilestoneTemplateActivity templateActivities : this.template.getMilestoneTemplateActivities()) {
            if (templateActivities.getPercentage() == null) continue;
            percentage = percentage + templateActivities.getPercentage();
        }
        if (percentage != 100.0) {
            this.addFieldError("milestone.activity.total.percentage", this.getText("milestone.activity.total.percentage"));
        }
    }

    protected void populateCategoryList(AjaxEstimateAction ajaxEstimateAction, boolean categoryPopulated) {
        if (categoryPopulated) {
            ajaxEstimateAction.setCategory(this.template.getTypeOfWork().getId());
            ajaxEstimateAction.subcategories();
            this.addDropdownData("categoryList", ajaxEstimateAction.getSubCategories());
        } else {
            this.addDropdownData("categoryList", Collections.emptyList());
        }
    }

    private void populateActivities() {
        this.template.getMilestoneTemplateActivities().clear();
        for (MilestoneTemplateActivity activity : this.templateActivities) {
            if (activity != null) {
                this.template.addMilestoneTemplateActivity(activity);
            }
            activity.setMilestoneTemplate(this.template);
            this.template.setCreatedBy(this.worksService.getCurrentLoggedInUser());
            this.template.setCreatedDate(new Date());
            activity.setCreatedBy(this.worksService.getCurrentLoggedInUser());
            activity.setCreatedDate(new Date());
            activity.setLastModifiedBy(this.worksService.getCurrentLoggedInUser());
            activity.setLastModifiedDate(new Date());
        }
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String dynQuery = " from MilestoneTemplate mt where mt.id is not null ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (this.template.getTypeOfWork() != null && this.template.getTypeOfWork().getId() != -1L) {
            dynQuery = dynQuery + " and mt.typeOfWork.id = ? ";
            paramList.add(this.template.getTypeOfWork().getId());
        }
        if (this.template.getSubTypeOfWork() != null && this.template.getSubTypeOfWork().getId() != -1L) {
            dynQuery = dynQuery + " and mt.subTypeOfWork.id = ? ";
            paramList.add(this.template.getSubTypeOfWork().getId());
        }
        if (StringUtils.isNotBlank((String)this.template.getCode().trim())) {
            dynQuery = dynQuery + " and UPPER(mt.code) like '%'||?||'%'";
            paramList.add(this.template.getCode().trim().toUpperCase());
        }
        if (this.template.getStatus() != null && this.template.getStatus() != -1) {
            dynQuery = dynQuery + " and mt.status = ? ";
            paramList.add(this.template.getStatus());
        }
        String countQuery = "select distinct count(mt) " + dynQuery;
        return new SearchQueryHQL(dynQuery, countQuery, paramList);
    }

    public MilestoneTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(MilestoneTemplate template) {
        this.template = template;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<MilestoneTemplateActivity> getTemplateActivities() {
        return this.templateActivities;
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setTemplateActivities(List<MilestoneTemplateActivity> templateActivities) {
        this.templateActivities = templateActivities;
    }
}

