/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractorBill;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.assets.model.Asset;
import org.egov.assets.service.AssetService;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.EgPartytype;
import org.egov.commons.EgwStatus;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgPartytypeHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FunctionaryHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.dao.SchemeHibernateDAO;
import org.egov.commons.dao.SubSchemeHibernateDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.models.EgChecklists;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.model.budget.BudgetGroup;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.services.budget.BudgetService;
import org.egov.services.recoveries.RecoveryService;
import org.egov.services.voucher.VoucherService;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.entity.FinancingSource;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.models.contractorBill.AssetForBill;
import org.egov.works.models.contractorBill.DeductionTypeForBill;
import org.egov.works.models.contractorBill.StatutoryDeductionsForBill;
import org.egov.works.models.contractorBill.WorkCompletionDetailInfo;
import org.egov.works.models.contractorBill.WorkCompletionInfo;
import org.egov.works.models.measurementbook.MBForCancelledBill;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.egov.works.services.impl.MeasurementBookServiceImpl;
import org.egov.works.web.actions.contractorBill.AjaxContractorBillAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"print"}, type="stream", location="CompletionCertificatePDF", params={"inputName", "CompletionCertificatePDF", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=ContractorBill_CompletionCertificate.pdf"}), @Result(name={"new"}, location="contractorBill-new.jsp")})
public class ContractorBillAction
extends BaseFormAction {
    private static final long serialVersionUID = -2842467886385709531L;
    private static final Logger logger = Logger.getLogger(ContractorBillAction.class);
    private ContractorBillService contractorBillService;
    private PersistenceService<MBForCancelledBill, Long> cancelBillService;
    private WorksService worksService;
    private ContractorBillRegister contractorBillRegister = new ContractorBillRegister();
    private WorkOrder workOrder;
    private Long id;
    private Long workOrderId;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private EgPartytypeHibernateDAO egPartytypeHibernateDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private AssetService assetService;
    private MeasurementBookServiceImpl measurementBookService;
    private EgovCommon egovCommon;
    @Autowired
    private UserService userService;
    private PersistenceService<EgChecklists, Long> checklistService;
    private List<StatutoryDeductionsForBill> actionStatutorydetails = new LinkedList();
    private List<AssetForBill> accountDetailsForBill = new ArrayList();
    private Map<Long, String> contratorCoaPayableMap = new HashMap();
    private String disp;
    private BigDecimal totalAdvancePaid = BigDecimal.ZERO;
    private BigDecimal totalPendingBalance = BigDecimal.ZERO;
    private BigDecimal advaceAdjustmentCreditAmount = BigDecimal.ZERO;
    private BigDecimal billAmount = BigDecimal.ZERO;
    private BigDecimal utilizedAmount = BigDecimal.ZERO;
    private BigDecimal sanctionedBudget = BigDecimal.ZERO;
    private PersistenceService<FinancialDetail, Long> financialDetailService;
    private Long netPayableCode;
    private BigDecimal netPayableAmount;
    private String partyBillNumber;
    private Date partyBillDate;
    private Date completionDate;
    private Integer partbillNo;
    private String sourcepage = "";
    private List<String> checklistValues = new LinkedList();
    private List<AppConfigValues> finalBillChecklist = new LinkedList();
    private List<CChartOfAccounts> standardDeductionAccountList = new LinkedList();
    private List<CChartOfAccounts> customDeductionAccountList = new LinkedList();
    private List<CChartOfAccounts> retentionMoneyAccountList = new LinkedList();
    private List<String> standardDeductionConfValues = new LinkedList();
    private List<DeductionTypeForBill> standardDeductions = new LinkedList();
    private List<EgBilldetails> customDeductions = new LinkedList();
    private List<EgBilldetails> retentionMoneyDeductions = new LinkedList();
    private List<MBHeader> mbHeaderList = new LinkedList();
    private Long[] appConfigValueId;
    private String[] selectedchecklistValue;
    private String[] remarks;
    private static final String ASSET_LIST = "assestList";
    private static final String SOURCE_INBOX = "inbox";
    private static final String COA_LIST = "coaList";
    private static final String CAPITAL_WORKS = "Capital Works";
    private static final String IMPROVEMENT_WORKS = "Improvement Works";
    private static final String REPAIR_AND_MAINTENANCE = "Repairs and maintenance";
    private static final String WORKS_NETPAYABLE_CODE = "WORKS_NETPAYABLE_CODE";
    private static final String RETENTION_MONEY_PURPOSE = "RETENTION_MONEY_PURPOSE";
    private static final String KEY_CWIP = "WORKS_CWIP_CODE";
    private static final String KEY_REPAIRS = "WORKS_REPAIRS_AND_MAINTENANCE";
    private static final String KEY_DEPOSIT = "WORKS_DEPOSIT_OTHER_WORKS";
    private static final String BILL_STATUS = "APPROVED";
    private static final String ACCOUNTDETAIL_TYPE_CONTRACTOR = "contractor";
    private static final String EXPENDITURE_TYPE = "Works";
    private static final String BILL_MODULE_KEY = "CONTRACTORBILL";
    private static final String AMOUNT_ERROR = "amount.lessthan.zero";
    @Autowired
    private DepartmentService departmentService;
    private WorkflowService<ContractorBillRegister> workflowService;
    private static final String SAVE_ACTION = "save";
    private String messageKey;
    private static final String ACTION_NAME = "actionName";
    private String nextEmployeeName;
    private String nextDesignation;
    @Autowired
    @Qualifier(value="recoveryPersistenceService")
    private RecoveryService recoveryService;
    private Long workOrderEstimateId;
    private List<WorkOrderEstimate> workOrderEstimateList = new ArrayList();
    private WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
    public static final String PRINT = "print";
    private InputStream completionCertificatePDF;
    private ReportService reportService;
    private static final String APPCONFIG_KEY_NAME = "SKIP_BUDGET_CHECK";
    private VoucherService voucherService;
    private ScriptService scriptExecutionService;
    private WorkCompletionInfo completionInfo;
    private List<WorkCompletionDetailInfo> completionDetailInfoList = new ArrayList();
    private boolean skipBudget;
    private static final String CHECK_BUDGET = "CHECK_BUDGET";
    private static final String ACCOUNTDETAIL_TYPE_PROJECTCODE = "PROJECTCODE";
    private String isRetMoneyAutoCalculated;
    private String isRetMoneyEditable;
    private String percDeductForRetMoneyPartBill;
    private String percDeductForRetMoneyFinalBill;
    private String retMoneyFinalBillPerOnValue;
    private TenderResponse tenderResponse;
    private String rebatePremLevel;
    private List<EgPartytype> subPartyTypeDtls = new ArrayList();
    private List<EgwTypeOfWork> typeOfWorkDtls = new ArrayList();
    public static final String BILL_STATUTORYDEDUCTIONS_SHOW_PARTYSUBTYPE = "BILL_STATUTORYDEDUCTIONS_SHOW_PARTYSUBTYPE";
    public static final String BILL_STATUTORYDEDUCTIONS_SHOW_SERVICETYPE = "BILL_STATUTORYDEDUCTIONS_SHOW_SERVICETYPE";
    public static final String BILL_STATUTORYDEDUCTIONS_EDITABLE = "BILL_STATUTORYDEDUCTIONS_EDITABLE";
    private String showSubPartyType;
    private String showTypeOfWork;
    private String editStatutoryAmount;
    public static final String PARTY_TYPE_CODE = "Contractor";
    private Long estimateId;
    private String percTenderType;
    private String isRebatePremLevelBill;
    private BigDecimal grossAmount = BigDecimal.ZERO;
    private BigDecimal tenderedItemsAmount = BigDecimal.ZERO;
    @Autowired
    private FunctionaryHibernateDAO functionaryHibDao;
    private BudgetService budgetService;
    private final String PENDING_FOR_VERIFICATION = "Pending for Verification";
    private final String PENDING_FOR_VALIDATION = "Pending for Validation";
    private final String PENDING_FOR_APPROVAL = "Pending for Approval";
    private final String PENDING_FOR_RECTIFICATION = "Pending for Rectification";
    private final String PENDING_FOR_CHECK = "Pending for Check";
    private Integer workflowFunctionaryId;
    private Long[] mbHeaderId;
    private List<MBHeader> mbHeaderListForBillId = new LinkedList();
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private EmployeeServiceOld employeeService;
    private String isRCEstimate = "";
    private String dwCategory = "";
    private Date restorationEndDate;
    private String showValidationMsg = "";
    @Autowired
    private FundHibernateDAO fundHibernateDao;
    @Autowired
    private FunctionHibernateDAO functionHibernateDao;
    @Autowired
    private SchemeHibernateDAO schemeHibernateDAO;
    @Autowired
    private SubSchemeHibernateDAO subschemeHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO finHibernateDao;
    private String allowForward = "";
    private Date latestMBDate;
    private String refNo;

    public void prepare() {
        super.prepare();
        if (this.id != null) {
            this.contractorBillRegister = (ContractorBillRegister)this.contractorBillService.findById((Serializable)this.id, false);
            if (this.contractorBillRegister.getBillstatus().equals("CANCELLED")) {
                for (MBForCancelledBill mbCancelBillObj : this.contractorBillService.getMbListForCancelBill(this.id)) {
                    if (this.mbHeaderListForBillId.contains(mbCancelBillObj.getMbHeader())) continue;
                    this.mbHeaderListForBillId.add(mbCancelBillObj.getMbHeader());
                }
            } else {
                this.mbHeaderListForBillId = this.measurementBookService.findAllByNamedQuery("getAllMBsForBillId", new Object[]{BILL_STATUS, this.id});
            }
            if (this.mbHeaderListForBillId != null && !this.mbHeaderListForBillId.isEmpty()) {
                this.workOrder = ((MBHeader)this.mbHeaderListForBillId.get(0)).getWorkOrder();
                this.workOrderId = this.workOrder.getId();
                this.workOrderEstimate = ((MBHeader)this.mbHeaderListForBillId.get(0)).getWorkOrderEstimate();
            }
        }
        if (this.workOrderId != null) {
            this.workOrder = (WorkOrder)this.persistenceService.find("from WorkOrder where id=?", new Object[]{this.workOrderId});
            this.workOrderEstimateList.addAll(this.getPersistenceService().findAllByNamedQuery("getWorkOrderEstimateByWorkOrderId", new Object[]{this.workOrderId}));
            this.loadTenderDetails();
        }
        if (this.id != null) {
            if (StringUtils.isNotBlank((String)this.isRebatePremLevelBill) && this.isRebatePremLevelBill.equals("yes") || this.isRCEstimate.equalsIgnoreCase("yes")) {
                this.billAmount = this.contractorBillService.getApprovedMBAmountforBill(this.contractorBillRegister);
            }
            if (!this.isRCEstimate.equalsIgnoreCase("yes")) {
                this.tenderedItemsAmount = this.contractorBillService.getApprovedMBAmountOfTenderedItemsForBill(this.contractorBillRegister);
            }
        }
        if (this.workOrderEstimateId != null) {
            this.workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{this.workOrderEstimateId});
        }
        if (this.workOrderEstimateList.isEmpty()) {
            this.addDropdownData("workOrderEstimateList", Collections.EMPTY_LIST);
        } else {
            this.workOrderEstimateList = this.measurementBookService.getWOEstForBillExludingLegacyMB(this.workOrderEstimateList);
            this.addDropdownData("workOrderEstimateList", this.workOrderEstimateList);
        }
        if (this.workOrderEstimateList.size() == 1 && this.id == null) {
            this.workOrderEstimate = (WorkOrderEstimate)this.workOrderEstimateList.get(0);
            this.mbHeaderList = this.measurementBookService.getApprovedMBList(this.workOrder.getId(), this.workOrderEstimate.getId(), new Date());
        }
        try {
            if (this.workOrderEstimate != null && this.workOrderEstimate.getId() != null) {
                List coaList;
                ArrayList<BudgetGroup> budgetGroupList;
                this.isSkipBudgetCheck();
                this.addDropdownData(ASSET_LIST, this.workOrderEstimate.getAssetValues());
                String accountCodeFromBudgetHead = this.worksService.getWorksConfigValue("BILL_DEFAULT_BUDGETHEAD_ACCOUNTCODE");
                if (this.workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals(CAPITAL_WORKS) || this.workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals(IMPROVEMENT_WORKS)) {
                    if (StringUtils.isNotBlank((String)accountCodeFromBudgetHead) && "no".equals(accountCodeFromBudgetHead) && StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(KEY_CWIP))) {
                        this.addDropdownData(COA_LIST, this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(KEY_CWIP))));
                    } else if (StringUtils.isNotBlank((String)accountCodeFromBudgetHead) && "yes".equals(accountCodeFromBudgetHead)) {
                        budgetGroupList = new ArrayList<BudgetGroup>();
                        if (((FinancialDetail)this.workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getBudgetGroup() != null) {
                            budgetGroupList.add(((FinancialDetail)this.workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getBudgetGroup());
                        }
                        coaList = this.budgetService.getAccountCodeForBudgetHead(budgetGroupList);
                        this.addDropdownData(COA_LIST, coaList);
                    } else {
                        this.addDropdownData(COA_LIST, Collections.EMPTY_LIST);
                    }
                } else if (this.workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals(REPAIR_AND_MAINTENANCE)) {
                    if (StringUtils.isNotBlank((String)accountCodeFromBudgetHead) && "no".equals(accountCodeFromBudgetHead) && StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(KEY_REPAIRS))) {
                        this.addDropdownData(COA_LIST, this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(KEY_REPAIRS))));
                    } else if (StringUtils.isNotBlank((String)accountCodeFromBudgetHead) && "yes".equals(accountCodeFromBudgetHead)) {
                        budgetGroupList = new ArrayList();
                        if (((FinancialDetail)this.workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getBudgetGroup() != null) {
                            budgetGroupList.add(((FinancialDetail)this.workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getBudgetGroup());
                        }
                        coaList = this.budgetService.getAccountCodeForBudgetHead(budgetGroupList);
                        this.addDropdownData(COA_LIST, coaList);
                    } else {
                        this.addDropdownData(COA_LIST, Collections.EMPTY_LIST);
                    }
                } else if (this.getAppConfigValuesToSkipBudget().contains(this.workOrderEstimate.getEstimate().getNatureOfWork().getName())) {
                    if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(KEY_DEPOSIT)) && !this.skipBudget) {
                        this.addDropdownData(COA_LIST, this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(KEY_CWIP))));
                    } else {
                        this.addDropdownData(COA_LIST, Collections.EMPTY_LIST);
                    }
                }
            }
            this.populateOtherDeductionList();
            this.setRetentionMoneyConfigValues();
        }
        catch (ApplicationException v) {
            logger.error((Object)("Unable to COA for WorkOrder" + (Object)((Object)v)));
            this.addFieldError("COA.notfound", "Unable to COA for WorkOrder");
        }
        if (this.contractorBillRegister != null && this.contractorBillRegister.getBilldate() == null && this.workOrderEstimateList.size() == 1) {
            this.workOrderEstimateId = ((WorkOrderEstimate)this.workOrderEstimateList.get(0)).getId();
            this.setBudgetDetails(this.workOrderId, this.workOrderEstimateId, new Date());
        }
        if (this.workOrderEstimate.getId() != null && this.workOrderId != null && this.id == null) {
            this.tenderedItemsAmount = this.contractorBillService.getApprovedMBAmountOfTenderedItems(this.workOrderId, this.workOrderEstimate.getId(), new Date());
        }
        this.addDropdownData("billTypeList", this.contractorBillService.getBillType());
        List statutoryDeductionsList = this.recoveryService.getAllTdsByPartyType(PARTY_TYPE_CODE);
        this.addDropdownData("statutoryDeductionsList", statutoryDeductionsList);
        this.addDropdownData("executingDepartmentList", this.departmentService.getAllDepartments());
        if (this.contractorBillRegister != null && this.contractorBillRegister.getId() != null && this.contractorBillRegister.getState() != null && this.contractorBillRegister.getState().getNextAction() != null && (this.contractorBillRegister.getState().getNextAction().equalsIgnoreCase("Pending for Verification") || this.contractorBillRegister.getState().getNextAction().equalsIgnoreCase("Pending for Validation") || this.contractorBillRegister.getState().getNextAction().equalsIgnoreCase("Pending for Approval") || this.contractorBillRegister.getState().getNextAction().equalsIgnoreCase("Pending for Rectification") || this.contractorBillRegister.getState().getNextAction().equalsIgnoreCase("Pending for Check") && this.contractorBillRegister.getState().getValue().equalsIgnoreCase("REJECTED"))) {
            Functionary func = (Functionary)this.persistenceService.find(" from  Functionary where upper(name) = ?", new Object[]{"UAC"});
            this.workflowFunctionaryId = func.getId();
        }
        this.showSubPartyType = this.worksService.getWorksConfigValue(BILL_STATUTORYDEDUCTIONS_SHOW_PARTYSUBTYPE);
        logger.debug((Object)("showSubPartyType>>>>>> " + this.showSubPartyType));
        this.showTypeOfWork = this.worksService.getWorksConfigValue(BILL_STATUTORYDEDUCTIONS_SHOW_SERVICETYPE);
        logger.debug((Object)("showTypeOfWork>>>>>> " + this.showTypeOfWork));
        this.editStatutoryAmount = this.worksService.getWorksConfigValue(BILL_STATUTORYDEDUCTIONS_EDITABLE);
        logger.debug((Object)("editStatutoryAmount>>>>>>> " + this.editStatutoryAmount));
        List subPartyTypeList = new ArrayList();
        List typeOfWorkList = new ArrayList();
        if (this.showSubPartyType != null && this.showSubPartyType != "") {
            subPartyTypeList = this.egPartytypeHibernateDAO.getSubPartyTypesForCode(PARTY_TYPE_CODE);
            this.addDropdownData("subPartyTypeList", subPartyTypeList);
        } else {
            this.addDropdownData("subPartyTypeList", subPartyTypeList);
        }
        if (this.showTypeOfWork != null && this.showTypeOfWork != "") {
            typeOfWorkList = this.getPersistenceService().findAllBy("from EgwTypeOfWork wt where wt.parentid is null", new Object[0]);
            this.addDropdownData("typeOfWorkList", typeOfWorkList);
        } else {
            this.addDropdownData("typeOfWorkList", typeOfWorkList);
        }
        this.getLastCreatedMBDate();
    }

    private void getLastCreatedMBDate() {
        Object[] mbDateRefNo;
        if ((this.id == null && this.workOrderEstimateList.size() == 1 || this.contractorBillRegister.getStatus() != null && (this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("NEW") || this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("REJECTED"))) && (mbDateRefNo = this.contractorBillService.getLatestMBCreatedDateAndRefNo(this.workOrderId, this.workOrderEstimate.getEstimate().getId())) != null && mbDateRefNo.length > 0) {
            this.refNo = (String)mbDateRefNo[0];
            this.latestMBDate = (Date)mbDateRefNo[1];
        }
    }

    private void checkForBillsInWorkflowForDepositWorks() {
        this.allowForward = "yes";
        if (!(this.workOrderEstimate.getEstimate().getDepositCode() == null || !this.skipBudget || !StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(KEY_DEPOSIT)) || this.sourcepage.equalsIgnoreCase("search") || this.contractorBillRegister.getStatus() == null || this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("NEW") || this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase(ContractorBillRegister.BillStatus.REJECTED.toString()) || this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase(ContractorBillRegister.BillStatus.APPROVED.toString()) || this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase(ContractorBillRegister.BillStatus.CANCELLED.toString()))) {
            this.allowForward = this.contractorBillService.validateForBudgetHeadInWorkflow(this.contractorBillRegister.getEgBilldetailes(), this.workOrderEstimate.getEstimate());
        }
    }

    private void populateBudgetHeadForDepositWorksEstimate() {
        if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(KEY_DEPOSIT)) && this.skipBudget && this.workOrderEstimate.getEstimate() != null && this.workOrderEstimate.getEstimate().getFinancialDetails() != null && this.workOrderEstimate.getEstimate().getFinancialDetails().get(0) != null && ((FinancialDetail)this.workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getCoa() != null && this.workOrderEstimate.getEstimate().getDepositCode() != null) {
            if (this.id == null || this.contractorBillRegister.getStatus() != null && (this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("NEW") || this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("REJECTED"))) {
                List mappedBudgetHeadList = this.contractorBillService.getBudgetHeadForDepositCOA(this.workOrderEstimate.getEstimate());
                if (mappedBudgetHeadList.isEmpty()) {
                    this.showValidationMsg = "yes";
                    this.addDropdownData(COA_LIST, Collections.EMPTY_LIST);
                    this.addFieldError("contractoBill.depositCOA.budgetHead.mapping.error", this.getText("contractoBill.depositCOA.budgetHead.mapping.error"));
                } else {
                    this.addDropdownData(COA_LIST, mappedBudgetHeadList);
                }
            } else {
                this.addDropdownData(COA_LIST, this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(KEY_CWIP))));
            }
        }
    }

    private void loadTenderDetails() {
        this.tenderResponse = (TenderResponse)this.persistenceService.find("from TenderResponse tr where tr.negotiationNumber=? and  tr.egwStatus.code !=? ", new Object[]{this.workOrder.getNegotiationNumber(), TenderResponse.TenderResponseStatus.CANCELLED.toString()});
        this.rebatePremLevel = this.worksService.getWorksConfigValue("REBATE_PREMIUM_LEVEL");
        this.isRebatePremLevelBill = this.rebatePremLevel.equalsIgnoreCase("BILL") ? "yes" : "no";
        List tenderTypeList = this.worksService.getTendertypeList();
        if (tenderTypeList != null && !tenderTypeList.isEmpty()) {
            this.percTenderType = (String)tenderTypeList.get(0);
        }
    }

    private void setRetentionMoneyConfigValues() {
        this.isRetMoneyAutoCalculated = this.worksService.getWorksConfigValue("IS_RETENTION_MONEY_AUTOCALCULATED");
        this.isRetMoneyEditable = this.worksService.getWorksConfigValue("IS_RETENTION_MONEY_EDITABLE");
        this.percDeductForRetMoneyPartBill = this.worksService.getWorksConfigValue("PERCENTAGE_DEDUCTION_FOR_RETENTION_MONEY_PART_BILL");
        this.percDeductForRetMoneyFinalBill = this.worksService.getWorksConfigValue("PERCENTAGE_DEDUCTION_FOR_RETENTION_MONEY_FINAL_BILL");
        this.retMoneyFinalBillPerOnValue = this.worksService.getWorksConfigValue("RETENTION_MONEY_PERCENTAGE_ON_VALUE");
    }

    @SkipValidation
    public String edit() throws Exception {
        if (SOURCE_INBOX.equalsIgnoreCase(this.sourcepage)) {
            User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
            boolean isValidUser = this.worksService.validateWorkflowForUser((StateAware)this.contractorBillRegister, user);
            if (isValidUser) {
                throw new ApplicationRuntimeException("Error: Invalid Owner - No permission to view this page.");
            }
        } else if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = "search";
        }
        this.checklistValues.add("Yes");
        this.checklistValues.add("No");
        this.contractorBillRegister = this.getContractorbillregisterforbillnumber(this.contractorBillRegister.getBillnumber());
        if (this.contractorBillRegister != null) {
            this.setId(this.contractorBillRegister.getId());
            if (!(this.isRCEstimate.equalsIgnoreCase("yes") || this.isRebatePremLevelBill.equals("yes") && this.tenderResponse.getTenderEstimate().getTenderType().equals(this.getPercTenderType()))) {
                this.setBillAmount(this.contractorBillRegister.getPassedamount());
            }
            this.setCompletionDate(this.workOrderEstimate.getWorkCompletionDate());
            this.setPartyBillNumber(this.contractorBillRegister.getEgBillregistermis().getPartyBillNumber());
            this.setPartyBillDate(this.contractorBillRegister.getEgBillregistermis().getPartyBillDate());
            if (this.contractorBillRegister.getBillstatus().equals("CANCELLED")) {
                for (MBForCancelledBill mbCancelBillObj : this.contractorBillService.getMbListForCancelBill(this.id)) {
                    if (this.mbHeaderList.contains(mbCancelBillObj.getMbHeader())) continue;
                    this.mbHeaderList.add(mbCancelBillObj.getMbHeader());
                }
            } else {
                for (MBHeader mbObj : this.contractorBillService.getMbListForBillAndWorkordrId(this.workOrderId, this.id)) {
                    if (this.mbHeaderList.contains(mbObj)) continue;
                    this.mbHeaderList.add(mbObj);
                }
            }
            this.workOrderEstimate = ((MBHeader)this.mbHeaderList.get(0)).getWorkOrderEstimate();
            this.populateBudgetHeadForDepositWorksEstimate();
            this.checkForBillsInWorkflowForDepositWorks();
            this.totalAdvancePaid = this.contractorAdvanceService.getTotalAdvancePaymentMadeByWOEstimateId(this.workOrderEstimate.getId(), this.contractorBillRegister.getBilldate());
            this.setTotalPendingBalance(this.contractorBillService.calculateTotalPendingAdvance(this.totalAdvancePaid, this.contractorBillRegister.getBilldate(), this.workOrderEstimate, this.contractorBillRegister.getId()));
            this.setAdvaceAdjustmentCreditAmount(this.contractorBillService.getAdvanceAdjustmentAmountForBill(this.id, this.workOrderEstimate.getId()));
            this.setNetPayableCode(Long.valueOf(this.contractorBillService.getNetPaybleCode(this.id).longValue()));
            this.setNetPayableAmount(this.contractorBillService.getNetPayableAmountForGlCodeId(this.id));
            this.disp = "yes";
            this.contractorBillService.setAllViewLists(this.id, this.workOrderId, this.workOrderEstimate.getId(), this.actionStatutorydetails, this.standardDeductions, this.customDeductions, this.retentionMoneyDeductions, this.accountDetailsForBill);
            List list = this.contractorBillService.getEgcheckList(this.id);
            int i = 0;
            this.selectedchecklistValue = new String[list.size()];
            for (EgChecklists egChecklists : list) {
                this.finalBillChecklist.add(egChecklists.getAppconfigvalue());
                this.selectedchecklistValue[i] = egChecklists.getChecklistvalue();
                ++i;
            }
        }
        return "edit";
    }

    @SkipValidation
    public String viewCompletionCertificate() {
        ReportRequest reportRequest = null;
        HashMap<String, WorkCompletionInfo> reportParams = new HashMap<String, WorkCompletionInfo>();
        reportParams.put("workCompletionInfo", this.getWorkcompletionInfo());
        reportRequest = new ReportRequest("completionCertificate", (Collection)this.getWorkCompletionDetailInfo(), reportParams);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.completionCertificatePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return PRINT;
    }

    public List<WorkCompletionDetailInfo> getWorkCompletionDetailInfo() {
        List mbHeaderList = this.persistenceService.findAllByNamedQuery("getAllMBHeadersbyBillId", new Object[]{this.contractorBillRegister.getId()});
        if (!mbHeaderList.isEmpty()) {
            return this.contractorBillService.setWorkCompletionDetailInfoList(((MBHeader)mbHeaderList.get(0)).getWorkOrderEstimate());
        }
        return new ArrayList<WorkCompletionDetailInfo>();
    }

    public WorkCompletionInfo getWorkcompletionInfo() {
        List mbHeaderList = this.persistenceService.findAllByNamedQuery("getAllMBHeadersbyBillId", new Object[]{this.contractorBillRegister.getId()});
        if (!mbHeaderList.isEmpty()) {
            return this.contractorBillService.setWorkCompletionInfoFromBill(this.contractorBillRegister, ((MBHeader)mbHeaderList.get(0)).getWorkOrderEstimate());
        }
        return new WorkCompletionInfo();
    }

    public ContractorBillRegister getContractorbillregisterforbillnumber(String billNumber) {
        return (ContractorBillRegister)this.contractorBillService.findByNamedQuery("getContractorBillRegister", new Object[]{billNumber});
    }

    public Object getModel() {
        return this.contractorBillRegister;
    }

    @SkipValidation
    public String view() {
        return "view";
    }

    public void setModel(ContractorBillRegister contractorBillRegister) {
        this.contractorBillRegister = contractorBillRegister;
    }

    public String execute() {
        return "success";
    }

    @SkipValidation
    @Action(value="/contractorBill/contractorBill-newform")
    public String newform() {
        if (!this.contractorBillService.getBillType().isEmpty()) {
            List objList = this.measurementBookService.getPartBillList(this.workOrderId, this.contractorBillService.getBillType().get(0).toString());
            this.contractorBillRegister.setBillSequenceNumber(Integer.valueOf(objList.size() + 1));
        }
        this.populateBudgetHeadForDepositWorksEstimate();
        return "new";
    }

    private void validateMilestoneCompletion() {
        if (this.id == null) {
            List tm = null;
            if (this.contractorBillRegister.getBilltype().equals(this.contractorBillService.getBillType().get(1).toString()) && ((tm = this.persistenceService.findAllBy(" select trmls from WorkOrderEstimate as woe left join woe.milestone mls left join mls.trackMilestone trmls where trmls.egwStatus.code='APPROVED' and woe.workOrder.id = ? and trmls.total=100 ", new Object[]{this.workOrderId})) == null || tm.isEmpty() || tm.get(0) == null)) {
                this.addActionError(this.getText("contactor.final.bill.milestone.ajaxmsg"));
            }
            if (this.contractorBillRegister.getBilltype().equals(this.contractorBillService.getBillType().get(0).toString()) && ((tm = this.persistenceService.findAllBy(" select trmls from WorkOrderEstimate as woe left join woe.milestone mls left join mls.trackMilestone trmls where trmls.egwStatus.code='APPROVED' and woe.workOrder.id = ? and trmls.total>0 ", new Object[]{this.workOrderId})) == null || tm.isEmpty() || tm.get(0) == null)) {
                this.addActionError(this.getText("contactor.final.bill.milestone.ajaxmsg"));
            }
        }
    }

    public String save() throws Exception {
        String actionName = "";
        if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
            actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        }
        if (this.contractorBillRegister.getStatus() == null || "REJECTED".equalsIgnoreCase(this.contractorBillRegister.getStatus().getCode()) && StringUtils.isBlank((String)this.contractorBillRegister.getState().getNextAction()) || "new".equalsIgnoreCase(this.contractorBillRegister.getStatus().getCode())) {
            this.contractorBillRegister.getEgBilldetailes().clear();
            this.contractorBillRegister.getStatutoryDeductionsList().clear();
            this.contractorBillRegister.getDeductionTypeList().clear();
            this.contractorBillRegister.getAssetDetailsList().clear();
        }
        this.workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{this.workOrderEstimateId});
        this.validateMilestoneCompletion();
        this.mbHeaderList = this.id == null ? this.measurementBookService.getApprovedMBList(this.workOrderId, this.workOrderEstimateId, this.contractorBillRegister.getBilldate()) : this.contractorBillService.getMbListForBillAndWorkordrId(this.workOrderId, this.id);
        if (this.mbHeaderList == null || this.mbHeaderList.isEmpty()) {
            throw new ValidationException(Arrays.asList(new ValidationError("error", this.getText("no.approved.mb.for.billdate", new String[]{new SimpleDateFormat("dd/MM/yyyy").format(this.contractorBillRegister.getBilldate())}))));
        }
        if (!actionName.equalsIgnoreCase("reject")) {
            this.validateARFInWorkflow();
            if (this.workOrderEstimate.getEstimate() != null && this.workOrderEstimate.getEstimate().getDepositCode() != null) {
                this.validateExpenditureForDepositCode(actionName);
                this.validateBudgetHeadForBillsInWorkflow();
            }
        }
        ContractorBillRegister contractorBill = null;
        try {
            contractorBill = this.setEgBillRegister();
        }
        catch (ValidationException sequenceException) {
            List errorList = sequenceException.getErrors();
            for (ValidationError error : errorList) {
                if (!error.getMessage().contains("DatabaseSequenceFirstTimeException")) continue;
                this.prepare();
                throw new ValidationException(Arrays.asList(new ValidationError("error", error.getMessage())));
            }
            throw sequenceException;
        }
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        if (this.contractorBillRegister.getStatus() == null || this.contractorBillRegister.getStatus() != null && (this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("NEW") || this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("REJECTED") && user == this.contractorBillRegister.getCreatedBy())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"entered condition for budgetary appropriation >>>>>>>>>>>>>> ");
            }
            this.isSkipBudgetCheck();
            this.checkBudgetandGenerateNumber(contractorBill);
        }
        if (this.contractorBillRegister.getStatus() == null) {
            this.contractorBillRegister.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(BILL_MODULE_KEY, "NEW"));
        }
        this.contractorBillService.persist((Object)this.contractorBillRegister);
        if (this.contractorBillRegister.getBilltype().equals(this.contractorBillService.getBillType().get(1).toString())) {
            this.workOrderEstimate.setWorkCompletionDate(this.getCompletionDate());
            this.contractorBillRegister.setBillSequenceNumber(null);
            int i = 0;
            for (WorkCompletionDetailInfo workCompletionDetailInfo : this.getWorkCompletionDetailInfo()) {
                if (this.getRemarks() != null && this.getRemarks().length > i && this.getRemarks()[i] != null) {
                    workCompletionDetailInfo.getWorkOrderActivity().setRemarks(this.getRemarks()[i]);
                }
                ++i;
            }
        }
        for (MBHeader mbObj : this.mbHeaderList) {
            mbObj.setEgBillregister(this.contractorBillRegister);
        }
        if (this.appConfigValueId != null && this.selectedchecklistValue != null && this.appConfigValueId.length > 0 && this.selectedchecklistValue.length > 0) {
            for (int i = 0; i < this.appConfigValueId.length; ++i) {
                if (this.appConfigValueId[i] == null || this.selectedchecklistValue[i].equals("-1")) continue;
                EgChecklists checklist = new EgChecklists();
                checklist.setAppconfigvalue((AppConfigValues)this.getPersistenceService().find("from AppConfigValues where id=?", new Object[]{Integer.valueOf(this.appConfigValueId[i].toString())}));
                checklist.setChecklistvalue(this.selectedchecklistValue[i]);
                checklist.setObjectid(this.contractorBillRegister.getId());
                this.checklistService.persist((Object)checklist);
            }
        }
        this.messageKey = "bill.save.success";
        this.contractorBillRegister.setBillstatus(this.contractorBillRegister.getCurrentState().getValue());
        this.contractorBillRegister.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(BILL_MODULE_KEY, this.contractorBillRegister.getCurrentState().getValue()));
        this.getPersistenceService().getSession().flush();
        this.getPersistenceService().getSession().refresh((Object)this.contractorBillRegister);
        this.contractorBillRegister.getEgBillregistermis().setSourcePath("/egworks/contractorBill/contractorBill!edit.action?id=" + this.contractorBillRegister.getId() + "&workOrderId=" + this.workOrderId + "&billnumber=" + this.contractorBillRegister.getBillnumber() + "&sourcepage=search");
        this.addActionMessage(this.getText(this.messageKey, this.messageKey));
        this.getDesignation(this.contractorBillRegister);
        if (SAVE_ACTION.equals(actionName)) {
            this.sourcepage = SOURCE_INBOX;
        }
        return SAVE_ACTION.equals(actionName) ? this.edit() : "success";
    }

    private String isSkipBudgetCheck() {
        List appConfigValuesList = this.worksService.getAppConfigValue(EXPENDITURE_TYPE, APPCONFIG_KEY_NAME);
        logger.info((Object)("lenght of appconfig values>>>>>> " + appConfigValuesList.size()));
        if (this.workOrderEstimate != null && this.workOrderEstimate.getId() != null) {
            for (AppConfigValues appValues : appConfigValuesList) {
                if (!appValues.getValue().equals(this.workOrderEstimate.getEstimate().getNatureOfWork().getName())) continue;
                this.skipBudget = true;
                return CHECK_BUDGET;
            }
            this.skipBudget = false;
        }
        return CHECK_BUDGET;
    }

    private void validateBudgetHeadForBillsInWorkflow() {
        if (StringUtils.isNotBlank((String)this.allowForward) && this.allowForward.equalsIgnoreCase("no")) {
            this.populateBudgetHeadForDepositWorksEstimate();
            throw new ValidationException(Arrays.asList(new ValidationError("contractoBill.depositCOA.budgetHead.mapping.workflow.error", this.getText("contractoBill.depositCOA.budgetHead.mapping.workflow.error", new String[]{this.workOrderEstimate.getEstimate().getEstimateNumber()}))));
        }
    }

    private ContractorBillRegister checkBudgetandGenerateNumber(ContractorBillRegister contractorBill) {
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"voucherService", this.voucherService, "bill", contractorBill});
        this.scriptExecutionService.executeScript("egf.bill.budgetcheck", scriptContext);
        return contractorBill;
    }

    public void getDesignation(ContractorBillRegister bill) {
        String result;
        if (this.contractorBillRegister.getCurrentState() != null && !"NEW".equalsIgnoreCase(bill.getCurrentState().getValue()) && (result = this.worksService.getEmpNameDesignation(this.contractorBillRegister.getState().getOwnerPosition(), this.contractorBillRegister.getState().getCreatedDate())) != null && !"@".equalsIgnoreCase(result)) {
            String empName = result.substring(0, result.lastIndexOf(64));
            String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
            this.setNextEmployeeName(empName);
            this.setNextDesignation(designation);
        }
    }

    public String cancel() {
        this.parameters.get(ACTION_NAME);
        if (this.contractorBillRegister.getId() != null) {
            this.contractorBillRegister.setBillstatus("CANCELLED");
            this.contractorBillRegister.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(BILL_MODULE_KEY, "CANCELLED"));
            this.contractorBillService.persist((Object)this.contractorBillRegister);
            List mbHeaderListForBillIdForCancellingBill = this.measurementBookService.findAllByNamedQuery("getAllMBsForBillId", new Object[]{BILL_STATUS, this.contractorBillRegister.getId()});
            if (StringUtils.isNotBlank((String)this.isRebatePremLevelBill) && this.isRebatePremLevelBill.equals("yes") && this.tenderResponse.getTenderEstimate().getTenderType().equals(this.getPercTenderType()) || this.isRCEstimate.equalsIgnoreCase("yes")) {
                this.contractorBillRegister.setPassedamount(this.grossAmount);
                this.contractorBillRegister.setBillamount(this.grossAmount);
            } else {
                this.contractorBillRegister.setPassedamount(this.contractorBillRegister.getBillamount());
            }
            for (MBHeader mbObj : mbHeaderListForBillIdForCancellingBill) {
                MBForCancelledBill mbCB = new MBForCancelledBill();
                mbCB.setEgBillregister(mbObj.getEgBillregister());
                mbCB.setMbHeader(mbObj);
                this.cancelBillService.persist((Object)mbCB);
            }
        }
        return "success";
    }

    public void validate() {
        String actionName = "";
        if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
            actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        }
        if (!actionName.equalsIgnoreCase("reject") && !actionName.equalsIgnoreCase("cancel")) {
            if (this.contractorBillRegister.getBilltype().equals("-1")) {
                this.addFieldError("billType", this.getText("billType.not.found"));
            } else if (this.contractorBillRegister.getBilltype().equals(this.contractorBillService.getBillType().get(1).toString()) && this.completionDate == null) {
                this.addFieldError("completionDate", this.getText("completionDate.not.found"));
            }
            if (StringUtils.isBlank((String)this.partyBillNumber)) {
                this.addFieldError("partyBillNumber", this.getText("partyBillNumber.not.found"));
            }
            if (!this.worksService.checkBigDecimalValue(this.contractorBillRegister.getBillamount(), BigDecimal.valueOf(0.0))) {
                this.addFieldError("billamount", this.getText("no.pending.bills"));
            }
            if (this.partyBillDate == null) {
                this.addFieldError("partyBillDate", this.getText("partyBillDate.not.found"));
            }
            if (!DateUtils.compareDates((Date)new Date(), (Date)this.partyBillDate)) {
                this.addFieldError("partyBillDate", this.getText("partyBillDate.greaterthan.currentDate"));
            }
            if (!DateUtils.compareDates((Date)this.contractorBillRegister.getBilldate(), (Date)this.completionDate)) {
                this.addFieldError("completionDate", this.getText("billdate.lessthan.completionDate"));
            }
            if (!DateUtils.compareDates((Date)this.contractorBillRegister.getBilldate(), (Date)this.workOrder.getWorkOrderDate())) {
                this.addFieldError("workorderdate", this.getText("billdate.lessthan.workorderdate"));
            }
            if (this.contractorBillRegister.getId() == null && !DateUtils.compareDates((Date)this.contractorBillRegister.getBilldate(), (Date)this.partyBillDate)) {
                this.addFieldError("partyBillDate", this.getText("partybilldate.greaterthan.billdate"));
            }
            if (this.contractorBillRegister.getId() == null) {
                this.validateMBAmountAndBillAmount(this.mbHeaderList);
            }
            if (this.contractorBillRegister.getStatus() != null && this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("NEW")) {
                this.validateMBAmountAndBillAmount(this.mbHeaderListForBillId);
            }
            if (this.contractorBillRegister.getId() == null && this.contractorBillRegister.getStatus() == null && this.mbHeaderId != null && this.mbHeaderId.length > 0) {
                ArrayList<MBHeader> mbHeaderWithBill = new ArrayList<MBHeader>();
                for (Long mbId : this.mbHeaderId) {
                    MBHeader mbHeader = (MBHeader)this.measurementBookService.findById((Serializable)mbId, false);
                    if (mbHeader.getEgBillregister() == null || mbHeader.getEgBillregister().getStatus().getCode().equalsIgnoreCase("CANCELLED")) continue;
                    mbHeaderWithBill.add(mbHeader);
                }
                StringBuilder billStr = new StringBuilder(200);
                StringBuilder mbStr = new StringBuilder(200);
                for (MBHeader mbh : mbHeaderWithBill) {
                    if (!billStr.toString().contains(mbh.getEgBillregister().getBillnumber())) {
                        billStr.append(mbh.getEgBillregister().getBillnumber()).append(",");
                    }
                    mbStr.append(mbh.getMbRefNo()).append(",");
                    if (mbHeaderWithBill.size() != 1) continue;
                    this.addActionError(this.getText("contractorBill.uniqueCheck.message1", new String[]{mbh.getEgBillregister().getBillnumber(), mbh.getMbRefNo()}));
                }
                if (mbHeaderWithBill.size() > 1) {
                    this.addActionError(this.getText("contractorBill.uniqueCheck.message2", new String[]{billStr.toString(), mbStr.toString()}));
                }
            }
            if (this.contractorBillRegister.getId() == null) {
                Date latestBillDate = null;
                latestBillDate = this.workOrderEstimate != null && this.workOrderEstimate.getId() != null ? this.measurementBookService.getLatestBillDateForMBPassingWOEstimate(this.workOrderEstimate.getId()) : this.measurementBookService.getLatestBillDateForMB(this.workOrderId);
                if (latestBillDate != null && !DateUtils.compareDates((Date)this.contractorBillRegister.getBilldate(), (Date)latestBillDate)) {
                    this.addFieldError("billdate", this.getText("billdate.lessthan.olderbill"));
                }
            }
            if (Long.valueOf(0L).equals(this.netPayableCode)) {
                this.addFieldError("netPayableCode", this.getText("netPayableCode.not.found"));
            }
            if (!this.worksService.checkBigDecimalValue(this.netPayableAmount, BigDecimal.valueOf(0.0))) {
                this.addFieldError("netPayableAmount", this.getText("netPayableAmount.lessthan.zero"));
            }
            this.validateAssetDetails();
            this.validateStatutoryDeduction();
            this.validateStandardDeduction();
            this.validateCustomDeduction();
            if (!this.checkForCOADuplicatesInAccDet()) {
                this.addFieldError("accountcode", this.getText("duplicate.accountcode"));
            }
            if (!this.checkForCOADuplicatesInCustomDed()) {
                this.addFieldError("glcodeId", this.getText("duplicate.glcodeId"));
            }
            if ((this.id == null || this.contractorBillRegister.getStatus() != null && (this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("NEW") || this.contractorBillRegister.getStatus().getCode().equalsIgnoreCase("REJECTED")) && StringUtils.isNotBlank((String)this.contractorBillRegister.getBilltype()) && this.contractorBillRegister.getBilltype().equalsIgnoreCase("Final Bill")) && this.latestMBDate != null && this.completionDate != null && this.latestMBDate.after(this.completionDate)) {
                this.addFieldError("work.compltion.date.less.than.lstMB.date", this.getText("work.compltion.date.less.than.lstMB.date") + " " + this.refNo + ", " + new SimpleDateFormat("dd/MM/yyyy").format(this.latestMBDate) + this.getText("pls.enter.valid.date"));
            }
            if (this.id != null && !this.getFieldErrors().isEmpty()) {
                try {
                    this.edit();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    private void validateARFInWorkflow() {
        AjaxContractorBillAction ajaxContractorBillAction = new AjaxContractorBillAction();
        ajaxContractorBillAction.setPersistenceService(this.getPersistenceService());
        ajaxContractorBillAction.setEmployeeService(this.employeeService);
        ajaxContractorBillAction.setContractorAdvanceService(this.contractorAdvanceService);
        ajaxContractorBillAction.setWorkOrderEstimateId(this.workOrderEstimate.getId());
        ajaxContractorBillAction.advanceRequisitionInWorkflowCheck();
        if (ajaxContractorBillAction.getArfInWorkFlowCheck().equalsIgnoreCase("invalid")) {
            throw new ValidationException(Arrays.asList(new ValidationError("arf.workflow.verification.for.bill.msg", this.getText("arf.workflow.verification.for.bill.msg", new String[]{ajaxContractorBillAction.getAdvanceRequisitionNo(), ajaxContractorBillAction.getEstimateNo(), ajaxContractorBillAction.getOwner()}))));
        }
    }

    private void validateExpenditureForDepositCode(String actionName) {
        FinancialDetail financialDetails;
        if (this.workOrderEstimate.getEstimate() != null && this.workOrderEstimate.getEstimate().getDepositCode() != null && StringUtils.isNotBlank((String)actionName) && (actionName.equalsIgnoreCase("submit_for_approval") || actionName.equalsIgnoreCase("approval") || actionName.equalsIgnoreCase("approve")) && (financialDetails = (FinancialDetail)this.workOrderEstimate.getEstimate().getFinancialDetails().get(0)) != null) {
            BigDecimal expenditureAmount = BigDecimal.ZERO;
            BigDecimal totalExpAmount = BigDecimal.ZERO;
            Fund fund = financialDetails.getFund();
            CChartOfAccounts coa = financialDetails.getCoa();
            Accountdetailtype accountdetailtype = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where name=?", new Object[]{"DEPOSITCODE"});
            if (fund != null && fund.getId() != null && coa != null && coa.getId() != null && this.workOrderEstimate.getEstimate().getDepositCode().getId() != null) {
                BigDecimal totalAmountDeposited = this.egovCommon.getDepositAmountForDepositCode(new Date(), coa.getGlcode(), fund.getCode(), accountdetailtype.getId(), Integer.valueOf(this.workOrderEstimate.getEstimate().getDepositCode().getId().intValue()));
                List projectCodeIdsList = this.contractorBillService.getProjCodeIdsListForDepositCode(fund.getId(), coa.getId(), this.workOrderEstimate.getEstimate().getDepositCode().getId());
                if (!projectCodeIdsList.isEmpty()) {
                    expenditureAmount = this.contractorBillService.getTotalExpenditure(projectCodeIdsList, ACCOUNTDETAIL_TYPE_PROJECTCODE);
                }
                totalExpAmount = this.id == null ? expenditureAmount.add(this.contractorBillRegister.getBillamount()) : expenditureAmount;
                BigDecimal finalExpenditureAmount = totalExpAmount.setScale(2, RoundingMode.HALF_UP);
                BigDecimal totalDepositedAmount = totalAmountDeposited.setScale(2, RoundingMode.HALF_UP);
                if (totalDepositedAmount.compareTo(finalExpenditureAmount) == -1) {
                    this.populateBudgetHeadForDepositWorksEstimate();
                    throw new ValidationException(Arrays.asList(new ValidationError("contractoBill.dwEstimate.expenditure.amount.insufficient", this.getText("contractoBill.dwEstimate.expenditure.amount.insufficient", new String[]{this.workOrderEstimate.getEstimate().getDepositCode().getCode(), NumberUtil.formatNumber((BigDecimal)finalExpenditureAmount), NumberUtil.formatNumber((BigDecimal)totalDepositedAmount)}))));
                }
            }
        }
    }

    private void validateMBAmountAndBillAmount(List<MBHeader> mbHeaderList) {
        BigDecimal totalMBAmount = BigDecimal.ZERO;
        for (MBHeader mbh : mbHeaderList) {
            totalMBAmount = totalMBAmount.add(mbh.getTotalMBAmount());
        }
        if (this.billAmount.setScale(2, RoundingMode.HALF_UP).compareTo(totalMBAmount.setScale(2, RoundingMode.HALF_UP)) != 0) {
            this.addFieldError("billAmount.compare.total.mbAmount", this.getText("billAmount.compare.total.mbAmount"));
        }
    }

    protected void validateStandardDeduction() {
        for (DeductionTypeForBill stanDetails : this.standardDeductions) {
            if (stanDetails == null) continue;
            if (stanDetails.getDeductionType() == null || stanDetails.getGlcodeid().equals(BigDecimal.valueOf(0L))) {
                this.addFieldError("standardDeductions", this.getText("please.select.standardDeductions"));
            }
            if (this.worksService.checkBigDecimalValue(stanDetails.getCreditamount(), BigDecimal.valueOf(0.0))) continue;
            this.addFieldError("amount", this.getText(AMOUNT_ERROR));
        }
    }

    protected void validateCustomDeduction() {
        for (EgBilldetails customDetails : this.customDeductions) {
            if (customDetails == null) continue;
            if (customDetails.getGlcodeid().equals(BigDecimal.valueOf(0L))) {
                this.addFieldError("customDeductions", this.getText("please.select.customDeductions"));
            }
            if (this.worksService.checkBigDecimalValue(customDetails.getCreditamount(), BigDecimal.valueOf(0.0))) continue;
            this.addFieldError("customDeductions.amount", this.getText(AMOUNT_ERROR));
        }
    }

    protected void validateRetentionDeduction() {
        for (EgBilldetails retentionMoney : this.retentionMoneyDeductions) {
            if (retentionMoney == null) continue;
            if (retentionMoney.getGlcodeid().equals(BigDecimal.valueOf(0L))) {
                this.addFieldError("customDeductions", this.getText("please.select.retentionMoney"));
            }
            if (this.worksService.checkBigDecimalValue(retentionMoney.getCreditamount(), BigDecimal.valueOf(0.0))) continue;
            this.addFieldError("retentionMoney.amount", this.getText(AMOUNT_ERROR));
        }
    }

    protected void validateAssetDetails() {
        for (AssetForBill adb : this.accountDetailsForBill) {
            if (this.workOrderEstimate.getAssetValues().isEmpty()) {
                if (adb != null && (adb.getCoa() == null || adb.getCoa().getId() == 0L)) {
                    this.addFieldError("coa", this.getText("please.select.asset"));
                }
            } else if (!(adb == null || adb.getAsset() != null && adb.getAsset().getId() != 0L || adb.getCoa() != null && adb.getCoa().getId() != 0L)) {
                this.addFieldError("asset", this.getText("please.select.asset"));
            }
            if (adb == null || this.worksService.checkBigDecimalValue(adb.getAmount(), BigDecimal.valueOf(0.0))) continue;
            this.addFieldError("asset.amount", this.getText(AMOUNT_ERROR));
        }
    }

    protected void validateStatutoryDeduction() {
        for (StatutoryDeductionsForBill adb : this.actionStatutorydetails) {
            if (adb == null) continue;
            if (adb.getEgBillPayeeDtls().getRecovery() == null || adb.getEgBillPayeeDtls().getRecovery().getId() == 0L) {
                this.addFieldError("actionStatutorydetails", this.getText("please.select.actionStatutorydetails"));
            }
            if (this.worksService.checkBigDecimalValue(adb.getEgBillPayeeDtls().getCreditAmount(), BigDecimal.valueOf(0.0))) continue;
            this.addFieldError("actionStatutorydetails.amount", this.getText(AMOUNT_ERROR));
        }
    }

    public boolean checkForCOADuplicatesInAccDet() {
        Collection assetAndAccountDetails = this.contractorBillService.getAssetAndAccountDetails(this.accountDetailsForBill);
        if (!assetAndAccountDetails.isEmpty() && this.workOrderEstimate.getAssetValues().isEmpty()) {
            HashSet<Long> coaSet = new HashSet<Long>();
            for (AssetForBill assetForBill : assetAndAccountDetails) {
                if (assetForBill.getCoa() == null || assetForBill.getCoa().getId() <= 0L) continue;
                if (coaSet.contains(assetForBill.getCoa().getId())) {
                    return false;
                }
                coaSet.add(assetForBill.getCoa().getId());
            }
        }
        return true;
    }

    public boolean checkForCOADuplicatesInCustomDed() {
        Collection customDeductionTypes = this.contractorBillService.getCustomDeductionTypes(this.customDeductions);
        if (!customDeductionTypes.isEmpty()) {
            HashSet<BigDecimal> coaSet = new HashSet<BigDecimal>();
            for (EgBilldetails egBilldetails : customDeductionTypes) {
                if (egBilldetails.getGlcodeid() == null || !this.worksService.checkBigDecimalValue(egBilldetails.getGlcodeid(), BigDecimal.valueOf(0L))) continue;
                if (coaSet.contains(egBilldetails.getGlcodeid())) {
                    return false;
                }
                coaSet.add(egBilldetails.getGlcodeid());
            }
        }
        return true;
    }

    private ContractorBillRegister setEgBillRegister() throws Exception {
        boolean shouldAddAccountDetails = false;
        if (this.contractorBillRegister.getStatus() == null || "REJECTED".equalsIgnoreCase(this.contractorBillRegister.getStatus().getCode()) && StringUtils.isBlank((String)this.contractorBillRegister.getState().getNextAction()) || "new".equalsIgnoreCase(this.contractorBillRegister.getStatus().getCode())) {
            shouldAddAccountDetails = true;
        }
        if (this.contractorBillRegister.getBillnumber() == null) {
            this.contractorBillRegister.setBillnumber(this.contractorBillService.generateContractorBillNumber(this.contractorBillRegister));
        }
        this.contractorBillRegister.setBillstatus(BILL_STATUS);
        if (StringUtils.isNotBlank((String)this.isRebatePremLevelBill) && this.isRebatePremLevelBill.equals("yes") && this.tenderResponse.getTenderEstimate().getTenderType().equals(this.getPercTenderType()) || this.isRCEstimate.equalsIgnoreCase("yes")) {
            this.contractorBillRegister.setPassedamount(this.grossAmount);
            this.contractorBillRegister.setBillamount(this.grossAmount);
        } else {
            this.contractorBillRegister.setPassedamount(this.contractorBillRegister.getBillamount());
        }
        this.contractorBillRegister.setExpendituretype(EXPENDITURE_TYPE);
        this.contractorBillRegister.setWorkordernumber(this.workOrder.getWorkOrderNumber());
        this.contractorBillRegister.setWorkorderdate(this.workOrder.getWorkOrderDate());
        if (this.advaceAdjustmentCreditAmount.intValue() > 0) {
            this.contractorBillRegister.setAdvanceadjusted(this.advaceAdjustmentCreditAmount);
        }
        List fdList = this.financialDetailService.findAllByNamedQuery("FINANCIALDETAILS_BY_ESTIMATEID", new Object[]{this.workOrderEstimate.getEstimate().getId()});
        this.contractorBillRegister.setEgBillregistermis(this.setEgBillregistermis(fdList));
        if (shouldAddAccountDetails) {
            this.addAccountDetails(fdList);
        }
        return this.contractorBillRegister;
    }

    private void addAccountDetails(List<FinancialDetail> fdList) throws Exception {
        EgBilldetails egbillDetails;
        Map debitAmountMap = this.getGlcodesForDebit();
        for (Map.Entry entry : debitAmountMap.entrySet()) {
            this.contractorBillRegister.getEgBilldetailes().add(this.getBillDetailsRegister(this.contractorBillRegister, fdList, (String)entry.getKey(), (BigDecimal)entry.getValue(), true, false));
        }
        Map creditAmountMap = this.getGlcodesForstanDed();
        for (Map.Entry entry : creditAmountMap.entrySet()) {
            this.contractorBillRegister.getEgBilldetailes().add(this.getBillDetailsRegister(this.contractorBillRegister, fdList, (String)entry.getKey(), (BigDecimal)entry.getValue(), false, false));
        }
        for (EgBilldetails egBilldetails : this.contractorBillService.getRetentionMoneyTypes(this.retentionMoneyDeductions)) {
            if (egBilldetails == null || !this.worksService.checkBigDecimalValue(egBilldetails.getGlcodeid(), BigDecimal.valueOf(0L))) continue;
            egbillDetails = this.getBillDetailsRegister(this.contractorBillRegister, fdList, egBilldetails.getGlcodeid().toString(), egBilldetails.getCreditamount(), false, false);
            egbillDetails.setNarration(egBilldetails.getNarration());
            this.contractorBillRegister.getEgBilldetailes().add(egbillDetails);
        }
        for (EgBilldetails egBilldetails : this.customDeductions) {
            if (egBilldetails == null || !this.worksService.checkBigDecimalValue(egBilldetails.getGlcodeid(), BigDecimal.valueOf(0L))) continue;
            egbillDetails = this.getBillDetailsRegister(this.contractorBillRegister, fdList, egBilldetails.getGlcodeid().toString(), egBilldetails.getCreditamount(), false, false);
            egbillDetails.setNarration(egBilldetails.getNarration());
            this.contractorBillRegister.getEgBilldetailes().add(egbillDetails);
        }
        CChartOfAccounts cChartOfAccounts = this.contractorAdvanceService.getContractorAdvanceAccountcodeForWOE(this.workOrderEstimate.getId());
        if (this.advaceAdjustmentCreditAmount != null && this.advaceAdjustmentCreditAmount.intValue() > 0 && cChartOfAccounts != null) {
            this.contractorBillRegister.getEgBilldetailes().add(this.getBillDetailsRegister(this.contractorBillRegister, fdList, cChartOfAccounts.getId().toString(), this.advaceAdjustmentCreditAmount, false, false));
        }
        Map map = this.getGlcodesForStatDed();
        for (Map.Entry entry : map.entrySet()) {
            this.contractorBillRegister.getEgBilldetailes().add(this.getBillDetailsRegister(this.contractorBillRegister, fdList, (String)entry.getKey(), (BigDecimal)entry.getValue(), false, true));
        }
        this.contractorBillRegister.getEgBilldetailes().add(this.getBillDetailsRegister(this.contractorBillRegister, fdList, this.getNetPayableCode().toString(), this.getNetPayableAmount(), false, false));
    }

    private EgBilldetails getBillDetailsRegister(ContractorBillRegister billregister, List<FinancialDetail> fdList, String glcode, BigDecimal amount, boolean isDebit, boolean isTds) throws Exception {
        List detailCode;
        EgBilldetails billDetails = new EgBilldetails();
        if (fdList != null && !fdList.isEmpty() && fdList.get(0).getFunction() != null && fdList.get(0).getFunction().getId() != null) {
            CFunction fun = this.functionHibernateDao.getFunctionById(fdList.get(0).getFunction().getId());
            billDetails.setFunctionid(BigDecimal.valueOf(fun.getId()));
        }
        CChartOfAccounts coa = null;
        if (StringUtils.isNotBlank((String)glcode) && Long.parseLong(glcode) > 0L) {
            coa = this.chartOfAccountsHibernateDAO.findById((Number)Long.valueOf(glcode), false);
        }
        if (coa != null && coa.getId() != null) {
            billDetails.setGlcodeid(BigDecimal.valueOf(coa.getId()));
        }
        if (isDebit) {
            billDetails.setDebitamount(amount);
        } else {
            billDetails.setCreditamount(amount);
        }
        billDetails.setEgBillregister((EgBillregister)billregister);
        if (coa != null && coa.getGlcode() != null && (detailCode = this.chartOfAccountsHibernateDAO.getAccountdetailtypeListByGLCode(coa.getGlcode())) != null && !detailCode.isEmpty()) {
            Accountdetailtype adt1 = null;
            Object adt2 = null;
            Accountdetailtype adt3 = null;
            if (isDebit) {
                adt3 = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), ACCOUNTDETAIL_TYPE_PROJECTCODE);
                if (adt3 != null) {
                    if (isTds) {
                        this.addTdsDetails(amount, isDebit, isTds, billDetails, adt3, Integer.valueOf(this.workOrderEstimate.getEstimate().getProjectCode().getId().toString()));
                    } else {
                        billDetails.getEgBillPaydetailes().add(this.getEgPayeeDetails(billDetails, adt3.getId(), amount, isDebit, false, null, null, Integer.valueOf(this.workOrderEstimate.getEstimate().getProjectCode().getId().toString())));
                    }
                }
            } else {
                adt1 = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), ACCOUNTDETAIL_TYPE_CONTRACTOR);
                if (adt1 != null) {
                    if (isTds) {
                        this.addTdsDetails(amount, isDebit, isTds, billDetails, adt1, Integer.valueOf(this.workOrder.getContractor().getId().toString()));
                    } else {
                        billDetails.getEgBillPaydetailes().add(this.getEgPayeeDetails(billDetails, adt1.getId(), amount, isDebit, false, null, null, Integer.valueOf(this.workOrder.getContractor().getId().toString())));
                    }
                }
            }
            if (adt1 == null && adt2 == null && adt3 == null) {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("contractorBill.validate_glcode_for_subledger", this.getText("contractorBill.validate_glcode_for_subledger", new String[]{coa.getGlcode()})));
                throw new ValidationException(errors);
            }
        }
        return billDetails;
    }

    private void addTdsDetails(BigDecimal amount, boolean isDebit, boolean isTds, EgBilldetails billDetails, Accountdetailtype adt, Integer adkId) {
        for (StatutoryDeductionsForBill payeeDetails : this.getActionStatutorydetails()) {
            if (payeeDetails == null || payeeDetails.getEgBillPayeeDtls().getRecovery() == null || payeeDetails.getEgBillPayeeDtls().getRecovery().getId() == null || payeeDetails.getEgBillPayeeDtls().getRecovery().getChartofaccounts() == null || payeeDetails.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId() == null || !payeeDetails.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId().equals(Long.valueOf(billDetails.getGlcodeid().toString()))) continue;
            EgBillPayeedetails egPayeeDtls = this.getEgPayeeDetails(billDetails, adt.getId(), amount, isDebit, isTds, payeeDetails.getEgBillPayeeDtls().getRecovery().getId(), payeeDetails.getEgBillPayeeDtls().getNarration(), adkId);
            billDetails.getEgBillPaydetailes().add(egPayeeDtls);
            this.addStatutoryDeductionsForBill(payeeDetails, egPayeeDtls);
        }
    }

    private void addStatutoryDeductionsForBill(StatutoryDeductionsForBill statutoryDeductionBill, EgBillPayeedetails egPayeeDtls) {
        StatutoryDeductionsForBill sdb = new StatutoryDeductionsForBill();
        if (statutoryDeductionBill.getSubPartyType().getId() != null) {
            sdb.setSubPartyType((EgPartytype)this.persistenceService.find("from EgPartytype where id=?", new Object[]{statutoryDeductionBill.getSubPartyType().getId()}));
        }
        if (statutoryDeductionBill.getTypeOfWork().getId() != null) {
            sdb.setTypeOfWork((EgwTypeOfWork)this.persistenceService.find("from EgwTypeOfWork where id=?", new Object[]{statutoryDeductionBill.getTypeOfWork().getId()}));
        }
        sdb.setEgBillPayeeDtls(egPayeeDtls);
        sdb.setEgBillReg(this.contractorBillRegister);
        this.contractorBillRegister.addStatutoryDeductions(sdb);
    }

    private EgBillPayeedetails getEgPayeeDetails(EgBilldetails billDetails, Integer adtId, BigDecimal amount, boolean isDebit, boolean isTds, Long tdsId, String narration, Integer adkId) {
        EgBillPayeedetails egBillPaydetail = new EgBillPayeedetails();
        egBillPaydetail.setAccountDetailKeyId(adkId);
        egBillPaydetail.setAccountDetailTypeId(adtId);
        if (isDebit) {
            egBillPaydetail.setDebitAmount(amount);
        } else {
            egBillPaydetail.setCreditAmount(amount);
        }
        if (isTds) {
            egBillPaydetail.setRecovery(this.recoveryService.getTdsById(tdsId));
        }
        if (narration != null) {
            egBillPaydetail.setNarration(narration);
        }
        egBillPaydetail.setEgBilldetailsId(billDetails);
        return egBillPaydetail;
    }

    private EgBillregistermis setEgBillregistermis(List<FinancialDetail> fdList) throws ApplicationException {
        EgBillregistermis egBillRegisterMis = null;
        egBillRegisterMis = this.id == null ? new EgBillregistermis() : this.contractorBillRegister.getEgBillregistermis();
        egBillRegisterMis.setEgBillregister((EgBillregister)this.contractorBillRegister);
        egBillRegisterMis.setPayto(this.workOrder.getContractor().getName());
        egBillRegisterMis.setFieldid(this.workOrderEstimate.getEstimate().getWard());
        egBillRegisterMis.setPartyBillDate(this.partyBillDate);
        egBillRegisterMis.setPartyBillNumber(this.partyBillNumber);
        if (fdList != null && !fdList.isEmpty()) {
            if (fdList.get(0).getFund() != null && fdList.get(0).getFund().getId() != null) {
                egBillRegisterMis.setFund(this.fundHibernateDao.fundById(fdList.get(0).getFund().getId(), false));
            }
            if (fdList.get(0).getFunctionary() != null && fdList.get(0).getFunctionary().getId() != null) {
                egBillRegisterMis.setFunctionaryid(this.functionaryHibDao.functionaryById(Integer.valueOf(fdList.get(0).getFunctionary().getId())));
            }
            if (fdList.get(0).getScheme() != null && fdList.get(0).getScheme().getId() != null) {
                egBillRegisterMis.setScheme(this.schemeHibernateDAO.getSchemeById(fdList.get(0).getScheme().getId()));
            }
            if (fdList.get(0).getSubScheme() != null && fdList.get(0).getSubScheme().getId() != null) {
                egBillRegisterMis.setSubScheme(this.subschemeHibernateDAO.getSubSchemeById(fdList.get(0).getSubScheme().getId()));
            }
            if (!fdList.get(0).getFinancingSources().isEmpty()) {
                egBillRegisterMis.setFundsource(((FinancingSource)fdList.get(0).getFinancingSources().get(0)).getFundSource());
            }
            if (fdList.get(0).getFunction() != null) {
                egBillRegisterMis.setFunction(fdList.get(0).getFunction());
            }
        }
        egBillRegisterMis.setEgDepartment(this.workOrderEstimate.getEstimate().getUserDepartment());
        String finyearId = this.finHibernateDao.getFinancialYearByDate(this.contractorBillRegister.getBilldate()).getId().toString();
        egBillRegisterMis.setFinancialyear(this.finHibernateDao.getFinancialYearById(Long.valueOf(finyearId)));
        egBillRegisterMis.setLastupdatedtime(new Date());
        return egBillRegisterMis;
    }

    public Map<String, BigDecimal> getGlcodesForDebit() {
        HashMap<String, BigDecimal> debitGlcodeAndAmountMap = new HashMap<String, BigDecimal>();
        HashSet<Long> coaSet = new HashSet<Long>();
        for (AssetForBill assetBill : this.accountDetailsForBill) {
            if (assetBill == null || assetBill.getCoa() == null || assetBill.getCoa().getId() == null) continue;
            if (coaSet.contains(assetBill.getCoa().getId())) {
                if (debitGlcodeAndAmountMap.containsKey(assetBill.getCoa().getId().toString())) {
                    BigDecimal amount = (BigDecimal)debitGlcodeAndAmountMap.get(assetBill.getCoa().getId().toString());
                    amount = amount.add(assetBill.getAmount());
                    debitGlcodeAndAmountMap.put(assetBill.getCoa().getId().toString(), amount);
                }
            } else {
                debitGlcodeAndAmountMap.put(assetBill.getCoa().getId().toString(), assetBill.getAmount());
                coaSet.add(assetBill.getCoa().getId());
            }
            this.addAssetForBill(assetBill);
        }
        return debitGlcodeAndAmountMap;
    }

    private void addAssetForBill(AssetForBill adb) {
        if (!this.workOrderEstimate.getAssetValues().isEmpty() && adb.getAsset() != null) {
            AssetForBill assetForBill = new AssetForBill();
            Asset assetNew = this.assetService.findOne(adb.getAsset().getId());
            String value = this.worksService.getWorksConfigValue("WORKS_ASSET_STATUS");
            if (StringUtils.isBlank((String)value)) {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("asset.status", "asset.status.configvalue"));
                throw new ValidationException(errors);
            }
            if (assetNew.getStatus().getDescription().equals(value.split(",")[0])) {
                EgwStatus status = this.egwStatusHibernateDAO.getStatusByModuleAndCode("ASSET", value.split(",")[1]);
                assetNew.setStatus(status);
            }
            assetForBill.setEgbill(this.contractorBillRegister);
            assetForBill.setCoa(this.chartOfAccountsHibernateDAO.findById((Number)adb.getCoa().getId(), false));
            assetForBill.setWorkOrderEstimate(this.workOrderEstimate);
            assetForBill.setAmount(adb.getAmount());
            assetForBill.setDescription(adb.getDescription());
            assetForBill.setAsset(assetNew);
            this.contractorBillRegister.addAssetDetails(assetForBill);
        }
    }

    public Map<String, BigDecimal> getGlcodesForstanDed() {
        HashMap<String, BigDecimal> debitGlcodeAndAmountMap = new HashMap<String, BigDecimal>();
        HashSet<BigDecimal> coaSet = new HashSet<BigDecimal>();
        for (DeductionTypeForBill deductionBill : this.standardDeductions) {
            if (deductionBill == null || deductionBill.getGlcodeid() == null) continue;
            if (coaSet.contains(deductionBill.getGlcodeid())) {
                if (debitGlcodeAndAmountMap.containsKey(deductionBill.getGlcodeid().toString())) {
                    BigDecimal amount = (BigDecimal)debitGlcodeAndAmountMap.get(deductionBill.getGlcodeid().toString());
                    amount = amount.add(deductionBill.getCreditamount());
                    debitGlcodeAndAmountMap.put(deductionBill.getGlcodeid().toString(), amount);
                }
            } else {
                debitGlcodeAndAmountMap.put(deductionBill.getGlcodeid().toString(), deductionBill.getCreditamount());
                coaSet.add(deductionBill.getGlcodeid());
            }
            this.addDeductionTypeBill(deductionBill);
        }
        return debitGlcodeAndAmountMap;
    }

    private void addDeductionTypeBill(DeductionTypeForBill deductionBill) {
        DeductionTypeForBill deductionTypeForBill = new DeductionTypeForBill();
        deductionTypeForBill.setEgbill(this.contractorBillRegister);
        deductionTypeForBill.setWorkOrder(this.workOrder);
        deductionTypeForBill.setNarration(deductionBill.getNarration());
        deductionTypeForBill.setCoa(this.chartOfAccountsHibernateDAO.findById((Number)Long.valueOf(deductionBill.getGlcodeid().toString()), false));
        deductionTypeForBill.setCreditamount(deductionBill.getCreditamount());
        deductionTypeForBill.setDeductionType(deductionBill.getDeductionType());
        this.contractorBillRegister.addDeductionType(deductionTypeForBill);
    }

    public Map<String, BigDecimal> getGlcodesForStatDed() {
        HashMap<String, BigDecimal> debitGlcodeAndAmountMap = new HashMap<String, BigDecimal>();
        HashSet<Long> coaSet = new HashSet<Long>();
        for (StatutoryDeductionsForBill bpd : this.contractorBillService.getStatutoryDeductions(this.actionStatutorydetails)) {
            if (bpd == null || bpd.getEgBillPayeeDtls().getRecovery() == null || bpd.getEgBillPayeeDtls().getRecovery().getId() == null || bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts() == null || bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId() == null) continue;
            if (coaSet.contains(bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId())) {
                if (!debitGlcodeAndAmountMap.containsKey(bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId().toString())) continue;
                BigDecimal amount = (BigDecimal)debitGlcodeAndAmountMap.get(bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId().toString());
                amount = amount.add(bpd.getEgBillPayeeDtls().getCreditAmount());
                debitGlcodeAndAmountMap.put(bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId().toString(), amount);
                continue;
            }
            debitGlcodeAndAmountMap.put(bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId().toString(), bpd.getEgBillPayeeDtls().getCreditAmount());
            coaSet.add(bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId());
        }
        return debitGlcodeAndAmountMap;
    }

    public void populateOtherDeductionList() throws ApplicationException {
        char[] charTypes = this.getBillAccountTypesFromConfig();
        if (charTypes != null) {
            for (char charType : charTypes) {
                List pList = this.chartOfAccountsHibernateDAO.getActiveAccountsForType(charType);
                List coaContPayableList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(WORKS_NETPAYABLE_CODE)));
                if (pList != null && coaContPayableList != null) {
                    pList.removeAll(coaContPayableList);
                }
                if (pList == null) continue;
                this.customDeductionAccountList.addAll(pList);
            }
        }
        if (!this.contractorBillService.getStandardDeductionsFromConfig().isEmpty()) {
            this.standardDeductionConfValues = new LinkedList(this.contractorBillService.getStandardDeductionsFromConfig().keySet());
        }
        if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(RETENTION_MONEY_PURPOSE))) {
            this.retentionMoneyAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(RETENTION_MONEY_PURPOSE)));
        }
    }

    private char[] getBillAccountTypesFromConfig() {
        String strTypes = this.worksService.getWorksConfigValue("CUSTOM_DEDUCTION");
        char[] charArr = null;
        if (StringUtils.isNotBlank((String)strTypes)) {
            String[] strArrayTypes = strTypes.split(",");
            charArr = new char[strArrayTypes.length];
            for (int i = 0; i < strArrayTypes.length; ++i) {
                charArr[i] = strArrayTypes[i].charAt(0);
            }
        }
        return charArr;
    }

    public void setBudgetDetails(Long workOrderId, Long workOrderEstimateId, Date billDate) {
        this.billAmount = this.contractorBillService.getApprovedMBAmount(workOrderId, workOrderEstimateId, billDate);
    }

    public Map<Long, String> getContratorCoaPayableMap() throws NumberFormatException, ApplicationException {
        if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(WORKS_NETPAYABLE_CODE))) {
            List coaPayableList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(WORKS_NETPAYABLE_CODE)));
            for (CChartOfAccounts coa : coaPayableList) {
                this.contratorCoaPayableMap.put(coa.getId(), coa.getGlcode() + "-" + coa.getName());
            }
        }
        return this.contratorCoaPayableMap;
    }

    public void setContratorCoaPayableMap(Map<Long, String> contratorCoaPayableMap) {
        this.contratorCoaPayableMap = contratorCoaPayableMap;
    }

    public String getDisp() {
        return this.disp;
    }

    public void setDisp(String disp) {
        this.disp = disp;
    }

    public List<AssetForBill> getAccountDetailsForBill() {
        return this.accountDetailsForBill;
    }

    public void setAccountDetailsForBill(List<AssetForBill> accountDetailsForBill) {
        this.accountDetailsForBill = accountDetailsForBill;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getWorkOrderId() {
        return this.workOrderId;
    }

    public void setWorkOrderId(Long workOrderId) {
        this.workOrderId = workOrderId;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
        this.contractorBillService = contractorBillService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public List<CChartOfAccounts> getStandardDeductionAccountList() {
        return this.standardDeductionAccountList;
    }

    public List<CChartOfAccounts> getCustomDeductionAccountList() {
        return this.customDeductionAccountList;
    }

    public List<String> getStandardDeductionConfValues() {
        return this.standardDeductionConfValues;
    }

    public List<StatutoryDeductionsForBill> getActionStatutorydetails() {
        return this.actionStatutorydetails;
    }

    public void setActionStatutorydetails(List<StatutoryDeductionsForBill> actionStatutorydetails) {
        this.actionStatutorydetails = actionStatutorydetails;
    }

    public List<DeductionTypeForBill> getStandardDeductions() {
        return this.standardDeductions;
    }

    public void setStandardDeductions(List<DeductionTypeForBill> standardDeductions) {
        this.standardDeductions = standardDeductions;
    }

    public List<EgBilldetails> getCustomDeductions() {
        return this.customDeductions;
    }

    public void setCustomDeductions(List<EgBilldetails> customDeductions) {
        this.customDeductions = customDeductions;
    }

    public BigDecimal getBillAmount() {
        return this.billAmount;
    }

    public void setBillAmount(BigDecimal billAmount) {
        this.billAmount = billAmount;
    }

    public BigDecimal getUtilizedAmount() {
        return this.utilizedAmount;
    }

    public void setUtilizedAmount(BigDecimal utilizedAmount) {
        this.utilizedAmount = utilizedAmount;
    }

    public BigDecimal getSanctionedBudget() {
        return this.sanctionedBudget;
    }

    public void setSanctionedBudget(BigDecimal sanctionedBudget) {
        this.sanctionedBudget = sanctionedBudget;
    }

    public void setFinancialDetailService(PersistenceService<FinancialDetail, Long> financialDetailService) {
        this.financialDetailService = financialDetailService;
    }

    public Long getNetPayableCode() {
        return this.netPayableCode;
    }

    public void setNetPayableCode(Long netPayableCode) {
        this.netPayableCode = netPayableCode;
    }

    public BigDecimal getNetPayableAmount() {
        return this.netPayableAmount;
    }

    public void setNetPayableAmount(BigDecimal netPayableAmount) {
        this.netPayableAmount = netPayableAmount;
    }

    public BigDecimal getAdvaceAdjustmentCreditAmount() {
        return this.advaceAdjustmentCreditAmount;
    }

    public void setAdvaceAdjustmentCreditAmount(BigDecimal advaceAdjustmentCreditAmount) {
        this.advaceAdjustmentCreditAmount = advaceAdjustmentCreditAmount;
    }

    public String getPartyBillNumber() {
        return this.partyBillNumber;
    }

    public void setPartyBillNumber(String partyBillNumber) {
        this.partyBillNumber = partyBillNumber;
    }

    public Date getPartyBillDate() {
        return this.partyBillDate;
    }

    public void setPartyBillDate(Date partyBillDate) {
        this.partyBillDate = partyBillDate;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public void setCommonAssetsService(AssetService assetService) {
        this.assetService = assetService;
    }

    public ContractorBillRegister getContractorBillRegister() {
        return this.contractorBillRegister;
    }

    public void setContractorBillRegister(ContractorBillRegister contractorBillRegister) {
        this.contractorBillRegister = contractorBillRegister;
    }

    public void setMeasurementBookService(MeasurementBookServiceImpl measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public Integer getPartbillNo() {
        return this.partbillNo;
    }

    public void setPartbillNo(Integer partbillNo) {
        this.partbillNo = partbillNo;
    }

    public void setStandardDeductionAccountList(List<CChartOfAccounts> standardDeductionAccountList) {
        this.standardDeductionAccountList = standardDeductionAccountList;
    }

    public void setCustomDeductionAccountList(List<CChartOfAccounts> customDeductionAccountList) {
        this.customDeductionAccountList = customDeductionAccountList;
    }

    public BigDecimal getTotalPendingBalance() {
        return this.totalPendingBalance;
    }

    public void setTotalPendingBalance(BigDecimal totalPendingBalance) {
        this.totalPendingBalance = totalPendingBalance;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public List<MBHeader> getMbHeaderList() {
        return this.mbHeaderList;
    }

    public void setMbHeaderList(List<MBHeader> mbHeaderList) {
        this.mbHeaderList = mbHeaderList;
    }

    public Long[] getAppConfigValueId() {
        return this.appConfigValueId;
    }

    public void setAppConfigValueId(Long[] appConfigValueId) {
        this.appConfigValueId = appConfigValueId;
    }

    public String[] getSelectedchecklistValue() {
        return this.selectedchecklistValue;
    }

    public void setSelectedchecklistValue(String[] selectedchecklistValue) {
        this.selectedchecklistValue = selectedchecklistValue;
    }

    public void setChecklistService(PersistenceService<EgChecklists, Long> checklistService) {
        this.checklistService = checklistService;
    }

    public List<AppConfigValues> getFinalBillChecklist() {
        return this.finalBillChecklist;
    }

    public void setFinalBillChecklist(List<AppConfigValues> finalBillChecklist) {
        this.finalBillChecklist = finalBillChecklist;
    }

    public List<String> getChecklistValues() {
        return this.checklistValues;
    }

    public void setChecklistValues(List<String> checklistValues) {
        this.checklistValues = checklistValues;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    public List<WorkflowAction> getValidActions() {
        return this.workflowService.getValidActions((StateAware)this.contractorBillRegister);
    }

    public void setContractorBillWorkflowService(WorkflowService<ContractorBillRegister> workflow) {
        this.workflowService = workflow;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getNextEmployeeName() {
        return this.nextEmployeeName;
    }

    public void setNextEmployeeName(String nextEmployeeName) {
        this.nextEmployeeName = nextEmployeeName;
    }

    public String getNextDesignation() {
        return this.nextDesignation;
    }

    public void setNextDesignation(String nextDesignation) {
        this.nextDesignation = nextDesignation;
    }

    public Long getWorkOrderEstimateId() {
        return this.workOrderEstimateId;
    }

    public void setWorkOrderEstimateId(Long workOrderEstimateId) {
        this.workOrderEstimateId = workOrderEstimateId;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public InputStream getCompletionCertificatePDF() {
        return this.completionCertificatePDF;
    }

    public void setCompletionCertificatePDF(InputStream completionCertificatePDF) {
        this.completionCertificatePDF = completionCertificatePDF;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public void setScriptExecutionService(ScriptService scriptExecutionService) {
        this.scriptExecutionService = scriptExecutionService;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
    }

    public WorkCompletionInfo getCompletionInfo() {
        return this.completionInfo;
    }

    public void setCompletionInfo(WorkCompletionInfo completionInfo) {
        this.completionInfo = completionInfo;
    }

    public List<WorkCompletionDetailInfo> getCompletionDetailInfoList() {
        return this.completionDetailInfoList;
    }

    public void setCompletionDetailInfoList(List<WorkCompletionDetailInfo> completionDetailInfoList) {
        this.completionDetailInfoList = completionDetailInfoList;
    }

    public String[] getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String[] remarks) {
        this.remarks = remarks;
    }

    public boolean getSkipBudget() {
        return this.skipBudget;
    }

    public void setSkipBudget(boolean skipBudget) {
        this.skipBudget = skipBudget;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public List<CChartOfAccounts> getRetentionMoneyAccountList() {
        return this.retentionMoneyAccountList;
    }

    public void setRetentionMoneyAccountList(List<CChartOfAccounts> retentionMoneyAccountList) {
        this.retentionMoneyAccountList = retentionMoneyAccountList;
    }

    public List<EgBilldetails> getRetentionMoneyDeductions() {
        return this.retentionMoneyDeductions;
    }

    public void setRetentionMoneyDeductions(List<EgBilldetails> retentionMoneyDeductions) {
        this.retentionMoneyDeductions = retentionMoneyDeductions;
    }

    public String getIsRetMoneyAutoCalculated() {
        return this.isRetMoneyAutoCalculated;
    }

    public void setIsRetMoneyAutoCalculated(String isRetMoneyAutoCalculated) {
        this.isRetMoneyAutoCalculated = isRetMoneyAutoCalculated;
    }

    public String getIsRetMoneyEditable() {
        return this.isRetMoneyEditable;
    }

    public void setIsRetMoneyEditable(String isRetMoneyEditable) {
        this.isRetMoneyEditable = isRetMoneyEditable;
    }

    public String getPercDeductForRetMoneyPartBill() {
        return this.percDeductForRetMoneyPartBill;
    }

    public void setPercDeductForRetMoneyPartBill(String percDeductForRetMoneyPartBill) {
        this.percDeductForRetMoneyPartBill = percDeductForRetMoneyPartBill;
    }

    public String getPercDeductForRetMoneyFinalBill() {
        return this.percDeductForRetMoneyFinalBill;
    }

    public void setPercDeductForRetMoneyFinalBill(String percDeductForRetMoneyFinalBill) {
        this.percDeductForRetMoneyFinalBill = percDeductForRetMoneyFinalBill;
    }

    public String getRetMoneyFinalBillPerOnValue() {
        return this.retMoneyFinalBillPerOnValue;
    }

    public void setRetMoneyFinalBillPerOnValue(String retMoneyFinalBillPerOnValue) {
        this.retMoneyFinalBillPerOnValue = retMoneyFinalBillPerOnValue;
    }

    public TenderResponse getTenderResponse() {
        return this.tenderResponse;
    }

    public void setTenderResponse(TenderResponse tenderResponse) {
        this.tenderResponse = tenderResponse;
    }

    public String getRebatePremLevel() {
        return this.rebatePremLevel;
    }

    public void setRebatePremLevel(String rebatePremLevel) {
        this.rebatePremLevel = rebatePremLevel;
    }

    public List<EgPartytype> getSubPartyTypeDtls() {
        return this.subPartyTypeDtls;
    }

    public void setSubPartyTypeDtls(List<EgPartytype> subPartyTypeDtls) {
        this.subPartyTypeDtls = subPartyTypeDtls;
    }

    public List<EgwTypeOfWork> getTypeOfWorkDtls() {
        return this.typeOfWorkDtls;
    }

    public void setTypeOfWorkDtls(List<EgwTypeOfWork> typeOfWorkDtls) {
        this.typeOfWorkDtls = typeOfWorkDtls;
    }

    public String getShowSubPartyType() {
        return this.showSubPartyType;
    }

    public void setShowSubPartyType(String showSubPartyType) {
        this.showSubPartyType = showSubPartyType;
    }

    public String getShowTypeOfWork() {
        return this.showTypeOfWork;
    }

    public void setShowTypeOfWork(String showTypeOfWork) {
        this.showTypeOfWork = showTypeOfWork;
    }

    public String getEditStatutoryAmount() {
        return this.editStatutoryAmount;
    }

    public void setEditStatutoryAmount(String editStatutoryAmount) {
        this.editStatutoryAmount = editStatutoryAmount;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public String getPercTenderType() {
        return this.percTenderType;
    }

    public void setPercTenderType(String percTenderType) {
        this.percTenderType = percTenderType;
    }

    public String getIsRebatePremLevelBill() {
        return this.isRebatePremLevelBill;
    }

    public void setIsRebatePremLevelBill(String isRebatePremLevelBill) {
        this.isRebatePremLevelBill = isRebatePremLevelBill;
    }

    public void setCancelBillService(PersistenceService<MBForCancelledBill, Long> cancelBillService) {
        this.cancelBillService = cancelBillService;
    }

    public BigDecimal getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(BigDecimal grossAmount) {
        this.grossAmount = grossAmount;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public List<String> getAppConfigValuesToSkipBudget() {
        return this.worksService.getNatureOfWorkAppConfigValues(EXPENDITURE_TYPE, APPCONFIG_KEY_NAME);
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public BigDecimal getTenderedItemsAmount() {
        return this.tenderedItemsAmount;
    }

    public void setTenderedItemsAmount(BigDecimal tenderedItemsAmount) {
        this.tenderedItemsAmount = tenderedItemsAmount;
    }

    public Integer getWorkflowFunctionaryId() {
        return this.workflowFunctionaryId;
    }

    public Long[] getMbHeaderId() {
        return this.mbHeaderId;
    }

    public void setMbHeaderId(Long[] mbHeaderId) {
        this.mbHeaderId = mbHeaderId;
    }

    public List<MBHeader> getMbHeaderListForBillId() {
        return this.mbHeaderListForBillId;
    }

    public void setMbHeaderListForBillId(List<MBHeader> mbHeaderListForBillId) {
        this.mbHeaderListForBillId = mbHeaderListForBillId;
    }

    public BigDecimal getTotalAdvancePaid() {
        return this.totalAdvancePaid;
    }

    public void setTotalAdvancePaid(BigDecimal totalAdvancePaid) {
        this.totalAdvancePaid = totalAdvancePaid;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public String getIsRCEstimate() {
        return this.isRCEstimate;
    }

    public void setIsRCEstimate(String isRCEstimate) {
        this.isRCEstimate = isRCEstimate;
    }

    public Date getRestorationEndDate() {
        return this.restorationEndDate;
    }

    public void setRestorationEndDate(Date restorationEndDate) {
        this.restorationEndDate = restorationEndDate;
    }

    public String getDwCategory() {
        return this.dwCategory;
    }

    public void setDwCategory(String dwCategory) {
        this.dwCategory = dwCategory;
    }

    public String getAllowForward() {
        return this.allowForward;
    }

    public void setAllowForward(String allowForward) {
        this.allowForward = allowForward;
    }

    public String getShowValidationMsg() {
        return this.showValidationMsg;
    }

    public void setShowValidationMsg(String showValidationMsg) {
        this.showValidationMsg = showValidationMsg;
    }

    public Date getLatestMBDate() {
        return this.latestMBDate;
    }

    public void setLatestMBDate(Date latestMBDate) {
        this.latestMBDate = latestMBDate;
    }

    public String getRefNo() {
        return this.refNo;
    }

    public void setRefNo(String refNo) {
        this.refNo = refNo;
    }
}

