/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.revisionestimate;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.service.ActivityService;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.masters.service.ScheduleOfRateService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.revisionestimate.service.RevisionEstimateService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/revisionestimate"})
public class UpdateRevisionEstimateController
extends GenericWorkFlowController {
    final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private RevisionEstimateService revisionEstimateService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private MeasurementSheetService measurementSheetService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ScheduleOfRateService scheduleOfRateService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private WorkOrderActivityService workOrderActivityService;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private CityService cityService;

    @ModelAttribute(value="revisionEstimate")
    public RevisionAbstractEstimate getRevisionEstimate(@PathVariable String revisionEstimateId) {
        RevisionAbstractEstimate revisionEstimate = this.revisionEstimateService.getRevisionEstimateById(Long.valueOf(Long.parseLong(revisionEstimateId)));
        return revisionEstimate;
    }

    @RequestMapping(value={"/update/{revisionEstimateId}"}, method={RequestMethod.GET})
    public String updateForm(Model model, @PathVariable Long revisionEstimateId, HttpServletRequest request, @RequestParam(value="mode", required=false) String mode) {
        RevisionAbstractEstimate revisionEstimate = this.revisionEstimateService.getRevisionEstimateById(revisionEstimateId);
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getParent().getId());
        this.revisionEstimateService.loadDataForView(revisionEstimate, workOrderEstimate, model);
        if (revisionEstimate.getCurrentState() != null) {
            model.addAttribute("currentState", (Object)revisionEstimate.getCurrentState().getValue());
            model.addAttribute("amountRule", (Object)revisionEstimate.getEstimateValue());
            model.addAttribute("pendingActions", (Object)revisionEstimate.getCurrentState().getNextAction());
        }
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAmountRule(revisionEstimate.getEstimateValue());
        workflowContainer.setPendingActions(revisionEstimate.getCurrentState().getNextAction());
        workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
        model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
        this.prepareWorkflow(model, (StateAware)revisionEstimate, workflowContainer);
        if (AbstractEstimate.EstimateStatus.NEW.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
            List validActions = Collections.emptyList();
            validActions = this.customizedWorkFlowService.getNextValidActions(revisionEstimate.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), "NEW", workflowContainer.getPendingActions(), revisionEstimate.getCreatedDate());
            model.addAttribute("validActionList", (Object)validActions);
        }
        model.addAttribute("workflowHistory", (Object)this.worksUtils.getHistory(revisionEstimate.getState(), revisionEstimate.getStateHistory()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
        model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
        model.addAttribute("measurementsPresent", (Object)this.measurementSheetService.existsByEstimate(revisionEstimate.getId()));
        model.addAttribute("defaultDepartmentId", (Object)this.worksUtils.getDefaultDepartmentId());
        if ("Save".equalsIgnoreCase(mode)) {
            model.addAttribute("message", (Object)this.messageSource.getMessage("msg.revisionestimate.saved", (Object[])new String[]{revisionEstimate.getEstimateNumber()}, null));
        }
        if (AbstractEstimate.EstimateStatus.NEW.toString().equals(revisionEstimate.getEgwStatus().getCode()) || AbstractEstimate.EstimateStatus.REJECTED.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
            model.addAttribute("mode", (Object)"edit");
            return "revisionEstimate-form";
        }
        model.addAttribute("estimateValue", (Object)revisionEstimate.getEstimateValue().setScale(2, 6));
        model.addAttribute("mode", (Object)"workflowView");
        return "revisionEstimate-view";
    }

    @RequestMapping(value={"/view/{revisionEstimateId}"}, method={RequestMethod.GET})
    public String viewForm(Model model, @PathVariable Long revisionEstimateId, HttpServletRequest request) {
        RevisionAbstractEstimate revisionEstimate = this.revisionEstimateService.getRevisionEstimateById(revisionEstimateId);
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getParent().getId());
        this.revisionEstimateService.loadDataForView(revisionEstimate, workOrderEstimate, model);
        model.addAttribute("workflowHistory", (Object)this.worksUtils.getHistory(revisionEstimate.getState(), revisionEstimate.getStateHistory()));
        model.addAttribute("estimateValue", (Object)revisionEstimate.getEstimateValue().setScale(2, 6));
        model.addAttribute("mode", (Object)"view");
        return "revisionEstimate-view";
    }

    @RequestMapping(value={"/update/{revisionEstimateId}"}, method={RequestMethod.POST})
    public String update(@ModelAttribute(value="revisionEstimate") RevisionAbstractEstimate revisionEstimate, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam String removedActivityIds) throws ApplicationException, IOException {
        String mode = "";
        String workFlowAction = "";
        RevisionAbstractEstimate updatedRevisionEstimate = new RevisionAbstractEstimate();
        String additionalRule = "";
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.estimateService.getApprovalPositionByMatrixDesignation((AbstractEstimate)revisionEstimate, approvalPosition, null, mode, workFlowAction);
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getParent().getId());
        this.revisionEstimateService.validateChangeQuantityActivities(revisionEstimate, errors);
        this.revisionEstimateService.validateNontenderedActivities(revisionEstimate, errors);
        this.revisionEstimateService.validateLumpsumActivities(revisionEstimate, errors);
        if (errors.hasErrors()) {
            this.revisionEstimateService.loadViewData(revisionEstimate, workOrderEstimate, model);
            for (Activity activity : revisionEstimate.getNonTenderedActivities()) {
                activity.setSchedule(this.scheduleOfRateService.getScheduleOfRateById(activity.getSchedule().getId()));
            }
            for (Activity activity : revisionEstimate.getChangeQuantityActivities()) {
                activity.setParent(this.activityService.findOne(activity.getParent().getId()));
                WorkOrderActivity workOrderActivity = this.workOrderActivityService.getWorkOrderActivityByActivity(activity.getParent().getId());
                if (workOrderActivity == null) continue;
                Double consumedQuantity = this.mbHeaderService.getPreviousCumulativeQuantity(Long.valueOf(-1L), workOrderActivity.getId());
                activity.setConsumedQuantity(Double.valueOf(consumedQuantity == null ? 0.0 : consumedQuantity));
                activity.setEstimateQuantity(Double.valueOf(workOrderActivity.getApprovedQuantity()));
                if ("-".equalsIgnoreCase(activity.getSignValue())) {
                    activity.setRevisionType(RevisionType.REDUCED_QUANTITY);
                    continue;
                }
                activity.setRevisionType(RevisionType.ADDITIONAL_QUANTITY);
            }
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
            model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
            workflowContainer.setAmountRule(revisionEstimate.getEstimateValue());
            this.prepareWorkflow(model, (StateAware)revisionEstimate, workflowContainer);
            List validActions = Collections.emptyList();
            validActions = this.customizedWorkFlowService.getNextValidActions(revisionEstimate.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), "NEW", workflowContainer.getPendingActions(), revisionEstimate.getCreatedDate());
            if (revisionEstimate.getState() != null && revisionEstimate.getState().getNextAction() != null) {
                model.addAttribute("nextAction", (Object)revisionEstimate.getState().getNextAction());
            }
            model.addAttribute("validActionList", (Object)validActions);
            model.addAttribute("mode", null);
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("designation", (Object)request.getParameter("designation"));
            model.addAttribute("approvedByValue", (Object)request.getParameter("approvedBy"));
            model.addAttribute("removedActivityIds", (Object)removedActivityIds);
            return "revisionEstimate-form";
        }
        try {
            if (null != workFlowAction) {
                updatedRevisionEstimate = this.revisionEstimateService.updateRevisionEstimate(revisionEstimate, approvalPosition, approvalComment, additionalRule, workFlowAction, removedActivityIds, workOrderEstimate);
            }
        }
        catch (ValidationException e) {
            String errorMessage = this.messageSource.getMessage("error.budgetappropriation.insufficient.amount", (Object[])new String[0], null);
            model.addAttribute("message", (Object)errorMessage);
            return "revisionEstimate-success";
        }
        model.addAttribute("revisionEstimate", (Object)updatedRevisionEstimate);
        if (AbstractEstimate.EstimateStatus.NEW.toString().equals(updatedRevisionEstimate.getEgwStatus().getCode())) {
            return "redirect:/revisionestimate/update/" + updatedRevisionEstimate.getId() + "?mode=save";
        }
        if (approvalPosition == null) {
            return "redirect:/revisionestimate/revisionestimate-success?revisionEstimate=" + updatedRevisionEstimate.getId() + "&approvalPosition=";
        }
        return "redirect:/revisionestimate/revisionestimate-success?revisionEstimate=" + updatedRevisionEstimate.getId() + "&approvalPosition=" + approvalPosition;
    }
}

