/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.revisionestimate;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.EstimateTechnicalSanction;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.revisionestimate.service.RevisionEstimateService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/revisionestimate"})
public class RevisionAgreementPDFController {
    public static final String REVISIONAGREEMENTPDF = "RevisionAgreementPDF";
    @Autowired
    private RevisionEstimateService revisionEstimateService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorkOrderActivityService workOrderActivityService;

    @RequestMapping(value={"/revisionagreementPDF/{revisionEstimateId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateContractorBillPDF(HttpServletRequest request, @PathVariable(value="revisionEstimateId") Long revisionEstimateId, HttpSession session) throws IOException {
        RevisionAbstractEstimate revisionEstimate = this.revisionEstimateService.getRevisionEstimateById(revisionEstimateId);
        return this.generateReport(revisionEstimate, request, session);
    }

    private ResponseEntity<byte[]> generateReport(RevisionAbstractEstimate revisionEstimate, HttpServletRequest request, HttpSession session) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        DecimalFormat df = new DecimalFormat("0.00");
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (revisionEstimate != null) {
            WorkOrderEstimate revisionWorkOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getId());
            WorkOrder revisionworkOrder = revisionWorkOrderEstimate.getWorkOrder();
            AbstractEstimate originalEstimate = revisionEstimate.getParent();
            WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(originalEstimate.getId());
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            String cityName = ApplicationThreadLocals.getMunicipalityName();
            reportParams.put("cityName", cityName);
            reportParams.put("revisionEstimate", revisionEstimate);
            reportParams.put("suplimentAgreementAmount", BigDecimal.valueOf(revisionworkOrder.getWorkOrderAmount()).setScale(2, 0).toString());
            reportParams.put("workOrderNumber", workOrderEstimate.getWorkOrder().getWorkOrderNumber() != null ? workOrderEstimate.getWorkOrder().getWorkOrderNumber() : "");
            reportParams.put("workOrderDate", revisionworkOrder.getWorkOrderDate() != null ? DateUtils.getDefaultFormattedDate((Date)revisionworkOrder.getWorkOrderDate()) : "");
            reportParams.put("contractorName", revisionworkOrder.getContractor().getName() != null ? revisionworkOrder.getContractor().getName() : "");
            reportParams.put("contractorAddress", revisionworkOrder.getContractor().getBankaccount() != null ? revisionworkOrder.getContractor().getCorrespondenceAddress() : "");
            reportParams.put("panNo", revisionworkOrder.getContractor().getPanNumber() != null ? revisionworkOrder.getContractor().getPanNumber() : "");
            reportParams.put("bank", revisionworkOrder.getContractor().getBank() != null ? revisionworkOrder.getContractor().getBank().getName() : "");
            reportParams.put("accountNo", revisionworkOrder.getContractor().getBankaccount() != null ? revisionworkOrder.getContractor().getBankaccount() : "");
            reportParams.put("subject", originalEstimate.getName());
            reportParams.put("modeOfAllotment", !StringUtils.isBlank((String)originalEstimate.getModeOfAllotment().toString()) ? originalEstimate.getModeOfAllotment().toString() : "");
            reportParams.put("agreementAmount", df.format(revisionworkOrder.getWorkOrderAmount()));
            reportParams.put("WINCode", originalEstimate.getProjectCode().getCode());
            reportParams.put("amountOfEstimate", revisionEstimate.getEstimateValue().setScale(2, 6));
            reportParams.put("ward", originalEstimate.getWard().getName());
            this.revisionEstimateService.prepareNonTenderedAndLumpSumActivities(revisionEstimate);
            reportParams.put("nonTenderedActivities", revisionEstimate.getNonTenderedActivities());
            reportParams.put("LumpSumActivities", revisionEstimate.getLumpSumActivities());
            this.revisionEstimateService.prepareChangeQuantityActivities(revisionEstimate);
            reportParams.put("changeQuatityActivities", revisionEstimate.getChangeQuantityActivities());
            reportParams.put("nonTenderedActivitiesFlag", !revisionEstimate.getNonTenderedActivities().isEmpty() ? Boolean.FALSE : Boolean.TRUE);
            reportParams.put("LumpSumActivitiesFlag", !revisionEstimate.getLumpSumActivities().isEmpty() ? Boolean.FALSE : Boolean.TRUE);
            reportParams.put("changeQuatityActivitiesFlag", !revisionEstimate.getChangeQuantityActivities().isEmpty() ? Boolean.FALSE : Boolean.TRUE);
            double tenderAmount = 0.0;
            double nonTenderAmount = 0.0;
            double approvedAmount = 0.0;
            Double tenderFinalizedPercentage = revisionworkOrder.getParent().getTenderFinalizedPercentage();
            for (Activity activity : revisionEstimate.getChangeQuantityActivities()) {
                WorkOrderActivity workOrderActivity = this.workOrderActivityService.getWorkOrderActivityByActivity(activity.getId());
                approvedAmount = new Money(activity.getRate() * workOrderActivity.getApprovedQuantity()).getValue();
                if (activity.getRevisionType() != null && RevisionType.REDUCED_QUANTITY.equals((Object)activity.getRevisionType())) {
                    approvedAmount *= -1.0;
                }
                if (activity != null && activity.getParent() != null && activity.getParent().getRevisionType() == null && (RevisionType.ADDITIONAL_QUANTITY.toString().equalsIgnoreCase(activity.getRevisionType().toString()) || RevisionType.REDUCED_QUANTITY.toString().equalsIgnoreCase(activity.getRevisionType().toString()))) {
                    tenderAmount += approvedAmount;
                    continue;
                }
                nonTenderAmount += approvedAmount;
            }
            if (!tenderFinalizedPercentage.equals(0.0)) {
                tenderAmount += tenderAmount * tenderFinalizedPercentage / 100.0;
            }
            reportParams.put("tenderFinalizedPercentage", tenderFinalizedPercentage);
            reportParams.put("currDate", DateUtils.getFormattedDateWithTimeStamp((DateTime)new DateTime()));
            reportParams.put("workValue", df.format(revisionEstimate.getWorkValue()));
            reportParams.put("reportRunDate", DateUtils.getFormattedDateWithTimeStamp((DateTime)new DateTime()));
            reportParams.put("changeQtyTenderAmount", tenderAmount);
            reportParams.put("changeQtyNonTenderAmount", nonTenderAmount);
            String technicalSanctionByDesignation = "";
            technicalSanctionByDesignation = !originalEstimate.getEstimateTechnicalSanctions().isEmpty() && ((EstimateTechnicalSanction)originalEstimate.getEstimateTechnicalSanctions().get(originalEstimate.getEstimateTechnicalSanctions().size() - 1)).getTechnicalSanctionBy() != null ? this.worksUtils.getUserDesignation(((EstimateTechnicalSanction)originalEstimate.getEstimateTechnicalSanctions().get(originalEstimate.getEstimateTechnicalSanctions().size() - 1)).getTechnicalSanctionBy()) : this.worksUtils.getUserDesignation(originalEstimate.getCreatedBy());
            reportParams.put("technicalSanctionByDesignation", technicalSanctionByDesignation);
            reportInput = new ReportRequest(REVISIONAGREEMENTPDF, (Object)revisionEstimate, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=RevisionAgreement_" + revisionEstimate.getEstimateNumber() + ".pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

