/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.revisionestimate;

import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.service.ActivityService;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.lineestimate.entity.EstimateAppropriation;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.masters.service.ScheduleOfRateService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.revisionestimate.service.RevisionEstimateService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/revisionestimate"})
public class CreateRevisionEstimateController
extends GenericWorkFlowController {
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private RevisionEstimateService revisionEstimateService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private ScheduleOfRateService scheduleOfRateService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private WorkOrderActivityService workOrderActivityService;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private CityService cityService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String showForm(@ModelAttribute(value="revisionEstimate") RevisionAbstractEstimate revisionEstimate, @RequestParam Long workOrderEstimateId, Model model) {
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(workOrderEstimateId);
        revisionEstimate.setParent(workOrderEstimate.getEstimate());
        this.revisionEstimateService.loadViewData(revisionEstimate, workOrderEstimate, model);
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
        model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
        if (revisionEstimate.getState() != null) {
            workflowContainer.setPendingActions("");
        }
        workflowContainer.setAmountRule(revisionEstimate.getEstimateValue() != null ? revisionEstimate.getEstimateValue() : BigDecimal.ZERO);
        this.prepareWorkflow(model, (StateAware)revisionEstimate, workflowContainer);
        ArrayList<String> validActions = new ArrayList<String>();
        validActions.add("Save");
        validActions.add(WorksConstants.FORWARD_ACTION.toString());
        validActions.add("Create And Approve");
        if (revisionEstimate.getState() != null && revisionEstimate.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)revisionEstimate.getState().getNextAction());
        }
        model.addAttribute("validActionList", validActions);
        model.addAttribute("mode", null);
        model.addAttribute("defaultDepartmentId", (Object)this.worksUtils.getDefaultDepartmentId());
        return "revisionEstimate-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String save(@ModelAttribute(value="revisionEstimate") RevisionAbstractEstimate revisionEstimate, RedirectAttributes redirectAttributes, Model model, BindingResult bindErrors, HttpServletRequest request, @RequestParam String workFlowAction) {
        RevisionAbstractEstimate savedRevisionEstimate;
        Long approvalPosition = 0L;
        String approvalComment = "";
        String additionalRule = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getParent().getId());
        JsonObject jsonObject = new JsonObject();
        this.revisionEstimateService.validateREInDrafts(workOrderEstimate.getEstimate().getId(), jsonObject, bindErrors);
        this.revisionEstimateService.validateREInWorkFlow(workOrderEstimate.getEstimate().getId(), jsonObject, bindErrors);
        this.revisionEstimateService.validateChangeQuantityActivities(revisionEstimate, bindErrors);
        this.revisionEstimateService.validateNontenderedActivities(revisionEstimate, bindErrors);
        this.revisionEstimateService.validateLumpsumActivities(revisionEstimate, bindErrors);
        this.revisionEstimateService.validateWorkflowActionButton(revisionEstimate, bindErrors, additionalRule, workFlowAction);
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            this.validateBudgetAmount(revisionEstimate, bindErrors);
        }
        if (bindErrors.hasErrors()) {
            this.revisionEstimateService.loadViewData(revisionEstimate, workOrderEstimate, model);
            for (Activity activity : revisionEstimate.getNonTenderedActivities()) {
                activity.setSchedule(this.scheduleOfRateService.getScheduleOfRateById(activity.getSchedule().getId()));
            }
            for (Activity activity : revisionEstimate.getChangeQuantityActivities()) {
                activity.setParent(this.activityService.findOne(activity.getParent().getId()));
                WorkOrderActivity workOrderActivity = this.workOrderActivityService.getWorkOrderActivityByActivity(activity.getParent().getId());
                if (workOrderActivity == null) continue;
                Double consumedQuantity = this.mbHeaderService.getPreviousCumulativeQuantity(Long.valueOf(-1L), workOrderActivity.getId());
                activity.setConsumedQuantity(Double.valueOf(consumedQuantity == null ? 0.0 : consumedQuantity));
                activity.setEstimateQuantity(Double.valueOf(workOrderActivity.getApprovedQuantity()));
                if ("-".equalsIgnoreCase(activity.getSignValue())) {
                    activity.setRevisionType(RevisionType.REDUCED_QUANTITY);
                    continue;
                }
                activity.setRevisionType(RevisionType.ADDITIONAL_QUANTITY);
            }
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
            model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
            workflowContainer.setAmountRule(revisionEstimate.getEstimateValue());
            this.prepareWorkflow(model, (StateAware)revisionEstimate, workflowContainer);
            ArrayList<String> validActions = new ArrayList<String>();
            validActions.add("Save");
            validActions.add(WorksConstants.FORWARD_ACTION.toString());
            if (revisionEstimate.getState() != null && revisionEstimate.getState().getNextAction() != null) {
                model.addAttribute("nextAction", (Object)revisionEstimate.getState().getNextAction());
                model.addAttribute("pendingActions", (Object)revisionEstimate.getState().getNextAction());
            }
            model.addAttribute("validActionList", validActions);
            model.addAttribute("mode", null);
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("designation", (Object)request.getParameter("designation"));
            model.addAttribute("approvedByValue", (Object)request.getParameter("approvedBy"));
            return "revisionEstimate-form";
        }
        if (revisionEstimate.getState() == null) {
            if (WorksConstants.FORWARD_ACTION.equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", AbstractEstimate.EstimateStatus.CREATED.toString()));
            } else if ("Create And Approve".equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", AbstractEstimate.EstimateStatus.APPROVED.toString()));
            } else {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", AbstractEstimate.EstimateStatus.NEW.toString()));
            }
        }
        try {
            savedRevisionEstimate = this.revisionEstimateService.createRevisionEstimate(revisionEstimate, approvalPosition, approvalComment, additionalRule, workFlowAction);
        }
        catch (ValidationException e) {
            String errorMessage = this.messageSource.getMessage("error.budgetappropriation.insufficient.amount", (Object[])new String[0], null);
            model.addAttribute("message", (Object)errorMessage);
            return "revisionEstimate-success";
        }
        if (AbstractEstimate.EstimateStatus.NEW.toString().equals(savedRevisionEstimate.getEgwStatus().getCode())) {
            return "redirect:/revisionestimate/update/" + savedRevisionEstimate.getId() + "?mode=save";
        }
        return "redirect:/revisionestimate/revisionestimate-success?revisionEstimate=" + savedRevisionEstimate.getId() + "&approvalPosition=" + approvalPosition;
    }

    private void validateBudgetAmount(RevisionAbstractEstimate revisionAbstractEstimate, BindingResult errors) {
        block3: {
            ArrayList<Long> budgetheadid = new ArrayList<Long>();
            FinancialDetail financialDetail = (FinancialDetail)revisionAbstractEstimate.getParent().getFinancialDetails().get(0);
            budgetheadid.add(financialDetail.getBudgetGroup().getId());
            try {
                BigDecimal budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.worksUtils.getFinancialYearByDate(new Date()).getId(), Integer.valueOf(Integer.parseInt(revisionAbstractEstimate.getParent().getExecutingDepartment().getId().toString())), financialDetail.getFunction().getId(), null, financialDetail.getScheme() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getScheme().getId().toString())), financialDetail.getSubScheme() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getSubScheme().getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(financialDetail.getFund().getId().toString())));
                if (BudgetControlType.BudgetCheckOption.MANDATORY.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && budgetAvailable.compareTo(revisionAbstractEstimate.getEstimateValue()) == -1) {
                    errors.reject("error.budgetappropriation.insufficient.amount", null);
                }
            }
            catch (ValidationException e) {
                Iterator iterator = e.getErrors().iterator();
                if (!iterator.hasNext()) break block3;
                ValidationError error = (ValidationError)iterator.next();
                throw new ApplicationRuntimeException(error.getKey());
            }
        }
    }

    @RequestMapping(value={"/revisionestimate-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute RevisionAbstractEstimate revisionEstimate, @RequestParam(value="revisionEstimate") Long id, @RequestParam(value="approvalPosition") Long approvalPosition, HttpServletRequest request, Model model) {
        if (id != null) {
            revisionEstimate = this.revisionEstimateService.getRevisionEstimateById(id);
        }
        String pathVars = this.worksUtils.getPathVars(revisionEstimate.getEgwStatus(), revisionEstimate.getState(), revisionEstimate.getId(), approvalPosition);
        String[] keyNameArray = pathVars.split(",");
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1 && keyNameArray[0] != null) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(revisionEstimate, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        return new ModelAndView("revisionEstimate-success", "revisionEstimate", (Object)revisionEstimate);
    }

    private String getMessageByStatus(RevisionAbstractEstimate revisionEstimate, String approverName, String nextDesign) {
        String message = "";
        if (RevisionAbstractEstimate.RevisionEstimateStatus.NEW.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.saved", (Object[])new String[]{revisionEstimate.getEstimateNumber()}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.CREATED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !"Rejected".equals(revisionEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.revisionestimate.created", (Object[])new String[]{approverName, nextDesign, revisionEstimate.getEstimateNumber()}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.RESUBMITTED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !"Rejected".equals(revisionEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.revisionestimate.resubmitted", (Object[])new String[]{approverName, nextDesign, revisionEstimate.getEstimateNumber()}, null);
        } else if (revisionEstimate.getState() != null && "Rejected".equals(revisionEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.revisionestimate.rejected", (Object[])new String[]{revisionEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.CANCELLED.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.cancel", (Object[])new String[]{revisionEstimate.getEstimateNumber()}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString().equalsIgnoreCase(revisionEstimate.getEgwStatus().getCode())) {
            EstimateAppropriation lea = this.estimateAppropriationService.findLatestByAbstractEstimate((AbstractEstimate)revisionEstimate);
            message = this.messageSource.getMessage("msg.revisionestimate.approved", (Object[])new String[]{revisionEstimate.getEstimateNumber(), lea.getBudgetUsage().getAppropriationnumber()}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.CHECKED.toString().equalsIgnoreCase(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.checked", (Object[])new String[]{revisionEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        }
        return message;
    }
}

