/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.revisionestimate;

import javax.servlet.http.HttpServletRequest;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.EstimateAppropriation;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.SearchRevisionEstimate;
import org.egov.works.revisionestimate.service.RevisionEstimateService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/revisionestimate"})
public class CancelRevisionEstimateController {
    private static final String REVISIONESTIMATE_SUCCESS = "revisionEstimate-success";
    @Autowired
    private RevisionEstimateService revisionEstimateService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String cancelRevisionEstimateSearchForm(@ModelAttribute SearchRevisionEstimate searchRevisionEstimate, Model model) {
        searchRevisionEstimate.setRevisionEstimateStatus(AbstractEstimate.EstimateStatus.APPROVED.toString());
        model.addAttribute("createdUsers", (Object)this.revisionEstimateService.getRevisionEstimateCreatedByUsers());
        model.addAttribute("searchRevisionEstimate", (Object)searchRevisionEstimate);
        return "revisionestimate-cancel";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelLetterOfAcceptance(HttpServletRequest request, Model model) {
        Long revisionEstimateId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        RevisionAbstractEstimate revisionEstimate = this.revisionEstimateService.getRevisionEstimateById(revisionEstimateId);
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getParent().getId());
        String revisionEstimates = this.revisionEstimateService.getRevisionEstimatesGreaterThanCurrent(revisionEstimate.getParent().getId(), revisionEstimate.getCreatedDate());
        if (!"".equals(revisionEstimates)) {
            this.messageSource.getMessage("error.reexists.greaterthancreateddate", (Object[])new String[]{revisionEstimates}, null);
            return REVISIONESTIMATE_SUCCESS;
        }
        String mbRefNumbers = this.revisionEstimateService.checkIfMBCreatedForRENonTenderedLumpSum(revisionEstimate, workOrderEstimate);
        if (!"".equals(mbRefNumbers)) {
            model.addAttribute("message", (Object)this.messageSource.getMessage("error.re.mb.created", (Object[])new String[]{mbRefNumbers}, null));
            return REVISIONESTIMATE_SUCCESS;
        }
        String message = this.revisionEstimateService.checkIfMBCreatedForREChangedQuantity(revisionEstimate, workOrderEstimate);
        if (!"".equals(message)) {
            return REVISIONESTIMATE_SUCCESS;
        }
        revisionEstimate.setCancellationReason(cancellationReason);
        revisionEstimate.setCancellationRemarks(cancellationRemarks);
        revisionEstimate = this.revisionEstimateService.cancelRevisionEstimate(revisionEstimate);
        EstimateAppropriation estimateAppropriation = this.estimateAppropriationService.findLatestByAbstractEstimate(revisionEstimate.getId());
        message = this.messageSource.getMessage("msg.revisionestimate.cancelled", (Object[])new String[]{revisionEstimate.getEstimateNumber(), estimateAppropriation.getBudgetUsage().getAppropriationnumber()}, null);
        model.addAttribute("revisionEstimate", (Object)revisionEstimate);
        model.addAttribute("message", (Object)message);
        return REVISIONESTIMATE_SUCCESS;
    }
}

