/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import java.util.Collections;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.FinancialYearService;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.services.masters.SchemeService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.entity.enums.Beneficiary;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.egov.works.masters.service.NatureOfWorkService;
import org.egov.works.reports.entity.EstimateAbstractReport;
import org.egov.works.reports.entity.enums.WorkStatus;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/reports/estimateabstractreport"})
public class EstimateAbstractReportController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private FinancialYearService financialYearService;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private TypeOfWorkService typeOfWorkService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private WorksUtils worksUtils;

    @RequestMapping(value={"/departmentwise-searchform"}, method={RequestMethod.GET})
    public String departmentWiseShowSearchForm(@ModelAttribute EstimateAbstractReport estimateAbstractReport, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        CFinancialYear currentFinancialYear = this.financialYearService.getCurrentFinancialYear();
        estimateAbstractReport.setFinancialYear(currentFinancialYear.getId());
        estimateAbstractReport.setCurrentFinancialYearId(currentFinancialYear.getId());
        model.addAttribute("estimateAbstractReport", (Object)estimateAbstractReport);
        estimateAbstractReport.setDepartment(this.worksUtils.getDefaultDepartmentId());
        return "estimateAbstractReportByDepartmentWise-search";
    }

    @RequestMapping(value={"/typeofworkwise-searchform"}, method={RequestMethod.GET})
    public String typeOfWorkWiseShowSearchForm(@ModelAttribute EstimateAbstractReport estimateAbstractReport, Model model) throws ApplicationException {
        Department approverDepartment;
        this.setDropDownValues(model);
        CFinancialYear currentFinancialYear = this.financialYearService.getCurrentFinancialYear();
        estimateAbstractReport.setFinancialYear(currentFinancialYear.getId());
        estimateAbstractReport.setCurrentFinancialYearId(currentFinancialYear.getId());
        model.addAttribute("estimateAbstractReport", (Object)estimateAbstractReport);
        String defaultApproverDept = this.worksApplicationProperties.getDefaultApproverDepartment();
        if (defaultApproverDept != null && (approverDepartment = this.departmentService.getDepartmentByName(defaultApproverDept)) != null) {
            estimateAbstractReport.getDepartments().add(approverDepartment);
        }
        return "estimateAbstractReportByTypeOfWorkWise-search";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("financialyears", (Object)this.financialYearService.getAll());
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("schemes", (Object)this.schemeService.findAll());
        model.addAttribute("subSchemes", Collections.emptyList());
        model.addAttribute("natureOfWork", (Object)this.natureOfWorkService.findAll());
        model.addAttribute("beneficiary", (Object)Beneficiary.values());
        model.addAttribute("typeOfWork", (Object)this.typeOfWorkService.getTypeOfWorkByPartyType("Contractor"));
        model.addAttribute("workStatus", (Object)WorkStatus.values());
        model.addAttribute("workCategory", (Object)WorkCategory.values());
    }
}

