/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.works.masters.entity.Contractor;
import org.egov.works.reports.entity.ContractorWiseAbstractReport;
import org.egov.works.reports.entity.ContractorWiseAbstractSearchResult;
import org.egov.works.reports.service.WorkProgressRegisterService;
import org.egov.works.web.adaptor.ContractorWiseAbstractJsonAdaptor;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class AjaxContractorWiseAbstractReportController {
    @Autowired
    private WorkProgressRegisterService workProgressRegisterService;
    @Autowired
    private ContractorWiseAbstractJsonAdaptor contractorWiseAbstractJsonAdaptor;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;

    @RequestMapping(value={"/ajax-contractorwiseabstractreport"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showSearchWorkProgressRegister(Model model, @ModelAttribute ContractorWiseAbstractReport contractorWiseAbstractReport) {
        List resultList = this.workProgressRegisterService.searchContractorWiseAbstractReport(contractorWiseAbstractReport);
        String result = "{ \"data\":" + this.searchResultToJson((Object)resultList) + "}";
        return result;
    }

    public Object searchResultToJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ContractorWiseAbstractSearchResult.class, (Object)this.contractorWiseAbstractJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajax-searchcontractors"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Contractor> searchContractors(@RequestParam String code) {
        return this.workOrderEstimateService.findContractorsByWorkOrderStatus(code);
    }
}

