/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.offlinestatus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.workorder.entity.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/offlinestatus"})
public class SetOfflineStatusController {
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;

    @RequestMapping(value={"/setstatus-loa/{workOrderId}"}, method={RequestMethod.GET})
    public String setOffLineStatus(Model model, @PathVariable Long workOrderId, HttpServletRequest request) throws ApplicationException {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(workOrderId);
        List offlineStatuses = this.offlineStatusService.getOfflineStatusByObjectIdAndType(workOrder.getId(), "WorkOrder");
        int offlineStatusSize = offlineStatuses.size();
        workOrder.setOfflineStatuses(offlineStatuses);
        this.setDropDownValues(model);
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("mode", (Object)"newWorkOrder");
        model.addAttribute("offlineStatusSize", (Object)offlineStatusSize);
        return "setstatus-form";
    }

    private void setDropDownValues(Model model) {
        ArrayList<String> offlineStatuses = new ArrayList<String>();
        ArrayList<String> offlineStatusesForAE = new ArrayList<String>();
        for (WorkOrder.OfflineStatuses offlineStatuses2 : WorkOrder.OfflineStatuses.values()) {
            offlineStatuses.add(offlineStatuses2.toString().toUpperCase());
        }
        for (WorkOrder.OfflineStatuses offlineStatuses3 : AbstractEstimate.OfflineStatusesForAbstractEstimate.values()) {
            offlineStatusesForAE.add(offlineStatuses3.toString().toUpperCase());
        }
        List egwStatuses = this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList("WorkOrder", offlineStatuses);
        List abstractEstimateStatusses = this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList("AbstractEstimate", offlineStatusesForAE);
        model.addAttribute("egwStatus", (Object)egwStatuses);
        model.addAttribute("abstractEstimateStatusses", (Object)abstractEstimateStatusses);
    }

    @RequestMapping(value={"/offlinestatus-save"}, method={RequestMethod.POST})
    public String saveOffLineStatus(@ModelAttribute WorkOrder workOrder, Model model, HttpServletRequest request, BindingResult resultBinder) throws ApplicationException {
        int i = 0;
        WorkOrder.OfflineStatuses[] statList = WorkOrder.OfflineStatuses.values();
        String[] statusName = new String[statList.length];
        for (int j = 0; j < statList.length; ++j) {
            statusName[j] = statList[j].name();
        }
        List<String> OffStatuses = Arrays.asList(statusName);
        List selectedStatus = workOrder.getOfflineStatuses();
        String[] selectedStatusArr = new String[selectedStatus.size()];
        for (int j = 0; j < selectedStatus.size(); ++j) {
            if (((OfflineStatus)selectedStatus.get(j)).getEgwStatus() == null) continue;
            EgwStatus egwStatus = this.egwStatusHibernateDAO.findById(((OfflineStatus)selectedStatus.get(j)).getEgwStatus().getId(), false);
            selectedStatusArr[j] = egwStatus.getCode();
        }
        for (String statName : this.offlineStatusService.getStatusNameDetails(selectedStatusArr)) {
            if (!OffStatuses.isEmpty() && !statName.equals(OffStatuses.get(i))) {
                resultBinder.reject("errors.status.order.incorrect", (Object[])new String[]{statName.replaceAll("_", " "), OffStatuses.get(OffStatuses.indexOf(statName) - 1).replaceAll("_", " ")}, "errors.status.order.incorrect");
                break;
            }
            ++i;
        }
        List newOfflinestatus = workOrder.getOfflineStatuses();
        for (int k = 0; k < newOfflinestatus.size() - 1; ++k) {
            if (!((OfflineStatus)newOfflinestatus.get(k)).getStatusDate().after(((OfflineStatus)newOfflinestatus.get(k + 1)).getStatusDate())) continue;
            EgwStatus egwStatus = this.egwStatusHibernateDAO.findById(((OfflineStatus)selectedStatus.get(k + 1)).getEgwStatus().getId(), false);
            EgwStatus newEgwStatus = this.egwStatusHibernateDAO.findById(((OfflineStatus)selectedStatus.get(k)).getEgwStatus().getId(), false);
            resultBinder.reject("errors.status.date.incorrect", (Object[])new String[]{egwStatus.getDescription(), newEgwStatus.getDescription()}, "errors.status.date.incorrect");
            break;
        }
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("workOrder", (Object)workOrder);
            return "setstatus-form";
        }
        List offlineStatuses = workOrder.getOfflineStatuses();
        this.offlineStatusService.create(offlineStatuses, workOrder.getId(), "WorkOrder");
        model.addAttribute("success", (Object)this.messageSource.getMessage("msg.offlinestatus.loasuccess", (Object[])new String[]{workOrder.getWorkOrderNumber()}, null));
        return "setstatus-success";
    }

    @RequestMapping(value={"/setstatus-abstractestimate/{abstractEstimateId}"}, method={RequestMethod.GET})
    public String setOffLineStatusForAbstractEstimate(Model model, @PathVariable Long abstractEstimateId, HttpServletRequest request) throws ApplicationException {
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateById(abstractEstimateId);
        List offlineStatuses = this.offlineStatusService.getOfflineStatusByObjectIdAndType(abstractEstimate.getId(), "AbstractEstimate");
        int offlineStatusSize = offlineStatuses.size();
        abstractEstimate.setOfflineStatuses(offlineStatuses);
        this.setDropDownValues(model);
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("offlineStatusSize", (Object)offlineStatusSize);
        model.addAttribute("lineEstimateRequired", (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "setabstractestimatestatus-form";
    }

    @RequestMapping(value={"/offlinestatus-saveabstractestimate"}, method={RequestMethod.POST})
    public String saveOffLineStatusForAbstractEstimate(@ModelAttribute AbstractEstimate abstractEstimate, Model model, HttpServletRequest request, BindingResult resultBinder) throws ApplicationException {
        int i = 0;
        AbstractEstimate.OfflineStatusesForAbstractEstimate[] statList = AbstractEstimate.OfflineStatusesForAbstractEstimate.values();
        String[] statusName = new String[statList.length];
        for (int j = 0; j < statList.length; ++j) {
            statusName[j] = statList[j].name();
        }
        List<String> OffStatuses = Arrays.asList(statusName);
        List selectedStatus = abstractEstimate.getOfflineStatuses();
        String[] selectedStatusArr = new String[selectedStatus.size()];
        for (int j = 0; j < selectedStatus.size(); ++j) {
            if (((OfflineStatus)selectedStatus.get(j)).getEgwStatus() == null) continue;
            EgwStatus egwStatus = this.egwStatusHibernateDAO.findById(((OfflineStatus)selectedStatus.get(j)).getEgwStatus().getId(), false);
            selectedStatusArr[j] = egwStatus.getCode();
        }
        for (String statName : this.offlineStatusService.getStatusNameDetails(selectedStatusArr)) {
            if (!OffStatuses.isEmpty() && !statName.equals(OffStatuses.get(i))) {
                resultBinder.reject("errors.status.order.incorrect", (Object[])new String[]{statName.replaceAll("_", " "), OffStatuses.get(OffStatuses.indexOf(statName.replaceAll(" ", "_")) - 1).replaceAll("_", " ")}, "errors.status.order.incorrect");
                break;
            }
            ++i;
        }
        List newOfflinestatus = abstractEstimate.getOfflineStatuses();
        for (int k = 0; k < newOfflinestatus.size() - 1; ++k) {
            if (!((OfflineStatus)newOfflinestatus.get(k)).getStatusDate().after(((OfflineStatus)newOfflinestatus.get(k + 1)).getStatusDate())) continue;
            EgwStatus egwStatus = this.egwStatusHibernateDAO.findById(((OfflineStatus)selectedStatus.get(k + 1)).getEgwStatus().getId(), false);
            EgwStatus newEgwStatus = this.egwStatusHibernateDAO.findById(((OfflineStatus)selectedStatus.get(k)).getEgwStatus().getId(), false);
            resultBinder.reject("errors.status.date.incorrect", (Object[])new String[]{egwStatus.getDescription(), newEgwStatus.getDescription()}, "errors.status.date.incorrect");
            break;
        }
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("abstractEstimate", (Object)abstractEstimate);
            return "setabstractestimatestatus-form";
        }
        List offlineStatuses = abstractEstimate.getOfflineStatuses();
        this.offlineStatusService.create(offlineStatuses, abstractEstimate.getId(), "AbstractEstimate");
        model.addAttribute("success", (Object)this.messageSource.getMessage("msg.offlinestatus.aesuccess", (Object[])new String[]{abstractEstimate.getEstimateNumber()}, null));
        return "setstatus-aesuccess";
    }
}

