/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.milestone;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.masters.entity.MilestoneTemplate;
import org.egov.works.masters.entity.MilestoneTemplateActivity;
import org.egov.works.masters.service.MilestoneTemplateActivityService;
import org.egov.works.masters.service.MilestoneTemplateService;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.MilestoneService;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/milestone"})
public class ViewMilestoneController {
    @Autowired
    private MilestoneTemplateService milestoneTemplateService;
    @Autowired
    private MilestoneTemplateActivityService milestoneTemplateActivityService;
    @Autowired
    private TrackMilestoneService trackMilestoneService;
    @Autowired
    private MilestoneService milestoneService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;

    @RequestMapping(value={"/viewmilestonetemplate/{id}"}, method={RequestMethod.GET})
    public String viewMilestoneTemplate(@PathVariable String id, Model model, HttpServletRequest request) throws ApplicationException {
        MilestoneTemplate milestoneTemplate = this.milestoneTemplateService.getMilestoneTemplateById(Long.valueOf(Long.parseLong(id)));
        model.addAttribute("milestoneTemplate", (Object)milestoneTemplate);
        model.addAttribute("mode", (Object)"view");
        return "milestoneTemplate-view";
    }

    @RequestMapping(value={"/setmilestonetemplateactivities/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MilestoneTemplateActivity> populateMilestoneTemplateActivity(@PathVariable String id, Model model, HttpServletRequest request) throws ApplicationException {
        List milestoneTemplateActivities = this.milestoneTemplateActivityService.getMilestoneTemplateActivityByMilestoneTemplate(Long.valueOf(Long.parseLong(id)));
        return milestoneTemplateActivities;
    }

    @RequestMapping(value={"/viewmilestone/{id}"}, method={RequestMethod.GET})
    public String viewMilestone(@PathVariable String id, Model model, HttpServletRequest request) throws ApplicationException {
        Milestone milestone = this.milestoneService.getMilestoneById(Long.valueOf(Long.parseLong(id)));
        model.addAttribute("milestone", (Object)milestone);
        model.addAttribute("lineEstimateRequired", (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "milestone-view";
    }

    @RequestMapping(value={"/viewtrackmilestone/{id}"}, method={RequestMethod.GET})
    public String viewTrackMilestone(@PathVariable String id, Model model, HttpServletRequest request) throws ApplicationException {
        TrackMilestone trackMilestone = this.trackMilestoneService.getTrackMilestoneByMilestoneId(Long.valueOf(Long.parseLong(id)));
        model.addAttribute("trackMilestone", (Object)trackMilestone);
        model.addAttribute("lineEstimateRequired", (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "trackmilestone-view";
    }
}

