/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.milestone;

import java.util.List;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.masters.entity.MilestoneTemplate;
import org.egov.works.milestone.entity.SearchRequestMilestone;
import org.egov.works.milestone.entity.enums.MilestoneActivityStatus;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/milestone"})
public class SearchMilestoneController {
    private static final String LINEESTIMATEREQUIRED = "lineEstimateRequired";
    private static final String SEARCHREQUESTMILESTONE = "searchRequestMilestone";
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private TypeOfWorkService typeOfWorkService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;

    @RequestMapping(value={"/search-form"}, method={RequestMethod.GET})
    public String showSearchMilestoneForm(@ModelAttribute SearchRequestMilestone searchRequestMilestone, Model model) throws ApplicationException {
        this.setDropDownValuesToTrackMilestone(model);
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestMilestone.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute("currentStatus", (Object)MilestoneActivityStatus.values());
        model.addAttribute(SEARCHREQUESTMILESTONE, (Object)searchRequestMilestone);
        model.addAttribute(LINEESTIMATEREQUIRED, (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "searchmilestone-form";
    }

    private void setDropDownValuesToTrackMilestone(Model model) {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("typeOfWork", (Object)this.typeOfWorkService.getActiveTypeOfWorksByPartyType("Contractor"));
    }

    @RequestMapping(value={"/searchmilestonetemplate"}, method={RequestMethod.GET})
    public String showSearchMilestoneTemplate(@ModelAttribute MilestoneTemplate milestoneTemplate, Model model) throws ApplicationException {
        model.addAttribute("typeOfWork", (Object)this.typeOfWorkService.getActiveTypeOfWorksByPartyType("Contractor"));
        return "milestoneTemplate-search";
    }

    @RequestMapping(value={"/searchtoview-form"}, method={RequestMethod.GET})
    public String searchMilestoneForm(@ModelAttribute SearchRequestMilestone searchRequestMilestone, Model model) throws ApplicationException {
        this.setDropDownValuesToSearchMilestone(model);
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestMilestone.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute(SEARCHREQUESTMILESTONE, (Object)searchRequestMilestone);
        model.addAttribute("egwStatus", (Object)this.egwStatusDAO.getStatusByModule("Milestone"));
        model.addAttribute(LINEESTIMATEREQUIRED, (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "viewMilestone-form";
    }

    @RequestMapping(value={"/searchtracked-form"}, method={RequestMethod.GET})
    public String searchTrackedMilestoneForm(@ModelAttribute SearchRequestMilestone searchRequestMilestone, Model model) throws ApplicationException {
        this.setDropDownValuesToSearchMilestone(model);
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestMilestone.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute(SEARCHREQUESTMILESTONE, (Object)searchRequestMilestone);
        model.addAttribute("egwStatus", (Object)this.egwStatusDAO.getStatusByModule("Milestone"));
        model.addAttribute(LINEESTIMATEREQUIRED, (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "searchTrackMilestone-form";
    }

    private void setDropDownValuesToSearchMilestone(Model model) {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("typeOfWork", (Object)this.typeOfWorkService.getTypeOfWorkByPartyType("Contractor"));
    }
}

