/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.mb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.service.CustomizedWorkFlowService;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/workorder/searchform"})
public class SearchWorkOrderForMBHeaderController
extends GenericWorkFlowController {
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected CustomizedWorkFlowService customizedWorkFlowService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private CityService cityService;

    @RequestMapping(method={RequestMethod.GET})
    public String showSearchWorkOrder(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, Model model) {
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestLetterOfAcceptance.setDepartmentName(((Department)departments.get(0)).getId());
        }
        searchRequestLetterOfAcceptance.setEgwStatus("Work commenced".toUpperCase());
        model.addAttribute("departments", (Object)this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser()));
        model.addAttribute("searchRequestLetterOfAcceptance", (Object)searchRequestLetterOfAcceptance);
        MBHeader mbHeader = new MBHeader();
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAmountRule(mbHeader.getMbAmount() != null ? mbHeader.getMbAmount() : BigDecimal.ZERO);
        workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
        this.prepareWorkflow(model, (StateAware)mbHeader, workflowContainer);
        ArrayList<String> validActions = new ArrayList<String>();
        validActions.add("Create And Approve");
        validActions.add("Save");
        validActions.add(WorksConstants.FORWARD_ACTION.toString());
        validActions.add("ContractorMeasurements");
        model.addAttribute("stateType", (Object)mbHeader.getClass().getSimpleName());
        if (mbHeader.getState() != null && mbHeader.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)mbHeader.getState().getNextAction());
            model.addAttribute("pendingActions", (Object)mbHeader.getState().getNextAction());
        }
        model.addAttribute("validActionList", validActions);
        model.addAttribute("currentDate", (Object)new Date());
        model.addAttribute("mbHeader", (Object)mbHeader);
        model.addAttribute("documentDetails", (Object)mbHeader.getDocumentDetails());
        model.addAttribute("defaultDepartmentId", (Object)this.worksUtils.getDefaultDepartmentId());
        model.addAttribute("amountRule", (Object)mbHeader.getMbAmount());
        model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
        return "workorder-search";
    }
}

