/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.mb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.web.adaptor.MeasurementBookJsonAdaptor;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/measurementbook"})
public class CreateMBController {
    public static final String MB_SUCCESS_MESSAGE = "message";
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private MeasurementBookJsonAdaptor measurementBookJsonAdaptor;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private WorksUtils worksUtils;

    public WorkOrderEstimate getWorkOrderEstimate(Long workOrderEstimateId) {
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(workOrderEstimateId);
        return workOrderEstimate;
    }

    @RequestMapping(value={"/create/{workOrderEstimateId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String createMeasurementBook(@PathVariable Long workOrderEstimateId, HttpServletRequest request, HttpServletResponse response) {
        WorkOrderEstimate workOrderEstimate = this.getWorkOrderEstimate(workOrderEstimateId);
        String result = "" + this.toSearchMilestoneTemplateJson((Object)workOrderEstimate);
        return result;
    }

    public Object toSearchMilestoneTemplateJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderEstimate.class, (Object)this.measurementBookJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String create(@ModelAttribute(value="mbHeader") MBHeader mbHeader, Model model, BindingResult errors, HttpServletRequest request, BindingResult resultBinder, HttpServletResponse response, @RequestParam(value="file") MultipartFile[] files) throws ApplicationException, IOException {
        Long approvalPosition = 0L;
        String approvalComment = "";
        String workFlowAction = "";
        String additionalRule = "";
        String mode = "";
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        mbHeader.setWorkOrder(this.letterOfAcceptanceService.getWorkOrderById(mbHeader.getWorkOrder().getId()));
        mbHeader.setWorkOrderEstimate(this.workOrderEstimateService.getWorkOrderEstimateById(mbHeader.getWorkOrderEstimate().getId()));
        JsonObject jsonObject = new JsonObject();
        this.mbHeaderService.validateMBInDrafts(mbHeader.getWorkOrderEstimate().getId(), jsonObject, errors);
        this.mbHeaderService.validateMBInWorkFlow(mbHeader.getWorkOrderEstimate().getId(), jsonObject, errors);
        this.mbHeaderService.validateMBHeader(mbHeader, jsonObject, resultBinder, mode);
        this.mbHeaderService.validateWorkflowActionButton(mbHeader, jsonObject, errors, additionalRule, workFlowAction);
        this.workOrderEstimateService.getContratorBillForWorkOrderEstimateAndBillType(mbHeader.getWorkOrderEstimate().getId(), jsonObject);
        if (StringUtils.isBlank((CharSequence)workFlowAction)) {
            this.validateMBDateToSkipWorkflow(mbHeader, jsonObject, errors);
        }
        if (jsonObject.toString().length() > 2) {
            this.sendAJAXResponse(jsonObject.toString(), response);
            return "";
        }
        MBHeader savedMBHeader = this.mbHeaderService.create(mbHeader, files, approvalPosition, approvalComment, workFlowAction, additionalRule);
        this.mbHeaderService.fillWorkflowData(jsonObject, request, savedMBHeader);
        if (workFlowAction.equalsIgnoreCase("Save")) {
            jsonObject.addProperty(MB_SUCCESS_MESSAGE, this.messageSource.getMessage("msg.mbheader.saved", (Object[])new String[]{mbHeader.getMbRefNo()}, null));
        } else {
            String pathVars = this.worksUtils.getPathVars(mbHeader.getEgwStatus(), mbHeader.getState(), mbHeader.getId(), approvalPosition);
            String[] keyNameArray = pathVars.split(",");
            String approverName = "";
            String nextDesign = "";
            if (keyNameArray.length != 0 && keyNameArray.length > 0) {
                if (keyNameArray.length == 3) {
                    approverName = keyNameArray[1];
                } else {
                    approverName = keyNameArray[1];
                    nextDesign = keyNameArray[3];
                }
            }
            if (StringUtils.isBlank((CharSequence)workFlowAction)) {
                jsonObject.addProperty(MB_SUCCESS_MESSAGE, this.messageSource.getMessage("msg.mbheader.createdandapprove", (Object[])new String[]{mbHeader.getMbRefNo()}, null));
            } else if ("Create And Approve".equalsIgnoreCase(workFlowAction)) {
                jsonObject.addProperty(MB_SUCCESS_MESSAGE, this.messageSource.getMessage("msg.mbheader.approved", (Object[])new String[]{mbHeader.getMbRefNo()}, null));
            } else {
                jsonObject.addProperty(MB_SUCCESS_MESSAGE, this.messageSource.getMessage("msg.mbheader.created", (Object[])new String[]{approverName, nextDesign, mbHeader.getMbRefNo()}, null));
            }
        }
        return jsonObject.toString();
    }

    protected void sendAJAXResponse(String msg, HttpServletResponse response) {
        try {
            PrintWriter httpResponseWriter = response.getWriter();
            IOUtils.write((String)msg, (Writer)httpResponseWriter);
            IOUtils.closeQuietly((Writer)httpResponseWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/mb-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute MBHeader mbHeader, @RequestParam(value="mbHeader") Long id, @RequestParam(value="approvalPosition") Long approvalPosition, HttpServletRequest request, Model model) {
        if (id != null) {
            mbHeader = this.mbHeaderService.getMBHeaderById(id);
        }
        String pathVars = this.worksUtils.getPathVars(mbHeader.getEgwStatus(), mbHeader.getState(), mbHeader.getId(), approvalPosition);
        String[] keyNameArray = pathVars.split(",");
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1 && keyNameArray[0] != null) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(mbHeader, approverName, nextDesign);
        model.addAttribute(MB_SUCCESS_MESSAGE, (Object)message);
        return new ModelAndView("mb-success", "mbHeader", (Object)mbHeader);
    }

    private String getMessageByStatus(MBHeader mbHeader, String approverName, String nextDesign) {
        String message = "";
        if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString())) {
            message = this.messageSource.getMessage("msg.mbheader.saved", (Object[])new String[]{mbHeader.getMbRefNo()}, null);
        } else if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.CREATED.toString()) && !mbHeader.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.mbheader.created", (Object[])new String[]{approverName, nextDesign, mbHeader.getMbRefNo()}, null);
        } else if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.RESUBMITTED.toString()) && !mbHeader.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.mbheader.resubmitted", (Object[])new String[]{approverName, nextDesign, mbHeader.getMbRefNo()}, null);
        } else if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.APPROVED.toString())) {
            message = this.messageSource.getMessage("msg.mbheader.approved", (Object[])new String[]{mbHeader.getMbRefNo()}, null);
        } else if (mbHeader.getState() != null && mbHeader.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.mbheader.rejected", (Object[])new String[]{mbHeader.getMbRefNo(), approverName, nextDesign}, null);
        } else if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.CANCELLED.toString())) {
            message = this.messageSource.getMessage("msg.mbheader.cancelled", (Object[])new String[]{mbHeader.getMbRefNo()}, null);
        } else if (MBHeader.MeasurementBookStatus.CHECKED.toString().equalsIgnoreCase(mbHeader.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.mbheader.checked", (Object[])new String[]{approverName, nextDesign, mbHeader.getMbRefNo()}, null);
        }
        return message;
    }

    private void validateMBDateToSkipWorkflow(MBHeader mBHeader, JsonObject jsonObject, BindingResult errors) {
        Date cutOffDate = this.worksUtils.getCutOffDate();
        SimpleDateFormat fmt = new SimpleDateFormat("dd-MM-yyyy");
        if (cutOffDate != null && mBHeader.getMbDate().after(cutOffDate)) {
            String message = this.messageSource.getMessage("error.mbdate.cutoffdate", (Object[])new String[]{fmt.format(cutOffDate)}, null);
            jsonObject.addProperty("cutoffdateerror", message);
            if (errors != null) {
                errors.reject("cutoffdateerror", message);
            }
        }
    }
}

