/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.EgPartytype;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.dao.EgPartytypeHibernateDAO;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.infra.exception.ApplicationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class UpdateTypeOfWorkController {
    @Autowired
    private TypeOfWorkService typeOfWorkService;
    @Autowired
    private EgPartytypeHibernateDAO egPartytypeHibernateDAO;

    @RequestMapping(value={"/typeofwork-update/{typeOfWorkId}"}, method={RequestMethod.GET})
    public String showTypeOfWorkFormToModify(Model model, @PathVariable Long typeOfWorkId) throws ApplicationException {
        EgwTypeOfWork typeOfWork = this.typeOfWorkService.getTypeOfWorkById(typeOfWorkId);
        model.addAttribute("egwTypeOfWork", (Object)typeOfWork);
        model.addAttribute("mode", (Object)"edit");
        return "typeofwork-modify";
    }

    @RequestMapping(value={"/subtypeofwork-update/{subTypeOfWorkId}"}, method={RequestMethod.GET})
    public String showSubTypeOfWorkFormToModify(Model model, @PathVariable Long subTypeOfWorkId) throws ApplicationException {
        EgwTypeOfWork typeOfWork = this.typeOfWorkService.getTypeOfWorkById(subTypeOfWorkId);
        model.addAttribute("typeOfWork", (Object)typeOfWork.getParentid());
        model.addAttribute("egwTypeOfWork", (Object)typeOfWork);
        model.addAttribute("mode", (Object)"edit");
        return "subtypeofwork-modify";
    }

    @RequestMapping(value={"/modifytypeofwork"}, method={RequestMethod.POST})
    public String modifyTypeOfWork(@ModelAttribute EgwTypeOfWork egwTypeOfWork, BindingResult resultBinder, Model model, HttpServletRequest request) throws ApplicationException {
        String mode = request.getParameter("mode");
        if (mode.equalsIgnoreCase("edit") && egwTypeOfWork.getId() != null) {
            model.addAttribute("mode", (Object)mode);
        }
        this.validateTypeOfWork(egwTypeOfWork, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("typeofwork", (Object)egwTypeOfWork);
            return "typeofwork-modify";
        }
        EgPartytype egPartytype = this.egPartytypeHibernateDAO.getPartytypeByCode("Contractor");
        egwTypeOfWork.setEgPartytype(egPartytype);
        this.typeOfWorkService.update(egwTypeOfWork);
        return "redirect:/masters/typeofwork-success?typeOfWorkId=" + egwTypeOfWork.getId();
    }

    @RequestMapping(value={"/modifysubtypeofwork"}, method={RequestMethod.POST})
    public String modifySubTypeOfWork(@ModelAttribute EgwTypeOfWork egwTypeOfWork, BindingResult resultBinder, Model model, HttpServletRequest request) throws ApplicationException, IOException {
        String mode = request.getParameter("mode");
        if (mode.equalsIgnoreCase("edit") && egwTypeOfWork.getId() != null) {
            model.addAttribute("mode", (Object)mode);
        }
        this.validateSubTypeOfWork(egwTypeOfWork, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("typeofwork", (Object)this.typeOfWorkService.getTypeOfWorkByPartyType("Contractor"));
            model.addAttribute("subtypeofwork", (Object)egwTypeOfWork);
            return "subtypeofwork-modify";
        }
        EgPartytype egPartytype = this.egPartytypeHibernateDAO.getPartytypeByCode("Contractor");
        egwTypeOfWork.setEgPartytype(egPartytype);
        this.typeOfWorkService.update(egwTypeOfWork);
        return "redirect:/masters/subtypeofwork-success?subTypeOfWorkId=" + egwTypeOfWork.getId();
    }

    private void validateTypeOfWork(EgwTypeOfWork typeOfWork, BindingResult resultBinder) {
        EgwTypeOfWork existingTypeOfWork = this.typeOfWorkService.getTypeOfWorkByCode(typeOfWork.getCode());
        this.checkExistingTypeOfWork(typeOfWork, resultBinder, existingTypeOfWork);
        if (typeOfWork.getCode() == null) {
            resultBinder.reject("error.typeofwork.code", "error.typeofwork.code");
        }
        if (typeOfWork.getName() == null) {
            resultBinder.reject("error.typeofwork.name", "error.typeofwork.name");
        }
        if (typeOfWork.getCode() != null && !typeOfWork.getCode().matches("[a-zA-Z0-9/-]+")) {
            resultBinder.reject("error.typeofwork.code.invalid", "error.typeofwork.code.invalid");
        }
        if (typeOfWork.getName() != null && !typeOfWork.getName().matches("[0-9a-zA-Z-& :,/.()@]+")) {
            resultBinder.reject("error.name.invalid", "error.name.invalid");
        }
        if (typeOfWork.getDescription() != null && !typeOfWork.getDescription().matches("[0-9a-zA-Z-& :,/.()@]+")) {
            resultBinder.reject("error.typeofwork.description.invalid", "error.typeofwork.description.invalid");
        }
    }

    private void validateSubTypeOfWork(EgwTypeOfWork subTypeOfWork, BindingResult resultBinder) {
        this.validateTypeOfWork(subTypeOfWork, resultBinder);
        if (subTypeOfWork.getParentid() == null) {
            resultBinder.reject("error.typeofwork.select", "error.typeofwork.select");
        }
    }

    private void checkExistingTypeOfWork(EgwTypeOfWork typeOfWork, BindingResult resultBinder, EgwTypeOfWork existingTypeOfWork) {
        if (existingTypeOfWork != null && !existingTypeOfWork.getId().equals(typeOfWork.getId())) {
            resultBinder.reject("error.typeofwork.exists", (Object[])new String[]{typeOfWork.getCode()}, "error.typeofwork.exists");
        }
    }
}

