/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import java.io.IOException;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.masters.entity.ScheduleCategory;
import org.egov.works.masters.service.ScheduleCategoryService;
import org.egov.works.web.controller.masters.BaseScheduleCategoryController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class UpdateScheduleCategoryController
extends BaseScheduleCategoryController {
    @Autowired
    private ScheduleCategoryService scheduleCategoryService;

    @RequestMapping(value={"/schedulecategory-update/{scheduleCategoryId}"}, method={RequestMethod.GET})
    public String showScheduleCategoryToModify(Model model, @PathVariable Long scheduleCategoryId) throws ApplicationException {
        ScheduleCategory scheduleCategory = this.scheduleCategoryService.getScheduleCategoryById(scheduleCategoryId);
        model.addAttribute("scheduleCategory", (Object)scheduleCategory);
        model.addAttribute("mode", (Object)"edit");
        return "scheduleCategory-modify";
    }

    @RequestMapping(value={"/schedulecategory-update"}, method={RequestMethod.POST})
    public String createScheduleCategory(@ModelAttribute ScheduleCategory scheduleCategory, BindingResult resultBinder, Model model) throws ApplicationException, IOException {
        this.validateScheduleOfRate(scheduleCategory, resultBinder);
        this.validateScheduleCategory(scheduleCategory, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("scheduleCategory", (Object)scheduleCategory);
            return "scheduleCategory-modify";
        }
        model.addAttribute("mode", (Object)"edit");
        this.scheduleCategoryService.save(scheduleCategory);
        return "redirect:/masters/schedulecategory-success?scheduleCategoryId=" + scheduleCategory.getId();
    }

    private void validateScheduleOfRate(ScheduleCategory scheduleCategory, BindingResult resultBinder) {
        ScheduleCategory existingCategory = this.scheduleCategoryService.findByCode(scheduleCategory.getCode());
        if (existingCategory != null && !existingCategory.getId().equals(scheduleCategory.getId())) {
            resultBinder.reject("error.schedulecategory.code.unique", "error.schedulecategory.code.unique");
        }
        if (!this.scheduleCategoryService.checkForSOR(scheduleCategory.getId())) {
            resultBinder.reject("error.schedulecategory.sor.check", "error.schedulecategory.sor.check");
        }
    }
}

