/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.masters.entity.Overhead;
import org.egov.works.masters.service.OverheadService;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class UpdateOverheadController {
    @Autowired
    private OverheadService overheadService;
    @Autowired
    private WorksService worksService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;

    @RequestMapping(value={"/overhead-update/{overheadId}"}, method={RequestMethod.GET})
    public String updateOverhead(Model model, @PathVariable String overheadId) throws ApplicationException {
        Overhead overhead = this.overheadService.getOverheadById(Long.valueOf(Long.parseLong(overheadId)));
        overhead.setTempOverheadRateValues(overhead.getOverheadRates());
        this.setDropDownValues(model);
        model.addAttribute("overhead", (Object)overhead);
        model.addAttribute("mode", (Object)"edit");
        return "overhead-form";
    }

    private void setDropDownValues(Model model) {
        if (this.worksService.getWorksConfigValue("OVERHEAD_PURPOSE") != null) {
            model.addAttribute("accounts", (Object)this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue("OVERHEAD_PURPOSE"))));
        }
    }
}

