/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import javax.servlet.http.HttpServletRequest;
import org.egov.commons.ContractorGrade;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.masters.service.ContractorGradeService;
import org.egov.works.web.controller.masters.BaseContractorClassController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class UpdateContractorClassController
extends BaseContractorClassController {
    @Autowired
    private ContractorGradeService contractorGradeService;

    @RequestMapping(value={"/contractorclass-edit/{contractorGradeId}"}, method={RequestMethod.GET})
    public String showContractorClassFormToModify(Model model, @PathVariable Long contractorGradeId) throws ApplicationException {
        ContractorGrade contractorGrade = this.contractorGradeService.getContractorGradeById(contractorGradeId);
        model.addAttribute("contractorGrade", (Object)contractorGrade);
        model.addAttribute("mode", (Object)"edit");
        return "contractorclass-modify";
    }

    @RequestMapping(value={"/contractorclass-edit"}, method={RequestMethod.POST})
    public String modifyContractorClass(@ModelAttribute ContractorGrade contractorGrade, BindingResult resultBinder, Model model, HttpServletRequest request) throws ApplicationException {
        String mode = request.getParameter("mode");
        this.validateContractorClass(contractorGrade, resultBinder, mode);
        if ("edit".equalsIgnoreCase(mode) && contractorGrade.getId() != null) {
            model.addAttribute("mode", (Object)mode);
        }
        if (resultBinder.hasErrors()) {
            model.addAttribute("contractorGrade", (Object)contractorGrade);
            return "contractorclass-modify";
        }
        this.contractorGradeService.update(contractorGrade);
        return "redirect:/masters/contractorclass-success?contractorClassId=" + contractorGrade.getId();
    }
}

