/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.commons.EgPartytype;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.dao.EgPartytypeHibernateDAO;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.infra.exception.ApplicationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class CreateTypeOfWorkController {
    @Autowired
    private TypeOfWorkService typeOfWorkService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private EgPartytypeHibernateDAO egPartytypeHibernateDAO;

    @RequestMapping(value={"/typeofwork-newform"}, method={RequestMethod.GET})
    public String showTypeOfWorkForm(Model model) {
        EgwTypeOfWork typeOfWork = new EgwTypeOfWork();
        model.addAttribute("egwTypeOfWork", (Object)typeOfWork);
        return "typeofwork-form";
    }

    @RequestMapping(value={"/typeofwork-save"}, method={RequestMethod.POST})
    public String createTypeOfWork(@Valid @ModelAttribute EgwTypeOfWork egwTypeOfWork, BindingResult resultBinder, Model model) throws ApplicationException, IOException {
        this.validateTypeOfWork(egwTypeOfWork, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("typeofwork", (Object)egwTypeOfWork);
            return "typeofwork-form";
        }
        EgPartytype egPartytype = this.egPartytypeHibernateDAO.getPartytypeByCode("Contractor");
        egwTypeOfWork.setEgPartytype(egPartytype);
        this.typeOfWorkService.create(egwTypeOfWork);
        return "redirect:/masters/typeofwork-success?typeOfWorkId=" + egwTypeOfWork.getId();
    }

    @RequestMapping(value={"/typeofwork-success"}, method={RequestMethod.GET})
    public String successView(Model model, HttpServletRequest request) {
        Long typeOfWorkId = Long.valueOf(request.getParameter("typeOfWorkId"));
        EgwTypeOfWork newTypeOfWork = this.typeOfWorkService.getTypeOfWorkById(typeOfWorkId);
        String mode = request.getParameter("mode");
        model.addAttribute("typeofwork", (Object)newTypeOfWork);
        if (mode != null && mode.equalsIgnoreCase("edit")) {
            model.addAttribute("mode", (Object)mode);
            model.addAttribute("modifySuccess", (Object)this.messageSource.getMessage("msg.typeofwork.modify.success", (Object[])new String[]{newTypeOfWork.getName()}, null));
        } else {
            model.addAttribute("createSuccess", (Object)this.messageSource.getMessage("msg.typeofwork.create.success", (Object[])new String[]{newTypeOfWork.getName()}, null));
        }
        return "typeofwork-success";
    }

    private void validateTypeOfWork(EgwTypeOfWork typeOfWork, BindingResult resultBinder) {
        EgwTypeOfWork existingTypeOfWork = this.typeOfWorkService.getTypeOfWorkByCode(typeOfWork.getCode());
        if (existingTypeOfWork != null && !existingTypeOfWork.getId().equals(typeOfWork.getId())) {
            resultBinder.reject("error.typeofwork.exists", (Object[])new String[]{typeOfWork.getCode()}, "error.typeofwork.exists");
        }
        if (typeOfWork.getCode() == null) {
            resultBinder.reject("error.typeofwork.code", "error.typeofwork.code");
        }
        if (typeOfWork.getName() == null) {
            resultBinder.reject("error.typeofwork.name", "error.typeofwork.name");
        }
        if (typeOfWork.getCode() != null && !typeOfWork.getCode().matches("[a-zA-Z0-9/-]+")) {
            resultBinder.reject("error.typeofwork.code.invalid", "error.typeofwork.code.invalid");
        }
        if (typeOfWork.getName() != null && !typeOfWork.getName().matches("[0-9a-zA-Z-& :,/.()@]+")) {
            resultBinder.reject("error.name.invalid", "error.name.invalid");
        }
        if (typeOfWork.getDescription() != null && !typeOfWork.getDescription().matches("[0-9a-zA-Z-& :,/.()@]+")) {
            resultBinder.reject("error.typeofwork.description.invalid", "error.typeofwork.description.invalid");
        }
    }

    @RequestMapping(value={"/subtypeofwork-newform"}, method={RequestMethod.GET})
    public String showSubTypeOfWorkForm(Model model) {
        EgwTypeOfWork subTypeOfWork = new EgwTypeOfWork();
        model.addAttribute("typeofwork", (Object)this.typeOfWorkService.getTypeOfWorkByPartyType("Contractor"));
        model.addAttribute("egwTypeOfWork", (Object)subTypeOfWork);
        return "subtypeofwork-form";
    }

    @RequestMapping(value={"/subtypeofwork-save"}, method={RequestMethod.POST})
    public String createSubTypeOfWork(@Valid @ModelAttribute EgwTypeOfWork egwTypeOfWork, BindingResult resultBinder, Model model) throws ApplicationException {
        this.validateSubTypeOfWork(egwTypeOfWork, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("typeofwork", (Object)this.typeOfWorkService.getTypeOfWorkByPartyType("Contractor"));
            model.addAttribute("subtypeofwork", (Object)egwTypeOfWork);
            return "subtypeofwork-form";
        }
        EgPartytype egPartytype = this.egPartytypeHibernateDAO.getPartytypeByCode("Contractor");
        egwTypeOfWork.setEgPartytype(egPartytype);
        this.typeOfWorkService.create(egwTypeOfWork);
        return "redirect:/masters/subtypeofwork-success?subTypeOfWorkId=" + egwTypeOfWork.getId();
    }

    @RequestMapping(value={"/subtypeofwork-success"}, method={RequestMethod.GET})
    public String subTypeOfWorkSuccessView(Model model, HttpServletRequest request) {
        Long subTypeOfWorkId = Long.valueOf(request.getParameter("subTypeOfWorkId"));
        EgwTypeOfWork newSubTypeOfWork = this.typeOfWorkService.getTypeOfWorkById(subTypeOfWorkId);
        String mode = request.getParameter("mode");
        model.addAttribute("subtypeofwork", (Object)newSubTypeOfWork);
        if (mode != null && mode.equalsIgnoreCase("edit")) {
            model.addAttribute("mode", (Object)mode);
            model.addAttribute("modifySuccess", (Object)this.messageSource.getMessage("msg.subtypeofwork.modify.success", (Object[])new String[]{newSubTypeOfWork.getName(), this.typeOfWorkService.getTypeOfWorkById(newSubTypeOfWork.getParentid().getId()).getName()}, null));
        } else {
            model.addAttribute("createSuccess", (Object)this.messageSource.getMessage("msg.subtypeofwork.create.success", (Object[])new String[]{newSubTypeOfWork.getName(), this.typeOfWorkService.getTypeOfWorkById(newSubTypeOfWork.getParentid().getId()).getName()}, null));
        }
        return "subtypeofwork-success";
    }

    private void validateSubTypeOfWork(EgwTypeOfWork subTypeOfWork, BindingResult resultBinder) {
        this.validateTypeOfWork(subTypeOfWork, resultBinder);
        if (subTypeOfWork.getParentid() == null) {
            resultBinder.reject("error.typeofwork.select", "error.typeofwork.select");
        }
    }
}

