/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.masters.entity.ScheduleCategory;
import org.egov.works.masters.service.ScheduleCategoryService;
import org.egov.works.web.controller.masters.BaseScheduleCategoryController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class CreateScheduleCategoryController
extends BaseScheduleCategoryController {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private ScheduleCategoryService scheduleCategoryService;

    @RequestMapping(value={"/schedulecategory-newform"}, method={RequestMethod.GET})
    public String showScheduleCategoryForm(Model model) {
        ScheduleCategory scheduleCategory = new ScheduleCategory();
        model.addAttribute("scheduleCategory", (Object)scheduleCategory);
        return "scheduleCategory-form";
    }

    @RequestMapping(value={"/schedulecategory-save"}, method={RequestMethod.POST})
    public String createScheduleCategory(@Valid @ModelAttribute ScheduleCategory scheduleCategory, BindingResult resultBinder, Model model) throws ApplicationException, IOException {
        this.validateScheduleCategory(scheduleCategory, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("scheduleCategory", (Object)scheduleCategory);
            return "scheduleCategory-form";
        }
        this.scheduleCategoryService.save(scheduleCategory);
        return "redirect:/masters/schedulecategory-success?scheduleCategoryId=" + scheduleCategory.getId();
    }

    @RequestMapping(value={"/schedulecategory-success"}, method={RequestMethod.GET})
    public String successView(Model model, HttpServletRequest request) {
        Long scheduleCategoryId = Long.valueOf(request.getParameter("scheduleCategoryId"));
        ScheduleCategory scheduleCategory = this.scheduleCategoryService.getScheduleCategoryById(scheduleCategoryId);
        String mode = request.getParameter("mode");
        model.addAttribute("scheduleCategory", (Object)scheduleCategory);
        if (mode != null && mode.equalsIgnoreCase("edit")) {
            model.addAttribute("mode", (Object)mode);
            model.addAttribute("modifySuccess", (Object)this.messageSource.getMessage("msg.schedulecategory.modify.success", null, null));
        } else {
            model.addAttribute("createSuccess", (Object)this.messageSource.getMessage("msg.schedulecategory.save.success", (Object[])new String[]{scheduleCategory.getCode()}, null));
        }
        return "scheduleCategory-success";
    }
}

