/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import javax.servlet.http.HttpServletRequest;
import org.egov.commons.ContractorGrade;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.masters.service.ContractorGradeService;
import org.egov.works.web.controller.masters.BaseContractorClassController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/masters"})
public class CreateContractorClassController
extends BaseContractorClassController {
    @Autowired
    private ContractorGradeService contractorGradeService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"/contractorclass-newform"}, method={RequestMethod.GET})
    public String showContractorClassForm(Model model) {
        ContractorGrade contractorGrade = new ContractorGrade();
        model.addAttribute("contractorGrade", (Object)contractorGrade);
        return "contractorclass-form";
    }

    @RequestMapping(value={"/contractorclass-save"}, method={RequestMethod.POST})
    public String createContractorClass(@ModelAttribute ContractorGrade contractorGrade, BindingResult resultBinder, Model model, HttpServletRequest request) throws ApplicationException {
        this.validateContractorClass(contractorGrade, resultBinder, request.getParameter("mode"));
        if (resultBinder.hasErrors()) {
            model.addAttribute("contractorGrade", (Object)contractorGrade);
            return "contractorclass-form";
        }
        this.contractorGradeService.save(contractorGrade);
        return "redirect:/masters/contractorclass-success?contractorClassId=" + contractorGrade.getId();
    }

    @RequestMapping(value={"/contractorclass-success"}, method={RequestMethod.GET})
    public String successView(Model model, HttpServletRequest request) {
        Long contractorGradeId = Long.valueOf(request.getParameter("contractorClassId"));
        ContractorGrade newContractorGrade = this.contractorGradeService.getContractorGradeById(contractorGradeId);
        String mode = request.getParameter("mode");
        model.addAttribute("contractorGrade", (Object)newContractorGrade);
        if (mode != null && mode.equalsIgnoreCase("edit")) {
            model.addAttribute("mode", (Object)mode);
            model.addAttribute("modifySuccess", (Object)this.messageSource.getMessage("msg.contractorclass.modify.success", (Object[])new String[]{newContractorGrade.getGrade()}, null));
        } else {
            model.addAttribute("createSuccess", (Object)this.messageSource.getMessage("msg.contractorclass.create.success", (Object[])new String[]{newContractorGrade.getGrade()}, null));
        }
        return "contractorclass-success";
    }
}

