/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.masters;

import org.egov.commons.ContractorGrade;
import org.egov.works.masters.service.ContractorGradeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;

@Controller
public abstract class BaseContractorClassController {
    protected static final String CONTRACTORGRADE = "contractorGrade";
    @Autowired
    private ContractorGradeService contractorGradeService;

    protected void validateContractorClass(ContractorGrade contractorGrade, BindingResult resultBinder, String mode) {
        this.checkExistingContractorClass(contractorGrade, resultBinder, mode);
        this.checkContractorClass(contractorGrade, resultBinder);
        if (contractorGrade.getDescription() == null) {
            resultBinder.reject("error.contractorclass.description", "error.contractorclass.description");
        }
        this.checkMinAmount(contractorGrade, resultBinder);
        this.checkMaxAmount(contractorGrade, resultBinder);
        if (contractorGrade.getMinAmount() != null && contractorGrade.getMaxAmount() != null && contractorGrade.getMinAmount().compareTo(contractorGrade.getMaxAmount()) == 1) {
            resultBinder.reject("error.contractorclass.maxamount.invalid", "error.contractorclass.maxamount.invalid");
        }
        if (!"edit".equalsIgnoreCase(mode)) {
            this.checkMinAndMaxAmountCombination(contractorGrade, resultBinder);
        }
    }

    private void checkMinAndMaxAmountCombination(ContractorGrade contractorGrade, BindingResult resultBinder) {
        if (this.contractorGradeService.getByMinAndMaxAmount(contractorGrade.getMinAmount(), contractorGrade.getMaxAmount()) != null) {
            resultBinder.reject("error.contractorclass.amount.exist", "error.contractorclass.amount.exist");
        }
    }

    private void checkMaxAmount(ContractorGrade contractorGrade, BindingResult resultBinder) {
        if (contractorGrade.getMinAmount() == null || contractorGrade.getMinAmount().signum() == -1) {
            resultBinder.reject("error.contractorclass.maxAmount.valid", "error.contractorclass.maxAmount.valid");
        }
    }

    private void checkMinAmount(ContractorGrade contractorGrade, BindingResult resultBinder) {
        if (contractorGrade.getMinAmount() == null || contractorGrade.getMinAmount().signum() == -1) {
            resultBinder.reject("error.contractorclass.minAmount.valid", "error.contractorclass.minAmount.valid");
        }
    }

    private void checkContractorClass(ContractorGrade contractorGrade, BindingResult resultBinder) {
        if (contractorGrade.getGrade() == null) {
            resultBinder.reject("error.contractorclass.grade.null", "error.contractorclass.grade.null");
        }
        if (contractorGrade.getGrade() != null && !contractorGrade.getGrade().matches("[A-Za-z-/ ]+")) {
            resultBinder.reject("error.contractorclass.alphaNumeric", "error.contractorclass.alphaNumeric");
        }
    }

    private void checkExistingContractorClass(ContractorGrade contractorGrade, BindingResult resultBinder, String mode) {
        if (!"edit".equalsIgnoreCase(mode) && this.contractorGradeService.getByContractorClass(contractorGrade.getGrade()) != null) {
            resultBinder.reject("error.contractorclass.grade.isunique", "error.contractorclass.grade.isunique");
        }
        if ("edit".equalsIgnoreCase(mode)) {
            ContractorGrade cg;
            ContractorGrade existingContactorGrade = this.contractorGradeService.getByContractorClass(contractorGrade.getGrade());
            if (existingContactorGrade != null && !existingContactorGrade.getId().equals(contractorGrade.getId())) {
                resultBinder.reject("error.contractorclass.exists", "error.contractorclass.exists");
            }
            if ((cg = this.contractorGradeService.getByMinAndMaxAmount(contractorGrade.getMinAmount(), contractorGrade.getMaxAmount())) != null && !cg.getId().equals(contractorGrade.getId())) {
                this.checkMinAndMaxAmountCombination(contractorGrade, resultBinder);
            }
        }
    }
}

