/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.services.masters.SchemeService;
import org.egov.works.lineestimate.entity.EstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.Beneficiary;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.masters.service.LineEstimateUOMService;
import org.egov.works.masters.service.ModeOfAllotmentService;
import org.egov.works.masters.service.NatureOfWorkService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/lineestimate"})
public class UpdateLineEstimateController
extends GenericWorkFlowController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    private FunctionHibernateDAO functionHibernateDAO;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ModeOfAllotmentService modeOfAllotmentService;
    @Autowired
    private LineEstimateUOMService lineEstimateUOMService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;
    @Autowired
    private TypeOfWorkService typeOfWorkService;
    @Autowired
    private CityService cityService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<LineEstimate> lineEstimateWorkflowService;

    @ModelAttribute
    public LineEstimate getLineEstimate(@PathVariable String lineEstimateId) {
        LineEstimate lineEstimate = this.lineEstimateService.getLineEstimateById(Long.valueOf(Long.parseLong(lineEstimateId)));
        return lineEstimate;
    }

    @RequestMapping(value={"/update/{lineEstimateId}"}, method={RequestMethod.GET})
    public String updateLineEstimate(Model model, @PathVariable String lineEstimateId, HttpServletRequest request) throws ApplicationException {
        model.addAttribute("hiddenfields", (Object)this.lineEstimateService.getLineEstimateHiddenFields());
        model.addAttribute("workdetailsadd", (Object)("yes".equalsIgnoreCase(this.lineEstimateService.getLineEstimateMultipleWorkDetailsAllowed()) ? Boolean.TRUE : Boolean.FALSE));
        LineEstimate lineEstimate = this.getLineEstimate(lineEstimateId);
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.REJECTED.toString())) {
            this.setDropDownValues(model);
        }
        lineEstimate.setTempLineEstimateDetails(lineEstimate.getLineEstimateDetails());
        return this.loadViewData(model, request, lineEstimate);
    }

    @RequestMapping(value={"/view/{lineEstimateId}"}, method={RequestMethod.GET})
    public String viewLineEstimate(Model model, @PathVariable String lineEstimateId, HttpServletRequest request) throws ApplicationException {
        model.addAttribute("hiddenfields", (Object)this.lineEstimateService.getLineEstimateHiddenFields());
        LineEstimate lineEstimate = this.getLineEstimate(lineEstimateId);
        String responsePage = this.loadViewData(model, request, lineEstimate);
        model.addAttribute("adminsanctionbydesignation", (Object)lineEstimate.getAdminSanctionBy());
        model.addAttribute("technicalsanctionbydesignation", (Object)this.worksUtils.getUserDesignation(lineEstimate.getTechnicalSanctionBy()));
        model.addAttribute("createdbybydesignation", (Object)this.worksUtils.getUserDesignation(lineEstimate.getCreatedBy()));
        model.addAttribute("mode", (Object)"readOnly");
        model.addAttribute("workflowHistory", (Object)this.worksUtils.getHistory(lineEstimate.getState(), lineEstimate.getStateHistory()));
        return responsePage;
    }

    @RequestMapping(value={"/update/{lineEstimateId}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute(value="lineEstimate") LineEstimate lineEstimate, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam String removedLineEstimateDetailsIds, @RequestParam(value="file") MultipartFile[] files) throws ApplicationException, IOException {
        String mode = "";
        String workFlowAction = "";
        LineEstimate newLineEstimate = null;
        String additionalRule = "";
        this.validateBudgetHead(lineEstimate, errors);
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.lineEstimateService.getApprovalPositionByMatrixDesignation(lineEstimate, approvalPosition, additionalRule, mode, workFlowAction);
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (workFlowAction.equalsIgnoreCase("Approve".toString())) {
            this.validateAdminSanctionDetail(lineEstimate, errors);
            this.lineEstimateService.validateAdminSanctionFields(lineEstimate, errors);
            if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
                this.validateBudgetAmount(lineEstimate, errors);
            }
        }
        if (workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
            this.lineEstimateService.validateLineEstimateDetails(lineEstimate, errors);
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("removedLineEstimateDetailsIds", (Object)removedLineEstimateDetailsIds);
            return this.loadViewData(model, request, lineEstimate);
        }
        if (null != workFlowAction) {
            try {
                CFinancialYear financialYear = this.worksUtils.getFinancialYearByDate(lineEstimate.getLineEstimateDate());
                newLineEstimate = this.lineEstimateService.updateLineEstimateDetails(lineEstimate, approvalPosition, approvalComment, additionalRule, workFlowAction, mode, null, removedLineEstimateDetailsIds, files, financialYear);
            }
            catch (ValidationException e) {
                ArrayList<Long> budgetheadid = new ArrayList<Long>();
                budgetheadid.add(lineEstimate.getBudgetHead().getId());
                BigDecimal budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.worksUtils.getFinancialYearByDate(new Date()).getId(), Integer.valueOf(Integer.parseInt(lineEstimate.getExecutingDepartment().getId().toString())), lineEstimate.getFunction().getId(), null, lineEstimate.getScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getScheme().getId().toString())), lineEstimate.getSubScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getSubScheme().getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(lineEstimate.getFund().getId().toString())));
                BigDecimal totalEstimateAmount = BigDecimal.ZERO;
                for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                    totalEstimateAmount = led.getEstimateAmount().add(totalEstimateAmount);
                }
                String errorMessage = this.messageSource.getMessage("error.budgetappropriation.amount", (Object[])new String[]{budgetAvailable.toString(), totalEstimateAmount.toString()}, null);
                model.addAttribute("message", (Object)errorMessage);
                return "lineestimate-success";
            }
        }
        redirectAttributes.addFlashAttribute("lineEstimate", newLineEstimate);
        String pathVars = this.worksUtils.getPathVars(newLineEstimate.getStatus(), newLineEstimate.getState(), newLineEstimate.getId(), approvalPosition);
        return "redirect:/lineestimate/lineestimate-success?pathVars=" + pathVars;
    }

    private void validateBudgetHead(LineEstimate lineEstimate, BindingResult errors) {
        if (lineEstimate.getBudgetHead() != null) {
            Boolean check = false;
            ArrayList accountDetails = new ArrayList();
            accountDetails.addAll(lineEstimate.getBudgetHead().getMaxCode().getChartOfAccountDetails());
            for (CChartOfAccountDetail detail : accountDetails) {
                if (detail.getDetailTypeId() == null || !detail.getDetailTypeId().getName().equalsIgnoreCase("PROJECTCODE")) continue;
                check = true;
            }
            if (!check.booleanValue()) {
                errors.reject("error.budgethead.validate", "error.budgethead.validate");
            }
        }
    }

    private void validateBudgetAmount(LineEstimate lineEstimate, BindingResult errors) {
        block4: {
            ArrayList<Long> budgetheadid = new ArrayList<Long>();
            budgetheadid.add(lineEstimate.getBudgetHead().getId());
            try {
                BigDecimal budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.worksUtils.getFinancialYearByDate(new Date()).getId(), Integer.valueOf(Integer.parseInt(lineEstimate.getExecutingDepartment().getId().toString())), lineEstimate.getFunction().getId(), null, lineEstimate.getScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getScheme().getId().toString())), lineEstimate.getSubScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getSubScheme().getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(lineEstimate.getFund().getId().toString())));
                BigDecimal totalEstimateAmount = BigDecimal.ZERO;
                for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                    totalEstimateAmount = led.getEstimateAmount().add(totalEstimateAmount);
                }
                if (BudgetControlType.BudgetCheckOption.MANDATORY.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && budgetAvailable.compareTo(totalEstimateAmount) == -1) {
                    errors.reject("error.budgetappropriation.amount", (Object[])new String[]{budgetAvailable.toString(), totalEstimateAmount.toString()}, null);
                }
            }
            catch (ValidationException e) {
                Iterator iterator = e.getErrors().iterator();
                if (!iterator.hasNext()) break block4;
                ValidationError error = (ValidationError)iterator.next();
                throw new ApplicationRuntimeException(error.getKey());
            }
        }
    }

    private void validateAdminSanctionDetail(LineEstimate lineEstimate, BindingResult errors) {
        LineEstimate checkLineEstimate;
        if (StringUtils.isBlank((CharSequence)lineEstimate.getAdminSanctionNumber())) {
            errors.rejectValue("adminSanctionNumber", "error.adminsanctionnumber.notnull");
        }
        if (lineEstimate.getAdminSanctionNumber() != null && (checkLineEstimate = this.lineEstimateService.getLineEstimateByAdminSanctionNumber(lineEstimate.getAdminSanctionNumber())) != null) {
            errors.rejectValue("adminSanctionNumber", "error.adminsanctionnumber.unique");
        }
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("funds", (Object)this.fundHibernateDAO.findAllActiveFunds());
        model.addAttribute("functions", (Object)this.functionHibernateDAO.getAllActiveFunctions());
        model.addAttribute("schemes", (Object)this.schemeService.findAll());
        model.addAttribute("departments", (Object)this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser()));
        model.addAttribute("beneficiary", (Object)Beneficiary.values());
        model.addAttribute("modeOfAllotment", (Object)this.modeOfAllotmentService.findAll());
        model.addAttribute("lineEstimateUOMs", (Object)this.lineEstimateUOMService.findAll());
        model.addAttribute("typeOfWork", (Object)this.typeOfWorkService.getActiveTypeOfWorksByPartyType("Contractor"));
        model.addAttribute("natureOfWork", (Object)this.natureOfWorkService.findAll());
        model.addAttribute("workCategory", (Object)WorkCategory.values());
        model.addAttribute("locations", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Locality", "LOCATION"));
    }

    private String loadViewData(Model model, HttpServletRequest request, LineEstimate lineEstimate) {
        WorkFlowMatrix wfmatrix = null;
        model.addAttribute("stateType", (Object)lineEstimate.getClass().getSimpleName());
        model.addAttribute("amountRule", (Object)lineEstimate.getTotalEstimateAmount());
        model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
        WorkflowContainer workflowContainer = new WorkflowContainer();
        if (lineEstimate.getCurrentState() != null) {
            model.addAttribute("currentState", (Object)lineEstimate.getCurrentState().getValue());
        }
        if (lineEstimate.getState() != null && lineEstimate.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)lineEstimate.getState().getNextAction());
            model.addAttribute("pendingActions", (Object)lineEstimate.getState().getNextAction());
            workflowContainer.setPendingActions(lineEstimate.getCurrentState().getNextAction());
            wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, lineEstimate.getTotalEstimateAmount(), (String)this.cityService.cityDataAsMap().get("cityGrade"), lineEstimate.getCurrentState().getValue(), lineEstimate.getCurrentState().getNextAction());
            if (wfmatrix != null) {
                model.addAttribute("nextStatus", (Object)wfmatrix.getNextStatus().toUpperCase());
            }
        }
        workflowContainer.setAmountRule(lineEstimate.getTotalEstimateAmount());
        this.prepareWorkflow(model, (StateAware)lineEstimate, workflowContainer);
        if (lineEstimate.getState() != null && lineEstimate.getState().getValue().equals("Rejected")) {
            model.addAttribute("mode", (Object)"edit");
        } else {
            model.addAttribute("mode", (Object)"view");
        }
        lineEstimate.setApprovalDepartment(this.worksUtils.getDefaultDepartmentId());
        model.addAttribute("workflowHistory", (Object)this.worksUtils.getHistory(lineEstimate.getState(), lineEstimate.getStateHistory()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
        model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
        LineEstimate newLineEstimate = this.getEstimateDocuments(lineEstimate);
        model.addAttribute("documentDetails", (Object)newLineEstimate.getDocumentDetails());
        model.addAttribute("lineEstimate", (Object)newLineEstimate);
        if (request != null && request.getParameter("message") != null && request.getParameter("message").equals("update")) {
            model.addAttribute("message", (Object)"update");
        }
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) || lineEstimate.getStatus().getCode().equals(LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString())) {
            model.addAttribute("fieldsRequiredMap", (Object)this.lineEstimateService.getWorkFlowLevelFields(lineEstimate));
            EstimateAppropriation lineEstimateAppropriation = this.estimateAppropriationService.findLatestByLineEstimateDetails((LineEstimateDetails)lineEstimate.getLineEstimateDetails().get(0));
            model.addAttribute("budgetAppropriationDate", (Object)lineEstimateAppropriation.getBudgetUsage().getUpdatedTime());
        }
        this.lineEstimateService.loadModelValues(lineEstimate, model);
        return "newLineEstimate-edit";
    }

    private LineEstimate getEstimateDocuments(LineEstimate lineEstimate) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(lineEstimate.getId(), "LineEstimate");
        lineEstimate.setDocumentDetails(documentDetailsList);
        return lineEstimate;
    }
}

