/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import java.util.List;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.services.masters.SchemeService;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.entity.LineEstimateSearchRequest;
import org.egov.works.lineestimate.entity.LineEstimatesForAbstractEstimate;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.masters.service.NatureOfWorkService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/lineestimate"})
public class SearchLineEstimateController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    private FunctionHibernateDAO functionHibernateDAO;
    @Autowired
    private BudgetGroupDAO budgetGroupDAO;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private WorksUtils worksUtils;

    @RequestMapping(value={"/searchform"}, method={RequestMethod.GET})
    public String showSearchLineEstimateForLoa(@ModelAttribute LineEstimateSearchRequest lineEstimateSearchRequest, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        model.addAttribute("lineEstimateSearchRequest", (Object)lineEstimateSearchRequest);
        return "lineestimate-search";
    }

    @RequestMapping(value={"/searchlineestimateforabstractestimate-form"}, method={RequestMethod.GET})
    public String searchLineEstimateForAbstractEstimate(@ModelAttribute LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate, Model model) {
        if (!this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return "redirect:/abstractestimate/create";
        }
        this.setDropDownValues(model);
        List lineEstimateCreatedByUsers = this.lineEstimateService.getLineEstimateCreatedByUsers();
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        lineEstimatesForAbstractEstimate.setSpillOverFlag(false);
        model.addAttribute("lineEstimatesForAbstractEstimate", (Object)lineEstimatesForAbstractEstimate);
        model.addAttribute("lineEstimateCreatedByUsers", (Object)lineEstimateCreatedByUsers);
        model.addAttribute("departments", (Object)departments);
        return "searchLineEstimateForAbstractEstimate-search";
    }

    @RequestMapping(value={"/searchleforspilloverae-form"}, method={RequestMethod.GET})
    public String searchLineEstimateForSpillOverAbstractEstimate(@ModelAttribute LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate, Model model) {
        if (!this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return "redirect:/abstractestimate/createspillover";
        }
        this.setDropDownValues(model);
        List lineEstimateCreatedByUsers = this.lineEstimateService.getLineEstimateCreatedByUsers();
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        lineEstimatesForAbstractEstimate.setSpillOverFlag(true);
        model.addAttribute("lineEstimatesForAbstractEstimate", (Object)lineEstimatesForAbstractEstimate);
        model.addAttribute("lineEstimateCreatedByUsers", (Object)lineEstimateCreatedByUsers);
        model.addAttribute("departments", (Object)departments);
        return "searchLineEstimateForSpilloverEstimate-search";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("funds", (Object)this.fundHibernateDAO.findAllActiveFunds());
        model.addAttribute("functions", (Object)this.functionHibernateDAO.getAllActiveFunctionsOrderByCode());
        model.addAttribute("budgetHeads", (Object)this.budgetGroupDAO.getBudgetGroupList());
        model.addAttribute("schemes", (Object)this.schemeService.findAll());
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("egwStatus", (Object)this.egwStatusDAO.getStatusByModule("LINEESTIMATE"));
        model.addAttribute("natureOfWork", (Object)this.natureOfWorkService.findAll());
    }

    @RequestMapping(value={"/searchlineestimateform"}, method={RequestMethod.GET})
    public String searchLineEstimateToUploadEstmatePhotographs(@ModelAttribute EstimatePhotographSearchRequest estimatePhotographSearchRequest, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        model.addAttribute("departments", (Object)departments);
        model.addAttribute("estimatePhotographSearchRequest", (Object)estimatePhotographSearchRequest);
        model.addAttribute("lineEstimateRequired", (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "searchLineEstimateForEstimatePhotograph-form";
    }
}

