/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.services.masters.SchemeService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.EstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.Beneficiary;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.masters.service.LineEstimateUOMService;
import org.egov.works.masters.service.ModeOfAllotmentService;
import org.egov.works.masters.service.NatureOfWorkService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/lineestimate"})
public class CreateLineEstimateController
extends GenericWorkFlowController {
    private static final int BUFFER_SIZE = 4096;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    @Qualifier(value="schemeService")
    private SchemeService schemeService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ModeOfAllotmentService modeOfAllotmentService;
    @Autowired
    private LineEstimateUOMService lineEstimateUOMService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private TypeOfWorkService typeOfWorkService;
    @Autowired
    private CityService cityService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewLineEstimateForm(@ModelAttribute(value="lineEstimate") LineEstimate lineEstimate, Model model) throws ApplicationException {
        model.addAttribute("hiddenfields", (Object)this.lineEstimateService.getLineEstimateHiddenFields());
        model.addAttribute("workdetailsadd", (Object)("yes".equalsIgnoreCase(this.lineEstimateService.getLineEstimateMultipleWorkDetailsAllowed()) ? Boolean.TRUE : Boolean.FALSE));
        this.setDropDownValues(model);
        model.addAttribute("lineEstimate", (Object)lineEstimate);
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            lineEstimate.setExecutingDepartment((Department)departments.get(0));
        }
        if (lineEstimate.getState() != null && lineEstimate.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)lineEstimate.getState().getNextAction());
        }
        lineEstimate.setApprovalDepartment(this.worksUtils.getDefaultDepartmentId());
        model.addAttribute("stateType", (Object)lineEstimate.getClass().getSimpleName());
        model.addAttribute("documentDetails", (Object)lineEstimate.getDocumentDetails());
        lineEstimate.setTempLineEstimateDetails(lineEstimate.getLineEstimateDetails());
        model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
        this.prepareWorkflow(model, (StateAware)lineEstimate, new WorkflowContainer());
        model.addAttribute("mode", null);
        this.lineEstimateService.loadModelValues(lineEstimate, model);
        return "newLineEstimate-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="lineEstimate") LineEstimate lineEstimate, RedirectAttributes redirectAttributes, Model model, BindingResult errors, @RequestParam(value="file") MultipartFile[] files, HttpServletRequest request, @RequestParam String workFlowAction) throws ApplicationException, IOException {
        this.setDropDownValues(model);
        this.validateLineEstimate(lineEstimate, errors);
        this.validateBudgetHead(lineEstimate, errors);
        this.lineEstimateService.validateLineEstimateDetails(lineEstimate, errors);
        if (errors.hasErrors()) {
            model.addAttribute("stateType", (Object)lineEstimate.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)lineEstimate, new WorkflowContainer());
            model.addAttribute("documentDetails", (Object)lineEstimate.getDocumentDetails());
            model.addAttribute("mode", null);
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
            model.addAttribute("hiddenfields", (Object)this.lineEstimateService.getLineEstimateHiddenFields());
            model.addAttribute("workdetailsadd", (Object)("yes".equalsIgnoreCase(this.lineEstimateService.getLineEstimateMultipleWorkDetailsAllowed()) ? Boolean.TRUE : Boolean.FALSE));
            return "newLineEstimate-form";
        }
        if (lineEstimate.getState() == null) {
            lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CREATED.toString()));
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        String additionalRule = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        LineEstimate newLineEstimate = this.lineEstimateService.create(lineEstimate, files, approvalPosition, approvalComment, additionalRule, workFlowAction);
        model.addAttribute("lineEstimate", (Object)newLineEstimate);
        String pathVars = this.worksUtils.getPathVars(newLineEstimate.getStatus(), newLineEstimate.getState(), newLineEstimate.getId(), approvalPosition);
        return "redirect:/lineestimate/lineestimate-success?pathVars=" + pathVars;
    }

    private void validateBudgetHead(LineEstimate lineEstimate, BindingResult errors) {
        if (lineEstimate.getBudgetHead() != null) {
            Boolean check = false;
            ArrayList accountDetails = new ArrayList();
            accountDetails.addAll(lineEstimate.getBudgetHead().getMaxCode().getChartOfAccountDetails());
            for (CChartOfAccountDetail detail : accountDetails) {
                if (detail.getDetailTypeId() == null || !detail.getDetailTypeId().getName().equalsIgnoreCase("PROJECTCODE")) continue;
                check = true;
            }
            if (!check.booleanValue()) {
                errors.reject("error.budgethead.validate", "error.budgethead.validate");
            }
        }
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("funds", (Object)this.fundHibernateDAO.findAllActiveFunds());
        model.addAttribute("departments", (Object)this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser()));
        model.addAttribute("workCategory", (Object)WorkCategory.values());
        model.addAttribute("beneficiary", (Object)Beneficiary.values());
        model.addAttribute("modeOfAllotment", (Object)this.modeOfAllotmentService.findAll());
        model.addAttribute("lineEstimateUOMs", (Object)this.lineEstimateUOMService.findAll());
        model.addAttribute("typeOfWork", (Object)this.typeOfWorkService.getActiveTypeOfWorksByPartyType("Contractor"));
        model.addAttribute("natureOfWork", (Object)this.natureOfWorkService.findAll());
        model.addAttribute("locations", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Locality", "LOCATION"));
    }

    @RequestMapping(value={"/downloadLineEstimateDoc"}, method={RequestMethod.GET})
    public void getLineEstimateDoc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = request.getServletContext();
        String fileStoreId = request.getParameter("fileStoreId");
        String fileName = "";
        File downloadFile = this.fileStoreService.fetch(fileStoreId, "WMS");
        FileInputStream inputStream = new FileInputStream(downloadFile);
        LineEstimate lineEstimate = this.lineEstimateService.getLineEstimateById(Long.valueOf(Long.parseLong(request.getParameter("lineEstimateId"))));
        lineEstimate = this.getEstimateDocuments(lineEstimate);
        for (DocumentDetails doc : lineEstimate.getDocumentDetails()) {
            if (!doc.getFileStore().getFileStoreId().equalsIgnoreCase(fileStoreId)) continue;
            fileName = doc.getFileStore().getFileName();
        }
        String mimeType = context.getMimeType(downloadFile.getAbsolutePath());
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        response.setContentType(mimeType);
        response.setContentLength((int)downloadFile.length());
        String headerKey = "Content-Disposition";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        ServletOutputStream outStream = response.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        outStream.close();
    }

    private LineEstimate getEstimateDocuments(LineEstimate lineEstimate) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(lineEstimate.getId(), "LineEstimate");
        lineEstimate.setDocumentDetails(documentDetailsList);
        return lineEstimate;
    }

    @RequestMapping(value={"/lineestimate-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute LineEstimate lineEstimate, HttpServletRequest request, Model model, ModelMap modelMap) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            lineEstimate = this.lineEstimateService.getLineEstimateById(id);
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(lineEstimate, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()) && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            ArrayList<String> basMessages = new ArrayList<String>();
            Integer count = 1;
            for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                EstimateAppropriation lea = this.estimateAppropriationService.findLatestByLineEstimateDetails(led);
                String tempMessage = this.messageSource.getMessage("msg.lineestimatedetails.budgetsanction.success", (Object[])new String[]{count.toString(), led.getEstimateNumber(), lea.getBudgetUsage().getAppropriationnumber()}, null);
                basMessages.add(tempMessage);
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            model.addAttribute("basMessages", basMessages);
        }
        return new ModelAndView("lineestimate-success", "lineEstimate", (Object)lineEstimate);
    }

    private String getMessageByStatus(LineEstimate lineEstimate, String approverName, String nextDesign) {
        String message = "";
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CREATED.toString()) && !lineEstimate.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.lineestimate.create.success", (Object[])new String[]{approverName, nextDesign, lineEstimate.getLineEstimateNumber()}, null);
        }
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.RESUBMITTED.toString()) && !lineEstimate.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.lineestimate.resubmit.success", (Object[])new String[]{approverName, nextDesign, lineEstimate.getLineEstimateNumber()}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CHECKED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.check.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), approverName, nextDesign}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.budgetsanction.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), approverName, nextDesign}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.adminsanction.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), lineEstimate.getAdminSanctionNumber()}, null);
        } else if (lineEstimate.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.lineestimate.reject", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), approverName, nextDesign}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CANCELLED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.cancel", (Object[])new String[]{lineEstimate.getLineEstimateNumber()}, null);
        } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.TECHNICALLY_APPROVED.toString())) {
            message = this.messageSource.getMessage("msg.lineestimate.technicalapprove.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), approverName, nextDesign}, null);
        }
        return message;
    }

    private void validateLineEstimate(LineEstimate lineEstimate, BindingResult errors) {
        if (!this.lineEstimateService.getLineEstimateHiddenFields().contains("subject") && lineEstimate.getSubject() == null) {
            errors.reject("error.subject.required", "error.subject.required");
        }
        if (!this.lineEstimateService.getLineEstimateHiddenFields().contains("description") && lineEstimate.getDescription() == null) {
            errors.reject("error.description.required", "error.description.required");
        }
    }
}

