/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.service.FinancialYearService;
import org.egov.commons.service.FunctionService;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.dao.budget.BudgetDetailsHibernateDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.support.json.adapter.UserAdaptor;
import org.egov.model.budget.BudgetGroup;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.egov.utils.BudgetAccountType;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.LineEstimateSearchRequest;
import org.egov.works.lineestimate.entity.LineEstimatesForAbstractEstimate;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.masters.entity.NatureOfWork;
import org.egov.works.masters.service.NatureOfWorkService;
import org.egov.works.web.adaptor.AbstractEstimateForEstimatePhotographJsonAdaptor;
import org.egov.works.web.adaptor.AbstractEstimateForLOAJsonAdaptor;
import org.egov.works.web.adaptor.LineEstimateForEstimatePhotographJsonAdaptor;
import org.egov.works.web.adaptor.LineEstimateJsonAdaptor;
import org.egov.works.web.adaptor.SearchLineEstimateToCancelJSONAdaptor;
import org.egov.works.web.adaptor.SubSchemeAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/lineestimate"})
public class AjaxLineEstimateController {
    @Autowired
    @Qualifier(value="schemeService")
    private SchemeService schemeService;
    @Autowired
    @Qualifier(value="subSchemeService")
    private SubSchemeService subSchemeService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private LineEstimateJsonAdaptor lineEstimateJsonAdaptor;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private SearchLineEstimateToCancelJSONAdaptor searchLineEstimateToCancelJSONAdaptor;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private FinancialYearService financialYearService;
    @Autowired
    private BudgetGroupDAO budgetGroupDAO;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private BudgetDetailsHibernateDAO budgetDetailsHibernateDAO;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private LineEstimateForEstimatePhotographJsonAdaptor lineEstimateForEstimatePhotographJsonAdaptor;
    @Autowired
    private TypeOfWorkService typeOfWorkService;
    @Autowired
    private AbstractEstimateForEstimatePhotographJsonAdaptor abstractEstimateForEstimatePhotographJsonAdaptor;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;

    @RequestMapping(value={"/getschemesbyfundid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Scheme> getAllSchemesByFundId(@RequestParam(value="fundId") String fundId) throws ApplicationException {
        return this.schemeService.getByFundId(Integer.valueOf(Integer.parseInt(fundId)));
    }

    @RequestMapping(value={"/getsubschemesbyschemeid/{schemeId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getAllSubSchemesBySchemeId(Model model, @PathVariable String schemeId) throws IOException, NumberFormatException, ApplicationException {
        if (schemeId != null && !schemeId.equals("undefined")) {
            List subSchemes = this.subSchemeService.getBySchemeId(Integer.valueOf(Integer.parseInt(schemeId)));
            String jsonResponse = JsonUtils.toJSON((Collection)subSchemes, SubScheme.class, SubSchemeAdaptor.class);
            return jsonResponse;
        }
        return "";
    }

    @RequestMapping(value={"/getfinancilyearbyid"}, method={RequestMethod.GET})
    @ResponseBody
    public CFinancialYear getFinancilYearById(@RequestParam(value="fyId") Long fyId) {
        CFinancialYear financialYear = new CFinancialYear();
        if (fyId != null) {
            financialYear = (CFinancialYear)this.financialYearService.findById((Serializable)fyId, false);
        }
        return financialYear;
    }

    @RequestMapping(value={"/ajax-getlocation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getChildBoundariesById(@RequestParam Long id) {
        return this.crossHierarchyService.getActiveChildBoundariesByBoundaryId(id);
    }

    @RequestMapping(value={"/getsubtypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<EgwTypeOfWork> getSubTypeOfWork(@RequestParam(value="id") Long id) {
        return this.typeOfWorkService.getActiveSubTypeOfWorksByParentIdAndPartyType(id, "Contractor");
    }

    @RequestMapping(value={"/ajax-getward"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> findWard(@RequestParam(value="name") String name) {
        List boundaries = this.boundaryService.getBondariesByNameAndBndryTypeAndHierarchyType("Ward", "ADMINISTRATION", "%" + name);
        List cityBoundary = this.boundaryService.getBondariesByNameAndBndryTypeAndHierarchyType("City", "ADMINISTRATION", "%" + name + "%");
        boundaries.addAll(cityBoundary);
        return boundaries;
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(Model model, @ModelAttribute LineEstimateSearchRequest lineEstimateSearchRequest) {
        List searchResultList = this.lineEstimateService.searchLineEstimates(lineEstimateSearchRequest);
        String result = "{ \"data\":" + this.toSearchLineEstimateResultJson((Object)searchResultList) + "}";
        return result;
    }

    @RequestMapping(value={"/ajaxsearchlineestimatesforabstractestimate"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchLineEstimatesForAbstractEstimate(Model model, @ModelAttribute LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate) {
        List searchResultList = this.lineEstimateService.searchLineEstimatesForAbstractEstimate(lineEstimatesForAbstractEstimate);
        String result = "{ \"data\":" + this.toSearchLineEstimateForAbstractEstimateResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchLineEstimateResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimate.class, (Object)this.lineEstimateJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    public Object toSearchLineEstimateForAbstractEstimateResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimate.class, (Object)new AbstractEstimateForLOAJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/lineEstimateNumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLineEstimateNumbers(@RequestParam String name) {
        return this.lineEstimateService.findLineEstimateNumbers(name);
    }

    @RequestMapping(value={"/lineEstimateNumbersForLoa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForLoa(@RequestParam String name) {
        return this.lineEstimateService.findEstimateNumbersForLoa(name);
    }

    @RequestMapping(value={"/lineEstimateNumbersForAbstractEstimate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForAbstractEstimate(@RequestParam String name) {
        return this.lineEstimateService.findEstimateNumbersForAbstractEstimate(name);
    }

    @RequestMapping(value={"/adminSanctionNumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findAdminSanctionNumbers(@RequestParam String name) {
        return this.lineEstimateService.findAdminSanctionNumbers(name);
    }

    @RequestMapping(value={"/adminSanctionNumbersForLoa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findAdminSanctionNumbersForLoa(@RequestParam String name) {
        return this.lineEstimateService.findAdminSanctionNumbersForLoa(name);
    }

    @RequestMapping(value={"/adminSanctionNumbersForAbstractEstimate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findAdminSanctionNumbersForAbstractEstimate(@RequestParam String name) {
        return this.lineEstimateService.findAdminSanctionNumbersForAbstractEstimate(name);
    }

    @RequestMapping(value={"/workIdNumbersForLoa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findworkIdNumbersForLoa(@RequestParam String name) {
        return this.lineEstimateService.findWorkIdentificationNumbersToSearchEstimatesForLoa(name);
    }

    @RequestMapping(value={"/workIdNumbersForEstimate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findworkIdNumbersToSearchEstimates(@RequestParam String name) {
        return this.lineEstimateService.findWorkIdentificationNumbersToSearchEstimates(name);
    }

    @RequestMapping(value={"/ajax-assignmentByDepartmentAndDesignation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getAssignmentByDepartmentAndDesignation(@RequestParam(value="approvalDesignation") Long approvalDesignation, @RequestParam(value="approvalDepartment") Long approvalDepartment) throws JsonGenerationException, JsonMappingException, IOException, NumberFormatException, ApplicationException {
        ArrayList<User> users = new ArrayList<User>();
        List assignments = new ArrayList();
        if (approvalDepartment != null && approvalDepartment != 0L && approvalDepartment != -1L && approvalDesignation != null && approvalDesignation != 0L && approvalDesignation != -1L) {
            assignments = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(approvalDepartment, approvalDesignation, new Date());
        }
        for (Assignment assignment : assignments) {
            users.add(this.userService.getUserById(assignment.getEmployee().getId()));
        }
        Gson jsonCreator = new GsonBuilder().registerTypeAdapter(User.class, (Object)new UserAdaptor()).create();
        return jsonCreator.toJson(users, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    @RequestMapping(value={"/ajaxsearchcreatedby"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getCreatedByDepartment(@RequestParam(value="department") Long department) throws JsonGenerationException, JsonMappingException, IOException, NumberFormatException, ApplicationException {
        List users = this.lineEstimateService.getLineEstimateCreatedByUsersForCancelLineEstimateByDepartment(department);
        Gson jsonCreator = new GsonBuilder().registerTypeAdapter(User.class, (Object)new UserAdaptor()).create();
        return jsonCreator.toJson((Object)users, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchLineEstimatesToCancel(Model model, @ModelAttribute LineEstimateSearchRequest lineEstimateSearchRequest) {
        List lineestimates = this.lineEstimateService.searchLineEstimatesToCancel(lineEstimateSearchRequest);
        String result = "{ \"data\":" + this.toSearchLineEstimatesToCancelJson((Object)lineestimates) + "}";
        return result;
    }

    public Object toSearchLineEstimatesToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimate.class, (Object)this.searchLineEstimateToCancelJSONAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajax-checkifdependantObjectscreated"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String checkDependantObjectsCreated(@RequestParam Long lineEstimateId) {
        String estimateNumbers = this.lineEstimateService.checkAbstractEstimatesWithBOQForLineEstimate(lineEstimateId);
        String message = "";
        if (!estimateNumbers.equals("")) {
            message = this.messageSource.getMessage("error.lineestimate.abstractestimatewithboq.exists", (Object[])new String[]{estimateNumbers}, null);
        } else {
            String loaEstimateNumbers = this.lineEstimateService.checkIfLOAsCreated(lineEstimateId);
            if (!loaEstimateNumbers.equals("")) {
                message = this.messageSource.getMessage("error.lineestimate.loa.created", (Object[])new String[]{loaEstimateNumbers}, null);
            }
        }
        return message;
    }

    @RequestMapping(value={"/getbudgethead"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<BudgetGroup> getBudgetHeadByFunction(@RequestParam(value="fundId") Integer fundId, @RequestParam(value="departmentId") Long departmentId, @RequestParam(value="functionId") Long functionId, @RequestParam(value="natureOfWorkId") Long natureOfWorkId) {
        List<Object> budgetGroups = new ArrayList<BudgetGroup>();
        try {
            NatureOfWork natureOfWork = null;
            if (natureOfWorkId != null) {
                natureOfWork = this.natureOfWorkService.findById(natureOfWorkId);
            }
            String accountType = null;
            if (natureOfWork != null && natureOfWork.getExpenditureType().toString().equalsIgnoreCase("CAPITAL")) {
                accountType = BudgetAccountType.CAPITAL_EXPENDITURE.toString();
            } else if (natureOfWork != null && natureOfWork.getExpenditureType().toString().equalsIgnoreCase("REVENUE")) {
                accountType = BudgetAccountType.REVENUE_EXPENDITURE.toString();
            }
            budgetGroups = this.budgetGroupDAO.getBudgetGroupsByFundFunctionDeptAndAccountType(fundId, departmentId, functionId, accountType);
            return budgetGroups;
        }
        catch (ValidationException v) {
            return budgetGroups;
        }
    }

    @RequestMapping(value={"/getbudgetheadbyfunction"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<BudgetGroup> getBudgetHeadByFunction(@RequestParam(value="functionId") Long functionId) {
        List<Object> budgetGroups = new ArrayList<BudgetGroup>();
        CFunction function = this.functionService.findOne(functionId);
        try {
            budgetGroups = this.budgetGroupDAO.getBudgetHeadByFunction(function.getCode());
            return budgetGroups;
        }
        catch (ValidationException v) {
            return budgetGroups;
        }
    }

    @RequestMapping(value={"/getfunctionsbyfundidanddepartmentid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CFunction> getAllFunctionsByFundIdAndDepartmentId(Model model, @RequestParam(value="fundId") Integer fundId, @RequestParam(value="departmentId") Long departmentId) throws JsonGenerationException, JsonMappingException, IOException, NumberFormatException, ApplicationException {
        List functions = this.budgetDetailsHibernateDAO.getFunctionsByFundAndDepartment(fundId, departmentId);
        return functions;
    }

    @RequestMapping(value={"/getestimatenumbers-uploadphotographs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForEstimatePhotograph(@RequestParam String estimateNumber) {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return this.lineEstimateService.getEstimateNumbersForEstimatePhotograph(estimateNumber);
        }
        return this.estimateService.getEstimateNumbersForEstimatePhotograph(estimateNumber);
    }

    @RequestMapping(value={"/getwin-uploadphotographs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWinForEstimatePhotograph(@RequestParam String workIdentificationNumber) {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return this.lineEstimateService.getWinForEstimatePhotograph(workIdentificationNumber);
        }
        return this.estimateService.getWinForEstimatePhotograph(workIdentificationNumber);
    }

    @RequestMapping(value={"/searchlineestimateforestimatephotograph"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchLEForEstimatePhotograph(Model model, @ModelAttribute EstimatePhotographSearchRequest estimatePhotographSearchRequest) {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            List searchResultList = this.lineEstimateService.searchLineEstimatesForEstimatePhotograph(estimatePhotographSearchRequest);
            return "{ \"data\":" + this.toSearchLineEstimateForEstimatePhotograph((Object)searchResultList) + "}";
        }
        List searchResultList = this.estimateService.searchAbstractEstimateForEstimatePhotograph(estimatePhotographSearchRequest);
        return "{ \"data\":" + this.toSearchAbstractEstimateForEstimatePhotograph((Object)searchResultList) + "}";
    }

    public Object toSearchLineEstimateForEstimatePhotograph(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimateDetails.class, (Object)this.lineEstimateForEstimatePhotographJsonAdaptor).create();
        return gson.toJson(object);
    }

    private Object toSearchAbstractEstimateForEstimatePhotograph(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AbstractEstimate.class, (Object)this.abstractEstimateForEstimatePhotographJsonAdaptor).create();
        return gson.toJson(object);
    }
}

