/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.service.CustomizedWorkFlowService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.autonumber.LetterOfAcceptanceNumberGenerator;
import org.egov.works.letterofacceptance.entity.SearchRequestContractor;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.masters.service.ContractorGradeService;
import org.egov.works.masters.service.ContractorService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class CreateLetterOfAcceptanceController
extends GenericWorkFlowController {
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="contractorGradeService")
    private ContractorGradeService contractorGradeService;
    @Autowired
    @Qualifier(value="contractorService")
    private ContractorService contractorService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    protected CustomizedWorkFlowService customizedWorkFlowService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private MeasurementSheetService measurementSheetService;
    @Autowired
    private CityService cityService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="workOrder") WorkOrder workOrder, Model model, HttpServletRequest request) {
        if (request.getParameter("mode") != null) {
            model.addAttribute("mode", (Object)request.getParameter("mode"));
        }
        String estimateNumber = request.getParameter("estimateNumber");
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumberAndStatus(estimateNumber);
        workOrder = this.letterOfAcceptanceService.getWorkOrderByEstimateNumber(estimateNumber);
        if (workOrder == null) {
            workOrder = new WorkOrder();
        }
        this.loadViewData(model, abstractEstimate, workOrder, request);
        model.addAttribute("documentDetails", (Object)workOrder.getDocumentDetails());
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        if (!abstractEstimate.isSpillOverFlag() || !abstractEstimate.isWorkOrderCreated()) {
            workOrder.setWorkOrderDate(new Date());
        }
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("measurementsPresent", (Object)this.measurementSheetService.existsByEstimate(abstractEstimate.getId()));
        model.addAttribute("workflowHistory", (Object)this.worksUtils.getHistory(workOrder.getState(), workOrder.getStateHistory()));
        model.addAttribute("defaultDepartmentId", (Object)this.worksUtils.getDefaultDepartmentId());
        return "createLetterOfAcceptance-form";
    }

    private void setDropDownValues(Model model, AbstractEstimate abstractEstimate) {
        model.addAttribute("engineerInchargeList", (Object)this.letterOfAcceptanceService.getEngineerInchargeList(abstractEstimate.getExecutingDepartment().getId(), this.letterOfAcceptanceService.getEngineerInchargeDesignationIds()));
    }

    @RequestMapping(value={"/loa-save"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="workOrder") WorkOrder workOrder, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files, @RequestParam String workFlowAction, @RequestParam String mode) throws IOException {
        WorkOrder existingWorkOrder;
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumber(workOrder.getEstimateNumber());
        if ((mode == null || mode != null && !mode.equalsIgnoreCase("edit")) && (existingWorkOrder = this.letterOfAcceptanceService.getWorkOrderByEstimateNumber(workOrder.getEstimateNumber())) != null) {
            resultBinder.reject("error.loa.exists.for.estimate", (Object[])new String[]{existingWorkOrder.getWorkOrderNumber(), workOrder.getEstimateNumber()}, "error.loa.exists.for.estimate");
        }
        this.validateInput(workOrder, resultBinder);
        this.validateWorkOrderFileDate(workOrder, resultBinder, abstractEstimate);
        if (abstractEstimate != null && abstractEstimate.isSpillOverFlag() && abstractEstimate.isWorkOrderCreated()) {
            this.validateSpillOverInput(workOrder, resultBinder);
        }
        if (resultBinder.hasErrors()) {
            this.loadViewData(model, abstractEstimate, workOrder, request);
            model.addAttribute("abstractEstimate", (Object)abstractEstimate);
            model.addAttribute("contractorSearch", (Object)request.getParameter("contractorSearch"));
            model.addAttribute("contractorCode", (Object)request.getParameter("contractorCode"));
            model.addAttribute("engineerIncharge", (Object)request.getParameter("engineerIncharge"));
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            return "createLetterOfAcceptance-form";
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        String additionalRule = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        workOrder.setContractor(this.contractorService.getContractorById(workOrder.getContractor().getId()));
        WorkOrderEstimate workOrderEstimate = this.letterOfAcceptanceService.createWorkOrderEstimate(workOrder);
        if (abstractEstimate != null && abstractEstimate.isSpillOverFlag() && !abstractEstimate.isWorkOrderCreated() || !abstractEstimate.isSpillOverFlag()) {
            LetterOfAcceptanceNumberGenerator l = (LetterOfAcceptanceNumberGenerator)this.beanResolver.getAutoNumberServiceFor(LetterOfAcceptanceNumberGenerator.class);
            String workOrderNumber = l.getNextNumber(workOrderEstimate);
            workOrder.setWorkOrderNumber(workOrderNumber);
        }
        WorkOrder savedWorkOrder = this.letterOfAcceptanceService.create(workOrder, files, approvalPosition, approvalComment, additionalRule, workFlowAction, abstractEstimate);
        String pathVars = "";
        pathVars = abstractEstimate != null && abstractEstimate.isSpillOverFlag() && abstractEstimate.isWorkOrderCreated() ? savedWorkOrder.getId().toString() : this.worksUtils.getPathVars(savedWorkOrder.getEgwStatus(), savedWorkOrder.getState(), savedWorkOrder.getId(), approvalPosition);
        return "redirect:/letterofacceptance/letterofacceptance-success?pathVars=" + pathVars;
    }

    private void loadViewData(Model model, AbstractEstimate abstractEstimate, WorkOrder workOrder, HttpServletRequest request) {
        this.setDropDownValues(model, abstractEstimate);
        model.addAttribute("stateType", (Object)workOrder.getClass().getSimpleName());
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAmountRule(new BigDecimal(workOrder.getWorkOrderAmount()));
        workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
        this.prepareWorkflow(model, (StateAware)workOrder, workflowContainer);
        List validActions = Collections.emptyList();
        if (workOrder.getId() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(workOrder.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), workOrder.getState().getValue(), workflowContainer.getPendingActions(), workOrder.getCreatedDate());
            model.addAttribute("contractorSearch", (Object)workOrder.getContractor().getName());
            model.addAttribute("contractorCode", (Object)workOrder.getContractor().getCode());
        } else {
            validActions = this.customizedWorkFlowService.getNextValidActions(workOrder.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), "NEW", workflowContainer.getPendingActions(), workOrder.getCreatedDate());
        }
        workOrder = this.letterOfAcceptanceService.getWorkOrderDocuments(workOrder);
        if (workOrder.getState() != null && workOrder.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)workOrder.getState().getNextAction());
            model.addAttribute("pendingActions", (Object)workOrder.getState().getNextAction());
        }
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "PERCENTAGE_ON_ESTIMATERATE_OR_WORKVALUE");
        AppConfigValues value = (AppConfigValues)values.get(0);
        if (StringUtils.isNotBlank((CharSequence)workOrder.getPercentageSign()) && workOrder.getPercentageSign().equals("-")) {
            workOrder.setTenderFinalizedPercentage(workOrder.getTenderFinalizedPercentage() * -1.0);
        }
        model.addAttribute("percentage_on_estimaterate_or_workvalue", (Object)value.getValue());
        model.addAttribute("documentDetails", (Object)workOrder.getDocumentDetails());
        model.addAttribute("validActionList", (Object)validActions);
        model.addAttribute("loggedInUser", (Object)this.securityUtils.getCurrentUser().getName());
        model.addAttribute("amountRule", (Object)workOrder.getWorkOrderAmount());
        List nominationName = this.estimateService.getNominationName();
        model.addAttribute("nominationName", (Object)(!nominationName.isEmpty() ? ((AppConfigValues)nominationName.get(0)).getValue() : ""));
        model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
    }

    @RequestMapping(value={"/letterofacceptance-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute WorkOrder workOrder, HttpServletRequest request, Model model, ModelMap modelMap) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            workOrder = this.letterOfAcceptanceService.getWorkOrderById(id);
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(workOrder, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        return new ModelAndView("letterOfAcceptance-success", "workOrder", (Object)workOrder);
    }

    private String getMessageByStatus(WorkOrder workOrder, String approverName, String nextDesign) {
        String message = "";
        if (workOrder.getEgwStatus().getCode().equals("CREATED")) {
            message = this.messageSource.getMessage("msg.letterofacceptance.saved", (Object[])new String[]{approverName, nextDesign, workOrder.getWorkOrderNumber()}, null);
        }
        if (workOrder.getEgwStatus().getCode().equals("RESUBMITTED")) {
            message = this.messageSource.getMessage("msg.letterofacceptance.resubmitted", (Object[])new String[]{approverName, nextDesign, workOrder.getWorkOrderNumber()}, null);
        } else if (workOrder.getEgwStatus().getCode().equals("REJECTED")) {
            message = this.messageSource.getMessage("msg.letterofacceptance.rejected", (Object[])new String[]{workOrder.getWorkOrderNumber(), approverName, nextDesign}, null);
        } else if (workOrder.getEgwStatus().getCode().equals("APPROVED")) {
            message = this.messageSource.getMessage("msg.letterofacceptance.approved", (Object[])new String[]{workOrder.getWorkOrderNumber()}, null);
        } else if (workOrder.getEgwStatus().getCode().equals("CANCELLED")) {
            message = this.messageSource.getMessage("msg.letterofacceptance.cancelled", (Object[])new String[]{workOrder.getWorkOrderNumber()}, null);
        } else if ("CHECKED".equalsIgnoreCase(workOrder.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.loa.check.success", (Object[])new String[]{workOrder.getWorkOrderNumber(), approverName, nextDesign}, null);
        }
        return message;
    }

    @RequestMapping(value={"/loa-success"}, method={RequestMethod.GET})
    public String showLetterOfAcceptanceSuccessPage(@RequestParam(value="loaNumber") String loaNumber, Model model, @RequestParam(value="isModify", required=false) boolean isModify) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderByWorkOrderNumber(loaNumber);
        model.addAttribute("workOrder", (Object)workOrder);
        if (isModify) {
            model.addAttribute("mode", (Object)"modify");
        }
        return "letterofacceptance-success";
    }

    private void validateInput(WorkOrder workOrder, BindingResult resultBinder) {
        if (StringUtils.isBlank((CharSequence)workOrder.getFileNumber())) {
            resultBinder.rejectValue("fileNumber", "error.fileno.required");
        }
        if (workOrder.getFileDate() == null) {
            resultBinder.rejectValue("fileDate", "error.filedate.required");
        }
        if (workOrder.getWorkOrderAmount() <= 0.0) {
            resultBinder.rejectValue("workOrderAmount", "error.workorderamount.required");
        }
        if (workOrder.getContractor() == null || workOrder.getContractor().getId() == null) {
            resultBinder.rejectValue("contractor", "error.contractor.required");
        }
        if (workOrder.getContractPeriod() == null || workOrder.getContractPeriod() <= 0) {
            resultBinder.rejectValue("contractPeriod", "error.contractorperiod.required");
        }
        if (workOrder.getDefectLiabilityPeriod() <= 0.0) {
            resultBinder.rejectValue("defectLiabilityPeriod", "error.defectliabilityperiod.required");
        }
        if (workOrder.getEngineerIncharge() == null || workOrder.getEngineerIncharge().getId() == null) {
            resultBinder.rejectValue("engineerIncharge", "error.engineerincharge.required");
        }
    }

    private void validateSpillOverInput(WorkOrder workOrder, BindingResult resultBinder) {
        WorkOrder wo;
        if (StringUtils.isBlank((CharSequence)workOrder.getWorkOrderNumber())) {
            resultBinder.rejectValue("workOrderNumber", "error.workordernumber.required");
        }
        if ((wo = this.letterOfAcceptanceService.getWorkOrderByWorkOrderNumber(workOrder.getWorkOrderNumber())) != null) {
            resultBinder.rejectValue("workOrderNumber", "error.workordernumber.unique");
        }
    }

    private void validateWorkOrderFileDate(WorkOrder workOrder, BindingResult resultBinder, AbstractEstimate abstractEstimate) {
        if (workOrder.getFileDate().before(abstractEstimate.getApprovedDate())) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            resultBinder.rejectValue("fileDate", "error.loa.filedate", (Object[])new String[]{formatter.format(abstractEstimate.getApprovedDate())}, null);
        }
        if (workOrder.getWorkOrderDate() == null) {
            resultBinder.rejectValue("workOrderDate", "error.loa.workorderdate.requires");
        }
        if (workOrder.getWorkOrderDate() != null && workOrder.getWorkOrderDate().before(workOrder.getFileDate())) {
            resultBinder.rejectValue("fileDate", "error.loa.workorderdate");
        }
    }

    @RequestMapping(value={"/contractorsearchform"}, method={RequestMethod.GET})
    public String showSearchContractorForm(@ModelAttribute SearchRequestContractor searchRequestContractor, Model model) throws ApplicationException {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("contractorClasses", (Object)this.contractorGradeService.getAllContractorGrades());
        model.addAttribute("searchRequestContractor", (Object)searchRequestContractor);
        return "contractor-search";
    }
}

