/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.revisionestimate.service.RevisionWorkOrderService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class CancelLetterOfAcceptanceController {
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String LETTEROFACCEPTANCE_SUCCESS = "letterofacceptance-success";
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private RevisionWorkOrderService revisionWorkOrderService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String showSearchLetterOfAcceptanceForm(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, Model model) throws ApplicationException {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestLetterOfAcceptance.setDepartmentName(((Department)departments.get(0)).getId());
        }
        List egwStatuses = this.egwStatusHibernateDAO.getStatusByModule("WorkOrder");
        ArrayList<EgwStatus> newEgwStatuses = new ArrayList<EgwStatus>();
        for (EgwStatus egwStatus : egwStatuses) {
            if (egwStatus.getCode().equalsIgnoreCase("CREATED") || egwStatus.getCode().equalsIgnoreCase("REJECTED") || egwStatus.getCode().equalsIgnoreCase("cancelled") || egwStatus.getCode().equalsIgnoreCase("RESUBMITTED")) continue;
            newEgwStatuses.add(egwStatus);
        }
        model.addAttribute("egwStatus", newEgwStatuses);
        model.addAttribute("searchRequestContractorBill", (Object)searchRequestLetterOfAcceptance);
        searchRequestLetterOfAcceptance.setDepartmentName(this.worksUtils.getDefaultDepartmentId());
        return "searchloa-cancel";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelLetterOfAcceptance(HttpServletRequest request, Model model) throws ApplicationException {
        Long letterOfAcceptanceId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(letterOfAcceptanceId);
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0);
        if (workOrderEstimate.getWorkOrderActivities().isEmpty()) {
            String billNumbers = this.letterOfAcceptanceService.checkIfBillsCreated(workOrder.getId());
            if (!billNumbers.equals("")) {
                model.addAttribute(ERROR_MESSAGE, (Object)this.messageSource.getMessage("error.loa.bills.created", (Object[])new String[]{billNumbers}, null));
                return LETTEROFACCEPTANCE_SUCCESS;
            }
        } else {
            String revisionEstimates;
            String mbRefNumbers = this.letterOfAcceptanceService.checkIfMBCreatedForLOA(workOrderEstimate);
            if (!mbRefNumbers.equals("")) {
                model.addAttribute(ERROR_MESSAGE, (Object)this.messageSource.getMessage("error.loa.mb.created", (Object[])new String[]{mbRefNumbers}, null));
                return LETTEROFACCEPTANCE_SUCCESS;
            }
            if (!workOrderEstimate.getWorkOrderActivities().isEmpty() && !(revisionEstimates = this.revisionWorkOrderService.getRevisionEstimatesForWorkOrder(workOrder.getId())).equals("")) {
                model.addAttribute(ERROR_MESSAGE, (Object)this.messageSource.getMessage("error.revisionestimates.created", (Object[])new String[]{revisionEstimates}, null));
                return LETTEROFACCEPTANCE_SUCCESS;
            }
        }
        if (this.letterOfAcceptanceService.checkIfMileStonesCreated(workOrder)) {
            model.addAttribute(ERROR_MESSAGE, (Object)this.messageSource.getMessage("error.loa.milestone.created", (Object[])new String[0], null));
            return LETTEROFACCEPTANCE_SUCCESS;
        }
        String arfNumbers = this.letterOfAcceptanceService.checkIfARFCreatedForLOA(workOrderEstimate);
        if (!arfNumbers.equals("")) {
            model.addAttribute(ERROR_MESSAGE, (Object)this.messageSource.getMessage("error.loa.arf.created", (Object[])new String[]{arfNumbers}, null));
            return LETTEROFACCEPTANCE_SUCCESS;
        }
        workOrder.setCancellationReason(cancellationReason);
        workOrder.setCancellationRemarks(cancellationRemarks);
        workOrder = this.letterOfAcceptanceService.cancel(workOrder);
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("mode", (Object)"cancel");
        return LETTEROFACCEPTANCE_SUCCESS;
    }
}

