/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.letterofacceptance.entity.SearchRequestContractor;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptanceForRE;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.masters.entity.Contractor;
import org.egov.works.masters.entity.ContractorDetail;
import org.egov.works.masters.service.ContractorService;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.revisionestimate.service.RevisionWorkOrderService;
import org.egov.works.web.adaptor.LetterOfAcceptanceForMilestoneJSONAdaptor;
import org.egov.works.web.adaptor.SearchContractorJsonAdaptor;
import org.egov.works.web.adaptor.SearchLetterOfAcceptanceForOfflineStatusJsonAdaptor;
import org.egov.works.web.adaptor.SearchLetterOfAcceptanceJsonAdaptor;
import org.egov.works.web.adaptor.SearchLetterOfAcceptanceToCancelJson;
import org.egov.works.web.adaptor.SearchLetterOfAcceptanceToCreateContractorBillJson;
import org.egov.works.web.adaptor.SearchLetterOfAcceptanceToMofifyJsonAdaptor;
import org.egov.works.web.adaptor.SearchWorkOrderForCRJsonAdaptor;
import org.egov.works.web.adaptor.SearchWorkOrderForMBHeaderJsonAdaptor;
import org.egov.works.web.adaptor.SearchWorkOrderForREJsonAdaptor;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class AjaxLetterOfAcceptanceController {
    @Autowired
    @Qualifier(value="contractorService")
    private ContractorService contractorService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private SearchLetterOfAcceptanceJsonAdaptor searchLetterOfAcceptanceJsonAdaptor;
    @Autowired
    private SearchContractorJsonAdaptor searchContractorJsonAdaptor;
    @Autowired
    private SearchLetterOfAcceptanceToCreateContractorBillJson searchLetterOfAcceptanceToCreateContractorBillJson;
    @Autowired
    private SearchLetterOfAcceptanceToCancelJson searchLetterOfAcceptanceToCancelJson;
    @Autowired
    private LetterOfAcceptanceForMilestoneJSONAdaptor letterOfAcceptanceForMilestoneJSONAdaptor;
    @Autowired
    private TrackMilestoneService trackMilestoneService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private SearchLetterOfAcceptanceForOfflineStatusJsonAdaptor searchLetterOfAcceptanceForOfflineStatusJsonAdaptor;
    @Autowired
    private SearchWorkOrderForMBHeaderJsonAdaptor searchWorkOrderForMBHeaderJsonAdaptor;
    @Autowired
    private SearchLetterOfAcceptanceToMofifyJsonAdaptor searchLetterOfAcceptanceToMofifyJsonAdaptor;
    @Autowired
    private SearchWorkOrderForREJsonAdaptor searchWorkOrderForREJsonAdaptor;
    @Autowired
    private RevisionWorkOrderService revisionWorkOrderService;
    @Autowired
    private SearchWorkOrderForCRJsonAdaptor searchWorkOrderForCRJsonAdaptor;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;

    @RequestMapping(value={"/ajaxcontractors-loa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Contractor> findContractorsByCodeOrName(@RequestParam String name) {
        return this.contractorService.getContractorsByCodeOrName(name);
    }

    @RequestMapping(value={"/ajaxsearch-loa"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearch(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List searchLoaList = this.letterOfAcceptanceService.searchLetterOfAcceptance(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLetterOfAcceptanceJson((Object)searchLoaList) + "}";
        return result;
    }

    public Object toSearchLetterOfAcceptanceJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrder.class, (Object)this.searchLetterOfAcceptanceJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxestimatenumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForLOA(@RequestParam String name) {
        return this.letterOfAcceptanceService.getApprovedEstimateNumbersToModifyLOA(name);
    }

    @RequestMapping(value={"/ajaxloanumber"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaNumbers(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.getApprovedWorkOrderByNumber(workOrderNumber);
    }

    @RequestMapping(value={"/ajaxsearchcontractors-loaforcontractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaContractorforContractorBill(@RequestParam String name) {
        return this.letterOfAcceptanceService.findDistinctContractorsInWorkOrderByCodeOrName(name);
    }

    @RequestMapping(value={"/ajaxsearch-loaforcontractorbill"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchForContractorBill(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List searchWorkOrderEstimateList = this.letterOfAcceptanceService.searchLetterOfAcceptanceForContractorBill(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLetterOfAcceptanceToCreateContractorBillJson((Object)searchWorkOrderEstimateList) + "}";
        return result;
    }

    public Object toSearchLetterOfAcceptanceToCreateContractorBillJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderEstimate.class, (Object)this.searchLetterOfAcceptanceToCreateContractorBillJson).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxestimatenumbers-contractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForContractorBill(@RequestParam String estimateNumber) {
        return this.letterOfAcceptanceService.getApprovedEstimateNumbersForCreateContractorBill(estimateNumber);
    }

    @RequestMapping(value={"/ajaxloanumber-contractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaNumbersForContractorBill(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.getApprovedWorkOrdersForCreateContractorBill(workOrderNumber);
    }

    @RequestMapping(value={"/ajaxsearchcontractors-loa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaContractor(@RequestParam String contractorname) {
        return this.letterOfAcceptanceService.getApprovedContractorsForCreateContractorBill(contractorname);
    }

    @RequestMapping(value={"/ajaxvalidate-createcontractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String validateWorkOrderNumberForCreateContractorBill(@RequestParam(value="workOrderId") Long workOrderId) {
        String message = "";
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByWorkOrderId(workOrderId);
        TrackMilestone trackMileStone = this.trackMilestoneService.getMinimumPercentageToCreateContractorBill(workOrderEstimate.getId());
        if (trackMileStone == null) {
            message = this.messageSource.getMessage("error.contractorbil.milestone.percentage", null, null);
        } else {
            Boolean nonApprovedBills = this.letterOfAcceptanceService.validateContractorBillInWorkflowForWorkorder(workOrderId);
            if (!nonApprovedBills.booleanValue()) {
                message = this.messageSource.getMessage("error.contractorbill.nonapprovedbills", (Object[])new String[]{workOrderEstimate.getWorkOrder().getWorkOrderNumber()}, null);
            }
        }
        return message;
    }

    @RequestMapping(value={"/ajaxcontractorsbycode-loa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Contractor> findContractorsByCode(@RequestParam String name) {
        return this.contractorService.getContractorsByCode(name);
    }

    @RequestMapping(value={"/ajax-contractorsforloa"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxContractorSearch(Model model, @ModelAttribute SearchRequestContractor searchRequestContractor) {
        List contractorDetails = this.letterOfAcceptanceService.searchContractorDetails(searchRequestContractor);
        ArrayList<Contractor> contractors = new ArrayList<Contractor>();
        for (ContractorDetail cd : contractorDetails) {
            if (contractors.contains(cd.getContractor())) continue;
            contractors.add(cd.getContractor());
        }
        String result = "{ \"data\":" + this.toSearchContractorJson(contractors) + "}";
        return result;
    }

    public Object toSearchContractorJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Contractor.class, (Object)this.searchContractorJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxsearch-loanumber"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findApprovedLoaNumbers(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.findLoaWorkOrderNumberForMilestone(workOrderNumber);
    }

    @RequestMapping(value={"/ajaxworkidentificationnumber-milestone"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findworkIdNumbersForLoa(@RequestParam String code) {
        return this.letterOfAcceptanceService.findWorkIdentificationNumbersToCreateMilestone(code);
    }

    @RequestMapping(value={"/ajaxsearch-loaformilestone"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showSearchLoaToCreateMilestone(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List workOrderEstimate = this.letterOfAcceptanceService.getLoaForCreateMilestone(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLOAForCreateMilestoneJson((Object)workOrderEstimate) + "}";
        return result;
    }

    public Object toSearchLOAForCreateMilestoneJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderEstimate.class, (Object)this.letterOfAcceptanceForMilestoneJSONAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxsearch-loatomodify"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchLoaToModify(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List searchLoaList = this.letterOfAcceptanceService.searchLetterOfAcceptanceToModify(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLetterOfAcceptanceJsonForModify((Object)searchLoaList) + "}";
        return result;
    }

    public Object toSearchLetterOfAcceptanceJsonForModify(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderEstimate.class, (Object)this.searchLetterOfAcceptanceToMofifyJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchLOAsToCancel(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List workOrders = this.letterOfAcceptanceService.searchLOAsToCancel(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLOAsToCancelJson((Object)workOrders) + "}";
        return result;
    }

    public Object toSearchLOAsToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrder.class, (Object)this.searchLetterOfAcceptanceToCancelJson).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxworkidentificationnumbers-loatocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkIdNumbersToCancelLOA(@RequestParam String code) {
        return this.letterOfAcceptanceService.findWorkIdentificationNumbersToSearchLOAToCancel(code);
    }

    @RequestMapping(value={"/ajaxcontractors-loatocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsToCancelLOA(@RequestParam String code) {
        return this.letterOfAcceptanceService.findContractorsToSearchLOAToCancel(code);
    }

    @RequestMapping(value={"/ajax-checkifdependantObjectscreated"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String checkIfBillsCreated(@RequestParam Long id) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(id);
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0);
        String message = "";
        if (workOrderEstimate.getWorkOrderActivities().isEmpty()) {
            String billNumbers = this.letterOfAcceptanceService.checkIfBillsCreated(id);
            if (!billNumbers.equals("")) {
                message = this.messageSource.getMessage("error.loa.bills.created", (Object[])new String[]{billNumbers}, null);
            }
        } else {
            String revisionEstimates;
            String mbRefNumbers = this.letterOfAcceptanceService.checkIfMBCreatedForLOA(workOrderEstimate);
            if (!mbRefNumbers.equals("")) {
                message = this.messageSource.getMessage("error.loa.mb.created", (Object[])new String[]{mbRefNumbers}, null);
            } else if (!workOrderEstimate.getWorkOrderActivities().isEmpty() && !(revisionEstimates = this.revisionWorkOrderService.getRevisionEstimatesForWorkOrder(workOrder.getId())).equals("")) {
                message = this.messageSource.getMessage("error.revisionestimates.created", (Object[])new String[]{revisionEstimates}, null);
            }
        }
        String arfNumbers = this.letterOfAcceptanceService.checkIfARFCreatedForLOA(workOrderEstimate);
        if (!arfNumbers.equals("")) {
            message = this.messageSource.getMessage("error.loa.arf.created", (Object[])new String[]{arfNumbers}, null);
        }
        return message;
    }

    @RequestMapping(value={"/ajaxworkorder-mbheader"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkOrderForMBHeader(@RequestParam String workOrderNo) {
        return this.workOrderEstimateService.findWorkOrderForMBHeader(workOrderNo);
    }

    @RequestMapping(value={"/ajaxsearch-loatosetofflinestatus"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchLoaToSetOfflineStatus(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List searchLoaList = this.letterOfAcceptanceService.searchLetterOfAcceptanceForOfflineStatus(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLetterOfAcceptanceJsonToSetOfflineStatus((Object)searchLoaList) + "}";
        return result;
    }

    public Object toSearchLetterOfAcceptanceJsonToSetOfflineStatus(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderEstimate.class, (Object)this.searchLetterOfAcceptanceForOfflineStatusJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxestimatenumbers-loa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findApprovedEstimateNumbersForLOA(@RequestParam String estimateNumber) {
        return this.workOrderEstimateService.getEstimateNumbersForApprovedLoa(estimateNumber);
    }

    @RequestMapping(value={"/ajaxsearch-loatocreatemb"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchWorkOrders(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List workOrderEstimateList = this.workOrderEstimateService.searchWorkOrderToCreateMBHeader(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.searchWorkOrder((Object)workOrderEstimateList) + "}";
        return result;
    }

    public Object searchWorkOrder(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderEstimate.class, (Object)this.searchWorkOrderForMBHeaderJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxestimatenumbers-modifyloa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForModifyLOA(@RequestParam String estimateNumber) {
        return this.letterOfAcceptanceService.getApprovedEstimateNumbersForModfyLOA(estimateNumber);
    }

    @RequestMapping(value={"/ajaxloanumber-modifyloa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaNumbersForModifyLOA(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.getApprovedWorkOrderNumberForModfyLOA(workOrderNumber);
    }

    @RequestMapping(value={"/ajaxestimatenumbers-loaofflinestatus"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForOfflineStatus(@RequestParam String estimateNumber) {
        return this.letterOfAcceptanceService.getApprovedEstimateNumbersForSetOfflineStatus(estimateNumber);
    }

    @RequestMapping(value={"/ajaxloanumber-loaofflinestatus"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaNumbersForForOfflineStatus(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.getApprovedWorkOrderNumberForSetOfflineStatus(workOrderNumber);
    }

    @RequestMapping(value={"/ajaxcontractors-loaofflinestatus"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorNameOrCodeForForOfflineStatus(@RequestParam String contractorName) {
        return this.letterOfAcceptanceService.getApprovedContractorForSetOfflineStatus(contractorName);
    }

    @RequestMapping(value={"/ajaxcontractors-modifyloa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsForModifyLOA(@RequestParam String contractorName) {
        return this.letterOfAcceptanceService.getApprovedContractorsForModfyLOA(contractorName);
    }

    @RequestMapping(value={"/ajaxworkordernumbers-createre"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkOrderNumbersForRE(@RequestParam String workOrderNo) {
        return this.workOrderEstimateService.findWorkOrderForRE(workOrderNo);
    }

    @RequestMapping(value={"/ajaxcontractors-createre"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsToCreateRE(@RequestParam String code) {
        return this.letterOfAcceptanceService.findContractorsToSearchLOAToCreateRE(code);
    }

    @RequestMapping(value={"/ajaxsearch-loatocreatere"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchWorkOrdersToCreateRE(@ModelAttribute SearchRequestLetterOfAcceptanceForRE searchRequestLetterOfAcceptanceForRE) {
        List workOrderEstimateList = this.workOrderEstimateService.searchWorkOrderToCreateRE(searchRequestLetterOfAcceptanceForRE);
        String result = "{ \"data\":" + this.searchWorkOrderToCreateRE((Object)workOrderEstimateList) + "}";
        return result;
    }

    public Object searchWorkOrderToCreateRE(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderEstimate.class, (Object)this.searchWorkOrderForREJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/getworkordernumber-viewestimatephotograph"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkOrderNumbersForViewEstimatePhotograph(@RequestParam String workOrderNumber) {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return this.letterOfAcceptanceService.getWorkOrderNumbersForViewEstimatePhotograph(workOrderNumber);
        }
        return this.letterOfAcceptanceService.getWorkOrderNumbersToViewEstimatePhotograph(workOrderNumber);
    }

    @RequestMapping(value={"/getcontractorname-viewestimatephotograph"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsNamesForViewEstimatePhotograph(@RequestParam String contractorName) {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return this.letterOfAcceptanceService.getContractorsNamesForViewEstimatePhotograph(contractorName);
        }
        return this.letterOfAcceptanceService.getContractorsNamesToViewEstimatePhotograph(contractorName);
    }

    @RequestMapping(value={"/ajaxsearch-loatocreatecm"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchWorkOrdersToCreateContractorAdvance(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List workOrderEstimateList = this.workOrderEstimateService.searchWorkOrderToCreateContractorAdvance(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.searchWorkOrderToCreateCR((Object)workOrderEstimateList) + "}";
        return result;
    }

    public Object searchWorkOrderToCreateCR(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrderEstimate.class, (Object)this.searchWorkOrderForCRJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxcontractors-createcr"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsToCreateCR(@RequestParam String code) {
        return this.letterOfAcceptanceService.findContractorsToCreateCR(code);
    }

    @RequestMapping(value={"/ajaxestimatenumbers-createcr"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getEstimateNumbersToCreateCR(@RequestParam String estimateNumber) {
        return this.letterOfAcceptanceService.findEstimateNumbersToCreateCR(estimateNumber);
    }

    @RequestMapping(value={"/ajaxworkordernumbers-createcr"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getWorkOrderNumbersToCreateCR(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.findWorkOrderNumbersToCreateCR(workOrderNumber);
    }
}

