/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.estimatephotograph;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographs;
import org.egov.works.abstractestimate.service.EstimatePhotographService;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/estimatephotograph"})
public class ViewEstimatePhotographController {
    @Autowired
    private EstimatePhotographService estimatePhotographService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private FileStoreUtils fileStoreUtils;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewEstimatePhotographs(@RequestParam(value="mode", required=false) String mode, Model model, HttpServletRequest request) throws ApplicationException {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            this.viewEstimatePhotographsFromLE(model, request);
        } else {
            this.viewEstimatePhotographsFromAE(model, request);
        }
        return "estimatePhotographs-view";
    }

    private void viewEstimatePhotographsFromAE(Model model, HttpServletRequest request) {
        Long aeId = Long.valueOf(request.getParameter("abstractEstimateId"));
        List photographsBefore = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndAbstractEstimate(EstimatePhotographs.WorkProgress.BEFORE, aeId);
        List photographsAfter = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndAbstractEstimate(EstimatePhotographs.WorkProgress.AFTER, aeId);
        List photographsOnProcess = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndAbstractEstimate(EstimatePhotographs.WorkProgress.DURING, aeId);
        JsonObject photographStages = new JsonObject();
        this.estimatePhotographService.setPhotographsBeforeJsonArray(photographsBefore, photographStages);
        this.estimatePhotographService.setPhotographsAfterJsonArray(photographsAfter, photographStages);
        this.estimatePhotographService.setPhotographsDuringJsonArray(photographsOnProcess, photographStages);
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateById(aeId);
        WorkOrderEstimate woe = this.workOrderEstimateService.getWorkOrderEstimateByEstimateNumber(abstractEstimate.getEstimateNumber());
        this.estimatePhotographService.setModelValues(model, request, photographStages, woe, abstractEstimate);
    }

    private void viewEstimatePhotographsFromLE(Model model, HttpServletRequest request) {
        Long ledId = Long.valueOf(request.getParameter("lineEstimateDetailsId"));
        List photographsBefore = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.BEFORE, ledId);
        List photographsAfter = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.AFTER, ledId);
        List photographsOnProcess = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.DURING, ledId);
        JsonObject photographStages = new JsonObject();
        this.estimatePhotographService.setPhotographsBeforeJsonArray(photographsBefore, photographStages);
        this.estimatePhotographService.setPhotographsAfterJsonArray(photographsAfter, photographStages);
        this.estimatePhotographService.setPhotographsDuringJsonArray(photographsOnProcess, photographStages);
        LineEstimateDetails lineEstimateDetails = this.lineEstimateDetailService.getById(ledId);
        WorkOrderEstimate woe = this.workOrderEstimateService.getWorkOrderEstimateByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        this.estimatePhotographService.setModelValues(model, request, photographStages, woe, abstractEstimate);
    }

    @RequestMapping(value={"/downloadphotgraphs"}, method={RequestMethod.GET})
    public void viewUploadedDocuments(@RequestParam String fileStoreId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.fileStoreUtils.fetchFileAndWriteToStream(fileStoreId, "WMS", false, response);
    }
}

