/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.estimatephotograph;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographs;
import org.egov.works.abstractestimate.service.EstimatePhotographService;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/estimatephotograph"})
public class UploadEstimatePhotographController {
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private EstimatePhotographService estimatePhotographService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showUploadEstimatePhotographForm(@ModelAttribute(value="estimatePhotographs") EstimatePhotographs estimatePhotographs, Model model, HttpServletRequest request, @RequestParam(value="mode", required=false) String mode) throws ApplicationException {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            this.setNewFormValuesFromLineEstimateDetails(estimatePhotographs, model, request);
        } else {
            this.setNewFormValuesFromAbstractEstimate(estimatePhotographs, model, request);
        }
        return "estimatePhotographs-form";
    }

    private void setNewFormValuesFromAbstractEstimate(EstimatePhotographs estimatePhotographs, Model model, HttpServletRequest request) {
        Long abstractEstimateId = Long.valueOf(request.getParameter("abstractEstimateId"));
        List photographsBefore = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndAbstractEstimate(EstimatePhotographs.WorkProgress.BEFORE, abstractEstimateId);
        List photographsAfter = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndAbstractEstimate(EstimatePhotographs.WorkProgress.AFTER, abstractEstimateId);
        List photographsOnProcess = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndAbstractEstimate(EstimatePhotographs.WorkProgress.DURING, abstractEstimateId);
        JsonObject photographStages = new JsonObject();
        this.estimatePhotographService.setPhotographsBeforeJsonArray(photographsBefore, photographStages);
        this.estimatePhotographService.setPhotographsAfterJsonArray(photographsAfter, photographStages);
        this.estimatePhotographService.setPhotographsDuringJsonArray(photographsOnProcess, photographStages);
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateById(abstractEstimateId);
        WorkOrderEstimate woe = this.workOrderEstimateService.getWorkOrderEstimateByEstimateNumber(abstractEstimate.getEstimateNumber());
        model.addAttribute("estimatePhotographs", (Object)estimatePhotographs);
        this.estimatePhotographService.setModelValues(model, request, photographStages, woe, abstractEstimate);
    }

    private void setNewFormValuesFromLineEstimateDetails(EstimatePhotographs estimatePhotographs, Model model, HttpServletRequest request) {
        Long lineEstimateDetailsId = Long.valueOf(request.getParameter("lineEstimateDetailsId"));
        List photographsBefore = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.BEFORE, lineEstimateDetailsId);
        List photographsAfter = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.AFTER, lineEstimateDetailsId);
        List photographsOnProcess = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.DURING, lineEstimateDetailsId);
        JsonObject photographStages = new JsonObject();
        this.estimatePhotographService.setPhotographsBeforeJsonArray(photographsBefore, photographStages);
        this.estimatePhotographService.setPhotographsAfterJsonArray(photographsAfter, photographStages);
        this.estimatePhotographService.setPhotographsDuringJsonArray(photographsOnProcess, photographStages);
        LineEstimateDetails lineEstimateDetails = this.lineEstimateDetailService.getById(lineEstimateDetailsId);
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("estimatePhotographs", (Object)estimatePhotographs);
        this.estimatePhotographService.setModelValues(model, request, photographStages, workOrderEstimate, abstractEstimate);
    }

    @RequestMapping(value={"/upload/{id}/{estimatephotographstage}"}, method={RequestMethod.POST})
    @ResponseBody
    public String uploadEstimatePhotographForm(@ModelAttribute(value="estimatePhotographs") EstimatePhotographs estimatePhotographs, @RequestParam(value="file[]") MultipartFile[] files, HttpServletRequest request, @PathVariable Long id, @PathVariable String estimatephotographstage) throws IOException {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return this.uploadEstimatePhotographsFromLE(files, id, estimatephotographstage);
        }
        return this.uploadEstimatePhotographsFromAE(files, id, estimatephotographstage);
    }

    private String uploadEstimatePhotographsFromAE(MultipartFile[] files, Long id, String estimatephotographstage) throws IOException {
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateById(id);
        List estimatePhotographsList = this.estimatePhotographService.getEstimatePhotographs(files, (Object)abstractEstimate);
        JsonArray array = new JsonArray();
        for (EstimatePhotographs ep : estimatePhotographsList) {
            ep.setAbstractestimate(abstractEstimate);
            this.saveEstimatePhotograph(estimatephotographstage, array, ep);
        }
        return array.toString();
    }

    private String uploadEstimatePhotographsFromLE(MultipartFile[] files, Long id, String estimatephotographstage) throws IOException {
        LineEstimateDetails lineEstimateDetails = this.lineEstimateDetailService.getById(id);
        List estimatePhotographsList = this.estimatePhotographService.getEstimatePhotographs(files, (Object)lineEstimateDetails);
        JsonArray array = new JsonArray();
        for (EstimatePhotographs ep : estimatePhotographsList) {
            ep.setLineEstimateDetails(lineEstimateDetails);
            this.saveEstimatePhotograph(estimatephotographstage, array, ep);
        }
        return array.toString();
    }

    @RequestMapping(value={"/update/{id}/{estimatephotographstage}/{fileid}"}, method={RequestMethod.POST})
    @ResponseBody
    public String updateEstimatePhotographForm(@ModelAttribute(value="estimatePhotographs") EstimatePhotographs estimatePhotographs, HttpServletRequest request, @PathVariable Long id, @PathVariable String estimatephotographstage, @PathVariable Long fileid) throws IOException {
        EstimatePhotographs photographs = this.estimatePhotographService.getEstimatePhotographByFilestore(fileid);
        this.estimatePhotographService.delete(photographs);
        return "";
    }

    private void saveEstimatePhotograph(String estimatephotographstage, JsonArray array, EstimatePhotographs ep) {
        JsonObject child = new JsonObject();
        ep.setDateOfCapture(new Date());
        ep.setLatitude(ep.getLatitude());
        ep.setLongitude(ep.getLongitude());
        if (EstimatePhotographs.WorkProgress.BEFORE.toString().equalsIgnoreCase(estimatephotographstage)) {
            ep.setWorkProgress(EstimatePhotographs.WorkProgress.BEFORE);
        } else if (EstimatePhotographs.WorkProgress.AFTER.toString().equalsIgnoreCase(estimatephotographstage)) {
            ep.setWorkProgress(EstimatePhotographs.WorkProgress.AFTER);
        } else {
            ep.setWorkProgress(EstimatePhotographs.WorkProgress.DURING);
        }
        this.estimatePhotographService.save(ep);
        child.addProperty("key", (Number)ep.getFileStore().getId());
        array.add((JsonElement)child);
    }
}

