/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.estimatephotograph;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.abstractestimate.service.EstimatePhotographService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.web.adaptor.ViewAbstractEstimatePhotographJsonAdaptor;
import org.egov.works.web.adaptor.ViewEstimatePhotographJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/estimatephotograph"})
public class AjaxEstimatePhotographController {
    @Autowired
    private EstimatePhotographService estimatePhotographService;
    @Autowired
    private ViewEstimatePhotographJsonAdaptor viewEstimatePhotographJsonAdaptor;
    @Autowired
    private ViewAbstractEstimatePhotographJsonAdaptor viewAbstractEstimatePhotographJsonAdaptor;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;

    @RequestMapping(value={"/searchestimatephotograph"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchEstimatePhotograph(Model model, @ModelAttribute EstimatePhotographSearchRequest estimatePhotographSearchRequest) {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            List searchResultList = this.estimatePhotographService.searchEstimatePhotograph(estimatePhotographSearchRequest);
            return "{ \"data\":" + this.toSearchEstimatePhotograph((Object)searchResultList) + "}";
        }
        List searchResultList = this.estimatePhotographService.searchEstimatePhotographFromAE(estimatePhotographSearchRequest);
        return "{ \"data\":" + this.toViewEstimatePhotograph((Object)searchResultList) + "}";
    }

    private Object toViewEstimatePhotograph(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AbstractEstimate.class, (Object)this.viewAbstractEstimatePhotographJsonAdaptor).create();
        return gson.toJson(object);
    }

    public Object toSearchEstimatePhotograph(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimateDetails.class, (Object)this.viewEstimatePhotographJsonAdaptor).create();
        return gson.toJson(object);
    }

    @RequestMapping(value={"/getestimatenumbers-viewestimatephotograph"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForViewEstimatePhotograph(@RequestParam String estimateNumber) {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return this.estimatePhotographService.getEstimateNumbersForViewEstimatePhotograph(estimateNumber);
        }
        return this.estimatePhotographService.getEstimateNumbers(estimateNumber);
    }

    @RequestMapping(value={"/getwin-viewestimatephotograph"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWinForViewEstimatePhotograph(@RequestParam String workIdentificationNumber) {
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            return this.estimatePhotographService.getWinForViewEstimatePhotograph(workIdentificationNumber);
        }
        return this.estimatePhotographService.getWorkIdentificationNumbers(workIdentificationNumber);
    }
}

