/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.util.ArrayList;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.contractorbill.entity.SearchRequestContractorBill;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/contractorbill"})
public class SearchContractorBillController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;

    @RequestMapping(value={"/searchcontractorform"}, method={RequestMethod.GET})
    public String showSearchContractorBill(@ModelAttribute SearchRequestContractorBill searchRequestContractorBill, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestContractorBill.setDepartment(((Department)departments.get(0)).getId());
        }
        model.addAttribute("searchRequestContractorBill", (Object)searchRequestContractorBill);
        model.addAttribute("lineEstimateRequired", (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "searchcontractorbill-search";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("billTypes", (Object)BillTypes.values());
        ArrayList<EgwStatus> newEgwStatuses = new ArrayList<EgwStatus>();
        List egwStatuses = this.egwStatusHibernateDAO.getStatusByModule("CONTRACTORBILL");
        for (EgwStatus egwStatus : egwStatuses) {
            if (egwStatus.getCode().equalsIgnoreCase("NEW")) continue;
            newEgwStatuses.add(egwStatus);
        }
        model.addAttribute("billStatus", newEgwStatuses);
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
    }
}

