/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.EgBilldetails;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateDeduction;
import org.egov.works.autonumber.ContractorBillNumberGenerator;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.contractoradvance.service.ContractorAdvanceService;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.web.controller.contractorbill.BaseContractorBillController;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/contractorbill"})
public class CreateContractorBillController
extends BaseContractorBillController {
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    private MBHeaderService mBHeaderService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private CityService cityService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, Model model, HttpServletRequest request) {
        OfflineStatus offlineStatus;
        String woeId = request.getParameter("woeId");
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(Long.valueOf(woeId));
        AbstractEstimate estimate = workOrderEstimate.getEstimate();
        contractorBillRegister.setWorkOrderEstimate(workOrderEstimate);
        this.setDropDownValues(model, contractorBillRegister);
        model.addAttribute("assetValues", (Object)workOrderEstimate.getAssetValues());
        model.addAttribute("documentDetails", (Object)contractorBillRegister.getDocumentDetails());
        model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
        model.addAttribute("woeId", (Object)woeId);
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAmountRule(contractorBillRegister.getBillamount() != null ? contractorBillRegister.getBillamount() : BigDecimal.ZERO);
        model.addAttribute("amountRule", (Object)(contractorBillRegister.getBillamount() != null ? contractorBillRegister.getBillamount() : BigDecimal.ZERO));
        workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
        workflowContainer.setPendingActions("");
        model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
        this.prepareWorkflow(model, (StateAware)contractorBillRegister, workflowContainer);
        contractorBillRegister.setBilldate(new Date());
        model.addAttribute("mode", (Object)"new");
        model.addAttribute("mbHeaders", (Object)this.mBHeaderService.getMBHeaderBasedOnBillDate(workOrderEstimate.getId(), contractorBillRegister.getBilldate()));
        if (estimate.isSpillOverFlag()) {
            contractorBillRegister.setBilldate(new Date());
        }
        model.addAttribute("offlinestatusWorkCommencedDate", (offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(workOrderEstimate.getWorkOrder().getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase())) != null ? offlineStatus.getStatusDate() : "");
        model.addAttribute("workOrderEstimate", (Object)workOrderEstimate);
        model.addAttribute("contractorBillRegister", (Object)contractorBillRegister);
        if (estimate.isSpillOverFlag()) {
            model.addAttribute("cutOffDate", this.worksUtils.getCutOffDate() != null ? this.worksUtils.getCutOffDate() : "");
            model.addAttribute("currFinYearStartDate", (Object)this.worksUtils.getFinancialYearByDate(new Date()).getStartingDate());
        }
        if (!estimate.getAbsrtractEstimateDeductions().isEmpty()) {
            contractorBillRegister.getEgBilldetailes().addAll(this.prepairBillDetailsMap(estimate, model));
            model.addAttribute("billDetailsMap", (Object)this.contractorBillRegisterService.getBillDetailsMap(contractorBillRegister, model));
        }
        contractorBillRegister.setApprovalDepartment(this.worksUtils.getDefaultDepartmentId());
        return "contractorBill-form";
    }

    private void setDropDownValues(Model model, ContractorBillRegister contractorBillRegister) {
        List contractorPayableAccountList = this.chartOfAccountsService.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        List contractorRefundAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByListOfPurposeName(WorksConstants.CONTRACTOR_REFUND_PURPOSE);
        model.addAttribute("netPayableAccounCodes", (Object)contractorPayableAccountList);
        model.addAttribute("statutoryDeductionAccounCodes", (Object)this.chartOfAccountsService.getAccountCodeByPurposeName("Contractor Deductions"));
        model.addAttribute("retentionMoneyDeductionAccounCodes", (Object)this.chartOfAccountsService.getAccountCodeByPurposeName("RETENTION_MONEY"));
        model.addAttribute("refundAccounCodes", (Object)contractorRefundAccountList);
        model.addAttribute("billTypes", (Object)BillTypes.values());
        List retentionMoneyPerForPartBillApp = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "Retention money deduction percentage for Part Bill");
        List retentionMoneyPerForFinalBillApp = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "Retention money deduction percentage for Final Bill");
        model.addAttribute("retentionMoneyPerForPartBill", (Object)((AppConfigValues)retentionMoneyPerForPartBillApp.get(0)).getValue());
        model.addAttribute("retentionMoneyPerForFinalBill", (Object)((AppConfigValues)retentionMoneyPerForFinalBillApp.get(0)).getValue());
        Double advancePaidTillNow = this.contractorAdvanceService.getTotalAdvanceBillsPaid(contractorBillRegister.getWorkOrderEstimate().getId(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        model.addAttribute("advancePaidTillNow", (Object)advancePaidTillNow);
        List contractorAdvanceAccountCodes = this.chartOfAccountsService.getAccountCodeByPurposeName("CONTRACTOR_ADVANCE_ACCOUNTCODE");
        Double advanceAdjustedSoFar = this.contractorBillRegisterService.getAdvanceAdjustedSoFar(contractorBillRegister.getWorkOrderEstimate().getId(), contractorBillRegister.getId(), contractorAdvanceAccountCodes);
        model.addAttribute("contractorAdvanceAccountCodes", (Object)contractorAdvanceAccountCodes);
        model.addAttribute("advanceAdjustedSoFar", (Object)advanceAdjustedSoFar);
    }

    @RequestMapping(value={"/contractorbill-save"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam String workFlowAction, @RequestParam(value="file") MultipartFile[] files) throws IOException {
        Integer partBillCount;
        String additionalRule = "";
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        String woeId = request.getParameter("woeId");
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(Long.valueOf(woeId));
        Date workCompletionDate = contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate();
        contractorBillRegister.setWorkOrderEstimate(workOrderEstimate);
        contractorBillRegister.getWorkOrderEstimate().setWorkCompletionDate(workCompletionDate);
        this.contractorBillRegisterService.mergeDeductionDetails(contractorBillRegister);
        this.validateInput(contractorBillRegister, workOrderEstimate, resultBinder, request);
        if (StringUtils.isBlank((String)workFlowAction)) {
            this.validateBillDateToSkipWorkflow(contractorBillRegister, resultBinder);
        }
        contractorBillRegister = this.addBillDetails(contractorBillRegister, workOrderEstimate, resultBinder, request);
        this.contractorBillRegisterService.validateRefundAmount(contractorBillRegister, resultBinder);
        this.contractorBillRegisterService.validateMileStonePercentage(contractorBillRegister, resultBinder);
        if (!this.contractorBillRegisterService.checkForDuplicateAccountCodes(contractorBillRegister)) {
            resultBinder.reject("error.contractorbill.duplicate.accountcodes", "error.contractorbill.duplicate.accountcodes");
        }
        if (!this.contractorBillRegisterService.validateDuplicateRefundAccountCodes(contractorBillRegister)) {
            resultBinder.reject("error.contractorbill.duplicate.refund.accountcodes", "error.contractorbill.duplicate.refund.accountcodes");
        }
        this.contractorBillRegisterService.validateTotalDebitAndCreditAmount(contractorBillRegister, resultBinder);
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model, contractorBillRegister);
            model.addAttribute("assetValues", (Object)workOrderEstimate.getAssetValues());
            model.addAttribute("woeId", (Object)woeId);
            model.addAttribute("documentDetails", (Object)contractorBillRegister.getDocumentDetails());
            model.addAttribute("netPayableAmount", (Object)request.getParameter("netPayableAmount"));
            model.addAttribute("netPayableAccountCode", (Object)request.getParameter("netPayableAccountCode"));
            model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAmountRule(contractorBillRegister.getBillamount() != null ? contractorBillRegister.getBillamount() : BigDecimal.ZERO);
            workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
            model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
            this.prepareWorkflow(model, (StateAware)contractorBillRegister, workflowContainer);
            model.addAttribute("mode", (Object)"new");
            OfflineStatus offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(workOrderEstimate.getWorkOrder().getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
            model.addAttribute("offlinestatusWorkCommencedDate", offlineStatus != null ? offlineStatus.getStatusDate() : "");
            model.addAttribute("workOrderEstimate", (Object)workOrderEstimate);
            model.addAttribute("contractorBillRegister", (Object)contractorBillRegister);
            model.addAttribute("mbHeaders", (Object)this.mBHeaderService.getMBHeaderBasedOnBillDate(workOrderEstimate.getId(), contractorBillRegister.getBilldate()));
            model.addAttribute("mode", (Object)"edit");
            model.addAttribute("billDetailsMap", (Object)this.contractorBillRegisterService.getBillDetailsMap(contractorBillRegister, model));
            return "contractorBill-form";
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ((partBillCount = this.contractorBillRegisterService.getMaxSequenceNumberByWorkOrder(workOrderEstimate)) == null || partBillCount == 0) {
            partBillCount = 1;
        } else {
            Integer n = partBillCount;
            Integer n2 = partBillCount = Integer.valueOf(partBillCount + 1);
        }
        contractorBillRegister.setBillSequenceNumber(partBillCount);
        ContractorBillNumberGenerator c = (ContractorBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ContractorBillNumberGenerator.class);
        String contractorBillNumber = c.getNextNumber(contractorBillRegister);
        contractorBillRegister.setBillnumber(contractorBillNumber);
        contractorBillRegister.setPassedamount(contractorBillRegister.getBillamount());
        ContractorBillRegister savedContractorBillRegister = null;
        try {
            savedContractorBillRegister = this.contractorBillRegisterService.create(contractorBillRegister, files, approvalPosition, approvalComment, additionalRule, workFlowAction);
        }
        catch (ValidationException e) {
            throw new ApplicationRuntimeException("error.contractorbill.budgetcheck.insufficient.amount");
        }
        String pathVars = this.worksUtils.getPathVars(savedContractorBillRegister.getStatus(), savedContractorBillRegister.getState(), savedContractorBillRegister.getId(), approvalPosition);
        return "redirect:/contractorbill/contractorbill-success?pathVars=" + pathVars + "&billNumber=" + savedContractorBillRegister.getBillnumber();
    }

    @RequestMapping(value={"/contractorbill-success"}, method={RequestMethod.GET})
    public String showContractorBillSuccessPage(@RequestParam(value="billNumber") String billNumber, Model model, HttpServletRequest request) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            model.addAttribute("approverName", (Object)approverName);
        }
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillByBillNumber(billNumber);
        String message = this.getMessageByStatus(contractorBillRegister, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        model.addAttribute("contractorBillRegister", (Object)contractorBillRegister);
        return "contractorBill-success";
    }

    private void validateInput(ContractorBillRegister contractorBillRegister, WorkOrderEstimate workOrderEstimate, BindingResult resultBinder, HttpServletRequest request) {
        List mbheaders;
        MBHeader mBHeader;
        boolean validateBillInWorkflow = this.letterOfAcceptanceService.validateContractorBillInWorkflowForWorkorder(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getId());
        if (!validateBillInWorkflow) {
            resultBinder.reject("error.contractorbill.in.workflow.for.workorder", (Object[])new String[]{contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber()}, null);
        }
        BigDecimal totalBillAmountIncludingCurrentBill = contractorBillRegister.getBillamount();
        BigDecimal totalBillAmount = this.contractorBillRegisterService.getTotalBillAmountByWorkOrder(contractorBillRegister.getWorkOrderEstimate());
        if (totalBillAmount != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(totalBillAmount);
        }
        if (workOrderEstimate.getEstimate().isBillsCreated() && workOrderEstimate.getEstimate().getGrossAmountBilled() != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(workOrderEstimate.getEstimate().getGrossAmountBilled());
        }
        if (totalBillAmountIncludingCurrentBill.doubleValue() > contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount()) {
            resultBinder.reject("error.contractorbill.totalbillamount.exceeds.workorderamount", (Object[])new String[]{String.valueOf(totalBillAmountIncludingCurrentBill), String.valueOf(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount())}, null);
        }
        if (StringUtils.isBlank((String)contractorBillRegister.getBilltype())) {
            resultBinder.rejectValue("billtype", "error.billtype.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().before(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderDate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.validate.partybilldate.lessthan.loadate");
        }
        if (contractorBillRegister.getWorkOrderEstimate() != null && contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty() && contractorBillRegister.getMbHeader() != null) {
            if (StringUtils.isBlank((String)contractorBillRegister.getMbHeader().getMbRefNo())) {
                resultBinder.rejectValue("mbHeader.mbRefNo", "error.mbrefno.required");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() == null) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.mbdate.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == null) {
                resultBinder.rejectValue("mbHeader.fromPageNo", "error.frompageno.required");
            }
            if (contractorBillRegister.getMbHeader().getToPageNo() == null) {
                resultBinder.rejectValue("mbHeader.toPageNo", "error.topageno.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == 0 || contractorBillRegister.getMbHeader().getToPageNo() == 0) {
                resultBinder.reject("error.validate.mb.pagenumbers.zero", "error.validate.mb.pagenumbers.zero");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() != null && contractorBillRegister.getMbHeader().getToPageNo() != null && contractorBillRegister.getMbHeader().getFromPageNo() > contractorBillRegister.getMbHeader().getToPageNo()) {
                resultBinder.reject("error.validate.mb.frompagenumber.greaterthan.topagenumber", "error.validate.mb.frompagenumber.greaterthan.topagenumber");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() != null && contractorBillRegister.getMbHeader().getMbDate().before(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.validate.mbdate.lessthan.loadate");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() != null && contractorBillRegister.getBilldate().before(contractorBillRegister.getMbHeader().getMbDate())) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.billdate.mbdate");
            }
        }
        if (StringUtils.isBlank((String)request.getParameter("netPayableAccountCode"))) {
            resultBinder.reject("error.netpayable.accountcode.required", "error.netpayable.accountcode.required");
        }
        if (StringUtils.isBlank((String)request.getParameter("netPayableAmount")) || Double.valueOf(request.getParameter("netPayableAmount").toString()) < 0.0) {
            resultBinder.reject("error.netpayable.amount.required", "error.netpayable.amount.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().after(contractorBillRegister.getBilldate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.partybilldate.billdate");
        }
        Date workCompletionDate = contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate();
        if (contractorBillRegister.getBilltype().equals(BillTypes.Final_Bill.toString()) && workCompletionDate == null) {
            resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.required");
        }
        Date currentDate = new Date();
        if (workCompletionDate != null) {
            OfflineStatus offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(workOrderEstimate.getWorkOrder().getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
            if (workCompletionDate.after(currentDate)) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.futuredate");
            }
            if (offlineStatus != null) {
                if (workCompletionDate.before(offlineStatus.getStatusDate())) {
                    resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.workcommenceddate");
                }
            } else if (workCompletionDate.before(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.workorderdate");
            }
            if (workCompletionDate.after(contractorBillRegister.getBilldate())) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.billdate");
            }
        }
        if (workOrderEstimate.getEstimate().isSpillOverFlag()) {
            Date currentFinYearStartDate = this.worksUtils.getFinancialYearByDate(currentDate).getStartingDate();
            if (contractorBillRegister.getBilldate().after(currentDate)) {
                resultBinder.rejectValue("billdate", "error.billdate.futuredate");
            }
            if (contractorBillRegister.getBilldate().before(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("billdate", "error.billdate.workorderdate");
            }
            if (contractorBillRegister.getBilldate().before(currentFinYearStartDate)) {
                resultBinder.rejectValue("billdate", "error.billdate.finyear");
            }
        }
        if ((mBHeader = this.mBHeaderService.getLatestMBHeaderToValidateBillDate(contractorBillRegister.getWorkOrderEstimate().getId(), contractorBillRegister.getBilldate())) != null && contractorBillRegister.getBilldate().before(mBHeader.getMbDate())) {
            resultBinder.rejectValue("mbHeader.mbDate", "error.billdate.mbdate");
        }
        if (contractorBillRegister.getWorkOrderEstimate() != null && !contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty() && (mbheaders = this.mBHeaderService.getMBHeaderBasedOnBillDate(contractorBillRegister.getWorkOrderEstimate().getId(), contractorBillRegister.getBilldate())) != null && mbheaders.isEmpty()) {
            resultBinder.reject("error.mbnotexists.tocreatebill", "error.mbnotexists.tocreatebill");
        }
        this.validateContractorAdvanceDetails(contractorBillRegister, workOrderEstimate, resultBinder);
    }

    private String getMessageByStatus(ContractorBillRegister contractorBillRegister, String approverName, String nextDesign) {
        String message = "";
        if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.CREATED.toString())) {
            message = StringUtils.isNotBlank((String)contractorBillRegister.getEgBillregistermis().getBudgetaryAppnumber()) && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) ? this.messageSource.getMessage("msg.contractorbill.create.success.with.budgetappropriation", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign, contractorBillRegister.getEgBillregistermis().getBudgetaryAppnumber()}, null) : this.messageSource.getMessage("msg.contractorbill.create.success", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        } else if (contractorBillRegister.getStatus().getCode().equalsIgnoreCase(ContractorBillRegister.BillStatus.APPROVED.toString())) {
            message = this.messageSource.getMessage("msg.contractorbill.approved.success", (Object[])new String[]{contractorBillRegister.getBillnumber()}, null);
        } else if (contractorBillRegister.getStatus().getCode().equalsIgnoreCase(ContractorBillRegister.BillStatus.RESUBMITTED.toString())) {
            message = this.messageSource.getMessage("msg.contractorbill.resubmit.success", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        } else if (contractorBillRegister.getState().getValue().equalsIgnoreCase("Rejected")) {
            message = this.messageSource.getMessage("msg.contractorbill.reject", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        } else if (contractorBillRegister.getState().getValue().equalsIgnoreCase("Cancelled")) {
            message = this.messageSource.getMessage("msg.contractorbill.cancel", (Object[])new String[]{contractorBillRegister.getBillnumber()}, null);
        } else if (contractorBillRegister.getStatus().getCode().equalsIgnoreCase("Rejected")) {
            message = this.messageSource.getMessage("msg.contractorbill.forward.success", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        } else if (contractorBillRegister.getStatus().getCode().equalsIgnoreCase("CHECKED")) {
            message = this.messageSource.getMessage("msg.contractorbill.checked.success", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        }
        return message;
    }

    private ContractorBillRegister addBillDetails(ContractorBillRegister contractorBillRegister, WorkOrderEstimate workOrderEstimate, BindingResult resultBinder, HttpServletRequest request) {
        if (contractorBillRegister.getBillDetailes() == null || contractorBillRegister.getBillDetailes().isEmpty()) {
            resultBinder.reject("error.contractorbill.accountdetails.required", "error.contractorbill.accountdetails.required");
        }
        for (EgBilldetails egBilldetails : contractorBillRegister.getBillDetailes()) {
            if (!contractorBillRegister.getEgBilldetailes().isEmpty() && contractorBillRegister.getEgBilldetailes().size() == 1) {
                for (EgBilldetails refundBill : contractorBillRegister.getRefundBillDetails()) {
                    if (refundBill.getGlcodeid() == null) continue;
                    contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, refundBill, workOrderEstimate, resultBinder, request));
                }
                if (egBilldetails.getGlcodeid() == null) continue;
                contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, egBilldetails, workOrderEstimate, resultBinder, request));
                continue;
            }
            if (egBilldetails.getGlcodeid() == null) continue;
            contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, egBilldetails, workOrderEstimate, resultBinder, request));
        }
        this.contractorBillRegisterService.validateZeroCreditAndDebitAmount(contractorBillRegister, resultBinder);
        String netPayableAccountCodeId = request.getParameter("netPayableAccountCode");
        String netPayableAmount = request.getParameter("netPayableAmount");
        if (StringUtils.isNotBlank((String)netPayableAccountCodeId) && StringUtils.isNotBlank((String)netPayableAmount)) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setGlcodeid(new BigDecimal(netPayableAccountCodeId));
            billdetails.setCreditamount(new BigDecimal(netPayableAmount));
            contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, billdetails, workOrderEstimate, resultBinder, request));
        }
        return contractorBillRegister;
    }

    private void validateBillDateToSkipWorkflow(ContractorBillRegister contractorBillRegister, BindingResult resultBinder) {
        Date cutOffDate = this.worksUtils.getCutOffDate();
        SimpleDateFormat fmt = new SimpleDateFormat("dd-MM-yyyy");
        Date currFinYearStartDate = this.worksUtils.getFinancialYearByDate(new Date()).getStartingDate();
        if (cutOffDate != null && (contractorBillRegister.getBilldate().before(currFinYearStartDate) || contractorBillRegister.getBilldate().after(cutOffDate))) {
            resultBinder.reject("error.billdate.cutoffdate", (Object[])new String[]{fmt.format(cutOffDate)}, null);
        }
    }

    public List<EgBilldetails> prepairBillDetailsMap(AbstractEstimate abstractEstimate, Model model) {
        EgBilldetails egBilldetails = null;
        ArrayList<EgBilldetails> billList = new ArrayList<EgBilldetails>();
        for (AbstractEstimateDeduction deduction : abstractEstimate.getAbsrtractEstimateDeductions()) {
            egBilldetails = new EgBilldetails();
            egBilldetails.setCreditamount(BigDecimal.ZERO);
            egBilldetails.setGlcodeid(new BigDecimal(deduction.getChartOfAccounts().getId()));
            billList.add(egBilldetails);
        }
        return billList;
    }
}

