/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.web.utils.WebUtils;
import org.egov.model.bills.EgBilldetails;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractorbill"})
public class ContractorBillPDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private MBHeaderService mbHeaderService;
    public static final String CONTRACTORBILLPDF = "ContractorBillPDF";
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @RequestMapping(value={"/contractorbillPDF/{contractorBillId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateContractorBillPDF(HttpServletRequest request, @PathVariable(value="contractorBillId") Long id, HttpSession session) throws IOException {
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(id);
        return this.generateReport(contractorBillRegister, request, session);
    }

    private ResponseEntity<byte[]> generateReport(ContractorBillRegister contractorBillRegister, HttpServletRequest request, HttpSession session) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (contractorBillRegister != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
            new DecimalFormat("#.##");
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            String cityName = (String)request.getSession().getAttribute("citymunicipalityname");
            reportParams.put("cityName", cityName);
            reportParams.put("contractorName", contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getName() != null ? contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getName() : "");
            reportParams.put("contractorCode", contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getCode() != null ? contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getCode() : "");
            reportParams.put("bankAcc", contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getBank() != null ? contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getBankaccount() : "N/A");
            reportParams.put("panNo", !contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getPanNumber().isEmpty() ? contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getPanNumber() : "N/A");
            reportParams.put("billType", contractorBillRegister.getBilltype());
            reportParams.put("workCommencedDate", contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate() != null ? formatter.format(contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate()) : "");
            reportParams.put("win", contractorBillRegister.getWorkOrderEstimate().getEstimate().getProjectCode().getCode());
            reportParams.put("billNumber", contractorBillRegister.getBillnumber());
            reportParams.put("billDate", formatter.format(contractorBillRegister.getBilldate()));
            reportParams.put("billAmount", contractorBillRegister.getBillamount());
            reportParams.put("nameOfTheWork", contractorBillRegister.getWorkOrderEstimate().getEstimate().getName());
            reportParams.put("ward", contractorBillRegister.getWorkOrderEstimate().getEstimate().getWard().getName());
            reportParams.put("department", contractorBillRegister.getEgBillregistermis().getEgDepartment().getName());
            reportParams.put("reportRunDate", sdf.format(new Date()));
            reportParams.put("creatorName", contractorBillRegister.getCreatedBy().getName());
            reportParams.put("creatorDesignation", this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
            reportParams.put("approverDesignation", this.worksUtils.getUserDesignation(contractorBillRegister.getApprovedBy()));
            reportParams.put("approverName", contractorBillRegister.getApprovedBy() != null ? contractorBillRegister.getApprovedBy().getName() : "N/A");
            reportParams.put("mbAmountExists", contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities() != null && !contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty() ? "Yes" : "No");
            reportParams.put("mbDetails", this.mbHeaderService.getApprovedMBHeadersByContractorBill(contractorBillRegister));
            reportInput = new ReportRequest(CONTRACTORBILLPDF, (Collection)this.getBillDetailsMap(contractorBillRegister, reportParams), reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=ContractorBill.pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public List<Map<String, Object>> getBillDetailsMap(ContractorBillRegister contractorBillRegister, Map<String, Object> reportParams) {
        CChartOfAccounts coa;
        ArrayList<Map<String, Object>> billDetailsList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> billDetails = new HashMap<String, Object>();
        BigDecimal creditSum = BigDecimal.ZERO;
        BigDecimal debitSum = BigDecimal.ZERO;
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getDebitamount() == null) continue;
            billDetails = new HashMap();
            coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
            billDetails.put("glcodeId", coa.getId());
            billDetails.put("glcode", coa.getGlcode());
            billDetails.put("accountHead", coa.getName());
            billDetails.put("amount", egBilldetails.getDebitamount());
            debitSum = debitSum.add(egBilldetails.getDebitamount());
            billDetails.put("isDebit", true);
            billDetails.put("isNetPayable", false);
            billDetailsList.add(billDetails);
        }
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getCreditamount() == null) continue;
            billDetails = new HashMap();
            coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
            billDetails.put("glcodeId", coa.getId());
            billDetails.put("glcode", coa.getGlcode());
            billDetails.put("accountHead", coa.getName());
            billDetails.put("amount", egBilldetails.getCreditamount());
            billDetails.put("isDebit", false);
            if (contractorPayableAccountList != null && !contractorPayableAccountList.isEmpty() && contractorPayableAccountList.contains(coa)) {
                billDetails.put("isNetPayable", true);
            } else {
                billDetails.put("isNetPayable", false);
                creditSum = creditSum.add(egBilldetails.getCreditamount());
            }
            billDetailsList.add(billDetails);
        }
        reportParams.put("debitSum", debitSum);
        reportParams.put("creditSum", creditSum);
        BigDecimal netpayable = BigDecimal.ZERO;
        netpayable = debitSum.subtract(creditSum);
        reportParams.put("netPayable", netpayable);
        reportParams.put("netpayable", netpayable.setScale(2, 6));
        reportParams.put("totalAmountWords", NumberUtil.amountInWords((BigDecimal)netpayable));
        return billDetailsList;
    }
}

