/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.contractorbill.entity.ContractorBillCertificateInfo;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.masters.entity.Contractor;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.service.MBDetailsService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractorbill"})
public class CompletionCertificatePDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private MBDetailsService mbDetailsService;
    @Autowired
    private WorksUtils worksUtils;
    public static final String CONTRACTORCOMPLETIONBILLPDF = "completionCertificate";

    @RequestMapping(value={"/completioncertificatepdf/{contractorBillId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateContractorBillPDF(HttpServletRequest request, @PathVariable(value="contractorBillId") Long id, HttpSession session) throws IOException {
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(id);
        return this.generateReport(contractorBillRegister, request);
    }

    private ResponseEntity<byte[]> generateReport(ContractorBillRegister contractorBillRegister, HttpServletRequest request) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        ReportRequest reportInput = null;
        if (contractorBillRegister != null) {
            DecimalFormat df = new DecimalFormat("0.00");
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            AbstractEstimate ae = contractorBillRegister.getWorkOrderEstimate().getEstimate();
            WorkOrder workOrder = contractorBillRegister.getWorkOrderEstimate().getWorkOrder();
            Contractor contractor = workOrder.getContractor();
            OfflineStatus offlineStatusses = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(workOrder.getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
            if (ae != null) {
                reportParams.put("nameOfWork", ae.getName());
                reportParams.put("estimateNumber", ae.getEstimateNumber());
                reportParams.put("winCode", ae.getProjectCode().getCode());
                reportParams.put("estimateValue", df.format(ae.getEstimateValue()));
                reportParams.put("ward", ae.getWard().getName());
            } else {
                reportParams.put("estimateNumber", "NA");
                reportParams.put("winCode", "NA");
            }
            if (contractor != null) {
                reportParams.put("contractorName", contractor.getName());
                reportParams.put("contractorCode", contractor.getCode());
            } else {
                reportParams.put("contractorName", "");
                reportParams.put("contractorCode", "");
            }
            if (workOrder != null) {
                reportParams.put("workOrderAmount", df.format(workOrder.getWorkOrderAmount()));
                reportParams.put("workOrderNumber", workOrder.getWorkOrderNumber());
            }
            reportParams.put("workCommencedOn", DateUtils.getFormattedDate((Date)offlineStatusses.getStatusDate(), (String)"dd/MM/yyyy"));
            reportParams.put("workCompletedDate", DateUtils.getFormattedDate((Date)contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate(), (String)"dd/MM/yyyy"));
            reportParams.put("crearedBy", this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
            reportParams.put("approvedBy", this.worksUtils.getUserDesignation(contractorBillRegister.getApprovedBy()));
            reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            reportParams.put("cityName", ApplicationThreadLocals.getMunicipalityName());
            reportParams.put("reportRunDate", DateUtils.getFormattedDate((Date)new Date(), (String)"dd/MM/yyyy hh:mm a"));
            double totalAsPerTender = 0.0;
            double totalAsPerExecution = 0.0;
            ArrayList<ContractorBillCertificateInfo> contractorBillCertificateInfoList = new ArrayList<ContractorBillCertificateInfo>();
            for (WorkOrderActivity woa : contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities()) {
                Activity act = woa.getActivity();
                List activities = this.estimateService.getActivitiesByParent(act.getId());
                activities.add(act);
                double quantity = 0.0;
                for (Activity activity : activities) {
                    ContractorBillCertificateInfo contractorBillCertificateInfo = new ContractorBillCertificateInfo();
                    List detailsList = this.mbDetailsService.getMBDetailsByWorkOrderActivity(woa.getId());
                    for (MBDetails mbDetails : detailsList) {
                        quantity += mbDetails.getQuantity();
                    }
                    contractorBillCertificateInfo.setExecutionQuantity(quantity);
                    contractorBillCertificateInfo.setTenderQuantity(activity.getQuantity());
                    contractorBillCertificateInfo.setTenderAmount(activity.getAmount().getValue());
                    contractorBillCertificateInfo.setTenderRate(activity.getEstimateRate());
                    contractorBillCertificateInfo.setExecutionRate(activity.getEstimateRate());
                    contractorBillCertificateInfo.setExecutionAmount(quantity * activity.getRate());
                    contractorBillCertificateInfo.setWorkOrderActivity(woa);
                    contractorBillCertificateInfo.setTotalAsPerTender(totalAsPerTender += activity.getEstimateRate() * activity.getQuantity());
                    contractorBillCertificateInfo.setTotalAsPerExecution(totalAsPerExecution += activity.getEstimateRate() * quantity);
                    double totalDifference = totalAsPerTender - totalAsPerExecution;
                    contractorBillCertificateInfo.setTotalDifference(totalDifference);
                    contractorBillCertificateInfoList.add(contractorBillCertificateInfo);
                }
            }
            reportInput = new ReportRequest(CONTRACTORCOMPLETIONBILLPDF, contractorBillCertificateInfoList, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=CompletionCertificate_" + contractorBillRegister.getBillnumber() + ".pdf");
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

