/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.model.bills.EgBilldetails;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.contractoradvance.service.ContractorAdvanceService;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;

@Controller
public abstract class BaseContractorBillController
extends GenericWorkFlowController {
    @Autowired
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;

    protected void validateContractorAdvanceDetails(ContractorBillRegister contractorBillRegister, WorkOrderEstimate workOrderEstimate, BindingResult resultBinder) {
        List contractorAdvanceAccountCodes = this.chartOfAccountsService.getAccountCodeByPurposeName("CONTRACTOR_ADVANCE_ACCOUNTCODE");
        ArrayList<String> errorArgs = new ArrayList<String>();
        Double advancePaidSoFar = this.contractorAdvanceService.getTotalAdvanceBillsPaid(workOrderEstimate.getId(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        Double advanceAdjustedSoFar = this.contractorBillRegisterService.getAdvanceAdjustedSoFar(workOrderEstimate.getId(), contractorBillRegister.getId(), contractorAdvanceAccountCodes);
        for (EgBilldetails billdetails : contractorBillRegister.getAdvanceAdjustmentDetails()) {
            if (billdetails.getGlcodeid() == null || billdetails.getCreditamount() == null || contractorAdvanceAccountCodes == null || !contractorAdvanceAccountCodes.contains(this.chartOfAccountsService.findById((Serializable)Long.valueOf(billdetails.getGlcodeid().longValue()), false))) continue;
            if (billdetails.getCreditamount().compareTo(BigDecimal.valueOf(advancePaidSoFar)) > 0) {
                resultBinder.reject("error.advance.greater.paid", "error.advance.greater.paid");
            }
            if (billdetails.getCreditamount().compareTo(contractorBillRegister.getBillamount()) > 0) {
                resultBinder.reject("error.advance.greater.billamount", "error.advance.greater.billamount");
            }
            if (billdetails.getCreditamount().add(BigDecimal.valueOf(advanceAdjustedSoFar)).compareTo(BigDecimal.valueOf(advancePaidSoFar)) > 0) {
                resultBinder.reject("error.adjusted.greater.paid", "error.adjusted.greater.paid");
            }
            if (!contractorBillRegister.getBilltype().equalsIgnoreCase("Final Bill") || !(advancePaidSoFar > 0.0) || billdetails.getCreditamount().add(BigDecimal.valueOf(advanceAdjustedSoFar)).compareTo(BigDecimal.valueOf(advancePaidSoFar)) == 0) continue;
            Double balance = advancePaidSoFar - advanceAdjustedSoFar;
            errorArgs.add(advancePaidSoFar.toString());
            errorArgs.add(advanceAdjustedSoFar.toString());
            errorArgs.add(balance.toString());
            resultBinder.reject("error.finalbill.adjust.remaining", errorArgs.toArray(), "error.finalbill.adjust.remaining");
        }
        if (contractorBillRegister.getBilltype().equalsIgnoreCase("Final Bill") && advancePaidSoFar > 0.0 && advanceAdjustedSoFar == 0.0) {
            errorArgs.add(advancePaidSoFar.toString());
            resultBinder.reject("error.finalbill.adjusted.zero", errorArgs.toArray(), "error.finalbill.adjusted.zero");
        }
    }
}

