/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractoradvance;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.contractoradvance.service.ContractorAdvanceService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/contractoradvance"})
public class ViewContractorAdvanceController {
    @Autowired
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private WorksUtils worksUtils;

    @RequestMapping(value={"/view/{advanceRequisitionId}"}, method={RequestMethod.GET})
    public String viewMilestoneTemplate(@PathVariable String advanceRequisitionId, Model model, HttpServletRequest request) throws ApplicationException {
        ContractorAdvanceRequisition contractorAdvanceRequisition = this.contractorAdvanceService.getContractorAdvanceRequisitionById(Long.valueOf(Long.parseLong(advanceRequisitionId)));
        ContractorAdvanceRequisition updatedContractorAdvance = this.getContractorAdvanceDocuments(contractorAdvanceRequisition);
        Double advancePaidTillNow = this.contractorAdvanceService.getTotalAdvancePaid(Long.valueOf(contractorAdvanceRequisition.getId() == null ? -1L : contractorAdvanceRequisition.getId()), contractorAdvanceRequisition.getWorkOrderEstimate().getId(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        model.addAttribute("advancePaidTillNow", (Object)advancePaidTillNow);
        model.addAttribute("contractorAdvanceRequisition", (Object)updatedContractorAdvance);
        model.addAttribute("workOrderEstimate", (Object)updatedContractorAdvance.getWorkOrderEstimate());
        model.addAttribute("documentDetails", (Object)updatedContractorAdvance.getDocumentDetails());
        model.addAttribute("mode", (Object)"view");
        model.addAttribute("workflowHistory", (Object)this.worksUtils.getHistory(updatedContractorAdvance.getState(), updatedContractorAdvance.getStateHistory()));
        return "contractorAdvance-view";
    }

    private ContractorAdvanceRequisition getContractorAdvanceDocuments(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(contractorAdvanceRequisition.getId(), "CONTRACTORADVANCE");
        contractorAdvanceRequisition.setDocumentDetails(documentDetailsList);
        return contractorAdvanceRequisition;
    }
}

