/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractoradvance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.model.bills.EgBillregister;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.contractoradvance.service.ContractorAdvanceService;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/contractoradvance"})
public class UpdateContractorAdvanceController
extends GenericWorkFlowController {
    @Autowired
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;

    @ModelAttribute
    public ContractorAdvanceRequisition getContractorAdvanceRequisition(@PathVariable String contractorAdvanceRequisitionId) {
        ContractorAdvanceRequisition contractorAdvanceRequisition = this.contractorAdvanceService.getContractorAdvanceRequisitionById(Long.valueOf(Long.parseLong(contractorAdvanceRequisitionId)));
        return contractorAdvanceRequisition;
    }

    @RequestMapping(value={"/update/{contractorAdvanceRequisitionId}"}, method={RequestMethod.GET})
    public String updateContractorAdvance(Model model, @PathVariable String contractorAdvanceRequisitionId, HttpServletRequest request) throws ApplicationException {
        ContractorAdvanceRequisition contractorAdvanceRequisition = this.getContractorAdvanceRequisition(contractorAdvanceRequisitionId);
        this.setDropDownValues(model);
        model.addAttribute("defaultDepartmentId", (Object)this.worksUtils.getDefaultDepartmentId());
        return this.loadViewData(model, request, contractorAdvanceRequisition);
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("debitAccounts", (Object)this.chartOfAccountsService.getAccountCodeByPurposeName("CONTRACTOR_ADVANCE_ACCOUNTCODE"));
        model.addAttribute("creditAccounts", (Object)this.chartOfAccountsService.getAccountCodeByPurposeName("Creditors-Contractor Payable"));
    }

    private String loadViewData(Model model, HttpServletRequest request, ContractorAdvanceRequisition contractorAdvanceRequisition) {
        model.addAttribute("stateType", (Object)contractorAdvanceRequisition.getClass().getSimpleName());
        WorkflowContainer workflowContainer = new WorkflowContainer();
        if (contractorAdvanceRequisition.getState() != null) {
            model.addAttribute("currentState", (Object)contractorAdvanceRequisition.getState().getValue());
            workflowContainer.setPendingActions(contractorAdvanceRequisition.getState().getNextAction());
            model.addAttribute("pendingActions", (Object)contractorAdvanceRequisition.getState().getNextAction());
            model.addAttribute("amountRule", (Object)contractorAdvanceRequisition.getAdvanceRequisitionAmount());
        }
        Double advancePaidTillNow = this.contractorAdvanceService.getTotalAdvancePaid(Long.valueOf(contractorAdvanceRequisition.getId() == null ? -1L : contractorAdvanceRequisition.getId()), contractorAdvanceRequisition.getWorkOrderEstimate().getId(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        Double totalPartBillsAmount = this.contractorBillRegisterService.getTotalPartBillsAmount(Long.valueOf(contractorAdvanceRequisition.getWorkOrderEstimate().getId()), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString(), BillTypes.Part_Bill.toString());
        model.addAttribute("advancePaidTillNow", (Object)advancePaidTillNow);
        model.addAttribute("totalPartBillsAmount", (Object)totalPartBillsAmount);
        workflowContainer.setAmountRule(contractorAdvanceRequisition.getAdvanceRequisitionAmount());
        this.prepareWorkflow(model, (StateAware)contractorAdvanceRequisition, workflowContainer);
        if (contractorAdvanceRequisition.getState() != null && contractorAdvanceRequisition.getState().getValue().equals("Rejected")) {
            model.addAttribute("mode", (Object)"edit");
        } else {
            model.addAttribute("mode", (Object)"view");
        }
        model.addAttribute("workflowHistory", (Object)this.worksUtils.getHistory(contractorAdvanceRequisition.getState(), contractorAdvanceRequisition.getStateHistory()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
        model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
        model.addAttribute("workOrderEstimate", (Object)contractorAdvanceRequisition.getWorkOrderEstimate());
        ContractorAdvanceRequisition newContractorAdvanceRequisition = this.getContractorAdvanceDocuments(contractorAdvanceRequisition);
        model.addAttribute("contractorAdvanceRequisition", (Object)newContractorAdvanceRequisition);
        model.addAttribute("documentDetails", (Object)contractorAdvanceRequisition.getDocumentDetails());
        return "contractorAdvance-update";
    }

    private ContractorAdvanceRequisition getContractorAdvanceDocuments(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(contractorAdvanceRequisition.getId(), "CONTRACTORADVANCE");
        contractorAdvanceRequisition.setDocumentDetails(documentDetailsList);
        return contractorAdvanceRequisition;
    }

    @RequestMapping(value={"/update/{contractorAdvanceRequisitionId}"}, method={RequestMethod.POST})
    public String update(@ModelAttribute(value="contractorAdvanceRequisition") ContractorAdvanceRequisition contractorAdvanceRequisition, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files) throws ApplicationException, IOException {
        String mode = "";
        String workFlowAction = "";
        ContractorAdvanceRequisition updatedContractorAdvanceRequisition = null;
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (contractorAdvanceRequisition.getStatus().getCode().equals(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.REJECTED.toString()) && WorksConstants.FORWARD_ACTION.equals(workFlowAction) && "edit".equals(mode)) {
            this.contractorAdvanceService.validateInput(contractorAdvanceRequisition, errors);
            for (EgAdvanceRequisitionDetails details : contractorAdvanceRequisition.getEgAdvanceReqDetailses()) {
                this.contractorAdvanceService.getEgAdvanceRequisitionDetails(contractorAdvanceRequisition, details, errors);
            }
        }
        if (workFlowAction.equalsIgnoreCase("approve")) {
            this.populateAndValidateAdvanceBill(contractorAdvanceRequisition, errors);
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            return this.loadViewData(model, request, contractorAdvanceRequisition);
        }
        if (null != workFlowAction) {
            updatedContractorAdvanceRequisition = this.contractorAdvanceService.updateContractorAdvanceRequisition(contractorAdvanceRequisition, approvalPosition, approvalComment, null, workFlowAction, mode, files);
        }
        redirectAttributes.addFlashAttribute("contractorAdvanceRequisition", updatedContractorAdvanceRequisition);
        String pathVars = this.worksUtils.getPathVars(contractorAdvanceRequisition.getStatus(), contractorAdvanceRequisition.getState(), contractorAdvanceRequisition.getId(), approvalPosition);
        return "redirect:/contractoradvance/contractoradvance-success?pathVars=" + pathVars + "&arfNumber=" + contractorAdvanceRequisition.getAdvanceRequisitionNumber();
    }

    private void populateAndValidateAdvanceBill(ContractorAdvanceRequisition contractorAdvanceRequisition, BindingResult errors) {
        contractorAdvanceRequisition.setApprovedDate(new Date());
        EgBillregister egBillregister = new EgBillregister();
        this.contractorAdvanceService.generateAdvanceBills(contractorAdvanceRequisition, egBillregister, errors);
        ArrayList errorMessages = new ArrayList();
        this.contractorAdvanceService.validateLedgerAndSubledger(egBillregister, errorMessages);
        if (errorMessages.size() == 0) {
            contractorAdvanceRequisition.getEgAdvanceReqMises().setEgBillregister(egBillregister);
        } else {
            for (String error : errorMessages) {
                errors.reject("", error);
            }
        }
    }
}

