/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractoradvance;

import com.google.gson.JsonObject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.contractoradvance.service.ContractorAdvanceService;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/contractoradvance"})
public class CreateContractorAdvanceController
extends GenericWorkFlowController {
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="contractorAdvanceRequisition") ContractorAdvanceRequisition contractorAdvanceRequisition, Model model, HttpServletRequest request) {
        String woeId = request.getParameter("woeId");
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(Long.valueOf(woeId));
        this.prepareWorkflow(model, (StateAware)contractorAdvanceRequisition, new WorkflowContainer());
        model.addAttribute("workOrderEstimate", (Object)workOrderEstimate);
        contractorAdvanceRequisition.setWorkOrderEstimate(workOrderEstimate);
        this.setModelValues(contractorAdvanceRequisition, model);
        model.addAttribute("defaultDepartmentId", (Object)this.worksUtils.getDefaultDepartmentId());
        return "contractorAdvance-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="contractorAdvanceRequisition") ContractorAdvanceRequisition contractorAdvanceRequisition, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam String workFlowAction, @RequestParam(value="file") MultipartFile[] files) throws IOException {
        JsonObject jsonObject = new JsonObject();
        this.contractorAdvanceService.validateARFInDrafts(contractorAdvanceRequisition.getId(), contractorAdvanceRequisition.getWorkOrderEstimate().getId(), jsonObject, resultBinder);
        this.contractorAdvanceService.validateARFInWorkFlow(contractorAdvanceRequisition.getId(), contractorAdvanceRequisition.getWorkOrderEstimate().getId(), jsonObject, resultBinder);
        this.contractorAdvanceService.validateInput(contractorAdvanceRequisition, resultBinder);
        for (EgAdvanceRequisitionDetails details : contractorAdvanceRequisition.getEgAdvanceReqDetailses()) {
            this.contractorAdvanceService.getEgAdvanceRequisitionDetails(contractorAdvanceRequisition, details, resultBinder);
        }
        if (resultBinder.hasErrors()) {
            this.setModelValues(contractorAdvanceRequisition, model);
            this.prepareWorkflow(model, (StateAware)contractorAdvanceRequisition, new WorkflowContainer());
            model.addAttribute("workOrderEstimate", (Object)contractorAdvanceRequisition.getWorkOrderEstimate());
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            return "contractorAdvance-form";
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        ContractorAdvanceRequisition savedContractorAdvanceRequisition = this.contractorAdvanceService.create(contractorAdvanceRequisition, files, approvalPosition, approvalComment, null, workFlowAction);
        String pathVars = this.worksUtils.getPathVars(savedContractorAdvanceRequisition.getStatus(), savedContractorAdvanceRequisition.getState(), savedContractorAdvanceRequisition.getId(), approvalPosition);
        return "redirect:/contractoradvance/contractoradvance-success?pathVars=" + pathVars + "&arfNumber=" + savedContractorAdvanceRequisition.getAdvanceRequisitionNumber();
    }

    @RequestMapping(value={"/contractoradvance-success"}, method={RequestMethod.GET})
    public String showContractorAdvanceSuccessPage(@RequestParam(value="arfNumber") String arfNumber, Model model, HttpServletRequest request) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            model.addAttribute("approverName", (Object)approverName);
        }
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        ContractorAdvanceRequisition contractorAdvanceRequisition = this.contractorAdvanceService.getContractorAdvanceByARFNumber(arfNumber);
        String message = this.getMessageByStatus(contractorAdvanceRequisition, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        return "contractorAdvance-success";
    }

    private String getMessageByStatus(ContractorAdvanceRequisition contractorAdvanceRequisition, String approverName, String nextDesign) {
        String message = "";
        if (contractorAdvanceRequisition.getStatus().getCode().equals(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CREATED.toString())) {
            message = this.messageSource.getMessage("msg.contractoradvance.create.success", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), approverName, nextDesign}, null);
        } else if (contractorAdvanceRequisition.getStatus().getCode().equalsIgnoreCase(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString())) {
            message = this.messageSource.getMessage("msg.contractoradvance.approved.success", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber()}, null);
        } else if (contractorAdvanceRequisition.getStatus().getCode().equalsIgnoreCase(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.RESUBMITTED.toString())) {
            message = this.messageSource.getMessage("msg.contractoradvance.resubmit.success", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), approverName, nextDesign}, null);
        } else if (contractorAdvanceRequisition.getState().getValue().equalsIgnoreCase("Rejected")) {
            message = this.messageSource.getMessage("msg.contractoradvance.reject", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), approverName, nextDesign}, null);
        } else if (contractorAdvanceRequisition.getState().getValue().equalsIgnoreCase("Cancelled")) {
            message = this.messageSource.getMessage("msg.contractoradvance.cancel", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber()}, null);
        } else if (contractorAdvanceRequisition.getStatus().getCode().equalsIgnoreCase("Rejected")) {
            message = this.messageSource.getMessage("msg.contractoradvance.forward.success", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), approverName, nextDesign}, null);
        } else if (contractorAdvanceRequisition.getStatus().getCode().equalsIgnoreCase("CHECKED")) {
            message = this.messageSource.getMessage("msg.contractoradvance.checked.success", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), approverName, nextDesign}, null);
        }
        return message;
    }

    private void setModelValues(ContractorAdvanceRequisition contractorAdvanceRequisition, Model model) {
        model.addAttribute("debitAccounts", (Object)this.chartOfAccountsService.getAccountCodeByPurposeName("CONTRACTOR_ADVANCE_ACCOUNTCODE"));
        model.addAttribute("creditAccounts", (Object)this.chartOfAccountsService.getAccountCodeByPurposeName("Creditors-Contractor Payable"));
        Double advancePaidTillNow = this.contractorAdvanceService.getTotalAdvancePaid(Long.valueOf(contractorAdvanceRequisition.getId() == null ? -1L : contractorAdvanceRequisition.getId()), Long.valueOf(contractorAdvanceRequisition.getWorkOrderEstimate().getId()), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString());
        Double totalPartBillsAmount = this.contractorBillRegisterService.getTotalPartBillsAmount(Long.valueOf(contractorAdvanceRequisition.getWorkOrderEstimate().getId()), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString(), BillTypes.Part_Bill.toString());
        model.addAttribute("advancePaidTillNow", (Object)advancePaidTillNow);
        model.addAttribute("totalPartBillsAmount", (Object)totalPartBillsAmount);
        model.addAttribute("documentDetails", (Object)contractorAdvanceRequisition.getDocumentDetails());
        model.addAttribute("stateType", (Object)contractorAdvanceRequisition.getClass().getSimpleName());
        model.addAttribute("contractorAdvanceRequisition", (Object)contractorAdvanceRequisition);
        model.addAttribute("mode", (Object)"new");
    }
}

