/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractoradvance;

import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.model.bills.EgBillregister;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.contractoradvance.entity.SearchRequestContractorRequisition;
import org.egov.works.contractoradvance.service.ContractorAdvanceService;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/contractoradvance"})
public class CancelContractorAdvanceController {
    public static final String CONTRACTORADVANCE_CANCEL_SUCCESS = "contractorAdvance-cancel-success";
    public static final String ERROR_MESSAGE = "errorMessage";
    @Autowired
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String SearchContractorAdvance(@ModelAttribute SearchRequestContractorRequisition searchRequestContractorRequisition, Model model) throws ApplicationException {
        List advanceRequisitionCreatedByUsers = this.contractorAdvanceService.getAdvanceRequisitionCreatedByUsers();
        model.addAttribute("advanceRequisitionCreatedByUsers", (Object)advanceRequisitionCreatedByUsers);
        model.addAttribute("searchRequestContractorRequisition", (Object)searchRequestContractorRequisition);
        return "contractorAdvance-cancel";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelContractorAdvance(HttpServletRequest request, Model model) throws ApplicationException {
        String advanceRequisitionBillNumbers;
        Long contractorAdvanceId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        ContractorAdvanceRequisition contractorAdvanceRequisition = this.contractorAdvanceService.getContractorAdvanceRequisitionById(contractorAdvanceId);
        if (contractorAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister() != null && !StringUtils.isBlank((String)(advanceRequisitionBillNumbers = this.checkForAdvanceAdjustment(contractorAdvanceRequisition)))) {
            model.addAttribute(ERROR_MESSAGE, (Object)this.messageSource.getMessage("error.arf.advanceadjustment", (Object[])new String[]{advanceRequisitionBillNumbers}, null));
            return CONTRACTORADVANCE_CANCEL_SUCCESS;
        }
        String advanceRequistions = this.contractorAdvanceService.getAdvanceRequisitionGreaterThanCurrent(contractorAdvanceRequisition.getWorkOrderEstimate().getId(), contractorAdvanceRequisition.getCreatedDate());
        if (!"".equals(advanceRequistions)) {
            model.addAttribute(ERROR_MESSAGE, (Object)this.messageSource.getMessage("error.arfexists.greaterthancreateddate", (Object[])new String[]{advanceRequistions}, null));
            return CONTRACTORADVANCE_CANCEL_SUCCESS;
        }
        EgBillregister billregister = contractorAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister();
        if (billregister.getEgBillregistermis() != null && billregister.getEgBillregistermis().getVoucherHeader() != null && billregister.getEgBillregistermis().getVoucherHeader().getStatus() != 4) {
            model.addAttribute(ERROR_MESSAGE, (Object)this.messageSource.getMessage("error.arf.voucher.created", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), billregister.getEgBillregistermis().getVoucherHeader().getVoucherNumber()}, null));
            return CONTRACTORADVANCE_CANCEL_SUCCESS;
        }
        contractorAdvanceRequisition.setCancellationReason(cancellationReason);
        contractorAdvanceRequisition.setCancellationRemarks(cancellationRemarks);
        contractorAdvanceRequisition = this.contractorAdvanceService.cancelContractorAdvance(contractorAdvanceRequisition);
        model.addAttribute("contractorAdvanceRequisition", (Object)contractorAdvanceRequisition);
        model.addAttribute("message", (Object)this.messageSource.getMessage("msg.cancel.arf.success", (Object[])new String[]{contractorAdvanceRequisition.getAdvanceRequisitionNumber(), billregister.getBillnumber()}, null));
        return CONTRACTORADVANCE_CANCEL_SUCCESS;
    }

    private String checkForAdvanceAdjustment(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        List contractorAdvanceAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("CONTRACTOR_ADVANCE_ACCOUNTCODE");
        StringBuilder glcodeIds = new StringBuilder();
        for (CChartOfAccounts chartOfAccounts : contractorAdvanceAccountList) {
            glcodeIds.append(',').append(chartOfAccounts.getId());
        }
        BigDecimal glCodes = new BigDecimal(glcodeIds.toString().replaceFirst(",", ""));
        List billNumbers = this.contractorBillRegisterService.getBillNumberToCancelAdvanceReqisition(contractorAdvanceRequisition.getWorkOrderEstimate().getId(), glCodes);
        StringBuilder existingBillNumbers = new StringBuilder();
        for (String details : billNumbers) {
            existingBillNumbers.append(details).append(',');
        }
        return existingBillNumbers.toString();
    }
}

