/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractoradvance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.contractoradvance.entity.SearchRequestContractorRequisition;
import org.egov.works.contractoradvance.service.ContractorAdvanceService;
import org.egov.works.web.adaptor.SearchContractorAdvanceJsonAdaptor;
import org.egov.works.web.adaptor.SearchContractorAdvanceToCancelJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractoradvance"})
public class AjaxContractorAdvanceController {
    @Autowired
    private SearchContractorAdvanceJsonAdaptor searchContractorAdvanceJsonAdaptor;
    @Autowired
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private SearchContractorAdvanceToCancelJsonAdaptor searchContractorAdvanceToCancelJsonAdaptor;

    @RequestMapping(value={"/ajaxarfnumbers-searchcr"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getAdvanceRequisitionNumberToSearchCR(@RequestParam String advanceRequisitionNumber) {
        return this.contractorAdvanceService.getAdvanceRequisitionNumberToSearchCR(advanceRequisitionNumber);
    }

    @RequestMapping(value={"/ajaxworkordernumbers-searchcr"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getWorkOrderNumberToSearchCR(@RequestParam String workOrderNumber) {
        return this.contractorAdvanceService.getWorkOrderNumberToSearchCR(workOrderNumber);
    }

    @RequestMapping(value={"/ajaxcontractors-searchcr"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getContractorToSearchCR(@RequestParam String contractorName) {
        return this.contractorAdvanceService.getContractorsToSearchCR(contractorName);
    }

    @RequestMapping(value={"/ajaxsearch-contractorrequisition"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchWorkOrdersToCreateCR(@ModelAttribute SearchRequestContractorRequisition searchRequestContractorRequisition) {
        List contractorAdvanceRequisitionList = this.contractorAdvanceService.searchContractorAdvance(searchRequestContractorRequisition);
        String result = "{ \"data\":" + this.searchContractorAdvanceRequisition((Object)contractorAdvanceRequisitionList) + "}";
        return result;
    }

    public Object searchContractorAdvanceRequisition(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ContractorAdvanceRequisition.class, (Object)this.searchContractorAdvanceJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/validatearf/{workOrderEstimateId}"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String validateContractorAdvance(@PathVariable Long workOrderEstimateId, HttpServletRequest request, HttpServletResponse response) {
        JsonObject jsonObject = new JsonObject();
        this.contractorAdvanceService.validateARFInDrafts(null, workOrderEstimateId, jsonObject, null);
        this.contractorAdvanceService.validateARFInWorkFlow(null, workOrderEstimateId, jsonObject, null);
        if (jsonObject.toString().length() > 2) {
            this.sendAJAXResponse(jsonObject.toString(), response);
            return "";
        }
        return null;
    }

    protected void sendAJAXResponse(String msg, HttpServletResponse response) {
        try {
            PrintWriter httpResponseWriter = response.getWriter();
            IOUtils.write((String)msg, (Writer)httpResponseWriter);
            IOUtils.closeQuietly((Writer)httpResponseWriter);
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("error.validate.re");
        }
    }

    @RequestMapping(value={"/ajaxadvancebillnumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getAdvanceBillNumber(@RequestParam String advanceBillNumber) {
        return this.contractorAdvanceService.findAdvanceBillNumber(advanceBillNumber);
    }

    @RequestMapping(value={"/ajaxarfnumbers-cancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getAdvanceRequistionNumberToCancelContractorAdvance(@RequestParam String advanceRequisitionNumber) {
        return this.contractorAdvanceService.findAdvanceRequisitionNumberToCancelContractorAdvance(advanceRequisitionNumber);
    }

    @RequestMapping(value={"/ajaxcontractors-cancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getContractorsToCancelContractorAdvance(@RequestParam String contractorName) {
        return this.contractorAdvanceService.findContractorsToCancelContractorAdvance(contractorName);
    }

    @RequestMapping(value={"/ajaxloanumbers-cancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getWorkOrderNumberToCancelContractorAdvance(@RequestParam String workOrderNumber) {
        return this.contractorAdvanceService.findWorkOrderNumberToCancelContractorAdvance(workOrderNumber);
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchContractorAdvanceToCancel(@ModelAttribute SearchRequestContractorRequisition searchRequestContractorRequisition) {
        List contractorAdvanceRequisitionList = this.contractorAdvanceService.searchContractorAdvanceToCancel(searchRequestContractorRequisition);
        String result = "{ \"data\":" + this.searchContractorAdvanceToCancel((Object)contractorAdvanceRequisitionList) + "}";
        return result;
    }

    public Object searchContractorAdvanceToCancel(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ContractorAdvanceRequisition.class, (Object)this.searchContractorAdvanceToCancelJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }
}

