/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.abstractestimate;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/abstractestimate"})
public class ViewBillOfQuantitiesXlsController {
    public static final String BOQ = "Bill Of Qunatities";
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private ReportService reportService;

    @RequestMapping(value={"/viewBillOfQuantitiesXls/{abstractEstimateId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewBillOfQuantities(@PathVariable Long abstractEstimateId, Model model) {
        AbstractEstimate estimate = this.estimateService.getAbstractEstimateById(abstractEstimateId);
        ReportRequest reportRequest = new ReportRequest("BillOfQuantities", estimate.getSORActivities(), this.createHeaderParams(estimate, BOQ));
        reportRequest.setReportFormat(ReportConstants.FileFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        HttpHeaders headers = new HttpHeaders();
        headers.add("content-disposition", "no-cache;filename=AbstractEstimate-BillOfQuantites_" + estimate.getEstimateNumber() + ".xls");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private Map createHeaderParams(AbstractEstimate estimate, String type) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
        if (type.equalsIgnoreCase(BOQ)) {
            reportParams.put("workName", estimate.getName());
            reportParams.put("deptName", estimate.getExecutingDepartment().getName());
            reportParams.put("estimateNo", estimate.getEstimateNumber());
            reportParams.put("activitySize", estimate.getSORActivities() == null ? 0 : estimate.getSORActivities().size());
            reportParams.put("NonSOR_Activities", estimate.getNonSORActivities());
            reportParams.put("grandTotalAmt", BigDecimal.valueOf(estimate.getWorkValue()));
            reportParams.put("estimateDate", estimate.getEstimateDate() != null ? formatter.format(estimate.getEstimateDate()) : "");
            reportParams.put("currDate", sdf.format(new Date()));
        }
        return reportParams;
    }
}

